/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.SectionsCollection;
import org.dbgl.service.ITextService;
import org.dbgl.util.StringRelatedUtils;

public class Settings {
    protected FileLocation fileLocation_ = null;
    protected SectionsCollection sections_ = new SectionsCollection();

    public SectionsCollection getSections() {
        return this.sections_;
    }

    public String[] getSectionNames() {
        return this.sections_.getSectionNames();
    }

    public void setSections(SectionsCollection sections) {
        this.sections_ = sections;
    }

    public FileLocation getFileLocation() {
        return this.fileLocation_;
    }

    public File getFile() {
        return this.fileLocation_.getFile();
    }

    public File getCanonicalFile() {
        return this.fileLocation_.getCanonicalFile();
    }

    public void setFileLocation(FileLocation fileLocation) {
        this.fileLocation_ = fileLocation;
    }

    public void removeSection(String sectionTitle) {
        this.sections_.removeSection(sectionTitle);
    }

    public void clearSections() {
        this.sections_ = new SectionsCollection();
    }

    public String load(ITextService text) throws IOException {
        File file = this.fileLocation_.getCanonicalFile();
        if (file == null || !file.isFile() || !file.canRead()) {
            throw new IOException(text.get("general.error.openfile", new Object[]{String.valueOf(file)}));
        }
        try (FileReader reader = new FileReader(file);){
            String string = this.loadData(text, reader, file, null, null);
            return string;
        }
    }

    protected String loadData(ITextService text, Reader reader, File file, String specialSection, List<String> specialSectionLines) throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        try (BufferedReader configData = new BufferedReader(reader);){
            String textLine = null;
            String currSectionTitle = null;
            boolean lastItemHadMissingSection = false;
            int lineNumber = 1;
            while ((textLine = configData.readLine()) != null) {
                if ((textLine = textLine.trim()).length() > 0 && textLine.charAt(0) != '#') {
                    if (textLine.charAt(0) == '[') {
                        int start = textLine.indexOf(91);
                        int end = textLine.lastIndexOf(93);
                        if (end == -1) {
                            warningsLog.append(text.get("general.error.parseconf", new Object[]{file.getPath(), lineNumber, textLine}));
                        } else {
                            currSectionTitle = textLine.substring(start + 1, end);
                        }
                    } else if (currSectionTitle == null) {
                        if (!lastItemHadMissingSection) {
                            warningsLog.append(text.get("general.error.sectionmissing", new Object[]{file.getPath(), lineNumber, textLine}));
                        }
                        lastItemHadMissingSection = true;
                    } else if (currSectionTitle.equals(specialSection)) {
                        specialSectionLines.add(textLine);
                    } else {
                        int end = textLine.indexOf(61);
                        if (end == -1) {
                            warningsLog.append(text.get("general.error.parseconf", new Object[]{file.getPath(), lineNumber, textLine}));
                        } else {
                            String name = textLine.substring(0, end).trim();
                            String value = textLine.substring(end + 1).trim();
                            this.sections_.setValue(currSectionTitle, name.toLowerCase(), value);
                        }
                        lastItemHadMissingSection = false;
                    }
                }
                ++lineNumber;
            }
        }
        return warningsLog.toString();
    }

    public void save() throws IOException {
        File file = this.fileLocation_.getCanonicalFile();
        FileUtils.forceMkdirParent(file);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.writeData(writer);
        }
    }

    private void writeData(BufferedWriter writer) throws IOException {
        writer.write(this.sections_.toString());
    }

    public boolean hasValue(String sectionTitle, String sectionItem) {
        return this.sections_.hasValue(sectionTitle, sectionItem);
    }

    public String getValue(String sectionTitle, String sectionItem) {
        return this.sections_.getValue(sectionTitle, sectionItem);
    }

    public String getValue(String sectionTitle, String sectionItem, String defaultValue) {
        if (this.hasValue(sectionTitle, sectionItem)) {
            return this.sections_.getValue(sectionTitle, sectionItem);
        }
        return defaultValue;
    }

    public boolean getBooleanValue(String sectionTitle, String sectionItem) {
        return Boolean.valueOf(this.sections_.getValue(sectionTitle, sectionItem));
    }

    public int getIntValue(String sectionTitle, String sectionItem) {
        try {
            return Integer.parseInt(this.sections_.getValue(sectionTitle, sectionItem));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getMultilineValue(String sectionTitle, String sectionItem, String delimiter) {
        return StringRelatedUtils.stringArrayToString(this.getValues(sectionTitle, sectionItem), delimiter);
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        String val = this.sections_.getValue(sectionTitle, sectionItem);
        if (val.length() <= 0) {
            return new String[0];
        }
        String[] res = val.split(" ");
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].replaceAll("<space>", " ");
        }
        return res;
    }

    public int[] getIntValues(String sectionTitle, String sectionItem) {
        return StringRelatedUtils.stringToIntArray(this.sections_.getValue(sectionTitle, sectionItem));
    }

    public boolean[] getBooleanValues(String sectionTitle, String sectionItem) {
        return StringRelatedUtils.stringToBooleanArray(this.sections_.getValue(sectionTitle, sectionItem));
    }

    public String[] getItemNames(String sectionTitle) {
        return this.sections_.getItemNames(sectionTitle);
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        this.sections_.setValue(sectionTitle, sectionItem, value);
    }

    public void setValue(String sectionTitle, String sectionItem, boolean value) {
        this.sections_.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setValue(String sectionTitle, String sectionItem, int value) {
        this.sections_.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setMultilineValue(String sectionTitle, String sectionItem, String values, String delimiter) {
        this.sections_.setValue(sectionTitle, sectionItem, values.replaceAll(" ", "<space>").replace(delimiter, " ").trim());
    }

    public void setValues(String sectionTitle, String sectionItem, int[] values) {
        this.sections_.setValue(sectionTitle, sectionItem, StringUtils.join((int[])values, (char)' '));
    }

    public void setValues(String sectionTitle, String sectionItem, boolean[] values) {
        this.sections_.setValue(sectionTitle, sectionItem, StringUtils.replaceChars((String)Arrays.toString(values), (String)"[,]", (String)""));
    }

    public void updateValue(String sectionTitle, String sectionItem, String value) {
        if (this.sections_.hasValue(sectionTitle, sectionItem)) {
            this.sections_.setValue(sectionTitle, sectionItem, value);
        }
    }

    public void switchSetting(String oldSection, String oldItem, String newSection, String newItem) {
        if (this.sections_.hasValue(oldSection, oldItem)) {
            this.sections_.setValue(newSection, newItem, this.getValue(oldSection, oldItem));
            this.sections_.removeValue(oldSection, oldItem);
        }
    }

    public void removeValue(String sectionTitle, String sectionItem) {
        this.sections_.removeValue(sectionTitle, sectionItem);
    }

    public void removeValueIfSet(String sectionTitle, String sectionItem) {
        if (this.hasValue(sectionTitle, sectionItem)) {
            this.removeValue(sectionTitle, sectionItem);
        }
    }

    public void removeDuplicateValuesIn(Settings configuration) {
        this.sections_.removeDuplicateValuesIn(configuration.sections_);
    }

    public void removeUnequalValuesIn(Settings configuration) {
        this.sections_.removeUnequalValuesIn(configuration.sections_);
    }

    public void removeValuesNotSetIn(Settings configuration) {
        this.sections_.removeValuesNotSetIn(configuration.sections_);
    }

    public String toString() {
        StringWriter result = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(result);){
            this.writeData(writer);
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
        return result.toString();
    }
}

