/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.entity;

import java.io.File;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.ArchiveFileLocation;
import org.dbgl.model.FileLocation;
import org.dbgl.model.GamePack;
import org.dbgl.model.IArchive;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.Entity;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;

public class GamePackEntry
extends Entity
implements Comparable<GamePackEntry> {
    private GamePack gamePack_;
    private int importedId_;
    private final Profile profile_;
    private final String fullConfig_;
    private final String incrConfig_;
    private FileLocation baseDir_;
    private ArchiveFileLocation gameDir_;
    private ArchiveFileLocation capturesDir_;
    private ArchiveFileLocation mapper_;
    private final List<File> capturesList_;
    private final List<File> extrasList_;
    private final List<File> extrasDstList_;
    private final File zipFile_;

    public GamePackEntry(int id, Profile profile, GamePack gamePack) {
        this.setId(id);
        this.profile_ = profile;
        this.gamePack_ = gamePack;
        this.setBaseDir(".");
        this.setGameDir(profile.getConfiguration().getAutoexec().getCanonicalGameDir().getPath());
        this.setCapturesDir("");
        File customMapper = profile.getCustomMapperFile();
        if (customMapper != null) {
            this.setMapper(customMapper.getPath());
        }
        this.fullConfig_ = null;
        this.incrConfig_ = null;
        this.capturesList_ = null;
        this.extrasList_ = null;
        this.extrasDstList_ = null;
        this.zipFile_ = null;
    }

    public GamePackEntry(int id, Profile profile, GamePack gamePack, String captures, String mapper, String gameDir, String fullConfig, String incrConfig) {
        this.setId(id);
        this.profile_ = profile;
        this.gamePack_ = gamePack;
        this.setBaseDir(".");
        if (StringUtils.isNotEmpty((CharSequence)gameDir)) {
            this.setGameDir(gameDir);
        }
        if (StringUtils.isNotEmpty((CharSequence)captures)) {
            this.setCapturesDir(captures);
        }
        if (StringUtils.isNotEmpty((CharSequence)mapper)) {
            this.setMapper(mapper);
        }
        this.fullConfig_ = fullConfig;
        this.incrConfig_ = incrConfig;
        this.capturesList_ = null;
        this.extrasList_ = null;
        this.extrasDstList_ = null;
        this.zipFile_ = null;
    }

    public GamePackEntry(int id, Profile profile, String gameDir, List<File> capturesList, List<File> extrasList, List<File> extrasDstList, File zipFile) {
        this.setId(id);
        this.profile_ = profile;
        this.setBaseDir(".");
        if (StringUtils.isNotEmpty((CharSequence)gameDir)) {
            this.setGameDir(gameDir);
        }
        this.setCapturesDir("");
        this.fullConfig_ = null;
        this.incrConfig_ = null;
        this.capturesList_ = capturesList;
        this.extrasList_ = extrasList;
        this.extrasDstList_ = extrasDstList;
        this.zipFile_ = zipFile;
    }

    public int getImportedId() {
        return this.importedId_;
    }

    public void setImportedId(int importedId) {
        this.importedId_ = importedId;
    }

    public Profile getProfile() {
        return this.profile_;
    }

    public GamePack getGamePack() {
        return this.gamePack_;
    }

    public String getFullConfig() {
        return this.fullConfig_;
    }

    public String getIncrConfig() {
        return this.incrConfig_;
    }

    public File getBaseDir() {
        return this.baseDir_.getFile();
    }

    public File getCanonicalBaseDir() {
        return this.baseDir_.getCanonicalFile();
    }

    public void setBaseDir(String baseDir) {
        this.baseDir_ = new FileLocation(baseDir, FileLocationService.getInstance().dosrootRelative());
    }

    public File getGameDir() {
        return this.gameDir_.getFile();
    }

    public File getCanonicalGameDir() {
        return this.gameDir_.getCanonicalFile();
    }

    public String getGameDirAsDosString() {
        return this.gameDir_.getFileAsDosString();
    }

    public String getArchiveGameDirAsDosString() {
        return this.gameDir_.getArchiveFileAsDosString();
    }

    public File getArchiveGameDir() {
        return this.gameDir_.getArchiveFile();
    }

    public void setGameDir(String gameDir) {
        this.gameDir_ = new ArchiveFileLocation(gameDir, FileLocationService.getInstance().dosrootRelative(), new IArchive(){

            @Override
            public File archive(File file) {
                return new File(FileLocationService.DOSROOT_DIR_STRING, new File(String.valueOf(GamePackEntry.this.getId()), file.getPath()).getPath());
            }
        });
    }

    public File getCapturesDir() {
        return this.capturesDir_.getFile();
    }

    public File getCanonicalCapturesDir() {
        return this.capturesDir_.getCanonicalFile();
    }

    public String getArchiveCapturesAsDosString() {
        return this.capturesDir_.getArchiveFileAsDosString();
    }

    public File getArchiveCapturesDir() {
        return this.capturesDir_.getArchiveFile();
    }

    public void setCapturesDir(String capturesDir) {
        this.capturesDir_ = new ArchiveFileLocation(capturesDir, FileLocationService.getInstance().dataRelative(), new IArchive(){

            @Override
            public File archive(File file) {
                return new File(FileLocationService.CAPTURES_DIR_STRING, String.valueOf(GamePackEntry.this.getId()));
            }
        });
    }

    public boolean hasMapper() {
        return this.mapper_ != null;
    }

    public File getMapper() {
        return this.mapper_.getFile();
    }

    public File getCanonicalMapper() {
        return this.mapper_.getCanonicalFile();
    }

    public String getArchiveMapperAsDosString() {
        return this.mapper_.getArchiveFileAsDosString();
    }

    public File getArchiveMapper() {
        return this.mapper_.getArchiveFile();
    }

    public File getNewMapper() {
        return new File(StringUtils.replace((String)this.profile_.getConfigurationCanonicalFile().getPath(), (String)".conf", (String)".map"));
    }

    public void setMapper(String mapper) {
        this.mapper_ = new ArchiveFileLocation(mapper, FileLocationService.getInstance().dosrootRelative(), new IArchive(){

            @Override
            public File archive(File file) {
                return new File(FileLocationService.MAPPER_DIR_STRING, GamePackEntry.this.getId() + ".map");
            }
        });
    }

    public List<File> getCapturesList() {
        return this.capturesList_;
    }

    public List<File> getExtrasList() {
        return this.extrasList_;
    }

    public List<File> getExtrasDstList() {
        return this.extrasDstList_;
    }

    public File getZipFile() {
        return this.zipFile_;
    }

    public File getCanonicalFullDir() {
        return new File(this.baseDir_.getCanonicalFile(), this.gameDir_.getFile().getPath());
    }

    public void stripGameTitleFromBaseDir() {
        String gameTitle = FilesUtils.toSafeFilename(this.getProfile().getTitle());
        if (this.getBaseDir().getName().equals(gameTitle)) {
            this.setBaseDir(this.getBaseDir().getParent());
        }
    }

    public void appendGameTitleToBaseDir() {
        String gameTitle = FilesUtils.toSafeFilename(this.getProfile().getTitle());
        if (!this.getBaseDir().getName().equals(gameTitle)) {
            this.setBaseDir(new File(this.getBaseDir(), gameTitle).getPath());
        }
    }

    @Override
    public int compareTo(GamePackEntry comp) {
        return FilesUtils.toSafeFilename(this.profile_.getTitle()).compareToIgnoreCase(FilesUtils.toSafeFilename(comp.profile_.getTitle()));
    }

    public int getIndexFirstEmptyLink() {
        return IntStream.range(0, this.profile_.getLinks().length).filter(x -> StringUtils.isBlank((CharSequence)this.profile_.getLinkDestination(x))).findFirst().orElse(-1);
    }
}

