/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.archive;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZipEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import org.dbgl.service.TextService;

public class SevenzipExtractFilesCallback
implements IArchiveExtractCallback {
    private ProgressNotifyable prog_;
    private IInArchive archiveHandler_;
    private Map<Integer, File> dstFileMap_;

    public SevenzipExtractFilesCallback(ProgressNotifyable prog, IInArchive archiveHandler, Map<Integer, File> dstFileMap) {
        this.prog_ = prog;
        this.archiveHandler_ = archiveHandler;
        this.dstFileMap_ = dstFileMap;
    }

    @Override
    public int SetTotal(long size) {
        return 0;
    }

    @Override
    public int SetCompleted(long completeValue) {
        this.prog_.setProgress(completeValue);
        return 0;
    }

    @Override
    public int PrepareOperation(int askExtractMode) {
        return 0;
    }

    @Override
    public int SetOperationResult(int operationResult) throws IOException {
        switch (operationResult) {
            case 0: {
                return 0;
            }
            case 1: {
                throw new IOException("Unsupported Method");
            }
            case 3: {
                throw new IOException("CRC Failed");
            }
            case 2: {
                throw new IOException("Data Error");
            }
        }
        throw new IOException("Unknown Error");
    }

    @Override
    public int GetStream(int index, OutputStream[] outStream, int askExtractMode) throws IOException {
        outStream[0] = null;
        if (askExtractMode == 0) {
            SevenZipEntry entry = this.archiveHandler_.getEntry(index);
            File dstFile = this.dstFileMap_.get(index);
            if (entry.isDirectory()) {
                if (dstFile.isDirectory()) {
                    return 0;
                }
                if (dstFile.mkdirs()) {
                    return 0;
                }
                return 1;
            }
            File dirAbove = dstFile.getParentFile();
            if (dirAbove != null && !dirAbove.isDirectory() && !dirAbove.mkdirs()) {
                return 1;
            }
            if (dstFile.exists()) {
                throw new IOException(TextService.getInstance().get("general.error.filetobeextractedexists", new Object[]{dstFile}));
            }
            outStream[0] = new FileOutputStream(dstFile);
        }
        return 0;
    }
}

