/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

public enum FatType {
    FAT12(4080, 4095L, 1.5f){

        @Override
        public long readEntry(byte[] data, int index) {
            int idx = (int)((double)index * 1.5);
            int b1 = data[idx + 0] & 0xFF;
            int b2 = data[idx + 1] & 0xFF;
            int v = b2 << 8 | b1;
            return index % 2 == 0 ? (long)(v & 0xFFF) : (long)(v >> 4);
        }
    }
    ,
    FAT16(65520, 65535L, 2.0f){

        @Override
        public long readEntry(byte[] data, int index) {
            int idx = index << 1;
            int b1 = data[idx + 0] & 0xFF;
            int b2 = data[idx + 1] & 0xFF;
            return b2 << 8 | b1;
        }
    }
    ,
    FAT32(0xFFFFFF0, 0xFFFFFFFFL, 4.0f){

        @Override
        public long readEntry(byte[] data, int index) {
            int idx = index * 4;
            long l1 = data[idx] & 0xFF;
            long l2 = data[idx + 1] & 0xFF;
            long l3 = data[idx + 2] & 0xFF;
            long l4 = data[idx + 3] & 0xFF;
            return l4 << 24 | l3 << 16 | l2 << 8 | l1;
        }
    };

    private final long eofCluster_;
    private final float entrySize_;

    private FatType(int maxClusters, long bitMask, float entrySize) {
        this.eofCluster_ = 0xFFFFFF8L & bitMask;
        this.entrySize_ = entrySize;
    }

    public boolean isEofCluster(long entry) {
        return entry >= this.eofCluster_;
    }

    public float getEntrySize() {
        return this.entrySize_;
    }

    public abstract long readEntry(byte[] var1, int var2);
}

