/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.DaControlConvertorAdapter;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.List_;
import org.dbgl.gui.controls.Scale_;
import org.dbgl.gui.controls.Spinner_;
import org.dbgl.gui.controls.TextControl_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class Chain {
    private static final Color normalFieldColor = Display.getDefault().getSystemColor(21);
    private static final Color conflictingValuesFieldColor = Display.getDefault().getSystemColor(4);
    private static final Color changedFieldValueColor = Display.getDefault().getSystemColor(3);
    private final Label[] labels_;
    private final Control[] controls_;
    private final Text[] texts_;
    private final Combo[] combos_;
    private final Button[] buttons_;
    private final org.eclipse.swt.widgets.List[] lists_;
    private final Spinner[] spinners_;
    private final Scale[] scales_;
    private final Function<TemplateProfileBase, List<NativeCommand>> nativeCommandsGetter_;
    private final BiConsumer<TemplateProfileBase, List<NativeCommand>> nativeCommandsUpdater_;
    private final Function<Template, String> templateStringGetter_;
    private final BiConsumer<Template, String> templateStringUpdater_;
    private final Function<Profile, String> profileStringGetter_;
    private final BiFunction<Profile, Integer, String> profileIndexedStringGetter_;
    private final BiConsumer<Profile, String> profileStringUpdater_;
    private final TriConsumer<Profile, Integer, String> profileIndexedStringUpdater_;
    private final Function<Autoexec, String> autoexecStringGetter_;
    private final BiConsumer<Autoexec, String> autoexecStringUpdater_;
    private final BiFunction<Autoexec, Integer, String> autoexecIndexedStringGetter_;
    private final TriConsumer<Autoexec, Integer, String> autoexecIndexedStringUpdater_;
    private final int index_;
    private final String section_;
    private final String sectionNew_;
    private final String item_;
    private final String itemNew_;
    private final boolean isOnOff_;
    private final DaControlConvertor convertor_;
    private boolean isMultiEdit_;
    private boolean initialValueSet_;
    private boolean conflictingValues_;
    private Object initialValue_;
    private Object currentValue_;

    public Chain(Builder builder) {
        this.labels_ = builder.labels_.toArray(new Label[builder.labels_.size()]);
        this.controls_ = builder.controls_.toArray(new Control[builder.controls_.size()]);
        this.texts_ = builder.texts_.toArray(new Text[builder.texts_.size()]);
        this.combos_ = builder.combos_.toArray(new Combo[builder.combos_.size()]);
        this.buttons_ = builder.buttons_.toArray(new Button[builder.buttons_.size()]);
        this.lists_ = builder.lists_.toArray(new org.eclipse.swt.widgets.List[builder.lists_.size()]);
        this.spinners_ = builder.spinners_.toArray(new Spinner[builder.spinners_.size()]);
        this.scales_ = builder.scales_.toArray(new Scale[builder.scales_.size()]);
        this.nativeCommandsGetter_ = builder.nativeCommandsGetter_;
        this.nativeCommandsUpdater_ = builder.nativeCommandsUpdater_;
        this.templateStringGetter_ = builder.templateStringGetter_;
        this.templateStringUpdater_ = builder.templateStringUpdater_;
        this.profileStringGetter_ = builder.profileStringGetter_;
        this.profileStringUpdater_ = builder.profileStringUpdater_;
        this.profileIndexedStringGetter_ = builder.profileIndexedStringGetter_;
        this.profileIndexedStringUpdater_ = builder.profileIndexedStringUpdater_;
        this.autoexecStringGetter_ = builder.autoexecStringGetter_;
        this.autoexecStringUpdater_ = builder.autoexecStringUpdater_;
        this.autoexecIndexedStringGetter_ = builder.autoexecIndexedStringGetter_;
        this.autoexecIndexedStringUpdater_ = builder.autoexecIndexedStringUpdater_;
        this.index_ = builder.index_;
        this.section_ = builder.section_;
        this.sectionNew_ = builder.sectionNew_;
        this.item_ = builder.item_;
        this.itemNew_ = builder.itemNew_;
        this.isOnOff_ = builder.isOnOff_;
        this.convertor_ = builder.convertor_;
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public void multiEdit() {
        this.isMultiEdit_ = true;
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Chain.this.updateLabelColor();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button;
                if (event.widget instanceof Button && Chain.this.conflictingValues_ && ((button = (Button)event.widget).getStyle() & 0x20) == 32) {
                    if (button.getSelection()) {
                        if (button.getGrayed()) {
                            button.setSelection(false);
                        }
                    } else if (button.getGrayed()) {
                        button.setGrayed(false);
                    } else {
                        button.setGrayed(true);
                        button.setSelection(true);
                    }
                }
                Chain.this.updateLabelColor();
            }
        };
        for (Control cntrl : this.controls_) {
            if (cntrl instanceof Combo) {
                ((Combo)cntrl).addModifyListener(modifyListener);
                continue;
            }
            if (cntrl instanceof Text) {
                ((Text)cntrl).addModifyListener(modifyListener);
                continue;
            }
            if (cntrl instanceof Button) {
                ((Button)cntrl).addSelectionListener((SelectionListener)selectionListener);
                continue;
            }
            if (cntrl instanceof Spinner) {
                ((Spinner)cntrl).addModifyListener(modifyListener);
                continue;
            }
            if (cntrl instanceof Scale) {
                ((Scale)cntrl).addSelectionListener((SelectionListener)selectionListener);
                continue;
            }
            if (!(cntrl instanceof org.eclipse.swt.widgets.List)) continue;
            ((org.eclipse.swt.widgets.List)cntrl).addSelectionListener((SelectionListener)selectionListener);
        }
        this.updateLabelColor();
    }

    private void updateLabelColor() {
        if (this.hasChangedValue()) {
            this.getLabel().setForeground(changedFieldValueColor);
            this.getLabel().setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.alteredvalue"));
        } else if (this.conflictingValues_) {
            this.getLabel().setForeground(conflictingValuesFieldColor);
            this.getLabel().setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.conflictingvalues"));
        } else {
            this.getLabel().setForeground(normalFieldColor);
            this.getLabel().setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.unalteredvalue"));
        }
    }

    public Label[] getLabels() {
        return this.labels_;
    }

    public Label getLabel() {
        return this.labels_[0];
    }

    public Text getText() {
        return this.texts_[0];
    }

    public Combo[] getCombos() {
        return this.combos_;
    }

    public Combo getCombo() {
        return this.combos_[0];
    }

    public Button[] getButtons() {
        return this.buttons_;
    }

    public Button getButton() {
        return this.buttons_[0];
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.lists_[0];
    }

    public Spinner getSpinner() {
        return this.spinners_[0];
    }

    public Scale[] getScales() {
        return this.scales_;
    }

    public Scale getScale() {
        return this.scales_[0];
    }

    public void enableOrDisableControl(TemplateProfileBase configurable) {
        if (StringUtils.isNotBlank((CharSequence)this.section_)) {
            GenerationAwareConfiguration conf = configurable.getDosboxVersion().getConfiguration();
            boolean dosboxHasConfSetting = conf.hasValue(this.confSection(conf), this.confItem(conf));
            Stream.of(this.controls_).forEach(x -> x.setEnabled(dosboxHasConfSetting));
            this.labels_[0].setEnabled(dosboxHasConfSetting);
        }
    }

    public void setControlByConfigurable(TemplateProfileBase configurable, Configuration combinedConf) {
        if (this.nativeCommandsGetter_ != null) {
            this.setControlByNativeCommands(this.nativeCommandsGetter_.apply(configurable));
        } else if (this.templateStringGetter_ != null) {
            this.setControlByStringValue(this.templateStringGetter_.apply((Template)configurable));
        } else if (this.profileStringGetter_ != null) {
            this.setControlByStringValue(this.profileStringGetter_.apply((Profile)configurable));
        } else if (this.profileIndexedStringGetter_ != null) {
            this.setControlByStringValue(this.profileIndexedStringGetter_.apply((Profile)configurable, this.index_));
        } else if (this.autoexecStringGetter_ != null) {
            this.setControlByStringValue(this.autoexecStringGetter_.apply(this.isMultiEdit_ ? configurable.getConfiguration().getAutoexec() : combinedConf.getAutoexec()));
        } else if (this.autoexecIndexedStringGetter_ != null) {
            this.setControlByStringValue(this.autoexecIndexedStringGetter_.apply(this.isMultiEdit_ ? configurable.getConfiguration().getAutoexec() : combinedConf.getAutoexec(), this.index_));
        } else if (StringUtils.isNotBlank((CharSequence)this.section_)) {
            String[] values;
            if (this.allControlsDisabled()) {
                return;
            }
            GenerationAwareConfiguration dosboxConf = configurable.getDosboxVersion().getConfiguration();
            Configuration conf = this.isMultiEdit_ ? configurable.getConfiguration() : combinedConf;
            String[] stringArray = values = conf.hasValue(this.section_, this.item_) && conf.hasValue(this.sectionNew_, this.itemNew_) ? this.convertor_.toControlValues(new String[]{conf.getValue(this.section_, this.item_), conf.getValue(this.sectionNew_, this.itemNew_)}) : this.convertor_.toControlValues(conf.getValue(this.confSection(dosboxConf), this.confItem(dosboxConf)));
            if (values.length != this.controls_.length) {
                Stream.of(this.controls_).forEach(x -> x.setEnabled(false));
                System.err.println(this.toString() + ": control disabled because of configuration mismatch");
                return;
            }
            for (int i = 0; i < this.controls_.length; ++i) {
                this.setFieldValue(this.controls_[i], values[i]);
            }
            if (!this.initialValueSet_) {
                this.initialValue_ = this.getCurrentStringValue();
                this.initialValueSet_ = true;
                this.conflictingValues_ = values.length == 0;
            }
        }
    }

    public void updateConfigurableByControl(TemplateProfileBase configurable, Configuration combinedConf) {
        if (this.nativeCommandsUpdater_ != null) {
            this.nativeCommandsUpdater_.accept(configurable, this.getCurrentNativeCommands());
        } else if (this.templateStringUpdater_ != null) {
            this.templateStringUpdater_.accept((Template)configurable, this.getCurrentStringValue());
        } else if (this.profileStringUpdater_ != null) {
            this.profileStringUpdater_.accept((Profile)configurable, this.getCurrentStringValue());
        } else if (this.profileIndexedStringUpdater_ != null) {
            this.profileIndexedStringUpdater_.accept((Profile)configurable, this.index_, this.getCurrentStringValue());
        } else if (this.autoexecStringUpdater_ != null) {
            this.autoexecStringUpdater_.accept(configurable.getConfiguration().getAutoexec(), this.getCurrentStringValue());
        } else if (this.autoexecIndexedStringUpdater_ != null) {
            this.autoexecIndexedStringUpdater_.accept(configurable.getConfiguration().getAutoexec(), this.index_, this.getCurrentStringValue());
        } else if (StringUtils.isNotBlank((CharSequence)this.section_)) {
            String[] fieldValues = (String[])Stream.of(this.controls_).map(x -> this.getFieldValue((Control)x)).filter(x -> x != null).toArray(String[]::new);
            if (fieldValues.length == 0) {
                return;
            }
            if (combinedConf.hasValue(this.section_, this.item_) && combinedConf.hasValue(this.sectionNew_, this.itemNew_)) {
                String[] confValues = this.convertor_.toConfValues(fieldValues);
                configurable.setValue(this.section_, this.item_, confValues[0]);
                configurable.setValue(this.sectionNew_, this.itemNew_, confValues[1]);
            } else {
                GenerationAwareConfiguration dosboxConf = configurable.getDosboxVersion().getConfiguration();
                String value = this.convertor_.toConfValue(fieldValues);
                configurable.setValue(this.confSection(dosboxConf), this.confItem(dosboxConf), value);
            }
        }
    }

    public void setControlByNativeCommands(List<NativeCommand> cmds) {
        if (cmds == null) {
            this.conflictingValues_ = true;
            return;
        }
        this.currentValue_ = cmds;
        org.eclipse.swt.widgets.List nativeCommandsList = (org.eclipse.swt.widgets.List)this.controls_[0];
        nativeCommandsList.setItems((String[])cmds.stream().map(x -> x.toString()).toArray(String[]::new));
        nativeCommandsList.notifyListeners(13, new Event());
        if (!this.initialValueSet_) {
            this.initialValue_ = cmds;
            this.initialValueSet_ = true;
        }
    }

    private void setControlByStringValue(String value) {
        this.setFieldValue(this.controls_[0], value);
        if (!this.initialValueSet_) {
            this.initialValue_ = this.getCurrentStringValue();
            this.initialValueSet_ = true;
            this.conflictingValues_ = value == null;
        }
    }

    public String getInitialNativeCommandsAsString() {
        return Chain.nativeCommandsToString((List)this.initialValue_);
    }

    public String getInitialStringValue() {
        return (String)this.initialValue_;
    }

    public List<NativeCommand> getCurrentNativeCommands() {
        return (List)this.currentValue_;
    }

    public String getCurrentNativeCommandsAsString() {
        return Chain.nativeCommandsToString(this.getCurrentNativeCommands());
    }

    private static String nativeCommandsToString(List<NativeCommand> obj) {
        if (obj != null) {
            return obj.stream().map(x -> x.toString()).collect(Collectors.joining("; "));
        }
        return "";
    }

    public String getCurrentStringValue() {
        String[] values = (String[])Stream.of(this.controls_).map(x -> this.getFieldValue((Control)x)).filter(x -> x != null).toArray(String[]::new);
        return values.length == this.controls_.length ? this.convertor_.toConfValue(values) : null;
    }

    public boolean conflictingValues() {
        return this.conflictingValues_;
    }

    public boolean hasChangedValue() {
        if (this.allControlsDisabled()) {
            return false;
        }
        if (this.nativeCommandsGetter_ != null) {
            return (List)this.initialValue_ != this.getCurrentNativeCommands();
        }
        return !StringUtils.equals((CharSequence)this.getInitialStringValue(), (CharSequence)this.getCurrentStringValue());
    }

    private String getFieldValue(Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                String contents = ((Text)control).getText();
                String del = ((Text)control).getLineDelimiter();
                return StringUtils.replace((String)StringUtils.strip((String)contents, (String)del), (String)del, (String)SystemUtils.EOLN);
            }
            if (control instanceof Combo) {
                return ((Combo)control).getText();
            }
            if (control instanceof Button && !((Button)control).getGrayed()) {
                boolean v = ((Button)control).getSelection();
                return this.isOnOff_ ? (v ? "on" : "off") : String.valueOf(v);
            }
            if (control instanceof Scale) {
                return String.valueOf(((Scale)control).getSelection());
            }
            if (control instanceof Spinner) {
                return String.valueOf(((Spinner)control).getSelection());
            }
        }
        return null;
    }

    private void setFieldValue(Control control, String value) {
        if (control.isEnabled()) {
            if (value == null) {
                if (control instanceof Button && (((Button)control).getStyle() & 0x20) == 32) {
                    ((Button)control).setSelection(true);
                    ((Button)control).setGrayed(true);
                }
            } else if (control instanceof Text) {
                String newValue = StringUtils.replace((String)value, (String)SystemUtils.EOLN, (String)((Text)control).getLineDelimiter());
                if (!((Text)control).getText().equals(newValue)) {
                    ((Text)control).setText(newValue);
                }
            } else if (control instanceof Combo) {
                if (!((Combo)control).getText().equals(value)) {
                    ((Combo)control).setText(value);
                }
            } else if (control instanceof Button) {
                boolean newValue;
                boolean bl = newValue = this.isOnOff_ ? "on".equalsIgnoreCase(value) : Boolean.valueOf(value).booleanValue();
                if (((Button)control).getSelection() != newValue || ((Button)control).getGrayed()) {
                    ((Button)control).setSelection(newValue);
                    ((Button)control).notifyListeners(13, new Event());
                }
            } else if (control instanceof Scale) {
                Integer newValue = Integer.valueOf(value);
                if (((Scale)control).getSelection() != newValue.intValue()) {
                    ((Scale)control).setSelection(newValue.intValue());
                }
            } else if (control instanceof Spinner) {
                Integer newValue = Integer.valueOf(value);
                if (((Spinner)control).getSelection() != newValue.intValue()) {
                    ((Spinner)control).setSelection(newValue.intValue());
                }
            }
        }
    }

    public void setComboValues(LinkedHashMap<String, String> map) {
        Stream.of(this.getCombos()).forEach(x -> {
            String item;
            String section = (String)x.getData("dynOptSection");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{section, item = (String)x.getData("dynOptItem")})) {
                x.setItems(map == null ? SettingsService.getInstance().getValues(section, item) : Settings.splitValues((String)map.get(item)));
            }
        });
    }

    private String confSection(Configuration conf) {
        return StringUtils.isNotBlank((CharSequence)this.sectionNew_) && StringUtils.isNotBlank((CharSequence)this.itemNew_) && conf.hasValue(this.sectionNew_, this.itemNew_) ? this.sectionNew_ : this.section_;
    }

    private String confItem(Configuration conf) {
        return StringUtils.isNotBlank((CharSequence)this.itemNew_) && (conf.hasValue(this.section_, this.itemNew_) || StringUtils.isNotBlank((CharSequence)this.sectionNew_) && conf.hasValue(this.sectionNew_, this.itemNew_)) ? this.itemNew_ : this.item_;
    }

    private boolean allControlsDisabled() {
        return Stream.of(this.controls_).noneMatch(x -> x.isEnabled());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getLabel().getText());
        if (StringUtils.isNotBlank((CharSequence)this.section_)) {
            result.append(" ([");
            result.append(StringUtils.isNotBlank((CharSequence)this.sectionNew_) ? this.sectionNew_ : this.section_);
            result.append("] ").append(StringUtils.isNotBlank((CharSequence)this.itemNew_) ? this.itemNew_ : this.item_);
            result.append(")");
        }
        return result.toString();
    }

    public static final class Builder {
        private static final DaControlConvertor defaultConvertor = new DaControlConvertorAdapter(){};
        private final Composite composite_;
        private final List<Label> labels_;
        private final List<Control> controls_;
        private final List<Text> texts_;
        private final List<Combo> combos_;
        private final List<Button> buttons_;
        private final List<org.eclipse.swt.widgets.List> lists_;
        private final List<Spinner> spinners_;
        private final List<Scale> scales_;
        private Function<TemplateProfileBase, List<NativeCommand>> nativeCommandsGetter_;
        private BiConsumer<TemplateProfileBase, List<NativeCommand>> nativeCommandsUpdater_;
        private Function<Template, String> templateStringGetter_;
        private BiConsumer<Template, String> templateStringUpdater_;
        private Function<Profile, String> profileStringGetter_;
        private BiFunction<Profile, Integer, String> profileIndexedStringGetter_;
        private BiConsumer<Profile, String> profileStringUpdater_;
        private TriConsumer<Profile, Integer, String> profileIndexedStringUpdater_;
        private Function<Autoexec, String> autoexecStringGetter_;
        private BiConsumer<Autoexec, String> autoexecStringUpdater_;
        private BiFunction<Autoexec, Integer, String> autoexecIndexedStringGetter_;
        private TriConsumer<Autoexec, Integer, String> autoexecIndexedStringUpdater_;
        private int index_;
        private String section_;
        private String sectionNew_;
        private String item_;
        private String itemNew_;
        private boolean isOnOff_;
        private DaControlConvertor convertor_ = defaultConvertor;

        public Builder(Composite composite) {
            this.composite_ = composite;
            this.controls_ = new ArrayList<Control>();
            this.labels_ = new ArrayList<Label>();
            this.texts_ = new ArrayList<Text>();
            this.combos_ = new ArrayList<Combo>();
            this.buttons_ = new ArrayList<Button>();
            this.lists_ = new ArrayList<org.eclipse.swt.widgets.List>();
            this.spinners_ = new ArrayList<Spinner>();
            this.scales_ = new ArrayList<Scale>();
        }

        public Builder lbl(Function<Label_.Builder, Label_.Builder> lb) {
            this.labels_.add(lb.apply(Label_.on(this.composite_)).ctrl());
            return this;
        }

        public Builder txt(Function<Text_.Builder, Text_.Builder> tb) {
            this.texts_.add(tb.apply(Text_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.texts_.get(this.texts_.size() - 1));
            return this;
        }

        public Builder cmb(Function<Combo_.Builder, Combo_.Builder> cb) {
            this.combos_.add(cb.apply(Combo_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.combos_.get(this.combos_.size() - 1));
            return this;
        }

        public Builder but(Function<Button_.Builder, Button_.Builder> bb) {
            TextControl_ textControl = !this.texts_.isEmpty() ? new TextControl_(this.texts_.get(this.texts_.size() - 1)) : (!this.combos_.isEmpty() ? new TextControl_(this.combos_.get(this.combos_.size() - 1)) : null);
            Button button = bb.apply(Button_.on(this.composite_)).ctrl(textControl);
            this.buttons_.add(button);
            if (IntStream.of(16, 2, 32).anyMatch(x -> (button.getStyle() & x) == x)) {
                this.controls_.add((Control)button);
            }
            return this;
        }

        public Builder lst(Function<List_.Builder, List_.Builder> lb) {
            this.lists_.add(lb.apply(List_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.lists_.get(this.lists_.size() - 1));
            return this;
        }

        public Builder spn(Function<Spinner_.Builder, Spinner_.Builder> sb) {
            this.spinners_.add(sb.apply(Spinner_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.spinners_.get(this.spinners_.size() - 1));
            return this;
        }

        public Builder scl(Function<Scale_.Builder, Scale_.Builder> sb) {
            this.scales_.add(sb.apply(Scale_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.scales_.get(this.scales_.size() - 1));
            return this;
        }

        public Builder section(String section) {
            return this.section(section, null);
        }

        public Builder section(String sectionOld, String sectionNew) {
            this.section_ = sectionOld;
            this.sectionNew_ = sectionNew;
            return this;
        }

        public Builder item(String item) {
            return this.item(item, null);
        }

        public Builder item(String itemOld, String itemNew) {
            this.item_ = itemOld;
            this.itemNew_ = itemNew;
            return this;
        }

        public Builder onOff() {
            this.isOnOff_ = true;
            return this;
        }

        public Builder convert(DaControlConvertor convertor) {
            this.convertor_ = convertor;
            return this;
        }

        public Builder nativeCommands(Function<TemplateProfileBase, List<NativeCommand>> getMethod, BiConsumer<TemplateProfileBase, List<NativeCommand>> updateMethod) {
            this.nativeCommandsGetter_ = getMethod;
            this.nativeCommandsUpdater_ = updateMethod;
            return this;
        }

        public Builder template(Function<Template, String> getMethod, BiConsumer<Template, String> updateMethod) {
            this.templateStringGetter_ = getMethod;
            this.templateStringUpdater_ = updateMethod;
            return this;
        }

        public Builder profile(Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
            this.profileStringGetter_ = getMethod;
            this.profileStringUpdater_ = updateMethod;
            return this;
        }

        public Builder profile(int i, BiFunction<Profile, Integer, String> getMethod, TriConsumer<Profile, Integer, String> updateMethod) {
            this.index_ = i;
            this.profileIndexedStringGetter_ = getMethod;
            this.profileIndexedStringUpdater_ = updateMethod;
            return this;
        }

        public Builder autoexec(Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
            this.autoexecStringGetter_ = getMethod;
            this.autoexecStringUpdater_ = updateMethod;
            return this;
        }

        public Builder autoexec(int i, BiFunction<Autoexec, Integer, String> getMethod, TriConsumer<Autoexec, Integer, String> updateMethod) {
            this.index_ = i;
            this.autoexecIndexedStringGetter_ = getMethod;
            this.autoexecIndexedStringUpdater_ = updateMethod;
            return this;
        }

        public Chain build(List<Chain> chains) {
            Chain chain = this.build();
            chains.add(chain);
            return chain;
        }

        public Chain build() {
            return new Chain(this);
        }

        public Label label() {
            return this.build().getLabel();
        }

        public Text text() {
            return this.build().getText();
        }

        public Combo combo() {
            return this.build().getCombo();
        }

        public Button button() {
            return this.build().getButton();
        }

        public org.eclipse.swt.widgets.List list() {
            return this.build().getList();
        }

        public Spinner spinner() {
            return this.build().getSpinner();
        }

        public Scale scale() {
            return this.build().getScale();
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);

        default public TriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after) {
            Objects.requireNonNull(after);
            return (a, b, c) -> {
                this.accept(a, b, c);
                after.accept(a, b, c);
            };
        }
    }
}

