/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuItem_ {
    public static Builder on(Menu menu) {
        return new Builder(menu);
    }

    public static class Builder {
        private final Menu menu_;
        private int style_ = 2;
        private int pos_ = -1;
        private String text_;
        private Image image_;
        private int accelerator_ = -1;
        private SelectionListener listener_;

        Builder(Menu menu) {
            this.menu_ = menu;
        }

        public Builder txt(String text) {
            this.text_ = text;
            this.style_ = 64;
            return this;
        }

        public Builder key(String key) {
            return this.txt(TextService.getInstance().get(key));
        }

        public Builder image(String path) {
            int display = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
            if (display != 1) {
                this.image_ = ImageService.getResourceImage(this.menu_.getDisplay(), path);
            }
            return this;
        }

        public Builder pos(int pos) {
            this.pos_ = pos;
            return this;
        }

        public Builder accel(int acc) {
            this.accelerator_ = acc;
            return this;
        }

        public Builder listen(SelectionListener listener) {
            this.listener_ = listener;
            this.style_ = 0;
            return this;
        }

        public MenuItem build() {
            MenuItem menuItem;
            MenuItem menuItem2 = menuItem = this.pos_ != -1 ? new MenuItem(this.menu_, this.style_, this.pos_) : new MenuItem(this.menu_, this.style_);
            if (this.text_ != null) {
                menuItem.setText(this.text_);
            }
            if (this.image_ != null) {
                menuItem.setImage(this.image_);
            }
            if (this.accelerator_ != -1) {
                menuItem.setAccelerator(this.accelerator_);
            }
            if (this.listener_ != null) {
                menuItem.addSelectionListener(this.listener_);
            }
            return menuItem;
        }
    }
}

