/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.service.TextService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class Spinner_ {
    private final Spinner spinner_;

    private Spinner_(Builder builder) {
        this.spinner_ = new Spinner(builder.composite_, builder.style_);
        this.spinner_.setLayoutData(builder.layoutData());
        if (builder.minimum_ != null) {
            this.spinner_.setMinimum(builder.minimum_.intValue());
        }
        if (builder.maximum_ != null) {
            this.spinner_.setMaximum(builder.maximum_.intValue());
        }
        if (builder.digits_ != null) {
            this.spinner_.setDigits(builder.digits_.intValue());
        }
        if (builder.increment_ != null) {
            this.spinner_.setIncrement(builder.increment_.intValue());
        }
        if (builder.pageIncrement_ != null) {
            this.spinner_.setPageIncrement(builder.pageIncrement_.intValue());
        }
        if (builder.tooltip_ != null) {
            this.spinner_.setToolTipText(builder.tooltip_);
        }
        if (builder.selection_ != null) {
            this.spinner_.setSelection(builder.selection_.intValue());
        }
    }

    public Spinner ctrl() {
        return this.spinner_;
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static class Builder
    extends ControlBuilder<Builder> {
        String tooltip_;
        Integer minimum_ = null;
        Integer maximum_ = null;
        Integer digits_ = null;
        Integer increment_ = null;
        Integer pageIncrement_ = null;
        Integer selection_ = null;

        Builder(Composite composite) {
            super(composite, 2048, 4, 0x1000000, false, false);
        }

        public Builder tooltip(String key) {
            this.tooltip_ = TextService.getInstance().get(key);
            return this;
        }

        public Builder min(int min) {
            this.minimum_ = min;
            return this;
        }

        public Builder max(int max) {
            this.maximum_ = max;
            return this;
        }

        public Builder digits(int digits) {
            this.digits_ = digits;
            return this;
        }

        public Builder incr(int incr) {
            this.increment_ = incr;
            return this;
        }

        public Builder pageIncr(int pageIncr) {
            this.pageIncrement_ = pageIncr;
            return this;
        }

        public Builder select(int select) {
            this.selection_ = select;
            return this;
        }

        public Spinner_ build() {
            return new Spinner_(this);
        }

        public Spinner ctrl() {
            return this.build().ctrl();
        }
    }
}

