/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.abstractdialog.EditProfileDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.GridData_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.dialog.BrowseSearchEngineDialog;
import org.dbgl.gui.dialog.LoadSharedConfDialog;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.gui.dialog.ShareConfDialog;
import org.dbgl.model.FileLocation;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImageService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.MetropolisSearchEngine;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditSingleProfileDialog
extends EditProfileDialog<Profile> {
    private static final boolean multiEdit = false;
    private Profile profile_;
    private final String sendTo_;
    private final boolean editing_;
    private final boolean focusOnTitle_;

    public EditSingleProfileDialog(Shell parent, Profile prof, String sendTo, boolean focusOnTitle) {
        super(parent);
        this.profile_ = prof;
        this.sendTo_ = sendTo;
        this.focusOnTitle_ = focusOnTitle;
        this.editing_ = this.profile_ != null;
    }

    @Override
    protected String getDialogTitle() {
        if (this.editing_) {
            return this.text_.get("dialog.profile.title.edit", new Object[]{this.profile_.getTitle(), this.profile_.getId()});
        }
        if (this.sendTo_ != null) {
            return this.text_.get("dialog.profile.title.send", new Object[]{this.sendTo_});
        }
        return this.text_.get("dialog.profile.title.add");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            StringBuffer warningsLog = new StringBuffer();
            if (this.editing_) {
                this.dbversionIndex_ = DosboxVersionRepository.indexOf(this.dbversionsList_, this.profile_.getDosboxVersion());
            } else {
                Template template = (Template)TemplateRepository.findDefault(this.templatesList_);
                if (template != null) {
                    warningsLog.append(template.resetAndLoadConfiguration());
                }
                this.profile_ = ProfileFactory.create((DosboxVersion)DosboxVersionRepository.findDefault(this.dbversionsList_), template);
                if (this.sendTo_ != null) {
                    if (FilesUtils.isConfFile(this.sendTo_)) {
                        File cwd = null;
                        File filterPath = new File(this.sendTo_).getParentFile();
                        if (filterPath != null && !filterPath.equals(FileLocationService.getInstance().getProfilesDir())) {
                            File dosboxDir = new File(filterPath, "DOSBOX");
                            if (FilesUtils.isExistingDirectory(dosboxDir)) {
                                filterPath = dosboxDir;
                            }
                            Mess_.on(this.getParent()).key("dialog.profile.notice.selectworkingdirectory", this.sendTo_).display();
                            DirectoryDialog dirDialog = new DirectoryDialog(this.getParent());
                            dirDialog.setFilterPath(filterPath.getPath());
                            String resultDir = dirDialog.open();
                            cwd = resultDir != null ? new File(resultDir) : FileLocationService.getInstance().getDosroot();
                        }
                        this.profile_.setConfigurationFileLocation(this.sendTo_);
                        warningsLog.append(this.profile_.resetAndLoadConfiguration(cwd));
                        String additional = "";
                        while (this.profile_.isIncomplete() && additional != null) {
                            Mess_.on(this.getParent()).key("dialog.profile.notice.looksincompleteloadadditional").display();
                            ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.text_.get("filetype.conf"), this.text_.get("filetype.exe") + ", " + this.text_.get("filetype.booterimage"), "*"));
                            ArrayList<String> extensions = new ArrayList<String>(Arrays.asList("*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0;*.fdd;*.FDD;*.fdi;*.FDI;*.d88;*.D88;*.hdi;*.HDI;*.hdm;*.HDM", "*"));
                            FileDialog dialog = new FileDialog(this.getParent(), 4096);
                            dialog.setFilterPath(new File(this.sendTo_).getParent());
                            dialog.setFilterNames(names.toArray(new String[0]));
                            dialog.setFilterExtensions(extensions.toArray(new String[0]));
                            additional = dialog.open();
                            if (additional == null) continue;
                            this.profile_.setConfigurationFileLocation(additional);
                            warningsLog.append(this.profile_.loadConfiguration(cwd));
                        }
                        if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                            Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
                        }
                        return true;
                    }
                    if (FilesUtils.isExecutable(this.sendTo_)) {
                        this.profile_.getConfiguration().getAutoexec().setGameMain(new FileLocation(this.sendTo_, FileLocationService.getInstance().dosrootRelative()).getFile().getPath());
                    } else if (FilesUtils.isBooterImage(this.sendTo_)) {
                        this.profile_.getConfiguration().getAutoexec().setImg1(new FileLocation(this.sendTo_, FileLocationService.getInstance().dosrootRelative()).getFile().getPath());
                    }
                }
            }
            warningsLog.append(this.profile_.resetAndLoadConfiguration());
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
            return true;
        }
        catch (Exception e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    @Override
    protected void updateControlsByConfigurable(TemplateProfileBase configurable) {
        super.updateControlsByConfigurable(configurable);
        this.loadfixValue_.setEnabled(this.loadfix_.getSelection());
    }

    @Override
    protected void doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction action, DosboxVersion newDosboxVersion) {
        try {
            StringBuffer warningsLog = new StringBuffer();
            this.updateConfigurableByControls(this.profile_);
            warningsLog.append(newDosboxVersion.resetAndLoadConfiguration());
            if (action == EditConfigurableDialog.DosboxConfAction.SET) {
                warningsLog.append(this.profile_.setToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.SWITCH) {
                warningsLog.append(this.profile_.switchToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD) {
                warningsLog.append(this.profile_.reloadDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.LOAD_TEMPLATE) {
                Template templ = (Template)this.templatesList_.get(this.templateCombo_.getSelectionIndex());
                templ.setDosboxVersion(newDosboxVersion);
                warningsLog.append(templ.resetAndLoadConfiguration());
                warningsLog.append(this.profile_.loadTemplate(newDosboxVersion, templ));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD_TEMPLATE) {
                Template templ = (Template)this.templatesList_.get(this.templateCombo_.getSelectionIndex());
                templ.setDosboxVersion(newDosboxVersion);
                warningsLog.append(templ.resetAndLoadConfiguration());
                warningsLog.append(this.profile_.reloadTemplate(newDosboxVersion, templ));
            }
            this.updateControlsByConfigurable(this.profile_);
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
        }
    }

    @Override
    protected void onShellCreated() {
        this.createInfoTab();
        this.createGeneralTab(this.editing_ ? this.profile_.getCanonicalCaptures().getPath() : this.text_.get("dialog.profile.automatic"), this.editing_ ? this.profile_.getConfigurationCanonicalFile().getPath() : SettingsDialog.confLocations[this.settings_.getIntValue("profiledefaults", "confpath")] + ", " + SettingsDialog.confFilenames[this.settings_.getIntValue("profiledefaults", "conffile")]);
        this.createDisplayTab();
        this.createMachineTab();
        this.createAudioTab();
        this.createIOTab();
        this.createCustomCommandsTab();
        this.createMountingTab(this.profile_, false);
        this.createOkCancelButtons();
        this.updateControlsByConfigurable(this.profile_);
        if (!this.editing_ || this.focusOnTitle_) {
            this.title_.selectAll();
            this.title_.setFocus();
        }
        VerifyListener addMountListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1 && EditSingleProfileDialog.this.mountingpointsList_.getItemCount() == 0) {
                    boolean booter = event.widget == EditSingleProfileDialog.this.img1_ || event.widget == EditSingleProfileDialog.this.img2_ || event.widget == EditSingleProfileDialog.this.img3_;
                    EditSingleProfileDialog.this.profile_.addRequiredMount(booter, event.text, false);
                    EditSingleProfileDialog.this.mountingpointsList_.setItems(EditSingleProfileDialog.this.profile_.getMountStringsForUI());
                }
            }
        };
        this.main_.addVerifyListener(addMountListener);
        this.setup_.addVerifyListener(addMountListener);
        this.img1_.addVerifyListener(addMountListener);
        this.img2_.addVerifyListener(addMountListener);
        this.img3_.addVerifyListener(addMountListener);
    }

    @Override
    protected ToolBar createInfoTab() {
        ToolBar toolBar = super.createInfoTab();
        final ToolItem engineToolItem = this.engineSelector_.getToolItem();
        engineToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    final int WEB_IMAGE_WIDTH = EditSingleProfileDialog.this.settings_.getIntValue("mobygames", "image_width");
                    int WEB_IMAGE_HEIGHT = EditSingleProfileDialog.this.settings_.getIntValue("mobygames", "image_height");
                    int WEB_IMAGE_COLUMNS = EditSingleProfileDialog.this.settings_.getIntValue("mobygames", "image_columns");
                    int DIALOG_RESIZE_WIDTH = (WEB_IMAGE_WIDTH + 10) * WEB_IMAGE_COLUMNS + 3 * (WEB_IMAGE_COLUMNS - 1) + 19;
                    WebSearchEngine engine = WebSearchEngine.getBySimpleName(EditSingleProfileDialog.this.settings_.getValue("gui", "searchengine"));
                    WebProfile orgProf = (WebProfile)engineToolItem.getData("profile");
                    if (orgProf == null) {
                        String currTitle = EditSingleProfileDialog.this.title_.getText();
                        if (currTitle.length() >= 1) {
                            try {
                                WebProfile thisGame = null;
                                List<WebProfile> webGamesList = engine.getEntries(currTitle, EditSingleProfileDialog.this.settings_.getValues(engine.getSimpleName(), "platform_filter"));
                                if (webGamesList.size() == 0) {
                                    Mess_.on(EditSingleProfileDialog.this.shell_).key("general.notice.searchenginenoresults", new String[]{engine.getName(), currTitle}).display();
                                } else {
                                    thisGame = webGamesList.size() == 1 ? webGamesList.get(0) : (WebProfile)new BrowseSearchEngineDialog(EditSingleProfileDialog.this.shell_, currTitle, webGamesList, engine).open();
                                }
                                if (thisGame != null) {
                                    int ss;
                                    String p;
                                    String n;
                                    final WebProfile profExt = engine.getEntryDetailedInformation(thisGame);
                                    WebProfile currentProf = new WebProfile();
                                    currentProf.setTitle(EditSingleProfileDialog.this.title_.getText());
                                    currentProf.setDeveloperName(EditSingleProfileDialog.this.developer_.getText());
                                    currentProf.setPublisherName(EditSingleProfileDialog.this.publisher_.getText());
                                    currentProf.setYear(EditSingleProfileDialog.this.year_.getText());
                                    currentProf.setGenre(EditSingleProfileDialog.this.genre_.getText());
                                    currentProf.setUrl(EditSingleProfileDialog.this.link_[0].getText());
                                    currentProf.setPlatform(EditSingleProfileDialog.this.linkTitle_[0].getText());
                                    currentProf.setNotes(EditSingleProfileDialog.this.notes_.getText());
                                    currentProf.setRank(EditSingleProfileDialog.this.custom9_.getSelection());
                                    engineToolItem.setData("profile", (Object)currentProf);
                                    engineToolItem.setImage(ImageService.getResourceImage(EditSingleProfileDialog.this.display_, "undo.png"));
                                    engineToolItem.setToolTipText(EditSingleProfileDialog.this.text_.get("dialog.profile.undosearchengine"));
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_title")) {
                                        EditSingleProfileDialog.this.title_.setText(profExt.getTitle());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_developer")) {
                                        EditSingleProfileDialog.this.developer_.setText(profExt.getDeveloperName());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_publisher")) {
                                        EditSingleProfileDialog.this.publisher_.setText(profExt.getPublisherName());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_year")) {
                                        EditSingleProfileDialog.this.year_.setText(profExt.getYear());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_genre")) {
                                        EditSingleProfileDialog.this.genre_.setText(profExt.getGenre());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_link")) {
                                        EditSingleProfileDialog.this.link_[0].setText(profExt.getUrl());
                                        EditSingleProfileDialog.this.linkTitle_[0].setText(EditSingleProfileDialog.this.text_.get("dialog.profile.searchengine.link.maininfo", new String[]{engine instanceof MetropolisSearchEngine ? MobyGamesSearchEngine.getInstance().getName() : engine.getName()}));
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_description") && !(n = EditSingleProfileDialog.this.notes_.getText()).endsWith(p = profExt.getNotes().replaceAll("\n", EditSingleProfileDialog.this.notes_.getLineDelimiter()))) {
                                        if (n.length() > 0) {
                                            EditSingleProfileDialog.this.notes_.append(EditSingleProfileDialog.this.notes_.getLineDelimiter() + EditSingleProfileDialog.this.notes_.getLineDelimiter());
                                        }
                                        EditSingleProfileDialog.this.notes_.append(p);
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_rank")) {
                                        EditSingleProfileDialog.this.custom9_.setSelection(profExt.getRank());
                                    }
                                    int ca = EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "choose_coverart") ? Integer.MAX_VALUE : 0;
                                    int n2 = ss = EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "choose_screenshot") ? Integer.MAX_VALUE : 0;
                                    if (ca > 0 || ss > 0) {
                                        boolean forceAllRegionsCoverArt = EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "force_all_regions_coverart");
                                        EditSingleProfileDialog.access$5102(EditSingleProfileDialog.this, engine.getEntryImages(profExt, ca, ss, forceAllRegionsCoverArt));
                                        EditSingleProfileDialog.this.webImagesSpaceHolder_ = ((Composite_.Builder)Composite_.on(EditSingleProfileDialog.this.contents_).layoutData(new GridData(4, 4, false, true))).innerLayout(2).build();
                                        if (EditSingleProfileDialog.this.imageInformation_.length > 0) {
                                            Chain.on(EditSingleProfileDialog.this.webImagesSpaceHolder_).but(b -> ((Button_.Builder)b.layoutData(new GridData(WEB_IMAGE_WIDTH + 10, -1))).text().key("button.all").listen((SelectionListener)new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent e) {
                                                    for (Button but : EditSingleProfileDialog.this.imgButtons_) {
                                                        if (!but.getSelection()) {
                                                            EditSingleProfileDialog.swapImages(but);
                                                        }
                                                        but.setSelection(true);
                                                    }
                                                }
                                            })).but(b -> ((Button_.Builder)b.layoutData(new GridData(WEB_IMAGE_WIDTH + 10, -1))).text().key("button.none").listen((SelectionListener)new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent e) {
                                                    for (Button but : EditSingleProfileDialog.this.imgButtons_) {
                                                        if (but.getSelection()) {
                                                            EditSingleProfileDialog.swapImages(but);
                                                        }
                                                        but.setSelection(false);
                                                    }
                                                }
                                            })).build();
                                        }
                                        ScrolledComposite webImagesSpace = new ScrolledComposite(EditSingleProfileDialog.this.webImagesSpaceHolder_, 512);
                                        webImagesSpace.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                                        webImagesSpace.setLayout((Layout)new GridLayout());
                                        webImagesSpace.getVerticalBar().setIncrement(WEB_IMAGE_HEIGHT / WEB_IMAGE_COLUMNS);
                                        webImagesSpace.getVerticalBar().setPageIncrement(WEB_IMAGE_HEIGHT / WEB_IMAGE_COLUMNS * 8);
                                        GridLayout gridLayoutImagesGroup = new GridLayout(WEB_IMAGE_COLUMNS, true);
                                        gridLayoutImagesGroup.marginHeight = 0;
                                        gridLayoutImagesGroup.marginWidth = 0;
                                        gridLayoutImagesGroup.horizontalSpacing = 1;
                                        gridLayoutImagesGroup.verticalSpacing = 1;
                                        final Composite webImagesComposite = Composite_.on((Composite)webImagesSpace).layout((Layout)gridLayoutImagesGroup).build();
                                        webImagesSpace.setContent((Control)webImagesComposite);
                                        if (EditSingleProfileDialog.this.imageInformation_.length > 0) {
                                            EditSingleProfileDialog.access$5802(EditSingleProfileDialog.this, new Button[EditSingleProfileDialog.this.imageInformation_.length]);
                                            int i = 0;
                                            while (i < EditSingleProfileDialog.this.imageInformation_.length) {
                                                ((EditSingleProfileDialog)EditSingleProfileDialog.this).imgButtons_[i] = Button_.on(webImagesComposite).image(ImageService.getEmptyImage(EditSingleProfileDialog.this.display_, WEB_IMAGE_WIDTH, WEB_IMAGE_HEIGHT), true).toggle().tooltipTxt(EditSingleProfileDialog.this.imageInformation_[i].getDescription()).ctrl();
                                                final int j = i++;
                                                Thread thread = new Thread(){

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            final ImageData imgData = profExt.getWebImage(j);
                                                            if (!EditSingleProfileDialog.this.display_.isDisposed()) {
                                                                EditSingleProfileDialog.this.display_.asyncExec(new Runnable(){

                                                                    @Override
                                                                    public void run() {
                                                                        if (!EditSingleProfileDialog.this.imgButtons_[j].isDisposed()) {
                                                                            Image img = ImageService.getWidthLimitedImage(EditSingleProfileDialog.this.display_, WEB_IMAGE_WIDTH, imgData);
                                                                            Image selectedImg = ImageService.createSelectedImage(img);
                                                                            EditSingleProfileDialog.this.imgButtons_[j].getImage().dispose();
                                                                            EditSingleProfileDialog.this.imgButtons_[j].setImage(img);
                                                                            EditSingleProfileDialog.this.imgButtons_[j].setData("selectedImage", (Object)selectedImg);
                                                                            EditSingleProfileDialog.this.imgButtons_[j].addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                                                public void widgetSelected(SelectionEvent e) {
                                                                                    EditSingleProfileDialog.swapImages(EditSingleProfileDialog.this.imgButtons_[j]);
                                                                                }
                                                                            });
                                                                            webImagesComposite.setSize(webImagesComposite.computeSize(-1, -1));
                                                                            webImagesComposite.layout();
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                };
                                                thread.start();
                                            }
                                        } else {
                                            ((Label_.Builder)((Label_.Builder)Label_.on(webImagesComposite).style(0x1000040)).layoutData(new GridData_(0x1000000, 4, true, true, WEB_IMAGE_COLUMNS, 1).widthHint((WEB_IMAGE_WIDTH + 10) * WEB_IMAGE_COLUMNS + 3 * (WEB_IMAGE_COLUMNS - 1) + 2).verticalIndent(WEB_IMAGE_HEIGHT / 2).build())).key("dialog.profile.notice.noimagesfound", engine.getName()).build();
                                        }
                                        EditSingleProfileDialog.this.setListenerEnabled(false);
                                        webImagesComposite.pack();
                                        EditSingleProfileDialog.this.shell_.setSize(((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().x + DIALOG_RESIZE_WIDTH, ((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().y);
                                        EditSingleProfileDialog.this.shell_.layout();
                                    }
                                }
                            }
                            catch (Exception e) {
                                Mess_.on(EditSingleProfileDialog.this.shell_).key("general.error.retrieveinfosearchengine", new String[]{engine.getName(), currTitle, StringRelatedUtils.toString(e)}).exception(e).warning();
                            }
                        }
                    } else {
                        EditSingleProfileDialog.this.title_.setText(orgProf.getTitle());
                        EditSingleProfileDialog.this.developer_.setText(orgProf.getDeveloperName());
                        EditSingleProfileDialog.this.publisher_.setText(orgProf.getPublisherName());
                        EditSingleProfileDialog.this.year_.setText(orgProf.getYear());
                        EditSingleProfileDialog.this.genre_.setText(orgProf.getGenre());
                        EditSingleProfileDialog.this.link_[0].setText(orgProf.getUrl());
                        EditSingleProfileDialog.this.linkTitle_[0].setText(orgProf.getPlatform());
                        EditSingleProfileDialog.this.notes_.setText(orgProf.getNotes());
                        EditSingleProfileDialog.this.custom9_.setSelection(orgProf.getRank());
                        engineToolItem.setData("profile", null);
                        engineToolItem.setImage(ImageService.getResourceImage(EditSingleProfileDialog.this.display_, engine.getIcon()));
                        engineToolItem.setToolTipText(EditSingleProfileDialog.this.text_.get("dialog.profile.consultsearchengine", new String[]{engine.getName()}));
                        if (EditSingleProfileDialog.this.webImagesSpaceHolder_ != null) {
                            EditSingleProfileDialog.this.webImagesSpaceHolder_.dispose();
                            EditSingleProfileDialog.this.webImagesSpaceHolder_ = null;
                            EditSingleProfileDialog.this.shell_.setSize(((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().x - DIALOG_RESIZE_WIDTH, ((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().y);
                            EditSingleProfileDialog.this.shell_.layout();
                            EditSingleProfileDialog.this.setListenerEnabled(true);
                            EditSingleProfileDialog.access$9702(EditSingleProfileDialog.this, null);
                        }
                    }
                }
            }
        });
        EditSingleProfileDialog.createImageToolItem(toolBar, 8, ImageService.getResourceImage(this.display_, "share.png"), this.text_.get("button.consultconfsearchengine", new String[]{"DBConfWS"}), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String currTitle = EditSingleProfileDialog.this.title_.getText();
                if (currTitle.length() >= 1) {
                    try {
                        Client client = ClientBuilder.newClient();
                        List confs = (List)client.target(EditSingleProfileDialog.this.settings_.getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)currTitle).request().accept(new String[]{"application/xml"}).get((GenericType)new GenericType<List<SharedConf>>(){});
                        client.close();
                        if (confs.size() == 0) {
                            Mess_.on(EditSingleProfileDialog.this.shell_).key("general.notice.searchenginenoresults", new String[]{"DBConfWS", currTitle}).display();
                            return;
                        }
                        LoadSharedConfDialog.SharedConfLoading result = (LoadSharedConfDialog.SharedConfLoading)new LoadSharedConfDialog(EditSingleProfileDialog.this.shell_, currTitle, confs).open();
                        if (result != null) {
                            EditSingleProfileDialog.this.updateConfigurableByControls(EditSingleProfileDialog.this.profile_);
                            if (result.reloadDosboxDefaults_) {
                                EditSingleProfileDialog.this.profile_.getConfiguration().clearSections();
                            }
                            EditSingleProfileDialog.this.profile_.loadConfigurationData(EditSingleProfileDialog.this.text_, result.conf_.getIncrConf(), new File(result.conf_.getGameTitle()));
                            EditSingleProfileDialog.this.updateControlsByConfigurable(EditSingleProfileDialog.this.profile_);
                        }
                    }
                    catch (Exception e) {
                        Mess_.on(EditSingleProfileDialog.this.shell_).key("general.error.retrieveinfosearchengine", new String[]{"DBConfWS", currTitle, StringRelatedUtils.toString(e)}).exception(e).warning();
                    }
                }
            }
        });
        return toolBar;
    }

    private static void swapImages(Button btn) {
        Image img1 = btn.getImage();
        Image img2 = (Image)btn.getData("selectedImage");
        btn.setImage(img2);
        btn.setData("selectedImage", (Object)img1);
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditSingleProfileDialog.this.isValid()) {
                    return;
                }
                try {
                    EditSingleProfileDialog.this.updateConfigurableByControls(EditSingleProfileDialog.this.profile_);
                    if (EditSingleProfileDialog.this.editing_) {
                        new ProfileRepository().update(EditSingleProfileDialog.this.profile_);
                        EditSingleProfileDialog.this.result_ = EditSingleProfileDialog.this.profile_;
                    } else {
                        EditSingleProfileDialog.this.result_ = new ProfileRepository().add(EditSingleProfileDialog.this.profile_);
                    }
                    if (EditSingleProfileDialog.this.imageInformation_ != null) {
                        File canonicalCapturesDir = EditSingleProfileDialog.this.profile_.getCanonicalCaptures();
                        for (int i = 0; i < EditSingleProfileDialog.this.imageInformation_.length; ++i) {
                            if (!EditSingleProfileDialog.this.imgButtons_[i].getSelection()) continue;
                            String description = FilesUtils.toSafeFilenameForWebImages(EditSingleProfileDialog.this.imageInformation_[i].getDescription());
                            String filename = EditSingleProfileDialog.this.imageInformation_[i].getType() == SearchEngineImageInformation.SearchEngineImageType.CoverArt ? EditSingleProfileDialog.this.text_.get("dialog.profile.mobygames.coverartfilename", new Object[]{i, description}) : EditSingleProfileDialog.this.text_.get("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                            File file = new File(canonicalCapturesDir, filename + ".png");
                            if (!FilesUtils.isExistingFile(file)) {
                                try {
                                    ImageService.save(EditSingleProfileDialog.this.display_, EditSingleProfileDialog.this.imageInformation_[i].getData(), file.getPath());
                                }
                                catch (SWTException e) {
                                    Mess_.on(EditSingleProfileDialog.this.shell_).key("general.error.savefile", file.getPath()).exception((Exception)((Object)e)).warning();
                                }
                                continue;
                            }
                            Mess_.on(EditSingleProfileDialog.this.shell_).key("dialog.profile.error.imagealreadyexists", new Object[]{file.getPath(), WebSearchEngine.getBySimpleName(EditSingleProfileDialog.this.settings_.getValue("gui", "searchengine")).getName()}).warning();
                        }
                    }
                }
                catch (Exception e) {
                    Mess_.on(EditSingleProfileDialog.this.shell_).exception(e).warning();
                }
                EditSingleProfileDialog.this.shell_.close();
            }
        });
        Button_.on(this.otherButtons_).imageText("share.png", "button.shareconf").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditSingleProfileDialog.this.updateConfigurableByControls(EditSingleProfileDialog.this.profile_);
                new ShareConfDialog(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.title_.getText(), EditSingleProfileDialog.this.year_.getText(), EditSingleProfileDialog.this.profile_).open();
            }
        }).build();
    }

    protected boolean isValid() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        String requiredMount = null;
        if (this.title_.getText().length() == 0) {
            mess.key("dialog.profile.required.title").bind((Control)this.title_, this.getTabItemByControl((Control)this.title_));
        }
        if (this.dosExpandItem_.getExpanded()) {
            if (FilesUtils.isExecutable(this.main_.getText())) {
                requiredMount = this.dealWithField(false, this.main_.getText());
            } else {
                mess.key("dialog.profile.required.mainexe").bind((Control)this.main_, this.getTabItemByControl((Control)this.main_));
            }
            if (FilesUtils.isExecutable(this.setup_.getText())) {
                requiredMount = this.dealWithField(false, this.setup_.getText());
            }
        } else {
            if (this.img1_.getText().length() == 0) {
                mess.key("dialog.profile.required.booterimage").bind((Control)this.img1_, this.getTabItemByControl((Control)this.img1_));
            } else {
                requiredMount = this.dealWithField(true, this.img1_.getText());
            }
            if (this.img2_.getText().length() > 0) {
                requiredMount = this.dealWithField(true, this.img2_.getText());
            }
            if (this.img3_.getText().length() > 0) {
                requiredMount = this.dealWithField(true, this.img3_.getText());
            }
        }
        if (requiredMount != null) {
            mess.key("dialog.profile.required.mountlocation").bind((Control)this.mountingpointsList_, this.getTabItemByControl((Control)this.mountingpointsList_));
        }
        if (this.setButton_.isEnabled()) {
            mess.key("dialog.template.required.dosboxassociation").bind((Control)this.setButton_, this.getTabItemByControl((Control)this.setButton_));
        }
        this.validateMounts(this.profile_, mess);
        return mess.valid();
    }

    private String dealWithField(boolean booter, String target) {
        String requiredMount = this.profile_.getRequiredMount(booter, target, true, false);
        if (requiredMount != null && Mess_.on(this.shell_).key("dialog.profile.confirm.addmountlocation", requiredMount).confirm()) {
            this.profile_.addRequiredMount(booter, target, false);
            this.mountingpointsList_.setItems(this.profile_.getMountStringsForUI());
        }
        return this.profile_.getRequiredMount(booter, target, true, false);
    }

    static /* synthetic */ SearchEngineImageInformation[] access$5102(EditSingleProfileDialog x0, SearchEngineImageInformation[] x1) {
        x0.imageInformation_ = x1;
        return x1;
    }

    static /* synthetic */ Button[] access$5802(EditSingleProfileDialog x0, Button[] x1) {
        x0.imgButtons_ = x1;
        return x1;
    }

    static /* synthetic */ SearchEngineImageInformation[] access$9702(EditSingleProfileDialog x0, SearchEngineImageInformation[] x1) {
        x0.imageInformation_ = x1;
        return x1;
    }
}

