/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.thread.DFendImportThread;
import org.dbgl.gui.thread.DFendReloadedImportThread;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DFendImportDialog
extends JobWizardDialog<Object> {
    private DosboxVersion defaultDbversion_;
    private ExpandItem orginalExpandItem_;
    private Text location_;
    private Text dfrLocation_;
    private Text dfrConfsLocation_;
    private Button cleanup_;
    private Button dfrCleanup_;

    public DFendImportDialog(Shell parent, DosboxVersion dbversion) {
        super(parent, "dfendimportdialog");
        this.defaultDbversion_ = dbversion;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.dfendimport.title");
    }

    @Override
    protected void onShellCreated() {
        Group optionsGroup = Group_.on((Composite)this.shell_).layout((Layout)new FillLayout()).key("dialog.dfendimport.options").build();
        final ExpandBar bar = new ExpandBar((Composite)optionsGroup, 512);
        Composite originalComposite = Composite_.on((Composite)bar).layout((Layout)new GridLayout(3, false)).build();
        this.location_ = Chain.on(originalComposite).lbl(l -> l.key("dialog.dfendimport.dfendpath")).txt(t -> t.val(FileLocationService.DFEND_STRING)).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DFEND, false)).text();
        this.cleanup_ = Chain.on(originalComposite).lbl(l -> l.key("dialog.dfendimport.cleanup")).but(b -> ((Button_.Builder)b.horSpan(2)).key("dialog.dfendimport.removesections").select(true)).button();
        this.orginalExpandItem_ = DFendImportDialog.createExpandItem(bar, "dialog.dfendimport.original.title", false, originalComposite);
        Composite reloadedComposite = Composite_.on((Composite)bar).layout((Layout)new GridLayout(3, false)).build();
        this.dfrLocation_ = Chain.on(reloadedComposite).lbl(l -> l.key("dialog.dfendimport.reloaded.path")).txt(t -> t.val(FileLocationService.DFEND_RELOADED_PATH_STRING)).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.NONE, false)).text();
        this.dfrConfsLocation_ = Chain.on(reloadedComposite).lbl(l -> l.key("dialog.dfendimport.reloaded.exportedconfspath")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.NONE, false)).text();
        this.dfrCleanup_ = Chain.on(reloadedComposite).lbl(l -> l.key("dialog.dfendimport.cleanup")).but(b -> ((Button_.Builder)b.horSpan(2)).key("dialog.dfendimport.reloaded.removesections").select(false)).button();
        DFendImportDialog.createExpandItem(bar, "dialog.dfendimport.reloaded.title", true, reloadedComposite);
        bar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(DFendImportDialog.this.text_.get("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(true);
                DFendImportDialog.this.display_.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DFendImportDialog.this.shell_.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(DFendImportDialog.this.text_.get("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(false);
                DFendImportDialog.this.display_.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DFendImportDialog.this.shell_.layout();
                    }
                });
            }
        });
        this.addStep(optionsGroup);
        this.addFinalStep("dialog.dfendimport.progress", "dialog.dfendimport.startimport");
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 0) {
            if (!this.isValid()) {
                return false;
            }
        } else if (step == 1) {
            try {
                if (this.orginalExpandItem_.getExpanded()) {
                    this.job_ = new DFendImportThread(this.log_, this.progressBar_, this.status_, new File(this.location_.getText()), this.cleanup_.getSelection(), this.defaultDbversion_);
                }
                this.job_ = new DFendReloadedImportThread(this.log_, this.progressBar_, this.status_, new File(this.dfrLocation_.getText()), new File(this.dfrConfsLocation_.getText()), this.dfrCleanup_.getSelection(), this.defaultDbversion_);
            }
            catch (IOException e) {
                Mess_.on(this.shell_).exception(e).warning();
                return false;
            }
        } else if (step == 2) {
            if (this.job_.isEverythingOk()) {
                Mess_.on(this.shell_).key("dialog.dfendimport.notice.importok").display();
            } else {
                Mess_.on(this.shell_).key("dialog.dfendimport.error.problem").warning();
            }
            this.status_.setText(this.text_.get("dialog.dfendimport.reviewlog"));
            this.status_.pack();
            this.result_ = this.job_;
        }
        return true;
    }

    private boolean isValid() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (this.orginalExpandItem_.getExpanded()) {
            if (StringUtils.isBlank((CharSequence)this.location_.getText())) {
                mess.key("dialog.dfendimport.required.location").bind((Control)this.location_);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)this.dfrLocation_.getText())) {
                mess.key("dialog.dfendimport.reloaded.required.location").bind((Control)this.dfrLocation_);
            }
            if (StringUtils.isBlank((CharSequence)this.dfrConfsLocation_.getText())) {
                mess.key("dialog.dfendimport.reloaded.required.confslocation").bind((Control)this.dfrConfsLocation_);
            }
        }
        return mess.valid();
    }
}

