/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.thread.ExportThread;
import org.dbgl.model.GamePack;
import org.dbgl.model.ICanonicalize;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.GamePackEntry;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExportDialog
extends JobWizardDialog<Object> {
    private static final Color normalValueColor = Display.getDefault().getSystemColor(25);
    private static final Color suspiciousValueColor = Display.getDefault().getSystemColor(7);
    private GamePack gamePack_ = new GamePack();
    private Button settingsOnly_;
    private Button exportGameData_;
    private Button exportCapturesButton_;
    private Button exportMapperfilesButton_;
    private Button exportNativeCommandsButton_;
    private Text title_;
    private Text notes_;
    private Text author_;
    private Text filename_;
    private Table profilesTable_;
    private ICanonicalize canonicalizer_;

    public ExportDialog(Shell parent, List<Profile> profiles) {
        super(parent, "export");
        for (int i = 0; i < profiles.size(); ++i) {
            Profile prof = profiles.get(i);
            this.gamePack_.getEntries().add(new GamePackEntry(i, prof, this.gamePack_));
        }
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.export.title", new Object[]{this.gamePack_.getEntries().size()});
    }

    @Override
    protected int stepSize(int step, boolean forward) {
        if ((step == 0 && forward || step == 2 && !forward) && this.settingsOnly_.getSelection()) {
            return 2;
        }
        return super.stepSize(step, forward);
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 1) {
            return this.isValidGameDirs();
        }
        if (step == 2) {
            return this.isValidTargetZip();
        }
        if (step == 3) {
            try {
                this.gamePack_.setTitle(this.title_.getText());
                this.gamePack_.setAuthor(this.author_.getText());
                this.gamePack_.setNotes(this.notes_.getText());
                this.gamePack_.setCapturesAvailable(this.exportCapturesButton_.getSelection());
                this.gamePack_.setMapperfilesAvailable(this.exportMapperfilesButton_.getSelection());
                this.gamePack_.setNativecommandsAvailable(this.exportNativeCommandsButton_.getSelection());
                this.gamePack_.setGamedataAvailable(this.exportGameData_.getSelection());
                this.job_ = new ExportThread(this.log_, this.progressBar_, this.status_, this.gamePack_, this.canonicalizer_.canonicalize(new File(this.filename_.getText())));
            }
            catch (Exception ex) {
                Mess_.on(this.shell_).exception(ex).warning();
                this.job_ = null;
                return false;
            }
        } else if (step == 4) {
            if (this.job_.isEverythingOk()) {
                Mess_.on(this.shell_).key("dialog.export.notice.exportok").display();
            } else {
                Mess_.on(this.shell_).key("dialog.export.error.problem").warning();
            }
            this.status_.setText(this.text_.get("dialog.export.reviewlog"));
            this.status_.pack();
        }
        return true;
    }

    private boolean isValidTargetZip() {
        String gpaFilename;
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank((CharSequence)this.title_.getText())) {
            mess.key("dialog.export.required.title").bind((Control)this.title_);
        }
        if (StringUtils.isBlank((CharSequence)(gpaFilename = this.filename_.getText()))) {
            mess.key("dialog.export.required.filename").bind((Control)this.filename_);
        } else {
            File target = this.canonicalizer_.canonicalize(new File(gpaFilename));
            if (FilesUtils.isExistingFile(target)) {
                mess.key("dialog.export.error.fileexists", new Object[]{target}).bind((Control)this.filename_);
            } else if (!FilesUtils.isExistingDirectory(target.getParentFile())) {
                mess.key("dialog.export.error.exportdirmissing", new Object[]{target}).bind((Control)this.filename_);
            }
        }
        return mess.valid();
    }

    private boolean isValidGameDirs() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        for (GamePackEntry entry : this.gamePack_.getEntries()) {
            if (!FilesUtils.isExistingDirectory(entry.getCanonicalGameDir())) {
                mess.key("dialog.export.error.gamedirmissing", new Object[]{entry.getCanonicalGameDir()}).bind((Control)this.profilesTable_);
            }
            if (entry.getGameDir().isAbsolute()) {
                mess.key("dialog.export.error.gamedirnotrelative", new Object[]{entry.getGameDir()}).bind((Control)this.profilesTable_);
            }
            for (GamePackEntry entry2 : this.gamePack_.getEntries()) {
                if (entry == entry2 || !FilesUtils.areRelated(entry.getCanonicalGameDir(), entry2.getCanonicalGameDir())) continue;
                mess.key("dialog.export.error.gamedirsconflict", new Object[]{entry.getCanonicalGameDir(), entry.getProfile().getTitle(), entry2.getCanonicalGameDir(), entry2.getProfile().getTitle()}).bind((Control)this.profilesTable_);
            }
        }
        return mess.valid();
    }

    @Override
    protected void onShellCreated() {
        Group group1 = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(2, false)).key("dialog.export.step1").build();
        SelectionAdapter gameDataAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDialog.this.settings_.setBooleanValue("exportwizard", "gamedata", ExportDialog.this.exportGameData_.getSelection());
            }
        };
        this.settingsOnly_ = Chain.on((Composite)group1).lbl(l -> l.key("dialog.export.export")).but(arg_0 -> this.lambda$onShellCreated$1((SelectionListener)gameDataAdapter, arg_0)).button();
        this.exportGameData_ = Chain.on((Composite)group1).lbl(l -> l).but(arg_0 -> this.lambda$onShellCreated$3((SelectionListener)gameDataAdapter, arg_0)).button();
        Chain.on((Composite)group1).lbl(l -> (Label_.Builder)l.horSpan(2));
        this.exportCapturesButton_ = Chain.on((Composite)group1).lbl(l -> l).but(b -> b.key("dialog.template.captures").select(true)).button();
        this.exportMapperfilesButton_ = Chain.on((Composite)group1).lbl(l -> l).but(b -> b.key("dialog.template.mapperfile")).button();
        this.exportNativeCommandsButton_ = Chain.on((Composite)group1).lbl(l -> l).but(b -> b.key("dialog.export.nativecommands")).button();
        this.addStep(group1);
        Group reviewDirsGroup = Group_.on((Composite)this.shell_).layout((Layout)new FillLayout()).key("dialog.export.step2").build();
        this.profilesTable_ = new Table((Composite)reviewDirsGroup, 67584);
        this.profilesTable_.setHeaderVisible(true);
        this.profilesTable_.setLinesVisible(true);
        TableColumn titleColumn = new TableColumn(this.profilesTable_, 0);
        titleColumn.setWidth(260);
        titleColumn.setText(this.text_.get("dialog.main.profiles.column.title"));
        TableColumn subdirColumn = new TableColumn(this.profilesTable_, 0);
        subdirColumn.setWidth(120);
        subdirColumn.setText(this.text_.get("dialog.export.column.gamedir"));
        for (GamePackEntry entry : this.gamePack_.getEntries()) {
            TableItem item = new TableItem(this.profilesTable_, 0);
            item.setText(entry.getProfile().getTitle());
            item.setText(1, entry.getGameDir().getPath());
            item.setBackground(entry.getGameDir().getPath().contains(File.separator) ? suspiciousValueColor : normalValueColor);
        }
        this.profilesTable_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                int idx = ExportDialog.this.profilesTable_.getSelectionIndex();
                GamePackEntry entry = ExportDialog.this.gamePack_.getEntries().get(idx);
                DirectoryDialog dialog = new DirectoryDialog(ExportDialog.this.shell_);
                dialog.setFilterPath(entry.getCanonicalGameDir().getPath());
                String result = dialog.open();
                if (result != null) {
                    entry.setGameDir(result);
                    ExportDialog.this.profilesTable_.getSelection()[0].setText(1, entry.getGameDir().getPath());
                    ExportDialog.this.profilesTable_.getSelection()[0].setBackground(entry.getGameDir().getPath().contains(File.separator) ? suspiciousValueColor : normalValueColor);
                }
            }
        });
        this.addStep(reviewDirsGroup);
        Group settingsGroup = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.export.step3").build();
        this.title_ = Chain.on((Composite)settingsGroup).lbl(l -> l.key("dialog.export.exporttitle")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        this.title_.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldTitle = ExportDialog.this.title_.getText();
                String newTitle = oldTitle.substring(0, e.start) + e.text + oldTitle.substring(e.end);
                String filename = ExportDialog.this.filename_.getText();
                if (StringUtils.isBlank((CharSequence)filename) || filename.equals(FileLocationService.getGpaExportFile(filename, oldTitle))) {
                    ExportDialog.this.filename_.setText(FileLocationService.getGpaExportFile(filename, newTitle));
                }
            }
        });
        this.author_ = Chain.on((Composite)settingsGroup).lbl(l -> l.key("dialog.export.author")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        this.notes_ = Chain.on((Composite)settingsGroup).lbl(l -> l.key("dialog.export.notes")).txt(t -> (Text_.Builder)t.multi().wrap().horSpan(2)).text();
        StringBuffer sb = new StringBuffer();
        for (GamePackEntry entry : this.gamePack_.getEntries()) {
            sb.append(entry.getProfile().getTitle()).append(this.notes_.getLineDelimiter());
        }
        this.notes_.setText(sb.toString());
        Chain chn = Chain.on((Composite)settingsGroup).lbl(l -> l.key("dialog.export.file")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DBGLZIP, true)).build();
        this.filename_ = chn.getText();
        this.canonicalizer_ = (ICanonicalize)chn.getButton().getData("canonicalizer");
        this.addStep(settingsGroup);
        this.addFinalStep("dialog.export.step4", "dialog.export.start");
    }

    private /* synthetic */ Button_.Builder lambda$onShellCreated$3(SelectionListener gameDataAdapter, Button_.Builder b) {
        return b.radio().key("dialog.export.export.games").select(this.settings_.getBooleanValue("exportwizard", "gamedata")).listen(gameDataAdapter);
    }

    private /* synthetic */ Button_.Builder lambda$onShellCreated$1(SelectionListener gameDataAdapter, Button_.Builder b) {
        return b.radio().key("dialog.export.export.profiles").select(!this.settings_.getBooleanValue("exportwizard", "gamedata")).listen(gameDataAdapter);
    }
}

