/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf.dfend;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.dfend.DFendProfile;
import org.dbgl.service.TextService;

public class DFendReloadedConfiguration {
    private Settings datConfiguration_ = new Settings();
    private Map<File, DFendProfile> profiles_;

    public DFendReloadedConfiguration(File file) {
        this.datConfiguration_.setFileLocation(new FileLocation(file.getPath()));
        this.profiles_ = new LinkedHashMap<File, DFendProfile>();
    }

    public String loadDat(File profsPath, File confsPath) throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        warningsLog.append(this.datConfiguration_.load(TextService.getInstance()));
        for (File profFile : FileUtils.listFiles(profsPath, new String[]{"prof"}, false)) {
            File confFile = new File(confsPath, FilenameUtils.removeExtension(profFile.getName()) + ".conf");
            Configuration prof = new Configuration();
            prof.setFileLocation(new FileLocation(profFile.getPath()));
            Configuration conf = new Configuration();
            conf.setFileLocation(new FileLocation(confFile.getPath()));
            this.profiles_.put(profFile, new DFendProfile(prof, conf));
        }
        return warningsLog.toString();
    }

    public String loadProfile(File profFile) throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        warningsLog.append(this.profiles_.get(profFile).getProf().load(TextService.getInstance()));
        warningsLog.append(this.profiles_.get(profFile).load(TextService.getInstance()));
        return warningsLog.toString();
    }

    public List<File> getConfFiles() {
        return new ArrayList<File>(this.profiles_.keySet());
    }

    public String getValue(String sectionTitle, String sectionItem) {
        return this.datConfiguration_.getValue(sectionTitle, sectionItem);
    }

    public String getValue(File profFile, String sectionTitle, String sectionItem) {
        return StringUtils.defaultString((String)this.profiles_.get(profFile).getProf().getValue(sectionTitle, sectionItem));
    }

    public File getConfFile(File profFile) {
        return this.profiles_.get(profFile).getConf().getFile();
    }

    public File getConfCanonicalFile(File profFile) {
        return this.profiles_.get(profFile).getConf().getCanonicalFile();
    }

    public String getConf(File profFile) {
        return this.profiles_.get(profFile).getConf().toString(null);
    }
}

