/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.entity;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.model.GenericStats;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.conf.mount.OverlayMount;
import org.dbgl.model.entity.Configurable;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.service.ITextService;
import org.dbgl.service.TextService;

public abstract class TemplateProfileBase
extends Configurable {
    private DosboxVersion dosboxVersion_;
    private List<NativeCommand> nativeCommands_;
    private GenericStats stats_;

    public abstract void setConfigurationFileLocationByIdentifiers();

    public abstract void setBooter(boolean var1);

    public DosboxVersion getDosboxVersion() {
        return this.dosboxVersion_;
    }

    public void setDosboxVersion(DosboxVersion dosboxVersion) {
        this.dosboxVersion_ = dosboxVersion;
    }

    public List<NativeCommand> getNativeCommands() {
        return this.nativeCommands_;
    }

    public void setNativeCommands(List<NativeCommand> nativeCommands) {
        this.nativeCommands_ = nativeCommands;
    }

    public void setNativeCommandsWithObject(Object nativeCommands) {
        this.nativeCommands_ = (List)nativeCommands;
    }

    public void resetNativeCommands() {
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        this.setNativeCommands(nativeCommands);
    }

    public GenericStats getStats() {
        return this.stats_;
    }

    public void setStats(GenericStats stats) {
        this.stats_ = stats;
    }

    public String getConfigurationString() {
        return this.configuration_.toString(this.getNettoMountingPoints());
    }

    public Configuration getCombinedConfiguration() {
        ITextService text = TextService.getInstance();
        Configuration conf = new Configuration();
        try {
            StringBuffer warnings = new StringBuffer();
            warnings.append(conf.loadDataWithAutoexec(text, this.dosboxVersion_.getConfigurationString(), this.dosboxVersion_.getConfigurationFile(), null));
            warnings.append(conf.loadDataWithAutoexec(text, this.getConfigurationString(), this.configuration_.getFileLocation() != null ? this.getConfigurationFile() : null, null));
            conf.getAutoexec().setBooterByDefault(this.configuration_.getAutoexec().getBooterByDefault());
            conf.getAutoexec().setGameMain(this.configuration_.getAutoexec().getGameMain());
            if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                System.err.println(warnings);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return conf;
    }

    public String resetAndLoadConfiguration() throws IOException {
        return this.resetAndLoadConfiguration(null);
    }

    public String resetAndLoadConfiguration(File cwd) throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        warningsLog.append(this.dosboxVersion_.resetAndLoadConfiguration());
        if (this.configuration_.getFileLocation() != null) {
            warningsLog.append(this.configuration_.reloadWithAutoexec(TextService.getInstance(), this.getDosboxNettoMountingPoints(), cwd));
            this.configuration_.removeDuplicateValuesIn(this.dosboxVersion_.getConfiguration());
        }
        return warningsLog.toString();
    }

    public String loadConfiguration(File cwd) throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        if (this.configuration_.getFileLocation() != null) {
            warningsLog.append(this.configuration_.loadWithAutoexec(TextService.getInstance(), this.getDosboxNettoMountingPoints(), cwd));
            this.configuration_.removeDuplicateValuesIn(this.dosboxVersion_.getConfiguration());
        }
        return warningsLog.toString();
    }

    public String loadConfigurationData(ITextService text, String data, File file) throws IOException {
        return this.loadConfigurationData(text, data, file, null);
    }

    public String loadConfigurationData(ITextService text, String data, File file, File cwd) throws IOException {
        return this.configuration_.loadDataWithAutoexec(text, data, file, this.getDosboxNettoMountingPoints(), cwd);
    }

    public void saveConfiguration() throws IOException {
        this.configuration_.save(false, this.getNettoMountingPoints());
    }

    public void saveConfiguration(boolean prepareOnly) throws IOException {
        this.configuration_.save(prepareOnly, this.getNettoMountingPoints());
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        String dbValue;
        if (this.configuration_.hasValue(sectionTitle, sectionItem)) {
            this.configuration_.removeValue(sectionTitle, sectionItem);
        }
        if (this.dosboxVersion_.getConfiguration().hasValue(sectionTitle, sectionItem) && !value.equals(dbValue = this.dosboxVersion_.getConfiguration().getValue(sectionTitle, sectionItem))) {
            this.configuration_.setValue(sectionTitle, sectionItem, value);
        }
    }

    public String setToDosboxVersion(DosboxVersion dstDosboxVersion) throws IOException {
        if (this.dosboxVersion_.getId() == dstDosboxVersion.getId()) {
            return "";
        }
        this.configuration_.setSections(this.getCombinedConfiguration().getSections());
        return this.alterToDosboxVersionGeneration(this.dosboxVersion_.getGeneration(), dstDosboxVersion);
    }

    public String switchToDosboxVersion(DosboxVersion dstDosboxVersion) throws IOException {
        if (this.dosboxVersion_.getId() == dstDosboxVersion.getId()) {
            return "";
        }
        return this.alterToDosboxVersionGeneration(this.dosboxVersion_.getGeneration(), dstDosboxVersion);
    }

    public String reloadDosboxVersion(DosboxVersion newDosboxVersion) throws IOException {
        String warningsLog = newDosboxVersion.resetAndLoadConfiguration();
        this.dosboxVersion_ = newDosboxVersion;
        this.configuration_.clearSections();
        this.configuration_.removeUnnecessaryMounts(this.dosboxVersion_.getConfiguration());
        return warningsLog;
    }

    public String alterToDosboxVersionGeneration(GenerationAwareConfiguration.Generation src, DosboxVersion dstDosboxVersion) throws IOException {
        int i;
        String warningsLog = dstDosboxVersion.resetAndLoadConfiguration();
        int srcGeneration = src.ordinal();
        int dstGeneration = dstDosboxVersion.getGeneration().ordinal();
        for (i = 0; i < srcGeneration - dstGeneration; ++i) {
            this.configuration_.downgradeOneGeneration(GenerationAwareConfiguration.Generation.values()[srcGeneration - i]);
        }
        for (i = 0; i < dstGeneration - srcGeneration; ++i) {
            this.configuration_.upgradeOneGeneration(GenerationAwareConfiguration.Generation.values()[srcGeneration + i]);
        }
        this.configuration_.removeValuesNotSetIn(dstDosboxVersion.getConfiguration());
        this.configuration_.removeDuplicateValuesIn(dstDosboxVersion.getConfiguration());
        this.dosboxVersion_ = dstDosboxVersion;
        return warningsLog;
    }

    private List<Mount> getDosboxNettoMountingPoints() {
        ArrayList<Mount> result = new ArrayList<Mount>();
        if (this.dosboxVersion_ != null) {
            for (Mount mount : this.dosboxVersion_.getConfiguration().getAutoexec().getMountingpoints()) {
                if (result.stream().anyMatch(x -> x.getDrive() == mount.getDrive() && !(mount instanceof OverlayMount))) {
                    if (!mount.isUnmounted()) continue;
                    result.removeIf(x -> x.getDrive() == mount.getDrive());
                    continue;
                }
                if (mount.isUnmounted()) continue;
                result.add(mount);
            }
        }
        return result;
    }

    public List<Mount> getNettoMountingPoints() {
        ArrayList<Mount> result = new ArrayList<Mount>(this.getDosboxNettoMountingPoints());
        for (Mount mount : this.configuration_.getAutoexec().getMountingpoints()) {
            if (result.stream().anyMatch(x -> x.getDrive() == mount.getDrive() && !(mount instanceof OverlayMount))) {
                if (!mount.isUnmounted()) continue;
                result.removeIf(x -> x.getDrive() == mount.getDrive());
                continue;
            }
            if (mount.isUnmounted()) continue;
            result.add(mount);
        }
        return result;
    }

    public List<Mount> getMountingPointsForUI() {
        ArrayList<Mount> result = new ArrayList<Mount>();
        try {
            for (Mount mount : this.getDosboxNettoMountingPoints()) {
                result.add(MountFactory.createCopy(mount));
            }
            for (Mount mount : this.configuration_.getAutoexec().getMountingpoints()) {
                Mount m = result.stream().filter(x -> x.getDrive() == mount.getDrive() && !x.isUnmounted()).findFirst().orElse(null);
                if (m != null && mount.isUnmounted()) {
                    m.setUnmounted(true);
                    continue;
                }
                result.add(MountFactory.createCopy(mount));
            }
        }
        catch (InvalidMountstringException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Set<Character> getNettoMountedDrives() {
        return this.getNettoMountingPoints().stream().map(x -> Character.valueOf(x.getDrive())).collect(Collectors.toSet());
    }

    public void unmountDosboxMounts() {
        for (char drive : this.getNettoMountedDrives()) {
            this.addMount(MountFactory.createUnmount(drive).toString());
        }
    }

    public void removeUnnecessaryMounts() {
        List<Mount> dbList = this.getDosboxNettoMountingPoints();
        List<Mount> fullList = this.getNettoMountingPoints();
        ArrayList<Mount> result = new ArrayList<Mount>();
        for (Mount dbMount : dbList) {
            Optional<Mount> finalMount = fullList.stream().filter(x -> x.getDrive() == dbMount.getDrive()).findFirst();
            if (!finalMount.isPresent()) {
                result.add(MountFactory.createUnmount(dbMount));
                continue;
            }
            if (finalMount.get().toString().equals(dbMount.toString())) continue;
            result.add(MountFactory.createUnmount(dbMount));
            try {
                result.add(MountFactory.createCopy(finalMount.get()));
            }
            catch (InvalidMountstringException e) {
                e.printStackTrace();
            }
        }
        for (Mount mnt : fullList) {
            if (!dbList.stream().noneMatch(x -> x.getDrive() == mnt.getDrive())) continue;
            result.add(mnt);
        }
        this.getConfiguration().getAutoexec().setMountingpoints(result);
    }

    public void editMountBasedOnIndexUI(int index, String mount) {
        List<Mount> uiMounts = this.getMountingPointsForUI();
        int dosboxMounts = this.dosboxVersion_.getConfiguration().getAutoexec().getMountingpoints().size();
        int unmountedDosboxMountsBeforeIndex = (int)IntStream.range(0, Math.min(index, dosboxMounts)).filter(x -> ((Mount)uiMounts.get(x)).isUnmounted()).count();
        if (index < dosboxMounts) {
            Mount mnt = uiMounts.get(index);
            if (!mnt.isUnmounted()) {
                this.removeMountBasedOnIndexUI(index);
                this.addMount(mount);
            }
        } else {
            try {
                this.configuration_.getAutoexec().getMountingpoints().set(index - (dosboxMounts - unmountedDosboxMountsBeforeIndex), MountFactory.create(mount));
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
    }

    public void removeMountBasedOnIndexUI(int index) {
        List<Mount> uiMounts = this.getMountingPointsForUI();
        int dosboxMounts = this.dosboxVersion_.getConfiguration().getAutoexec().getMountingpoints().size();
        int unmountedDosboxMountsBeforeIndex = (int)IntStream.range(0, Math.min(index, dosboxMounts)).filter(x -> ((Mount)uiMounts.get(x)).isUnmounted()).count();
        if (index < dosboxMounts) {
            Mount mnt = uiMounts.get(index);
            if (mnt.isUnmounted()) {
                if (!this.getNettoMountedDrives().contains(Character.valueOf(mnt.getDrive()))) {
                    this.configuration_.getAutoexec().getMountingpoints().remove(unmountedDosboxMountsBeforeIndex);
                }
            } else {
                this.configuration_.getAutoexec().getMountingpoints().add(unmountedDosboxMountsBeforeIndex, MountFactory.createUnmount(mnt));
            }
        } else {
            this.configuration_.getAutoexec().getMountingpoints().remove(index - (dosboxMounts - unmountedDosboxMountsBeforeIndex));
        }
    }

    public void removeFloppyMounts() {
        Iterator<Mount> it = this.configuration_.getAutoexec().getMountingpoints().iterator();
        while (it.hasNext()) {
            if (!it.next().getMountAs().equals("floppy")) continue;
            it.remove();
        }
    }

    public String[] getMountStringsForUI() {
        return (String[])this.getMountingPointsForUI().stream().map(x -> x.toString(true)).toArray(String[]::new);
    }

    public EditConfigurableDialog.MountsValidationResult checkMounts() {
        List<Mount> mountingpoints = this.getCombinedConfiguration().getAutoexec().getMountingpoints();
        for (int i = 0; i < mountingpoints.size(); ++i) {
            boolean absolute2;
            Mount mount = mountingpoints.get(i);
            if (!(mount instanceof OverlayMount)) continue;
            int idx = IntStream.range(0, i).filter(x -> !((Mount)mountingpoints.get(x)).isUnmounted() && ((Mount)mountingpoints.get(x)).getDrive() == mount.getDrive() && mountingpoints.get(x) instanceof DirMount).findFirst().orElse(-1);
            if (idx == -1) {
                return EditConfigurableDialog.MountsValidationResult.INVALID_OVERLAY_NO_BASEDRIVE;
            }
            DirMount baseMount = (DirMount)mountingpoints.get(idx);
            OverlayMount overlayMount = (OverlayMount)mount;
            boolean absolute1 = baseMount.getPath().isAbsolute();
            if (absolute1 != (absolute2 = overlayMount.getPath().isAbsolute())) {
                return EditConfigurableDialog.MountsValidationResult.INVALID_OVERLAY_MIXED_ABSREL_PATHS;
            }
            if (!overlayMount.getPath().equals(baseMount.getPath())) continue;
            return EditConfigurableDialog.MountsValidationResult.INVALID_OVERLAY_PATHS_EQUAL;
        }
        return EditConfigurableDialog.MountsValidationResult.OK;
    }
}

