/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.io.File;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.dbgl.model.WebProfile;
import org.dbgl.service.MetropolisDatabaseService;
import org.dbgl.util.FilesUtils;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.types.Type;

public class GameFilesRepository {
    private static final String GET_FILENAMES_QRY = "SELECT NAME FROM FILENAMES";
    private static final String GET_FILES_WITH_MD5_QRY = "SELECT FILE_MD5S.ID_FILE_MD5 FROM FILE_MD5S, FILENAMES WHERE FILE_MD5S.ID_FILENAME=FILENAMES.ID_FILENAME AND (FILENAMES.NAME, HEX(FILE_MD5S.MD5)) IN ";
    private static final String GET_GAMES_QRY = "SELECT MD5.ID_MOBY_RELEASES, MD5.ID_FILE_SET, MD5.ID_FILE_TYPE, NAM.NAME, FIL.MD5, GAM.NAME, PUBL.NAME, REL.YEAR, GAM.ID_MOBY_GAMES, GAM.NAME_PREFIX, GAM.DESCRIPTION FROM RELEASE_MD5S AS MD5, TBL_MOBY_RELEASES AS REL, TBL_MOBY_GAMES AS GAM, FILE_MD5S AS FIL, FILENAMES AS NAM LEFT JOIN tbl_Moby_Companies Publ ON REL.Publisher_id_Moby_Companies = PUBL.id_Moby_Companies WHERE MD5.ID_MOBY_RELEASES = REL.ID_MOBY_RELEASES AND FIL.ID_FILE_MD5 = MD5.ID_FILE_MD5  AND NAM.ID_FILENAME = FIL.ID_FILENAME AND REL.ID_MOBY_GAMES = GAM.ID_MOBY_GAMES AND ID_FILE_MD5 IN (UNNEST(?)) ORDER BY MD5.ID_MOBY_RELEASES, MD5.ID_FILE_SET, MD5.ID_FILE_TYPE";
    private static final String GET_RELEASE_FILESET_QRY = "SELECT FILENAMES.NAME FROM RELEASE_MD5S JOIN FILE_MD5S ON FILE_MD5S.ID_FILE_MD5 = RELEASE_MD5S.ID_FILE_MD5 JOIN FILENAMES ON FILENAMES.ID_FILENAME = FILE_MD5S.ID_FILENAME WHERE RELEASE_MD5S.ID_MOBY_RELEASES = ? AND RELEASE_MD5S.ID_FILE_SET = ? ORDER BY RELEASE_MD5S.ID_MOBY_RELEASES, RELEASE_MD5S.ID_FILE_SET, RELEASE_MD5S.ID_FILE_TYPE";
    MetropolisDatabaseService metropolisService_ = MetropolisDatabaseService.getInstance();

    /*
     * Exception decompiling
     */
    public List<String> listAllFilenames() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public HashMap<Integer, GameData> getGamesWithMd5Ids(List<ImmutablePair<File, byte[]>> fileMd5s) throws SQLException {
        LinkedHashMap<Integer, GameData> result = new LinkedHashMap<Integer, GameData>();
        if (fileMd5s.isEmpty()) {
            return result;
        }
        String inClause = "(" + fileMd5s.stream().map(x -> "('" + ((File)x.getKey()).getName() + "','" + DatatypeConverter.printHexBinary((byte[])((byte[])x.getValue())).toLowerCase() + "')").collect(Collectors.joining(",")) + ")";
        ArrayList<Integer> fileWithMd5Ids = new ArrayList<Integer>();
        try (Connection con = this.metropolisService_.getConnection();){
            try (Statement stmt = con.createStatement();
                 ResultSet resultset = stmt.executeQuery(GET_FILES_WITH_MD5_QRY + inClause);){
                while (resultset.next()) {
                    fileWithMd5Ids.add(resultset.getInt(1));
                }
            }
            try (PreparedStatement pstmt = con.prepareStatement(GET_GAMES_QRY);){
                JDBCArrayBasic array = new JDBCArrayBasic(fileWithMd5Ids.toArray(), (Type)Type.SQL_INTEGER);
                pstmt.setArray(1, (Array)array);
                try (ResultSet resultset = pstmt.executeQuery();){
                    int lastMobyReleaseId = -1;
                    int lastSet = -1;
                    while (resultset.next()) {
                        GameData gameData;
                        int mobyReleaseId = resultset.getInt(1);
                        int fileSet = resultset.getInt(2);
                        String filename = resultset.getString(4);
                        FileData fileData = new FileData(FileType.values()[resultset.getInt(3)], resultset.getBytes(5));
                        if ((mobyReleaseId != lastMobyReleaseId || fileSet != lastSet) && lastMobyReleaseId != -1 && lastSet != -1) {
                            GameData gameData2 = result.get(lastMobyReleaseId);
                            Map<String, FileData> fileData2 = gameData2.fileSets_.get((int)(gameData2.fileSets_.size() - 1)).set_;
                            try (PreparedStatement pstmt2 = con.prepareStatement(GET_RELEASE_FILESET_QRY);){
                                pstmt2.setInt(1, lastMobyReleaseId);
                                pstmt2.setInt(2, lastSet);
                                try (ResultSet resultset2 = pstmt2.executeQuery();){
                                    while (resultset2.next()) {
                                        String filename2 = resultset2.getString(1);
                                        if (fileData2.containsKey(filename2)) continue;
                                        fileData2.put(filename2, new FileData());
                                    }
                                }
                            }
                        }
                        if (result.containsKey(mobyReleaseId)) {
                            gameData = result.get(mobyReleaseId);
                            if (fileSet == lastSet) {
                                gameData.fileSets_.get((int)(gameData.fileSets_.size() - 1)).set_.put(filename, fileData);
                            } else {
                                gameData.fileSets_.add(new FileSet(filename, fileData));
                            }
                        } else {
                            gameData = new GameData();
                            gameData.webProfile_.setReleaseId(mobyReleaseId);
                            gameData.webProfile_.setGameId(resultset.getInt(9));
                            gameData.webProfile_.setTitle(resultset.getString(10) != null ? resultset.getString(10) + " " + resultset.getString(6) : resultset.getString(6));
                            gameData.webProfile_.setPublisherName(resultset.getString(7));
                            gameData.webProfile_.setYear(resultset.getString(8));
                            gameData.webProfile_.setNotes(resultset.getString(11));
                            gameData.fileSets_.add(new FileSet(filename, fileData));
                            result.put(mobyReleaseId, gameData);
                        }
                        lastMobyReleaseId = mobyReleaseId;
                        lastSet = fileSet;
                    }
                }
            }
        }
        return result;
    }

    public static class FileData {
        public FileType type_;
        public byte[] md5_;
        public int score_;

        public FileData() {
        }

        public FileData(FileType type, byte[] md5) {
            this.type_ = type;
            this.md5_ = md5;
        }
    }

    public static enum FileType {
        Main,
        Setup,
        Extra;

    }

    public static class GameData {
        public List<FileSet> fileSets_ = new ArrayList<FileSet>();
        public WebProfile webProfile_ = new WebProfile();
    }

    public static class FileSet {
        public Map<String, FileData> set_;

        public FileSet(String filename, FileData fileData) {
            this.set_ = new LinkedHashMap<String, FileData>();
            this.set_.put(filename, fileData);
        }

        public FileSet(Map<String, FileData> set) {
            this.set_ = set;
        }

        public int getScore() {
            return this.set_.values().stream().mapToInt(x -> x.score_).sum();
        }
    }

    public static class GameDirEntry
    implements Comparable<GameDirEntry> {
        public File dir_;
        public Optional<File> main_;
        public Optional<File> setup_;
        public List<File> executables_;
        public WebProfile webProfile_;
        public int score_;
        public String explanation_;

        @Override
        public int compareTo(GameDirEntry comp) {
            if (this.main_.isPresent() && !comp.main_.isPresent()) {
                return -1;
            }
            if (!this.main_.isPresent() && comp.main_.isPresent()) {
                return 1;
            }
            return this.webProfile_.getTitle().compareTo(comp.webProfile_.getTitle());
        }

        public static final class byScore
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                return Integer.compare(prof1.score_, prof2.score_);
            }
        }

        public static final class byYear
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{prof1.webProfile_.getYear(), prof2.webProfile_.getYear()})) {
                    return 0;
                }
                if (StringUtils.isBlank((CharSequence)prof1.webProfile_.getYear())) {
                    return 1;
                }
                if (StringUtils.isBlank((CharSequence)prof2.webProfile_.getYear())) {
                    return -1;
                }
                return new WebProfile.byYear().compare(prof1.webProfile_, prof2.webProfile_);
            }
        }

        public static final class byPublisher
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{prof1.webProfile_.getPublisherName(), prof2.webProfile_.getPublisherName()})) {
                    return 0;
                }
                if (StringUtils.isBlank((CharSequence)prof1.webProfile_.getPublisherName())) {
                    return 1;
                }
                if (StringUtils.isBlank((CharSequence)prof2.webProfile_.getPublisherName())) {
                    return -1;
                }
                return prof1.webProfile_.getPublisherName().compareToIgnoreCase(prof2.webProfile_.getPublisherName());
            }
        }

        public static final class bySetup
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                if (!prof1.setup_.isPresent() && !prof2.setup_.isPresent()) {
                    return new byDir().compare(prof1, prof2);
                }
                if (!prof1.setup_.isPresent()) {
                    return 1;
                }
                if (!prof2.setup_.isPresent()) {
                    return -1;
                }
                return new FilesUtils.FilenameComparator().compare(prof1.setup_.get().getName(), prof2.setup_.get().getName());
            }
        }

        public static final class byMain
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                if (!prof1.main_.isPresent() && !prof2.main_.isPresent()) {
                    return new byDir().compare(prof1, prof2);
                }
                if (!prof1.main_.isPresent()) {
                    return 1;
                }
                if (!prof2.main_.isPresent()) {
                    return -1;
                }
                return new FilesUtils.FilenameComparator().compare(prof1.main_.get().getName(), prof2.main_.get().getName());
            }
        }

        public static final class byTitle
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                return new WebProfile.byTitle().compare(prof1.webProfile_, prof2.webProfile_);
            }
        }

        public static final class byDir
        implements Comparator<GameDirEntry> {
            @Override
            public int compare(GameDirEntry prof1, GameDirEntry prof2) {
                return new FilesUtils.FileComparator().compare(prof1.dir_, prof2.dir_);
            }
        }
    }
}

