/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.dbgl.model.entity.IEntity;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.model.entity.LogEntry;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;

public class LoggingRepository<T extends IEntity>
extends BaseRepository<T> {
    private static final String CREATE_QRY = "INSERT INTO LOG(EVENT, ENTITY_TYPE, ENTITY_ID, ENTITY_TITLE) VALUES(?, ?, ?, ?)";
    private static final String READ_QRY = "SELECT ID, TIME, EVENT, ENTITY_TYPE, ENTITY_ID, ENTITY_TITLE FROM LOG";
    private static final String DEL_QRY = "DELETE FROM LOG";

    protected static void log(DatabaseService.Transaction transaction, LogEntry.Event event, LogEntry.EntityType entityType, ITitledEntity titledEntity) throws SQLException {
        if (SettingsService.getInstance().getBooleanValue("log", "enabled")) {
            try (PreparedStatement pstmt = transaction.prepareStatement(CREATE_QRY);){
                pstmt.setByte(1, (byte)event.ordinal());
                pstmt.setByte(2, (byte)entityType.ordinal());
                pstmt.setInt(3, titledEntity.getId());
                pstmt.setString(4, titledEntity.getTitle());
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"add log entry"}));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public List<LogEntry> list(String whereClause, String orderByClause) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clear() throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();
             Statement stmt = transaction.createStatement();){
            stmt.executeQuery(DEL_QRY);
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"clear log"}));
        }
    }
}

