/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.service;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.ProfilesList;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.Settings;
import org.dbgl.service.GenericTextService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;

public class SettingsService {
    private static final String SETTINGS_CONF = "settings.conf";
    private static final String SAMPLE_RATES = "8000 11025 16000 22050 32000 44100 48000 49716";
    private static final String BASE_ADDRS = "220 240 260 280 2a0 2c0 2e0 300";
    private static final String IRQS = "3 5 7 9 10 11 12";
    private static final String DMAS = "0 1 3 5 6 7";
    private Settings settings_ = new Settings();

    private SettingsService() {
        this.setDefaultSettings();
        String conf = SystemUtils.USE_USER_HOME_DIR || !FilesUtils.isWritableDirectory(new File(".")) ? new File(SystemUtils.USER_DATA_DIR, SETTINGS_CONF).getPath() : SETTINGS_CONF;
        this.settings_.setFileLocation(new FileLocation(conf));
        try {
            String warnings = this.settings_.load(GenericTextService.getInstance());
            if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                System.out.println(warnings);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SettingsService getInstance() {
        return SettingsServiceHolder.instance_;
    }

    public void save() throws IOException {
        this.settings_.save();
    }

    public String getValue(String sectionTitle, String sectionItem) {
        return this.settings_.getValue(sectionTitle, sectionItem);
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        this.settings_.setValue(sectionTitle, sectionItem, value);
    }

    public boolean getBooleanValue(String sectionTitle, String sectionItem) {
        return this.settings_.getBooleanValue(sectionTitle, sectionItem);
    }

    public void setBooleanValue(String sectionTitle, String sectionItem, boolean value) {
        this.settings_.setValue(sectionTitle, sectionItem, value);
    }

    public int getIntValue(String sectionTitle, String sectionItem) {
        return this.settings_.getIntValue(sectionTitle, sectionItem);
    }

    public void setIntValue(String sectionTitle, String sectionItem, int value) {
        this.settings_.setValue(sectionTitle, sectionItem, value);
    }

    public String getMultilineValue(String sectionTitle, String sectionItem, String delimiter) {
        return this.settings_.getMultilineValue(sectionTitle, sectionItem, delimiter);
    }

    public void setMultilineValue(String sectionTitle, String sectionItem, String values, String delimiter) {
        this.settings_.setMultilineValue(sectionTitle, sectionItem, values, delimiter);
    }

    public int[] getIntValues(String sectionTitle, String sectionItem) {
        return this.settings_.getIntValues(sectionTitle, sectionItem);
    }

    public void setIntValues(String sectionTitle, String sectionItem, int[] values) {
        this.settings_.setValues(sectionTitle, sectionItem, values);
    }

    public boolean[] getBooleanValues(String sectionTitle, String sectionItem) {
        return this.settings_.getBooleanValues(sectionTitle, sectionItem);
    }

    public void setBooleanValues(String sectionTitle, String sectionItem, boolean[] values) {
        this.settings_.setValues(sectionTitle, sectionItem, values);
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        return this.settings_.getValues(sectionTitle, sectionItem);
    }

    public String[] getProfileSectionItemNames() {
        return this.settings_.getItemNames("profile");
    }

    private void setDefaultSettings() {
        this.settings_.setValue("gui", "width", "904");
        this.settings_.setValue("gui", "height", "475");
        this.settings_.setValue("gui", "x", "10");
        this.settings_.setValue("gui", "y", "10");
        this.settings_.setValue("gui", "profiledialog_width", "768");
        this.settings_.setValue("gui", "profiledialog_height", "588");
        this.settings_.setValue("gui", "profileloaderdialog_width", "375");
        this.settings_.setValue("gui", "profileloaderdialog_height", "300");
        this.settings_.setValue("gui", "profiledeletedialog_width", "550");
        this.settings_.setValue("gui", "profiledeletedialog_height", "224");
        this.settings_.setValue("gui", "multiprofiledialog_width", "600");
        this.settings_.setValue("gui", "multiprofiledialog_height", "375");
        this.settings_.setValue("gui", "addgamewizard_width", "500");
        this.settings_.setValue("gui", "addgamewizard_height", "375");
        this.settings_.setValue("gui", "dosboxdialog_width", "600");
        this.settings_.setValue("gui", "dosboxdialog_height", "400");
        this.settings_.setValue("gui", "templatedialog_width", "768");
        this.settings_.setValue("gui", "templatedialog_height", "588");
        this.settings_.setValue("gui", "mountdialog_width", "640");
        this.settings_.setValue("gui", "mountdialog_height", "500");
        this.settings_.setValue("gui", "imgsizedialog_width", "330");
        this.settings_.setValue("gui", "imgsizedialog_height", "260");
        this.settings_.setValue("gui", "archivebrowser_width", "400");
        this.settings_.setValue("gui", "mobygamesbrowser_width", "650");
        this.settings_.setValue("gui", "mobygamesbrowser_height", "375");
        this.settings_.setValue("gui", "mixerdialog_width", "950");
        this.settings_.setValue("gui", "mixerdialog_height", "450");
        this.settings_.setValue("gui", "archivebrowser_height", "375");
        this.settings_.setValue("gui", "dfendimportdialog_width", "600");
        this.settings_.setValue("gui", "dfendimportdialog_height", "375");
        this.settings_.setValue("gui", "exportlistdialog_width", "550");
        this.settings_.setValue("gui", "exportlistdialog_height", "190");
        this.settings_.setValue("gui", "nativecommanddialog_width", "520");
        this.settings_.setValue("gui", "nativecommanddialog_height", "225");
        this.settings_.setValue("gui", "export_width", "550");
        this.settings_.setValue("gui", "export_height", "500");
        this.settings_.setValue("gui", "import_width", "654");
        this.settings_.setValue("gui", "import_height", "500");
        this.settings_.setValue("gui", "migratedialog_width", "600");
        this.settings_.setValue("gui", "migratedialog_height", "375");
        this.settings_.setValue("gui", "settingsdialog_width", "715");
        this.settings_.setValue("gui", "settingsdialog_height", "560");
        this.settings_.setValue("gui", "shareconfdialog_width", "560");
        this.settings_.setValue("gui", "shareconfdialog_height", "540");
        this.settings_.setValue("gui", "sharedconfbrowser_width", "860");
        this.settings_.setValue("gui", "sharedconfbrowser_height", "540");
        this.settings_.setValue("gui", "importdirdialog_width", "1680");
        this.settings_.setValue("gui", "importdirdialog_height", "800");
        this.settings_.setValue("gui", "importdir_column_1width", "70");
        this.settings_.setValue("gui", "importdir_column_2width", "400");
        this.settings_.setValue("gui", "importdir_column_3width", "260");
        this.settings_.setValue("gui", "importdir_column_4width", "165");
        this.settings_.setValue("gui", "importdir_column_5width", "165");
        this.settings_.setValue("gui", "importdir_column_6width", "240");
        this.settings_.setValue("gui", "importdir_column_7width", "60");
        this.settings_.setValue("gui", "importdir_column_8width", "105");
        this.settings_.setValue("gui", "log_width", "860");
        this.settings_.setValue("gui", "log_height", "540");
        this.settings_.setValue("gui", "filterdialog_width", "725");
        this.settings_.setValue("gui", "filterdialog_height", "540");
        this.settings_.setValue("gui", "filtertab", "0");
        this.settings_.setValue("gui", "maximized", false);
        this.settings_.setValue("gui", "column1width", "150");
        this.settings_.setValue("gui", "column2width", "48");
        this.settings_.setValue("gui", "column3width", "100");
        this.settings_.setValue("gui", "column4width", "100");
        this.settings_.setValue("gui", "column5width", "70");
        this.settings_.setValue("gui", "column6width", "40");
        this.settings_.setValue("gui", "column7width", "60");
        this.settings_.setValue("gui", "column8width", "60");
        this.settings_.setValue("gui", "column9width", "38");
        this.settings_.setValue("gui", "column10width", "40");
        this.settings_.setValue("gui", "column11width", "70");
        this.settings_.setValue("gui", "column12width", "70");
        this.settings_.setValue("gui", "column13width", "70");
        this.settings_.setValue("gui", "column14width", "70");
        this.settings_.setValue("gui", "column15width", "70");
        this.settings_.setValue("gui", "column16width", "70");
        this.settings_.setValue("gui", "column17width", "70");
        this.settings_.setValue("gui", "column18width", "70");
        this.settings_.setValue("gui", "column19width", "44");
        this.settings_.setValue("gui", "column20width", "44");
        this.settings_.setValue("gui", "column21width", "82");
        this.settings_.setValue("gui", "column22width", "70");
        this.settings_.setValue("gui", "column23width", "150");
        this.settings_.setValue("gui", "column24width", "150");
        this.settings_.setValue("gui", "column25width", "150");
        this.settings_.setValue("gui", "column26width", "150");
        this.settings_.setValue("gui", "column27width", "70");
        this.settings_.setValue("gui", "column28width", "70");
        this.settings_.setValue("gui", "column29width", "70");
        this.settings_.setValue("gui", "column30width", "70");
        this.settings_.setValue("gui", "column31width", "70");
        this.settings_.setValue("gui", "column32width", "70");
        this.settings_.setValue("gui", "column1visible", true);
        this.settings_.setValue("gui", "column2visible", true);
        this.settings_.setValue("gui", "column3visible", true);
        this.settings_.setValue("gui", "column4visible", true);
        this.settings_.setValue("gui", "column5visible", true);
        this.settings_.setValue("gui", "column6visible", true);
        this.settings_.setValue("gui", "column7visible", true);
        this.settings_.setValue("gui", "column8visible", true);
        this.settings_.setValue("gui", "column9visible", true);
        this.settings_.setValue("gui", "column10visible", false);
        this.settings_.setValue("gui", "column11visible", false);
        this.settings_.setValue("gui", "column12visible", false);
        this.settings_.setValue("gui", "column13visible", false);
        this.settings_.setValue("gui", "column14visible", false);
        this.settings_.setValue("gui", "column15visible", false);
        this.settings_.setValue("gui", "column16visible", false);
        this.settings_.setValue("gui", "column17visible", false);
        this.settings_.setValue("gui", "column18visible", false);
        this.settings_.setValue("gui", "column19visible", false);
        this.settings_.setValue("gui", "column20visible", false);
        this.settings_.setValue("gui", "column21visible", false);
        this.settings_.setValue("gui", "column22visible", false);
        this.settings_.setValue("gui", "column23visible", false);
        this.settings_.setValue("gui", "column24visible", false);
        this.settings_.setValue("gui", "column25visible", false);
        this.settings_.setValue("gui", "column26visible", false);
        this.settings_.setValue("gui", "column27visible", false);
        this.settings_.setValue("gui", "column28visible", false);
        this.settings_.setValue("gui", "column29visible", false);
        this.settings_.setValue("gui", "column30visible", false);
        this.settings_.setValue("gui", "column31visible", false);
        this.settings_.setValue("gui", "column32visible", false);
        this.settings_.setValue("gui", "column2_1width", "300");
        this.settings_.setValue("gui", "column2_2width", "250");
        this.settings_.setValue("gui", "column2_3width", "150");
        this.settings_.setValue("gui", "column2_4width", "68");
        this.settings_.setValue("gui", "column2_5width", "46");
        this.settings_.setValue("gui", "column2_6width", "150");
        this.settings_.setValue("gui", "column2_7width", "150");
        this.settings_.setValue("gui", "column2_8width", "150");
        this.settings_.setValue("gui", "column2_9width", "112");
        this.settings_.setValue("gui", "column3_1width", "500");
        this.settings_.setValue("gui", "column3_2width", "50");
        this.settings_.setValue("gui", "column3_3width", "68");
        this.settings_.setValue("gui", "column3_4width", "150");
        this.settings_.setValue("gui", "column3_5width", "150");
        this.settings_.setValue("gui", "column3_6width", "150");
        this.settings_.setValue("gui", "column3_7width", "112");
        this.settings_.setValue("gui", "sortcolumn", "0 8");
        this.settings_.setValue("gui", "sortascending", "true true");
        this.settings_.setValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
        this.settings_.setValue("gui", "sashweights", "777 222");
        this.settings_.setValue("gui", "screenshotsheight", "100");
        this.settings_.setValue("gui", "screenshotscolumnheight", "50");
        this.settings_.setValue("gui", "screenshotscolumnstretch", false);
        this.settings_.setValue("gui", "screenshotscolumnkeepaspectratio", false);
        this.settings_.setValue("gui", "screenshotsvisible", true);
        this.settings_.setValue("gui", "screenshotsmaxzoompercentage", "300");
        this.settings_.setValue("gui", "screenshotsmaxwidth", "1920");
        this.settings_.setValue("gui", "screenshotsmaxheight", "1440");
        this.settings_.setValue("gui", "autosortonupdate", false);
        this.settings_.setValue("gui", "screenshotsfilename", true);
        this.settings_.setValue("gui", "buttondisplay", 0);
        this.settings_.setValue("gui", "custom1", "Custom1");
        this.settings_.setValue("gui", "custom2", "Custom2");
        this.settings_.setValue("gui", "custom3", "Custom3");
        this.settings_.setValue("gui", "custom4", "Custom4");
        this.settings_.setValue("gui", "custom5", "Custom5");
        this.settings_.setValue("gui", "custom6", "Custom6");
        this.settings_.setValue("gui", "custom7", "Custom7");
        this.settings_.setValue("gui", "custom8", "Custom8");
        this.settings_.setValue("gui", "custom9", "Custom9");
        this.settings_.setValue("gui", "custom10", "Custom10");
        this.settings_.setValue("gui", "custom11", "Custom11");
        this.settings_.setValue("gui", "custom12", "Custom12");
        this.settings_.setValue("gui", "custom13", "Custom13");
        this.settings_.setValue("gui", "custom14", "Custom14");
        this.settings_.setValue("gui", "searchengine", "mobygames");
        this.settings_.setValue("gui", "notesfont", "Courier 10 0");
        this.settings_.setValue("gui", "notesvisible", true);
        this.settings_.setValue("gui", "viewstyle", ProfilesList.ProfilesListType.TABLE.toString().toLowerCase());
        this.settings_.setValue("gui", "small_tile_width", 100);
        this.settings_.setValue("gui", "small_tile_height", 82);
        this.settings_.setValue("gui", "medium_tile_width", 132);
        this.settings_.setValue("gui", "medium_tile_height", 102);
        this.settings_.setValue("gui", "large_tile_width", 164);
        this.settings_.setValue("gui", "large_tile_height", 122);
        this.settings_.setValue("gui", "small_box_width", 75);
        this.settings_.setValue("gui", "small_box_height", 100);
        this.settings_.setValue("gui", "medium_box_width", 120);
        this.settings_.setValue("gui", "medium_box_height", 150);
        this.settings_.setValue("gui", "large_box_width", 150);
        this.settings_.setValue("gui", "large_box_height", 200);
        this.settings_.setValue("gui", "tile_title_trunc_pos", "end");
        this.settings_.setValue("gui", "gallerybackgroundcolor", "-1");
        this.settings_.setValue("profiledefaults", "confpath", 0);
        this.settings_.setValue("profiledefaults", "conffile", 0);
        this.settings_.setValue("dosbox", "hideconsole", false);
        this.settings_.setValue("communication", "port_enabled", SystemUtils.IS_WINDOWS);
        this.settings_.setValue("communication", "port", "4740");
        this.settings_.setValue("database", "connectionstring", "jdbc:hsqldb:file:./db/database");
        this.settings_.setValue("database", "username", "sa");
        this.settings_.setValue("database", "pasword", "");
        this.settings_.setValue("mobygames_database", "connectionstring", "jdbc:hsqldb:file:./db/mobygames;shutdown=true");
        this.settings_.setValue("mobygames_database", "username", "sa");
        this.settings_.setValue("mobygames_database", "pasword", "");
        this.settings_.setValue("directory", "data", ".");
        this.settings_.setValue("directory", "dosbox", ".");
        this.settings_.setValue("directory", "tmpinstall", "TMP_INST");
        this.settings_.setValue("directory", "orgimages", "ORGIMAGE");
        this.settings_.setValue("locale", "language", "en");
        this.settings_.setValue("locale", "country", "");
        this.settings_.setValue("locale", "variant", "");
        this.settings_.setValue("log", "enabled", true);
        this.settings_.setValue("mobygames", "platform_filter", "dos pc<space>booter");
        this.settings_.setValue("mobygames", "set_title", true);
        this.settings_.setValue("mobygames", "set_developer", true);
        this.settings_.setValue("mobygames", "set_publisher", true);
        this.settings_.setValue("mobygames", "set_year", true);
        this.settings_.setValue("mobygames", "set_genre", true);
        this.settings_.setValue("mobygames", "set_link", true);
        this.settings_.setValue("mobygames", "set_description", true);
        this.settings_.setValue("mobygames", "set_rank", true);
        this.settings_.setValue("mobygames", "choose_coverart", false);
        this.settings_.setValue("mobygames", "choose_screenshot", false);
        this.settings_.setValue("mobygames", "force_all_regions_coverart", false);
        this.settings_.setValue("mobygames", "multi_max_coverart", 0);
        this.settings_.setValue("mobygames", "multi_max_screenshot", 0);
        this.settings_.setValue("mobygames", "image_width", 128);
        this.settings_.setValue("mobygames", "image_height", 80);
        this.settings_.setValue("mobygames", "image_columns", 2);
        this.settings_.setValue("metropolis", "platform_filter", "dos pc<space>booter");
        this.settings_.setValue("metropolis", "region", "United States");
        this.settings_.setValue("metropolis", "set_title", true);
        this.settings_.setValue("metropolis", "set_developer", true);
        this.settings_.setValue("metropolis", "set_publisher", true);
        this.settings_.setValue("metropolis", "set_year", true);
        this.settings_.setValue("metropolis", "set_genre", true);
        this.settings_.setValue("metropolis", "set_link", true);
        this.settings_.setValue("metropolis", "set_description", true);
        this.settings_.setValue("metropolis", "set_rank", true);
        this.settings_.setValue("metropolis", "choose_coverart", false);
        this.settings_.setValue("metropolis", "choose_screenshot", false);
        this.settings_.setValue("metropolis", "force_all_regions_coverart", false);
        this.settings_.setValue("metropolis", "multi_max_coverart", 0);
        this.settings_.setValue("metropolis", "multi_max_screenshot", 0);
        this.settings_.setValue("metropolis", "image_width", 128);
        this.settings_.setValue("metropolis", "image_height", 80);
        this.settings_.setValue("metropolis", "image_columns", 2);
        this.settings_.setValue("pouet", "platform_filter", "ms-dos ms-dos/gus");
        this.settings_.setValue("pouet", "set_title", true);
        this.settings_.setValue("pouet", "set_developer", true);
        this.settings_.setValue("pouet", "set_year", true);
        this.settings_.setValue("pouet", "set_genre", true);
        this.settings_.setValue("pouet", "set_link", true);
        this.settings_.setValue("pouet", "set_rank", true);
        this.settings_.setValue("pouet", "choose_coverart", false);
        this.settings_.setValue("pouet", "choose_screenshot", false);
        this.settings_.setValue("pouet", "multi_max_coverart", 0);
        this.settings_.setValue("pouet", "multi_max_screenshot", 0);
        this.settings_.setValue("thegamesdb", "platform_filter", "pc");
        this.settings_.setValue("thegamesdb", "set_title", true);
        this.settings_.setValue("thegamesdb", "set_developer", true);
        this.settings_.setValue("thegamesdb", "set_publisher", true);
        this.settings_.setValue("thegamesdb", "set_year", true);
        this.settings_.setValue("thegamesdb", "set_genre", true);
        this.settings_.setValue("thegamesdb", "set_link", true);
        this.settings_.setValue("thegamesdb", "set_description", true);
        this.settings_.setValue("thegamesdb", "set_rank", true);
        this.settings_.setValue("thegamesdb", "choose_coverart", false);
        this.settings_.setValue("thegamesdb", "choose_screenshot", false);
        this.settings_.setValue("thegamesdb", "multi_max_coverart", 0);
        this.settings_.setValue("thegamesdb", "multi_max_screenshot", 0);
        this.settings_.setValue("environment", "use", false);
        this.settings_.setValue("environment", "value", "");
        this.settings_.setValue("profile", "priority_active", "lowest lower normal higher highest");
        this.settings_.setValue("profile", "priority_inactive", "lowest lower normal higher highest pause");
        this.settings_.setValue("profile", "output", "ddraw overlay opengl openglnb surface");
        this.settings_.setValue("profile", "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
        this.settings_.setValue("profile", "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x hq2x hq3x 2xsai super2xsai supereagle tv2x tv3x rgb2x rgb3x scan2x scan3x");
        this.settings_.setValue("profile", "fullresolution", "original desktop 0x0 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.settings_.setValue("profile", "windowresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.settings_.setValue("profile", "glshader", "none advinterp2x advinterp3x advmame2x advmame3x rgb2x rgb3x scan2x scan3x tv2x tv3x sharp");
        this.settings_.setValue("profile", "machine", "cga hercules pcjr tandy vga");
        this.settings_.setValue("profile", "machine073", "cga hercules pcjr tandy ega vgaonly svga_s3 svga_et3000 svga_et4000 svga_paradise vesa_nolfb vesa_oldvbe");
        this.settings_.setValue("profile", "cputype", "auto 386 386_slow 486_slow pentium_slow 386_prefetch");
        this.settings_.setValue("profile", "core", "dynamic full normal simple auto");
        this.settings_.setValue("profile", "cycles", "350 500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max<space>50% max<space>80% max<space>90% max");
        this.settings_.setValue("profile", "cycles_up", "10 20 50 100 500 1000 2000 5000 10000");
        this.settings_.setValue("profile", "cycles_down", "10 20 50 100 500 1000 2000 5000 10000");
        this.settings_.setValue("profile", "memsize", "0 1 2 4 8 16 32 63");
        this.settings_.setValue("profile", "ems", "false emsboard emm386 true");
        this.settings_.setValue("profile", "umb", "false true max");
        this.settings_.setValue("profile", "loadfix_value", "1 63 64 127");
        this.settings_.setValue("profile", "rate", SAMPLE_RATES);
        this.settings_.setValue("profile", "blocksize", "256 512 1024 2048 4096 8192");
        this.settings_.setValue("profile", "prebuffer", "10 20 25");
        this.settings_.setValue("profile", "mpu401", "none intelligent uart");
        this.settings_.setValue("profile", "device", "alsa default coreaudio coremidi none oss win32");
        this.settings_.setValue("profile", "sbtype", "none gb sb1 sb2 sbpro1 sbpro2 sb16");
        this.settings_.setValue("profile", "oplrate", SAMPLE_RATES);
        this.settings_.setValue("profile", "oplmode", "auto cms opl2 dualopl2 opl3 opl3gold none");
        this.settings_.setValue("profile", "oplemu", "default compat fast mame");
        this.settings_.setValue("profile", "sbbase", BASE_ADDRS);
        this.settings_.setValue("profile", "irq", IRQS);
        this.settings_.setValue("profile", "dma", DMAS);
        this.settings_.setValue("profile", "hdma", DMAS);
        this.settings_.setValue("profile", "gusrate", SAMPLE_RATES);
        this.settings_.setValue("profile", "gusbase", BASE_ADDRS);
        this.settings_.setValue("profile", "irq1", IRQS);
        this.settings_.setValue("profile", "irq2", IRQS);
        this.settings_.setValue("profile", "dma1", DMAS);
        this.settings_.setValue("profile", "dma2", DMAS);
        this.settings_.setValue("profile", "pcrate", SAMPLE_RATES);
        this.settings_.setValue("profile", "tandy", "auto off on");
        this.settings_.setValue("profile", "tandyrate", SAMPLE_RATES);
        this.settings_.setValue("profile", "sensitivity", "10 20 30 40 50 60 70 80 90 100 100,-50 125 150 175 200 250 300 350 400 450 500 550 600 700 800 900 1000");
        this.settings_.setValue("profile", "joysticktype", "auto none 2axis 4axis 4axis_2 ch fcs");
        this.settings_.setValue("profile", "mount_type", "cdrom dir floppy overlay");
        this.settings_.setValue("profile", "imgmount_type", "iso floppy hdd");
        this.settings_.setValue("profile", "imgmount_fs", "iso fat none");
        this.settings_.setValue("profile", "zipmount_type", "cdrom dir floppy");
        this.settings_.setValue("profile", "freesize", "1 10 100 200 500 1000");
        this.settings_.setValue("profile", "lowlevelcd_type", "aspi ioctl ioctl_dx ioctl_dio ioctl_mci noioctl");
        this.settings_.setValue("profile", "keyboardlayout", "auto none ba234 be120 bg241 bg442 bl463 br274 br275 by463 ca58 ca445 cf58 cf445 cf501 cz243 de129 de453 dk159 dv103 ee454 el220 el319 el459 es172 es173 et454 fi153 fo fr120 fr189 gk220 gk319 gk459 gr129 gr453 hr234 hu208 is161 is197 is458 it141 it142 la171 lt210 lt211 lt212 lt221 lt456 lh103 mk449 ml47 mt47 nl143 no155 ph pl214 pl457 po163 rh103 ro333 ro446 ru441 ru443 sd150 sf150 sg150 si234 sk245 sp172 sp173 sq448 sq452 sr118 sr450 su153 sv153 tm tr179 tr440 ua465 uk166 uk168 ur465 us103 ux103 yc118 yc450 yu234");
        this.settings_.setValue("profile", "pixelshader", "none 2xSaI.fx 2xSaI_sRGB.fx 2xSaL.fx 2xSaL_Ls.fx 2xSaL2xAA.fx 2xSaLAA.fx 4xSaL.fx 4xSoft.fx 4xSoft_PS3.0.fx AdvancedAA.fx bilinear.fx Cartoon.fx ColorSketch.fx CRT.D3D.fx CRT.D3D.br.fx CRT-simple.D3D.fx CRT-simple.D3D.br.fx DotnBloom.D3D.fx GS2x.fx GS2xFilter.fx Gs2xLS.fx Gs2xSmartFilter.fx GS2xSuper.fx GS2xTwo.fx GS4x.fx GS4xColorScale.fx GS4xFilter.fx GS4xHqFilter.fx GS4xScale.fx GS4xSoft.fx HQ2x.fx Lanczos.fx Lanczos12.fx Lanczos16.fx Matrix.fx MCAmber.fx MCGreen.fx MCHerc.fx MCOrange.fx none.fx point.fx scale2x.fx scale2x_ps14.fx Scale2xPlus.fx Scale4x.fx SimpleAA.fx Sketch.fx Super2xSaI.fx SuperEagle.fx Tv.fx");
        this.settings_.setValue("profile", "overscan", "1 2 3 4 5 6 7 8 9 10");
        this.settings_.setValue("profile", "vsyncmode", "off on force host");
        this.settings_.setValue("profile", "lfbglide", "full full_noaux read read_noaux write write_noaux none");
        this.settings_.setValue("profile", "vmemsize", "-1 0 1 2 4 8");
        this.settings_.setValue("profile", "glide", "false true emu");
        this.settings_.setValue("profile", "voodoo", "false software opengl auto");
        this.settings_.setValue("profile", "voodoomem", "standard max");
        this.settings_.setValue("profile", "memalias", "0 24 26");
        this.settings_.setValue("profile", "hardwaresbbase", "210 220 230 240 250 260 280");
        this.settings_.setValue("profile", "mt32dac", "0 1 2 3 auto");
        this.settings_.setValue("profile", "mt32reverbmode", "0 1 2 3 auto");
        this.settings_.setValue("profile", "mt32reverbtime", "0 1 2 3 4 5 6 7");
        this.settings_.setValue("profile", "mt32reverblevel", "0 1 2 3 4 5 6 7");
        this.settings_.setValue("profile", "mt32analog", "0 1 2 3");
        this.settings_.setValue("profile", "fluidsynthdriver", "pulseaudio alsa oss coreaudio dsound portaudio sndman jack file default");
        this.settings_.setValue("profile", "fluidsynthsamplerate", SAMPLE_RATES);
        this.settings_.setValue("profile", "ps1rate", SAMPLE_RATES);
        this.settings_.setValue("profile", "innovarate", SAMPLE_RATES);
        this.settings_.setValue("profile", "innovabase", BASE_ADDRS);
        this.settings_.setValue("profile", "innovaquality", "0 1 2 3");
        this.settings_.setValue("profile", "auxdevice", "none 2button 3button intellimouse intellimouse45");
        this.settings_.setValue("profile", "printeroutput", "png ps bmp printer");
        this.settings_.setValue("profile", "uniquemapperfile", "%1$d.map");
        this.settings_.setValue("addgamewizard", "requiresinstallation", false);
        this.settings_.setValue("addgamewizard", "consultsearchengine", true);
        this.settings_.setValue("addgamewizard", "consultdbconfws", true);
        this.settings_.setValue("addgamewizard", "useuniquemapperfile", false);
        this.settings_.setValue("exportwizard", "gamedata", false);
        this.settings_.setValue("confsharing", "endpoint", "https://share.dbgl.org/DBConfWS/apiv1/");
    }

    private static class SettingsServiceHolder {
        private static final SettingsService instance_ = new SettingsService();

        private SettingsServiceHolder() {
        }
    }
}

