/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.nio.ByteBuffer;
import org.dbgl.util.fat.ShortName;
import org.dbgl.util.iso.Util;

public final class FatDirectoryEntry {
    public static final int SIZE = 32;
    private static final int OFFSET_ATTRIBUTES = 11;
    private static final int F_READONLY = 1;
    private static final int F_HIDDEN = 2;
    private static final int F_SYSTEM = 4;
    private static final int F_VOLUME_ID = 8;
    private static final int F_DIRECTORY = 16;
    private static final int F_ARCHIVE = 32;
    public static final int ENTRY_DELETED_MAGIC = 229;
    private final byte[] data_;

    FatDirectoryEntry(byte[] data) {
        this.data_ = data;
    }

    public static FatDirectoryEntry read(ByteBuffer buff) {
        assert (buff.remaining() >= 32);
        if (buff.get(buff.position()) == 0) {
            return null;
        }
        byte[] data = new byte[32];
        buff.get(data);
        return new FatDirectoryEntry(data);
    }

    public boolean isVolumeLabel() {
        return this.isLfnEntry() ? false : (this.getFlags() & 0x18) == 8;
    }

    public boolean isSystemFlag() {
        return (this.getFlags() & 4) != 0;
    }

    public boolean isArchiveFlag() {
        return (this.getFlags() & 0x20) != 0;
    }

    public boolean isHiddenFlag() {
        return (this.getFlags() & 2) != 0;
    }

    public boolean isReadonlyFlag() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean isVolumeIdFlag() {
        return (this.getFlags() & 8) != 0;
    }

    public boolean isLfnEntry() {
        return this.isReadonlyFlag() && this.isSystemFlag() && this.isHiddenFlag() && this.isVolumeIdFlag();
    }

    private int getFlags() {
        return Util.getUInt8(this.data_, 11);
    }

    public boolean isDirectory() {
        return (this.getFlags() & 0x18) == 16;
    }

    public boolean isDeleted() {
        return Util.getUInt8(this.data_, 0) == 229;
    }

    public ShortName getShortName() {
        return this.data_[0] == 0 ? null : new ShortName(this.data_);
    }

    public boolean isFile() {
        return (this.getFlags() & 0x18) == 0;
    }

    public long getStartCluster() {
        return Util.getUInt16(this.data_, 26);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.getShortName() + "]";
    }

    String getLfnPart() {
        int end;
        char[] unicodechar = new char[]{(char)Util.getUInt16(this.data_, 1), (char)Util.getUInt16(this.data_, 3), (char)Util.getUInt16(this.data_, 5), (char)Util.getUInt16(this.data_, 7), (char)Util.getUInt16(this.data_, 9), (char)Util.getUInt16(this.data_, 14), (char)Util.getUInt16(this.data_, 16), (char)Util.getUInt16(this.data_, 18), (char)Util.getUInt16(this.data_, 20), (char)Util.getUInt16(this.data_, 22), (char)Util.getUInt16(this.data_, 24), (char)Util.getUInt16(this.data_, 28), (char)Util.getUInt16(this.data_, 30)};
        for (end = 0; end < 13 && unicodechar[end] != '\u0000'; ++end) {
        }
        return new String(unicodechar).substring(0, end);
    }
}

