/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dbgl.util.fat.AbstractDirectory;
import org.dbgl.util.fat.ClusterChain;
import org.dbgl.util.fat.ClusterChainDirectory;
import org.dbgl.util.fat.Fat;
import org.dbgl.util.fat.FatDirectoryEntry;
import org.dbgl.util.fat.FatLfnDirectoryEntry;
import org.dbgl.util.fat.ShortName;

public final class FatLfnDirectory {
    private final Fat fat_;
    final AbstractDirectory dir_;
    private final Set<String> usedNames_;
    private final Map<ShortName, FatLfnDirectoryEntry> shortNameIndex_;
    private final Map<String, FatLfnDirectoryEntry> longNameIndex_;
    private final Map<FatDirectoryEntry, FatLfnDirectory> entryToDirectory_;

    FatLfnDirectory(AbstractDirectory dir, Fat fat) throws IOException {
        if (dir == null || fat == null) {
            throw new NullPointerException();
        }
        this.fat_ = fat;
        this.dir_ = dir;
        this.usedNames_ = new HashSet<String>();
        this.shortNameIndex_ = new LinkedHashMap<ShortName, FatLfnDirectoryEntry>();
        this.longNameIndex_ = new LinkedHashMap<String, FatLfnDirectoryEntry>();
        this.entryToDirectory_ = new LinkedHashMap<FatDirectoryEntry, FatLfnDirectory>();
        this.parseLfn();
    }

    FatLfnDirectory getDirectory(FatDirectoryEntry entry) throws IOException {
        FatLfnDirectory result = this.entryToDirectory_.get(entry);
        if (result == null) {
            result = new FatLfnDirectory(FatLfnDirectory.read(entry, this.fat_), this.fat_);
            this.entryToDirectory_.put(entry, result);
        }
        return result;
    }

    private void checkUniqueName(String name) throws IOException {
        if (!this.usedNames_.add(name.toLowerCase())) {
            throw new IOException("an entry named " + name + " already exists");
        }
    }

    private void parseLfn() throws IOException {
        int i = 0;
        int size = this.dir_.getEntryCount();
        while (i < size) {
            while (i < size && this.dir_.getEntry(i) == null) {
                ++i;
            }
            if (i >= size) break;
            int offset = i;
            while (this.dir_.getEntry(i).isLfnEntry() && ++i < size) {
            }
            if (i >= size) break;
            FatLfnDirectoryEntry current = FatLfnDirectoryEntry.extract(this, offset, ++i - offset);
            if (current.realEntry_.isDeleted()) continue;
            this.checkUniqueName(current.getName());
            this.shortNameIndex_.put(current.realEntry_.getShortName(), current);
            this.longNameIndex_.put(current.getName().toLowerCase(), current);
        }
    }

    public Iterator<FatLfnDirectoryEntry> iterator() {
        return new Iterator<FatLfnDirectoryEntry>(){
            final Iterator<FatLfnDirectoryEntry> it;
            {
                this.it = FatLfnDirectory.this.shortNameIndex_.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public FatLfnDirectoryEntry next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [size=" + this.shortNameIndex_.size() + ", dir=" + this.dir_ + "]";
    }

    private static ClusterChainDirectory read(FatDirectoryEntry entry, Fat fat) throws IOException {
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException(entry + " is no directory");
        }
        ClusterChainDirectory result = new ClusterChainDirectory(new ClusterChain(fat, entry.getStartCluster()), false);
        result.read();
        return result;
    }
}

