/*
 * Decompiled with CFR 0.152.
 */
package exodos;

import exodos.AsciiProgressBar;
import exodos.ExoUtils;
import exodos.ZipReference;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Import {
    private static final String IMPORTER_VERSION = "0.94";
    private static boolean listOnly_ = false;
    private static boolean analyzeOnly_ = false;
    private static boolean verboseOutput_ = false;

    private static void displaySyntax() {
        System.out.println("Use: Import <inputexodosdir> [-l] [-a] [-v] [game-1] [game-2] [game-N]");
        System.out.println("-l\t\tList game titles and abbreviations, don't import");
        System.out.println("-a\t\tAnalyze only, don't import");
        System.out.println("-v\t\tVerbose output");
        System.out.println("Optional: game(s) to import based on title or abbreviation");
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("Imports eXoDOS games into DBGL (v0.94)");
        System.out.println();
        if (args.length < 1) {
            Import.displaySyntax();
        }
        File srcDir = new File(args[0]);
        ArrayList<String> impTitles = new ArrayList<String>();
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-l")) {
                    listOnly_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-a")) {
                    analyzeOnly_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-v")) {
                    verboseOutput_ = true;
                    continue;
                }
                impTitles.add(args[i].toLowerCase());
            }
        }
        if (listOnly_) {
            System.out.println("* List only");
        }
        if (analyzeOnly_) {
            System.out.println("* Analyze only");
        }
        if (verboseOutput_) {
            System.out.println("* Verbose output");
        }
        if (!impTitles.isEmpty()) {
            System.out.println("* Processing: " + StringUtils.join(impTitles, (String)", "));
        } else {
            System.out.println("* Processing all games");
        }
        System.out.println();
        if (ExoUtils.validateExoV5Parameters(srcDir)) {
            System.out.println("eXoDOS V5 found");
            DosboxVersion defaultDosboxVersion = ExoUtils.findDefaultDosboxVersion(verboseOutput_);
            new Import().importData(impTitles, srcDir, defaultDosboxVersion);
            try {
                DatabaseService.getInstance().shutdown();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void importData(List<String> impTitles, File srcDir, DosboxVersion dosboxVersion) {
        File contentDir = new File(srcDir, "Content");
        File gameZipsDir = new File(srcDir, ExoUtils.EXODOS_V5_GAMEZIPS_DIR);
        try (ZipFile xodosZipfile = new ZipFile(new File(contentDir, "XODOSMetadata.zip"), ExoUtils.CP437);
             ZipFile dosZipfile = new ZipFile(new File(contentDir, "!DOSmetadata.zip"), ExoUtils.CP437);){
            List<ZipEntry> xodosZipEntries = ExoUtils.listEntries(xodosZipfile, true);
            List<ZipEntry> dosZipEntries = ExoUtils.listEntries(dosZipfile, true);
            List dosboxConfEntries = dosZipEntries.parallelStream().filter(x -> x.getName().toLowerCase().endsWith("dosbox.conf")).collect(Collectors.toList());
            List<ZipEntry> imageEntries = xodosZipEntries.parallelStream().filter(x -> x.getName().startsWith("Images/MS-DOS")).collect(Collectors.toList());
            List<ZipEntry> extrasEntries = dosZipEntries.parallelStream().filter(x -> ExoUtils.EXTRAFILES.contains(FilenameUtils.getExtension(x.getName()).toLowerCase())).collect(Collectors.toList());
            List<ZipEntry> manualEntries = xodosZipEntries.parallelStream().filter(x -> x.getName().startsWith("Manuals/MS-DOS") && ExoUtils.EXTRAFILES.contains(FilenameUtils.getExtension(x.getName()).toLowerCase())).collect(Collectors.toList());
            List<ZipEntry> musicEntries = xodosZipEntries.parallelStream().filter(x -> x.getName().startsWith("Music/MS-DOS") && ExoUtils.EXTRAFILES.contains(FilenameUtils.getExtension(x.getName()).toLowerCase())).collect(Collectors.toList());
            ZipEntry msdosXmlEntry = xodosZipEntries.parallelStream().filter(x -> x.getName().equals("xml/MS-DOS.xml")).findAny().orElse(null);
            Document doc = XmlUtils.getDocumentBuilder().parse(xodosZipfile.getInputStream(msdosXmlEntry));
            NodeList gameNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/LaunchBox/Game", doc, XPathConstants.NODESET);
            int processed = 0;
            for (int i = 0; i < gameNodes.getLength(); ++i) {
                String gameDirName;
                Element gameNode = (Element)gameNodes.item(i);
                String gameApplicationPath = XmlUtils.getTextValue(gameNode, "ApplicationPath");
                String gameTitle = StringUtils.defaultString((String)XmlUtils.getTextValue(gameNode, "Title"));
                String fullGameTitle = FilenameUtils.getBaseName(gameApplicationPath);
                File gamePath = new File(gameApplicationPath).getParentFile();
                String string = gameDirName = gamePath != null ? gamePath.getName() : "";
                if (StringUtils.isBlank((CharSequence)fullGameTitle) || !impTitles.isEmpty() && !impTitles.contains(fullGameTitle.toLowerCase()) && !impTitles.contains(gameDirName.toLowerCase())) continue;
                if (listOnly_) {
                    System.out.println(String.format("%4d %-100s %-10s", i + 1, fullGameTitle, gameDirName));
                    continue;
                }
                File gameSrcZipfile = new File(gameZipsDir, fullGameTitle + ".zip");
                if (!FilesUtils.isExistingFile(gameSrcZipfile)) {
                    System.err.println(fullGameTitle + ": Zip file " + gameSrcZipfile + " is missing, skipping");
                    continue;
                }
                File canonicalGamePath = new File(FileLocationService.getInstance().getDosroot(), gameDirName);
                String confPathAndFile = FilenameUtils.separatorsToUnix(new File(gamePath, "dosbox.conf").getPath());
                ZipEntry confEntry = dosboxConfEntries.parallelStream().filter(x -> x.getName().equalsIgnoreCase(confPathAndFile)).findAny().orElse(null);
                if (confEntry == null) {
                    System.err.println(fullGameTitle + ": Zip file " + dosZipfile.getName() + " does not contain " + confPathAndFile + ", skipping");
                    continue;
                }
                Collection<ZipEntry> gameImageEntries = ExoUtils.getImages(imageEntries, gameTitle);
                List<ZipReference> gameCombinedExtraEntries = ExoUtils.getCombinedExtras(xodosZipfile, dosZipfile, extrasEntries, manualEntries, musicEntries, fullGameTitle, gameTitle, gameDirName);
                if (gameImageEntries.isEmpty() && verboseOutput_) {
                    System.out.println(fullGameTitle + ": No images found");
                }
                try (ZipFile gameZipfile = new ZipFile(gameSrcZipfile, ExoUtils.CP437);){
                    List<ZipEntry> gameZipEntries = ExoUtils.listEntries(gameZipfile, false);
                    Profile profile = ExoUtils.createProfile(gameNode, fullGameTitle, gameTitle, gamePath, gameDirName, dosboxVersion, confEntry, dosZipfile, gameSrcZipfile.getPath(), gameZipEntries, gameCombinedExtraEntries, verboseOutput_);
                    if (analyzeOnly_) continue;
                    profile = new ProfileRepository().add(profile);
                    AsciiProgressBar prog = new AsciiProgressBar(fullGameTitle, Stream.of(gameImageEntries, gameZipEntries).flatMap(Collection::stream).mapToLong(ZipEntry::getSize).sum() + gameCombinedExtraEntries.stream().mapToLong(x -> x.zipEntry_.getSize()).sum());
                    if (!gameImageEntries.isEmpty()) {
                        ExoUtils.unzip(xodosZipfile, gameImageEntries, profile.getCanonicalCaptures(), false, true, prog);
                    }
                    if (!gameCombinedExtraEntries.isEmpty()) {
                        ExoUtils.unzip(gameCombinedExtraEntries, new File(canonicalGamePath, "Extras"), prog);
                    }
                    ExoUtils.unzip(gameZipfile, gameZipEntries, canonicalGamePath, true, false, prog);
                    double p = impTitles != null && !impTitles.isEmpty() ? (double)(++processed) / (double)impTitles.size() * 100.0 : (double)(i + 1) / (double)gameNodes.getLength() * 100.0;
                    System.out.println(String.format("\r%s Imported. Overall progress: %3.1f%%", StringUtils.rightPad((String)StringUtils.abbreviate((String)fullGameTitle, (int)68), (int)70, (char)'.'), p));
                    continue;
                }
            }
            System.out.println("\n\nFinished.");
        }
        catch (IOException | SQLException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            e.printStackTrace();
        }
    }
}

