/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.CTabFolder_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.DaControlConvertorAdapter;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.List_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Spinner_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.dialog.EditMixerDialog;
import org.dbgl.gui.dialog.EditMountDialog;
import org.dbgl.gui.dialog.EditNativeCommandDialog;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.helper.DriveLetterHelper;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class EditConfigurableDialog<T>
extends SizeControlledTabbedDialog<T> {
    protected final List<Chain> metaControls_ = new ArrayList<Chain>();
    protected Chain nativeCommandControl_;
    protected List<DosboxVersion> dbversionsList_;
    protected int dbversionIndex_;
    protected Combo dbversionCombo_;
    protected Button setButton_;
    protected ExpandItem booterExpandItem_;
    protected ExpandItem dosExpandItem_;
    protected org.eclipse.swt.widgets.List mountingpointsList_;
    private Button switchButton_;
    private Button ipx_;
    private Text ipxNet_;
    private Combo machine_;
    protected org.eclipse.swt.widgets.List nativeCommandsList_;

    protected EditConfigurableDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    protected abstract void doPerformDosboxConfAction(DosboxConfAction var1, DosboxVersion var2);

    @Override
    protected boolean prepare() {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            this.dbversionIndex_ = BaseRepository.indexOfDefault(this.dbversionsList_);
            return true;
        }
        catch (SQLException e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    protected void updateControlsByConfigurable(TemplateProfileBase configurable) {
        Object[] machineValues;
        Configuration combinedConf = configurable.getCombinedConfiguration();
        Autoexec combinedAuto = combinedConf.getAutoexec();
        DosboxVersion dosbox = configurable.getDosboxVersion();
        this.metaControls_.forEach(x -> x.enableOrDisableControl(configurable));
        this.metaControls_.stream().forEach(x -> x.setComboValues(dosbox.getDynamicOptions()));
        Object[] objectArray = machineValues = dosbox.isUsingNewMachineConfig() ? this.settings_.getValues("profile", "machine073") : this.settings_.getValues("profile", "machine");
        if (!Arrays.equals(this.machine_.getItems(), machineValues)) {
            this.machine_.setItems((String[])machineValues);
        }
        if (this.mountingpointsList_.isEnabled() && !Arrays.equals(this.mountingpointsList_.getItems(), configurable.getMountStringsForUI())) {
            this.mountingpointsList_.setItems(configurable.getMountStringsForUI());
        }
        this.dosExpandItem_.setExpanded(!combinedAuto.isBooter());
        this.booterExpandItem_.setExpanded(combinedAuto.isBooter());
        this.metaControls_.forEach(x -> x.setControlByConfigurable(configurable, combinedConf));
        this.nativeCommandControl_.setControlByConfigurable(configurable, combinedConf);
        this.setButton_.setEnabled(false);
        this.switchButton_.setEnabled(false);
        this.ipxNet_.setEnabled(this.ipx_.getSelection());
    }

    protected void updateConfigurableByControls(TemplateProfileBase configurable) {
        Configuration combinedConf = configurable.getCombinedConfiguration();
        this.metaControls_.forEach(x -> x.updateConfigurableByControl(configurable, combinedConf));
        this.nativeCommandControl_.updateConfigurableByControl(configurable, combinedConf);
        configurable.setBooter(this.booterExpandItem_.getExpanded());
    }

    protected Group createGeneralTab(String capturesText, String configFileText) {
        Composite composite = this.createTabWithComposite("dialog.template.tab.general", (Layout)new GridLayout());
        Group associationGroup = Group_.on(composite).layout((Layout)new GridLayout(5, false)).key("dialog.template.association").build();
        associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversionCombo_ = Chain.on((Composite)associationGroup).lbl(l -> l.key("dialog.template.dosboxversion")).cmb(c -> c.wide().items((String[])this.dbversionsList_.stream().map(TitledEntity::getTitle).toArray(String[]::new)).select(this.dbversionIndex_).visibleItemCount(20)).combo();
        this.setButton_ = Button_.on((Composite)associationGroup).text().key("dialog.template.set").tooltip("dialog.template.set.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.SET, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        }).ctrl();
        this.switchButton_ = Button_.on((Composite)associationGroup).text().key("dialog.template.switch").tooltip("dialog.template.switch.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.SWITCH, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        }).ctrl();
        Button_.on((Composite)associationGroup).text().key("dialog.template.reloadsettings").tooltip("dialog.template.reloadsettings.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.RELOAD, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        }).ctrl();
        this.dbversionCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.setButton_.setEnabled(true);
                EditConfigurableDialog.this.switchButton_.setEnabled(true);
            }
        });
        Group miscGroup = Group_.on(composite).layout((Layout)new GridLayout(3, false)).key("dialog.template.miscellaneous").build();
        miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Chain.on((Composite)miscGroup).lbl(l -> l).lbl(l -> l.key("dialog.template.active")).lbl(l -> l.key("dialog.template.inactive")).build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.priority")).cmb(c -> c.tooltip("dialog.template.priority.tooltip").items("profile", "priority_active")).cmb(c -> c.tooltip("dialog.template.priority.tooltip").items("profile", "priority_inactive")).section("sdl").item("priority").build(this.metaControls_);
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.waitonerror")).but(b -> (Button_.Builder)b.horSpan(2)).section("sdl").item("waitonerror").build(this.metaControls_);
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.exitafterwards")).but(b -> (Button_.Builder)b.horSpan(2)).autoexec(Autoexec::getExit, Autoexec::setExit).build(this.metaControls_);
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.languagefile")).txt(t -> ((Text_.Builder)t.horSpan(2)).tooltip("dialog.template.languagefile.tooltip")).section("dosbox").item("language").build(this.metaControls_);
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.captures")).txt(t -> ((Text_.Builder)t.horSpan(2)).tooltip("dialog.template.captures.tooltip").val(capturesText).nonEditable()).build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.profile.configfile")).txt(t -> ((Text_.Builder)t.horSpan(2)).val(configFileText).nonEditable()).build();
        return associationGroup;
    }

    protected void createDisplayTab() {
        CTabFolder subTabFolder = this.createSubTabs("dialog.template.tab.display", 1, 2);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group groupRelease = Group_.on(releaseComposite).layout((Layout)new GridLayout(4, false)).key("dialog.template.general").build();
        groupRelease.setLayoutData((Object)new GridData(1, 1, false, false));
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.output")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.output.tooltip").items("profile", "output")).section("sdl").item("output").build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.frameskip")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.frameskip.tooltip").items("profile", "frameskip").visibleItemCount(15)).section("render").item("frameskip").build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.scaler")).cmb(c -> c.tooltip("dialog.template.scaler.tooltip").items("profile", "scaler").visibleItemCount(15)).lbl(l -> l.key("dialog.template.scalerforced")).but(b -> b.tooltip("dialog.template.scalerforced.tooltip")).section("render").item("scaler").convert(new DaControlConvertorAdapter(){

            @Override
            public String toConfValue(String[] values) {
                String result = values[0];
                if (Boolean.parseBoolean(values[1])) {
                    result = result + " forced";
                }
                return result;
            }

            @Override
            public String[] toControlValues(String value) {
                if (value == null) {
                    return new String[0];
                }
                String[] results = new String[2];
                if (value.endsWith("forced")) {
                    results[0] = value.substring(0, value.length() - 7);
                    results[1] = "true";
                } else {
                    results[0] = value;
                    results[1] = "false";
                }
                return results;
            }
        }).build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.fullscreenresolution")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.fullscreenresolution.tooltip").items("profile", "fullresolution")).section("sdl").item("fullresolution").build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.windowresolution")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.windowresolution.tooltip").items("profile", "windowresolution")).section("sdl").item("windowresolution").build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.fullscreen")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.fullscreen.tooltip")).section("sdl").item("fullscreen").build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.doublebuffering")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.doublebuffering.tooltip")).section("sdl").item("fulldouble").build(this.metaControls_);
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.aspectcorrection")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.aspectcorrection.tooltip")).section("render").item("aspect").build(this.metaControls_);
        Group groupExpGeneral = Group_.on(experimentalComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.general").build();
        groupExpGeneral.setLayoutData((Object)new GridData(4, 1, true, false, 1, 3));
        Object[] glShaderFiles = FileLocationService.getInstance().listGlShaderFilenames();
        String[] glShaders = glShaderFiles.length > 0 ? (String[])ArrayUtils.addAll((Object[])this.settings_.getValues("profile", "glshader"), (Object[])glShaderFiles) : this.settings_.getValues("profile", "glshader");
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.glshader")).cmb(c -> c.editable().wide().items(glShaders)).but(b -> b.browse(true, Button_.BrowseType.FILE, Button_.CanonicalType.GLSHADER, false)).section("render").item("glshader").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.autofit")).but(b -> (Button_.Builder)b.horSpan(2)).section("render").item("autofit").build(this.metaControls_);
        Combo pixelshader = Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.pixelshader")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).visibleItemCount(20)).section("sdl").item("pixelshader").build(this.metaControls_).getCombo();
        String[] shaders = FileLocationService.getInstance().listShaderFilenames();
        if (shaders.length > 0) {
            pixelshader.setItems(shaders);
            pixelshader.add("none", 0);
        } else {
            pixelshader.setItems(this.settings_.getValues("profile", "pixelshader"));
        }
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.linewise")).but(b -> (Button_.Builder)b.horSpan(2)).section("render").item("linewise").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.char9")).but(b -> (Button_.Builder)b.horSpan(2)).section("render").item("char9").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.multiscan")).but(b -> (Button_.Builder)b.horSpan(2)).section("render").item("multiscan").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.cgasnow")).but(b -> (Button_.Builder)b.horSpan(2)).section("cpu", "video").item("cgasnow", "cgasnow").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.overscan")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).editable().items("profile", "overscan")).section("sdl").item("overscan").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.vsyncmode")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "vsyncmode")).section("vsync").item("vsyncmode").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.vsyncrate")).txt(t -> (Text_.Builder)t.horSpan(2)).section("vsync").item("vsyncrate").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.forcerate")).txt(t -> (Text_.Builder)t.horSpan(2)).section("cpu", "video").item("forcerate", "forcerate").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.videoram")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "vmemsize")).section("dosbox", "video").item("vmemsize", "vmemsize").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.fullborderless")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.fullborderless.tooltip")).section("sdl").item("fullborderless").build(this.metaControls_);
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.glfullvsync")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.glfullvsync.tooltip")).section("sdl").item("glfullvsync").build(this.metaControls_);
        Group groupExpGlide = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.glide").build();
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.glide")).cmb(c -> c.items("profile", "glide")).section("glide", "voodoo").item("glide", "glide").build(this.metaControls_);
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.glideport")).txt(t -> t).section("glide").item("port", "grport").build(this.metaControls_);
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.lfbglide")).cmb(c -> c.items("profile", "lfbglide")).section("glide", "voodoo").item("lfb", "lfb").build(this.metaControls_);
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.splash3dfx")).but(b -> b).section("glide", "voodoo").item("splash", "splash").build(this.metaControls_);
        Group groupExpVoodoo = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.voodoo").build();
        Chain.on((Composite)groupExpVoodoo).lbl(l -> l.key("dialog.template.voodoo")).cmb(c -> c.items("profile", "voodoo")).section("pci", "voodoo").item("voodoo", "voodoo_card").build(this.metaControls_);
        Chain.on((Composite)groupExpVoodoo).lbl(l -> l.key("dialog.template.voodoomem")).cmb(c -> c.items("profile", "voodoomem")).section("pci").item("voodoomem").build(this.metaControls_);
        Group groupExpPPScaling = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.pixelperfectscaling").build();
        Chain.on((Composite)groupExpPPScaling).lbl(l -> l.key("dialog.template.surfacenpsharpness")).spn(s -> s.min(0).max(100)).section("sdl").item("surfacenp-sharpness").build(this.metaControls_);
    }

    protected Group createMachineTab() {
        CTabFolder subTabFolder = this.createSubTabs("dialog.template.tab.machine", 1, 1);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group cpuGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(6, false)).key("dialog.template.cpu").build();
        this.machine_ = Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.machine")).cmb(c -> c.tooltip("dialog.template.machine.tooltip").visibleItemCount(20)).section("dosbox").item("machine").build(this.metaControls_).getCombo();
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.cputype")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.cputype.tooltip").items("profile", "cputype")).section("cpu").item("cputype").build(this.metaControls_);
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.core")).cmb(c -> ((Combo_.Builder)c.horSpan(5)).tooltip("dialog.template.core.tooltip").items("profile", "core")).section("cpu").item("core").build(this.metaControls_);
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.cycles")).cmb(c -> c.editable().tooltip("dialog.template.cycles.tooltip").items("profile", "cycles").visibleItemCount(15)).section("cpu").item("cycles").build(this.metaControls_);
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.up")).cmb(c -> c.editable().tooltip("dialog.template.up.tooltip").items("profile", "cycles_up")).section("cpu").item("cycleup").build(this.metaControls_);
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.down")).cmb(c -> c.editable().tooltip("dialog.template.down.tooltip").items("profile", "cycles_down")).section("cpu").item("cycledown").build(this.metaControls_);
        Group memoryGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(4, false)).key("dialog.template.memory").build();
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.memorysize")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.memorysize.tooltip").items("profile", "memsize")).section("dosbox").item("memsize").build(this.metaControls_);
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.xms")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.xms.tooltip")).section("dos").item("xms").build(this.metaControls_);
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.ems")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.ems.tooltip").items("profile", "ems")).section("dos").item("ems").build(this.metaControls_);
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.umb")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.umb.tooltip").items("profile", "umb")).section("dos").item("umb").build(this.metaControls_);
        Group expMemoryGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.memory").build();
        Chain.on((Composite)expMemoryGroup).lbl(l -> l.key("dialog.template.memorysizekb")).txt(t -> t).section("dosbox").item("memsizekb").build(this.metaControls_);
        Chain.on((Composite)expMemoryGroup).lbl(l -> l.key("dialog.template.memalias")).cmb(c -> c.editable().items("profile", "memalias")).section("dosbox").item("memalias").build(this.metaControls_);
        return memoryGroup;
    }

    protected void createAudioTab() {
        CTabFolder subTabFolder = this.createSubTabs("dialog.template.tab.audio", 3, 3);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group generalGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.general").build();
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.silentmode")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.silentmode.tooltip")).section("mixer").item("nosound").build(this.metaControls_);
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.samplerate")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.samplerate.tooltip").items("profile", "rate")).section("mixer").item("rate").build(this.metaControls_);
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.blocksize")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.blocksize.tooltip").items("profile", "blocksize")).section("mixer").item("blocksize").build(this.metaControls_);
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.prebuffer")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).editable().tooltip("dialog.template.prebuffer.tooltip").items("profile", "prebuffer")).section("mixer").item("prebuffer").build(this.metaControls_);
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.mpu401")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.mpu401.tooltip").items("profile", "mpu401")).section("midi", "midi").item("intelligent", "mpu401").convert(new DaControlConvertorAdapter(){

            @Override
            public String toConfValue(String[] values) {
                return values[0];
            }

            @Override
            public String[] toControlValues(String value) {
                if (value == null) {
                    return new String[0];
                }
                return new String[]{value};
            }

            @Override
            public String[] toConfValues(String[] values) {
                String[] result = new String[]{String.valueOf(!values[0].equalsIgnoreCase("none")), String.valueOf(!values[0].equalsIgnoreCase("uart"))};
                return result;
            }

            @Override
            public String[] toControlValues(String[] values) {
                boolean intelligent = Boolean.parseBoolean(values[0]);
                boolean mpu = Boolean.parseBoolean(values[1]);
                String[] stringArray = new String[1];
                stringArray[0] = mpu ? (intelligent ? "intelligent" : "uart") : "none";
                return stringArray;
            }
        }).build(this.metaControls_);
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.mididevice")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.mididevice.tooltip").items("profile", "device")).section("midi").item("device", "mididevice").build(this.metaControls_);
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.midiconfig")).txt(t -> ((Text_.Builder)t.horSpan(2)).tooltip("dialog.template.midiconfig.tooltip")).section("midi").item("config", "midiconfig").build(this.metaControls_);
        final Chain chnMixer = Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.mixercommand")).txt(t -> t).autoexec(Autoexec::getMixer, Autoexec::setMixer).but(Button_.Builder::threedots).build(this.metaControls_);
        chnMixer.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String command = (String)new EditMixerDialog(EditConfigurableDialog.this.shell_, chnMixer.getText().getText()).open();
                if (command != null) {
                    chnMixer.getText().setText(command);
                }
            }
        });
        Group soundblasterGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.soundblaster").build();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbtype")).cmb(c -> c.tooltip("dialog.template.sbtype.tooltip").items("profile", "sbtype")).section("sblaster").item("type", "sbtype").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sboplrate")).cmb(c -> c.tooltip("dialog.template.sboplrate.tooltip").items("profile", "oplrate")).section("sblaster").item("oplrate").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sboplmode")).cmb(c -> c.tooltip("dialog.template.sboplmode.tooltip").items("profile", "oplmode")).section("sblaster").item("oplmode").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sboplemu")).cmb(c -> c.tooltip("dialog.template.sboplemu.tooltip").items("profile", "oplemu")).section("sblaster").item("oplemu").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbaddress")).cmb(c -> c.tooltip("dialog.template.sbaddress.tooltip").items("profile", "sbbase")).section("sblaster").item("base", "sbbase").build(this.metaControls_).getCombo();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbirq")).cmb(c -> c.tooltip("dialog.template.sbirq.tooltip").items("profile", "irq")).section("sblaster").item("irq").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbdma")).cmb(c -> c.tooltip("dialog.template.sbdma.tooltip").items("profile", "dma")).section("sblaster").item("dma").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbhdma")).cmb(c -> c.tooltip("dialog.template.sbhdma.tooltip").items("profile", "hdma")).section("sblaster").item("hdma").build(this.metaControls_);
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.mixer")).but(b -> b.tooltip("dialog.template.mixer.tooltip")).section("sblaster").item("mixer", "sbmixer").build(this.metaControls_);
        Group gusGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.gravisultrasound").build();
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.enablegus")).but(b -> b.tooltip("dialog.template.enablegus.tooltip")).section("gus").item("gus").build(this.metaControls_);
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusrate")).cmb(c -> c.tooltip("dialog.template.gusrate.tooltip").items("profile", "gusrate")).section("gus").item("rate", "gusrate").build(this.metaControls_).getCombo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusaddress")).cmb(c -> c.tooltip("dialog.template.gusaddress.tooltip").items("profile", "gusbase")).section("gus").item("base", "gusbase").build(this.metaControls_).getCombo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusirq1")).cmb(c -> c.tooltip("dialog.template.gusirq1.tooltip").items("profile", "irq1")).section("gus").item("irq1", "gusirq").build(this.metaControls_).getCombo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusirq2")).cmb(c -> c.tooltip("dialog.template.gusirq1.tooltip").items("profile", "irq2")).section("gus").item("irq2").build(this.metaControls_);
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusdma1")).cmb(c -> c.tooltip("dialog.template.gusdma1.tooltip").items("profile", "dma1")).section("gus").item("dma1", "gusdma").build(this.metaControls_).getCombo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusdma2")).cmb(c -> c.tooltip("dialog.template.gusdma1.tooltip").items("profile", "dma2")).section("gus").item("dma2").build(this.metaControls_);
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.ultradir")).txt(t -> t.tooltip("dialog.template.ultradir.tooltip")).section("gus").item("ultradir").build(this.metaControls_).getText();
        Group speakerGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.pcspeaker").build();
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)speakerGroup).lbl(l -> l.key("dialog.template.enablepcspeaker")).but(b -> b.tooltip("dialog.template.enablepcspeaker.tooltip")).section("speaker").item("pcspeaker").build(this.metaControls_);
        Chain.on((Composite)speakerGroup).lbl(l -> l.key("dialog.template.pcrate")).cmb(c -> c.tooltip("dialog.template.pcrate.tooltip").items("profile", "pcrate")).section("speaker").item("pcrate").build(this.metaControls_);
        Group tandyGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.tandy").build();
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)tandyGroup).lbl(l -> l.key("dialog.template.enabletandy")).cmb(c -> c.tooltip("dialog.template.enabletandy.tooltip").items("profile", "tandy")).section("speaker").item("tandy").build(this.metaControls_);
        Chain.on((Composite)tandyGroup).lbl(l -> l.key("dialog.template.tandyrate")).cmb(c -> c.tooltip("dialog.template.tandyrate.tooltip").items("profile", "tandyrate")).section("speaker").item("tandyrate").build(this.metaControls_);
        Group disneyGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.miscellaneous").build();
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)disneyGroup).lbl(l -> l.key("dialog.template.enablesoundsource")).but(b -> b.tooltip("dialog.template.enablesoundsource.tooltip")).section("speaker").item("disney").build(this.metaControls_);
        Group generalExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.general").build();
        generalExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)generalExpGroup).lbl(l -> l.key("dialog.template.swapstereo")).but(b -> b).section("mixer").item("swapstereo").build(this.metaControls_);
        Group soundblasterExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.soundblaster").build();
        soundblasterExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)soundblasterExpGroup).lbl(l -> l.key("dialog.template.hardwaresbaddress")).cmb(c -> c.items("profile", "hardwaresbbase")).section("sblaster").item("hardwarebase").build(this.metaControls_);
        Chain.on((Composite)soundblasterExpGroup).lbl(l -> l.key("dialog.template.goldplay")).but(b -> b).section("sblaster").item("goldplay").build(this.metaControls_);
        Chain.on((Composite)soundblasterExpGroup).lbl(l -> l.key("dialog.template.fmstrength")).spn(s -> s.min(1).max(1000)).section("sblaster").item("fmstrength").build(this.metaControls_);
        Group mt32ExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.mt32").build();
        mt32ExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.romdir")).txt(t -> t).but(b -> b.browse(true, Button_.BrowseType.DIR, Button_.CanonicalType.NONE, false)).section("midi").item("mt32.romdir").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.swapstereo")).but(b -> (Button_.Builder)b.horSpan(2)).section("midi").item("mt32.reverse.stereo").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.verboselogging")).but(b -> (Button_.Builder)b.horSpan(2)).section("midi").item("mt32.verbose").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.multithread")).but(b -> (Button_.Builder)b.horSpan(2)).section("midi").item("mt32.thread").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.chunk")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).min(2).max(100)).section("midi").item("mt32.chunk").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.prebuffer")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).min(3).max(200)).section("midi").item("mt32.prebuffer").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.partials")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).min(0).max(256)).section("midi").item("mt32.partials").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.dac")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "mt32dac")).section("midi").item("mt32.dac").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.analog")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "mt32analog")).section("midi").item("mt32.analog").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.reverbmode")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "mt32reverbmode")).section("midi").item("mt32.reverb.mode").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.reverbtime")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "mt32reverbtime")).section("midi").item("mt32.reverb.time").build(this.metaControls_);
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.reverblevel")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "mt32reverblevel")).section("midi").item("mt32.reverb.level").build(this.metaControls_);
        Group fluidExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.fluidsynth").build();
        fluidExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.driver")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).editable().items("profile", "fluidsynthdriver")).section("midi").item("fluid.driver").build(this.metaControls_);
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.soundfont")).txt(t -> t).but(b -> b.browse(true, Button_.BrowseType.FILE, Button_.CanonicalType.NONE, false)).section("midi").item("fluid.soundfont").build(this.metaControls_);
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.samplerate")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "fluidsynthsamplerate")).section("midi").item("fluid.samplerate").build(this.metaControls_);
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.gain")).txt(t -> (Text_.Builder)t.horSpan(2)).section("midi").item("fluid.gain").build(this.metaControls_);
        Group innovaExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.innova").build();
        innovaExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovaenable")).but(b -> b).section("innova").item("innova").build(this.metaControls_);
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovarate")).cmb(c -> c.items("profile", "innovarate")).section("innova").item("samplerate").build(this.metaControls_);
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovaaddress")).cmb(c -> c.items("profile", "innovabase")).section("innova").item("sidbase").build(this.metaControls_);
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovaquality")).cmb(c -> c.items("profile", "innovaquality")).section("innova").item("quality").build(this.metaControls_);
        Group ps1ExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.ps1").build();
        ps1ExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)ps1ExpGroup).lbl(l -> l.key("dialog.template.ps1enable")).but(b -> b).section("speaker").item("ps1audio").onOff().build(this.metaControls_);
        Chain.on((Composite)ps1ExpGroup).lbl(l -> l.key("dialog.template.ps1rate")).cmb(c -> c.items("profile", "ps1rate")).section("speaker").item("ps1audiorate").build(this.metaControls_);
    }

    protected void createIOTab() {
        CTabFolder subTabFolder = this.createSubTabs("dialog.template.tab.io", 3, 4);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group mouseGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.mouse").build();
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)mouseGroup).lbl(l -> l.key("dialog.template.autolock")).but(b -> b.tooltip("dialog.template.autolock.tooltip")).section("sdl").item("autolock").build(this.metaControls_);
        Chain.on((Composite)mouseGroup).lbl(l -> l.key("dialog.template.sensitivity")).cmb(c -> c.editable().items("profile", "sensitivity").visibleItemCount(20).tooltip("dialog.template.sensitivity.tooltip")).section("sdl").item("sensitivity").convert(new DaControlConvertor(){

            @Override
            public String toConfValue(String[] values) {
                return String.join((CharSequence)",", values);
            }

            @Override
            public String[] toControlValues(String value) {
                String[] stringArray;
                if (value == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = value;
                }
                return stringArray;
            }

            @Override
            public String[] toConfValues(String[] values) {
                return new String[0];
            }

            @Override
            public String[] toControlValues(String[] values) {
                return new String[0];
            }
        }).build(this.metaControls_);
        Group keyboardGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.keyboard").build();
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.usescancodes")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.usescancodes.tooltip")).section("sdl").item("usescancodes").build(this.metaControls_);
        final Text mapperfile = Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.mapperfile")).txt(t -> t.tooltip("dialog.template.mapperfile.tooltip")).section("sdl").item("mapperfile").build(this.metaControls_).getText();
        Button_.on((Composite)keyboardGroup).star().listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                mapperfile.setText(EditConfigurableDialog.this.settings_.getValue("profile", "uniquemapperfile"));
            }
        }).ctrl();
        Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.keyboardlayout")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).wide().editable().tooltip("dialog.template.keyboardlayout.tooltip").items("profile", "keyboardlayout").visibleItemCount(15)).section("dos").item("keyboardlayout").build(this.metaControls_);
        Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.keybcommand")).txt(t -> (Text_.Builder)t.horSpan(2)).autoexec(Autoexec::getKeyb, Autoexec::setKeyb).build(this.metaControls_);
        Group joystickGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.joystick").build();
        joystickGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.joysticktype")).cmb(c -> c.tooltip("dialog.template.joysticktype.tooltip").items("profile", "joysticktype")).section("bios", "joystick").item("joysticktype", "joysticktype").build(this.metaControls_);
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.timedemulation")).but(b -> b.tooltip("dialog.template.timedemulation.tooltip")).section("joystick").item("timed").build(this.metaControls_);
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.autofire")).but(b -> b.tooltip("dialog.template.autofire.tooltip")).section("joystick").item("autofire").build(this.metaControls_);
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.swap34")).but(b -> b.tooltip("dialog.template.swap34.tooltip")).section("joystick").item("swap34").build(this.metaControls_);
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.buttonwrapping")).but(b -> b.tooltip("dialog.template.buttonwrapping.tooltip")).section("joystick").item("buttonwrap").build(this.metaControls_);
        Group modemGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.modem").build();
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial1")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).section("serial").item("serial1").build(this.metaControls_);
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial2")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).section("serial").item("serial2").build(this.metaControls_);
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial3")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).section("serial").item("serial3").build(this.metaControls_);
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial4")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).section("serial").item("serial4").build(this.metaControls_);
        Group networkGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.network").build();
        networkGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipx_ = Chain.on((Composite)networkGroup).lbl(l -> l.key("dialog.template.enableipx")).but(b -> b.tooltip("dialog.template.enableipx.tooltip")).section("ipx").item("ipx").build(this.metaControls_).getButton();
        this.ipxNet_ = Chain.on((Composite)networkGroup).lbl(l -> ((Label_.Builder)l.horSpan(2)).key("dialog.template.ipxnetcommand")).txt(t -> (Text_.Builder)t.horSpan(2)).autoexec(Autoexec::getIpxnet, Autoexec::setIpxnet).build(this.metaControls_).getText();
        this.ipx_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.ipxNet_.setEnabled(EditConfigurableDialog.this.ipx_.getSelection());
            }
        });
        Group mouseExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.mouse").build();
        mouseExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.int33")).but(b -> b).section("dos").item("int33").build(this.metaControls_);
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.biosps2")).but(b -> b).section("dos").item("biosps2").build(this.metaControls_);
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.aux")).but(b -> b).section("keyboard").item("aux").build(this.metaControls_);
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.auxdevice")).cmb(c -> c.items("profile", "auxdevice")).section("keyboard").item("auxdevice").build(this.metaControls_);
        Group miscExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.miscellaneous").build();
        miscExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.files")).spn(s -> s.min(8).max(255)).section("dos", "config").item("files", "files").build(this.metaControls_);
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.isapnpbios")).but(b -> b).section("cpu").item("isapnpbios").build(this.metaControls_);
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide1")).but(b -> b).section("ide, primary").item("enable").build(this.metaControls_);
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide2")).but(b -> b).section("ide, secondary").item("enable").build(this.metaControls_);
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide3")).but(b -> b).section("ide, tertiary").item("enable").build(this.metaControls_);
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide4")).but(b -> b).section("ide, quaternary").item("enable").build(this.metaControls_);
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.automount")).but(b -> b).section("dos").item("automount").build(this.metaControls_);
        Group printerExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.printer").build();
        printerExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerenable")).but(b -> b).section("printer").item("printer").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerdpi")).spn(s -> s.min(0).max(Short.MAX_VALUE)).section("printer").item("dpi").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerwidth")).spn(s -> s.min(0).max(Short.MAX_VALUE)).section("printer").item("width").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerheight")).spn(s -> s.min(0).max(Short.MAX_VALUE)).section("printer").item("height").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printeroutput")).cmb(c -> c.items("profile", "printeroutput")).section("printer").item("printoutput").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printermultipage")).but(b -> b).section("printer").item("multipage").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerdocpath")).txt(t -> t).section("printer").item("docpath").build(this.metaControls_);
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printertimeout")).spn(s -> s.min(0).max(Short.MAX_VALUE)).section("printer").item("timeout").build(this.metaControls_);
        Group joystickExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.joystick").build();
        joystickExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)joystickExpGroup).lbl(l -> l.key("dialog.template.circularinput")).but(b -> b.tooltip("dialog.template.circularinput.tooltip")).section("joystick").item("circularinput").build(this.metaControls_);
        Chain.on((Composite)joystickExpGroup).lbl(l -> l.key("dialog.template.deadzone")).spn(s -> s.tooltip("dialog.template.deadzone.tooltip").min(0).max(100)).section("joystick").item("deadzone").build(this.metaControls_);
        Group parallelExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.parallel").build();
        parallelExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.parallel1")).txt(t -> t).section("parallel").item("parallel1").build(this.metaControls_);
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.parallel2")).txt(t -> t).section("parallel").item("parallel2").build(this.metaControls_);
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.parallel3")).txt(t -> t).section("parallel").item("parallel3").build(this.metaControls_);
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.dongle")).but(b -> b).section("parallel").item("dongle").build(this.metaControls_);
        Group ne2000ExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.ne2000").build();
        ne2000ExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000enable")).but(b -> b).section("ne2000").item("ne2000").build(this.metaControls_);
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000base")).txt(t -> t).section("ne2000").item("nicbase").build(this.metaControls_);
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000irq")).txt(t -> t).section("ne2000").item("nicirq").build(this.metaControls_);
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000macaddress")).txt(t -> t).section("ne2000").item("macaddr").build(this.metaControls_);
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000realnic")).txt(t -> t).section("ne2000").item("realnic").build(this.metaControls_);
    }

    protected void createCustomCommandsTab() {
        CTabFolder subTabFolder = this.createSubTabs("dialog.template.tab.customcommands", "dialog.template.tab.dosboxautoexec", 2, "dialog.template.tab.native", 2);
        Composite dosboxComposite = (Composite)subTabFolder.getChildren()[0];
        Composite nativeComposite = (Composite)subTabFolder.getChildren()[1];
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            int j = i + 1;
            Chain.on(dosboxComposite).lbl(l -> l.key("dialog.template.customcommand" + j)).txt(Text_.Builder::multi).autoexec(i, Autoexec::getCustomSection, Autoexec::setCustomSection).build(this.metaControls_);
        }
        this.nativeCommandControl_ = Chain.on(nativeComposite).lbl(l -> l.key("dialog.template.nativecommands")).lbl(l -> l).lst(l -> l).nativeCommands(TemplateProfileBase::getNativeCommands, TemplateProfileBase::setNativeCommandsWithObject).build();
        this.nativeCommandsList_ = this.nativeCommandControl_.getList();
        this.nativeCommandsList_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.this.doAddNativeCommand();
                } else {
                    EditConfigurableDialog.this.doEditNativeCommand();
                }
            }
        });
        Composite nativeButComp = ((Composite_.Builder)Composite_.on(nativeComposite).layoutData(new GridData(1, 1, false, false))).innerLayout(1).vertSpacing().build();
        Chain.on(nativeButComp).but(b -> b.text().key("dialog.template.mount.add").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doAddNativeCommand();
            }
        })).but(b -> b.text().key("dialog.template.mount.edit").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doEditNativeCommand();
            }
        })).but(b -> b.text().key("dialog.template.mount.remove").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doRemoveNativeCommand();
            }
        })).but(b -> b.arrow(true).listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex();
                if (sel > 0) {
                    List cmds = EditConfigurableDialog.this.getNativeCommands();
                    Collections.swap(cmds, sel, sel - 1);
                    EditConfigurableDialog.this.nativeCommandControl_.setControlByNativeCommands(cmds);
                    EditConfigurableDialog.this.nativeCommandsList_.select(sel - 1);
                }
            }
        })).but(b -> b.arrow(false).listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex();
                if (sel >= 0 && sel < EditConfigurableDialog.this.nativeCommandsList_.getItemCount() - 1) {
                    List cmds = EditConfigurableDialog.this.getNativeCommands();
                    Collections.swap(cmds, sel, sel + 1);
                    EditConfigurableDialog.this.nativeCommandControl_.setControlByNativeCommands(cmds);
                    EditConfigurableDialog.this.nativeCommandsList_.select(sel + 1);
                }
            }
        })).build();
    }

    private List<NativeCommand> getNativeCommands() {
        return new ArrayList<NativeCommand>(this.nativeCommandControl_.getCurrentNativeCommands());
    }

    protected void doAddNativeCommand() {
        EditNativeCommandDialog cmdDialog = new EditNativeCommandDialog(this.shell_, null);
        NativeCommand cmd = (NativeCommand)cmdDialog.open();
        if (cmd != null) {
            int nr = this.nativeCommandsList_.getSelectionIndex() + 1;
            List<NativeCommand> cmds = this.getNativeCommands();
            cmds.add(nr, cmd);
            this.nativeCommandControl_.setControlByNativeCommands(cmds);
        }
    }

    protected void doEditNativeCommand() {
        EditNativeCommandDialog cmdDialog;
        List<NativeCommand> cmds;
        NativeCommand cmd;
        int sel = this.nativeCommandsList_.getSelectionIndex();
        if (sel != -1 && !(cmd = (cmds = this.getNativeCommands()).get(sel)).isDosboxCommand() && (cmd = (NativeCommand)(cmdDialog = new EditNativeCommandDialog(this.shell_, cmd)).open()) != null) {
            cmds.set(sel, cmd);
            this.nativeCommandControl_.setControlByNativeCommands(cmds);
        }
    }

    protected void doRemoveNativeCommand() {
        List<NativeCommand> cmds;
        NativeCommand cmd;
        int sel = this.nativeCommandsList_.getSelectionIndex();
        if (sel != -1 && !(cmd = (cmds = this.getNativeCommands()).get(sel)).isDosboxCommand()) {
            cmds.remove(sel);
            this.nativeCommandControl_.setControlByNativeCommands(cmds);
            this.nativeCommandsList_.select(Math.min(sel, this.nativeCommandsList_.getItemCount() - 1));
        }
    }

    protected void createMountingTab(final TemplateProfileBase configurable, boolean multiEdit) {
        final Composite composite = this.createTabWithComposite("dialog.template.tab.mounting", (Layout)new GridLayout());
        Group mountGroup = Group_.on(composite).layout((Layout)new GridLayout(2, false)).key("dialog.template.mountingoverview").build();
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mountingpointsList_ = List_.on((Composite)mountGroup).ctrl();
        Group executeGroup = Group_.on(composite).layout((Layout)new FillLayout()).key("dialog.template.execute").build();
        executeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        final ExpandBar dosBooterExpandBar = EditConfigurableDialog.createExpandBar((Composite)executeGroup);
        Composite booterComposite = Composite_.on((Composite)dosBooterExpandBar).build();
        Composite dosComposite = Composite_.on((Composite)dosBooterExpandBar).build();
        this.booterExpandItem_ = EditConfigurableDialog.createExpandItem(dosBooterExpandBar, "dialog.template.booter", false, booterComposite);
        this.dosExpandItem_ = EditConfigurableDialog.createExpandItem(dosBooterExpandBar, "dialog.template.dos", false, dosComposite);
        dosBooterExpandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                dosBooterExpandBar.getItem(((ExpandItem)e.item).getText().equals(EditConfigurableDialog.this.text_.get("dialog.template.dos")) ? 0 : 1).setExpanded(true);
                EditConfigurableDialog.this.display_.asyncExec(() -> ((Composite)composite).layout());
            }

            public void itemExpanded(ExpandEvent e) {
                dosBooterExpandBar.getItem(((ExpandItem)e.item).getText().equals(EditConfigurableDialog.this.text_.get("dialog.template.dos")) ? 0 : 1).setExpanded(false);
                EditConfigurableDialog.this.display_.asyncExec(() -> ((Composite)composite).layout());
            }
        });
        this.mountingpointsList_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditConfigurableDialog.this.mountingpointsList_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.doAddMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.booterExpandItem_.getExpanded(), EditConfigurableDialog.this.mountingpointsList_, configurable);
                } else {
                    EditConfigurableDialog.doEditMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.mountingpointsList_, configurable);
                }
            }
        });
        Composite mntButComp = Composite_.on((Composite)mountGroup).innerLayout(1).vertSpacing().build();
        Chain.on(mntButComp).but(b -> b.text().key("dialog.template.mount.add").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doAddMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.booterExpandItem_.getExpanded(), EditConfigurableDialog.this.mountingpointsList_, configurable);
            }
        })).but(b -> b.text().key("dialog.template.mount.edit").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doEditMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.mountingpointsList_, configurable);
            }
        })).but(b -> b.text().key("dialog.template.mount.remove").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doRemoveMount(configurable);
            }
        })).build();
        if (multiEdit) {
            Arrays.asList(mntButComp.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }

    public static void doAddMount(Shell shell, boolean floppy, org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        char drive;
        try {
            drive = DriveLetterHelper.getFirstAvailable(floppy, configurable.getNettoMountedDrives());
        }
        catch (DrivelettersExhaustedException e) {
            drive = 'C';
        }
        EditMountDialog addMountDialog = new EditMountDialog(shell, null, drive);
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            configurable.addMount(mount);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            mountingpoints.select(mountingpoints.getItemCount() - 1);
        }
    }

    public static void doEditMount(Shell shell, org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        EditMountDialog editMountDialog;
        String mount;
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            mountingpoints.select(sel);
        }
        if (sel != -1 && !configurable.getMountingPointsForUI().get(sel).isUnmounted() && (mount = (String)(editMountDialog = new EditMountDialog(shell, mountingpoints.getItem(sel), 'C')).open()) != null) {
            configurable.editMountBasedOnIndexUI(sel, mount);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else {
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void doRemoveMount(TemplateProfileBase configurable) {
        EditConfigurableDialog.doRemoveMount(this.mountingpointsList_, configurable);
    }

    public static void doRemoveMount(org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            mountingpoints.select(sel);
        }
        if (sel != -1) {
            configurable.removeMountBasedOnIndexUI(sel);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else if (mountingpoints.getItemCount() > 0) {
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            }
        }
    }

    private CTabFolder createSubTabs(String titleKey, int numColumns1, int numColumns2) {
        return this.createSubTabs(titleKey, "dialog.template.tab.releaseoptions", numColumns1, "dialog.template.tab.experimentaloptions", numColumns2);
    }

    private CTabFolder createSubTabs(String titleKey, String key1, int numColumns1, String key2, int numColumns2) {
        CTabFolder subTabFolder = CTabFolder_.on(this.createTabWithComposite(titleKey, (Layout)new FillLayout())).ctrl();
        Composite_.on((Composite)subTabFolder).layout((Layout)new GridLayout(numColumns1, false)).tab(key1).build();
        Composite_.on((Composite)subTabFolder).layout((Layout)new GridLayout(numColumns2, false)).tab(key2).build();
        return subTabFolder;
    }

    protected void validateMounts(TemplateProfileBase configurable, Mess_.Builder mess) {
        if (mess.noErrors()) {
            String msg = null;
            switch (configurable.checkMounts()) {
                case INVALID_OVERLAY_NO_BASEDRIVE: {
                    msg = this.text_.get("dialog.template.notice.invalidmounts.overlaynobasedrive");
                    break;
                }
                case INVALID_OVERLAY_MIXED_ABSREL_PATHS: {
                    msg = this.text_.get("dialog.template.notice.invalidmounts.overlaymixedpaths");
                    break;
                }
                case INVALID_OVERLAY_PATHS_EQUAL: {
                    msg = this.text_.get("dialog.template.notice.invalidmounts.overlaypathsequal");
                    break;
                }
            }
            if (msg != null && !Mess_.on(this.shell_).txt(msg + "\n" + this.text_.get("dialog.template.notice.invalidmounts.ignore")).confirm()) {
                mess.txt(msg).bind((Control)this.mountingpointsList_, this.getTabItemByControl((Control)this.mountingpointsList_));
            }
        }
    }

    public static enum MountsValidationResult {
        OK,
        INVALID_OVERLAY_NO_BASEDRIVE,
        INVALID_OVERLAY_MIXED_ABSREL_PATHS,
        INVALID_OVERLAY_PATHS_EQUAL;

    }

    protected static enum DosboxConfAction {
        SET,
        SWITCH,
        RELOAD,
        LOAD_TEMPLATE,
        RELOAD_TEMPLATE;

    }
}

