/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.service.TextService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public final class Text_ {
    private final Text text_;

    private Text_(Builder builder) {
        this.text_ = new Text(builder.composite_, builder.style_);
        if (DarkTheme.forced()) {
            this.text_.setBackground(DarkTheme.inputBackground);
            this.text_.setForeground(DarkTheme.defaultForeground);
        }
        this.text_.setLayoutData(builder.layoutData());
        if (builder.focus_) {
            this.text_.setFocus();
        }
        if (builder.tooltip_ != null) {
            this.text_.setToolTipText(builder.tooltip_);
        }
        if (builder.value_ != null) {
            this.text_.setText(builder.value_);
        }
        if (!builder.editable_) {
            this.text_.setEditable(false);
        }
    }

    public Text ctrl() {
        return this.text_;
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static final class Builder
    extends ControlBuilder<Builder> {
        private String tooltip_;
        private String value_;
        private boolean editable_ = true;
        private boolean focus_;

        Builder(Composite composite) {
            super(composite, 2048, 4, 0x1000000, true, false);
        }

        public Builder tooltip(String tooltip) {
            this.tooltip_ = TextService.getInstance().get(tooltip);
            return this;
        }

        public Builder tooltip(String tooltip, String param) {
            this.tooltip_ = TextService.getInstance().get(tooltip, param);
            return this;
        }

        public Builder multi() {
            this.style_ |= 2;
            this.style_ |= 0x100;
            this.style_ |= 0x200;
            this.verticalAlignment_ = 4;
            this.grabExcessVerticalSpace_ = true;
            return this;
        }

        public Builder readOnly() {
            this.style_ |= 8;
            return this;
        }

        public Builder wrap() {
            this.style_ &= 0xFFFFFEFF;
            this.style_ |= 0x40;
            return this;
        }

        public Builder nonEditable() {
            this.editable_ = false;
            return this;
        }

        public Builder val(String value) {
            this.value_ = value;
            return this;
        }

        public Builder focus() {
            this.focus_ = true;
            return this;
        }

        public Text_ build() {
            return new Text_(this);
        }

        public Text ctrl() {
            return this.build().ctrl();
        }
    }
}

