/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Table_;
import org.dbgl.model.entity.LogEntry;
import org.dbgl.model.repository.LoggingRepository;
import org.dbgl.service.ImageService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class LogDialog
extends SizeControlledButtonDialog<Object> {
    private List<LogEntry> logEntries;
    private String orderByClause_;
    private LogEntry clickedEntry;
    private Integer clickedColumn;

    public LogDialog(Shell parent) {
        super(parent, "log");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.log.title");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new FillLayout());
        final Table table = Table_.on(this.contents_).header().ctrl();
        final LinkedHashMap<String, String> filterClauses = new LinkedHashMap<String, String>();
        this.orderByClause_ = " ORDER BY ID";
        String[] titles = new String[]{this.text_.get("dialog.log.columns.time"), this.text_.get("dialog.log.columns.event"), this.text_.get("dialog.log.columns.entitytype"), this.text_.get("dialog.log.columns.entitytitle"), this.text_.get("dialog.log.columns.entityid")};
        for (int i = 0; i < titles.length; ++i) {
            int columnId = i;
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.addListener(13, e -> {
                TableColumn sortColumn = (TableColumn)e.widget;
                int sortDirection = 128;
                if (sortColumn == table.getSortColumn() && table.getSortDirection() == 128) {
                    sortDirection = 1024;
                }
                String direction = sortDirection == 1024 ? " DESC" : "";
                switch (columnId) {
                    case 0: {
                        this.orderByClause_ = " ORDER BY ID" + direction;
                        break;
                    }
                    case 1: {
                        this.orderByClause_ = " ORDER BY EVENT" + direction;
                        break;
                    }
                    case 2: {
                        this.orderByClause_ = " ORDER BY ENTITY_TYPE" + direction;
                        break;
                    }
                    case 3: {
                        this.orderByClause_ = " ORDER BY ENTITY_TITLE" + direction;
                        break;
                    }
                    case 4: {
                        this.orderByClause_ = " ORDER BY ENTITY_ID" + direction;
                        break;
                    }
                }
                this.repopulateEntries(table, sortColumn, sortDirection, filterClauses);
            });
        }
        Menu menu = new Menu((Decorations)this.shell_, 8);
        menu.addListener(22, event -> {
            MenuItem[] menuItems = menu.getItems();
            for (MenuItem menuItem : menuItems) {
                menuItem.dispose();
            }
            if (this.clickedEntry != null && this.clickedColumn != null) {
                MenuItem mi = new MenuItem(menu, 8);
                switch (this.clickedColumn) {
                    case 0: {
                        mi.setText(titles[this.clickedColumn] + ": " + this.text_.toString(this.clickedEntry.getTime()));
                        break;
                    }
                    case 1: {
                        mi.setText(titles[this.clickedColumn] + ": " + this.getEventName(this.clickedEntry.getEvent()));
                        break;
                    }
                    case 2: {
                        mi.setText(titles[this.clickedColumn] + ": " + this.getEntityTypeName(this.clickedEntry.getEntityType()));
                        break;
                    }
                    case 3: {
                        mi.setText(titles[this.clickedColumn] + ": " + this.clickedEntry.getEntityTitle());
                        break;
                    }
                    case 4: {
                        mi.setText(titles[this.clickedColumn] + ": " + this.clickedEntry.getEntityId());
                        break;
                    }
                }
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evnt) {
                        MenuItem item = (MenuItem)evnt.widget;
                        switch (LogDialog.this.clickedColumn) {
                            case 0: {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(LogDialog.this.clickedEntry.getTime());
                                filterClauses.put("YEAR(TIME)=" + cal.get(1) + " AND MONTH(TIME)=" + (cal.get(2) + 1) + " AND DAY(TIME)=" + cal.get(5), item.getText());
                                break;
                            }
                            case 1: {
                                filterClauses.put("EVENT=" + LogDialog.this.clickedEntry.getEvent().ordinal(), item.getText());
                                break;
                            }
                            case 2: {
                                filterClauses.put("ENTITY_TYPE=" + LogDialog.this.clickedEntry.getEntityType().ordinal(), item.getText());
                                break;
                            }
                            case 3: {
                                filterClauses.put("ENTITY_TITLE='" + LogDialog.this.clickedEntry.getEntityTitle() + "'", item.getText());
                                break;
                            }
                            case 4: {
                                filterClauses.put("ENTITY_ID=" + LogDialog.this.clickedEntry.getEntityId(), item.getText());
                                break;
                            }
                        }
                        LogDialog.this.repopulateEntries(table, table.getSortColumn(), table.getSortDirection(), filterClauses);
                    }
                });
                if (!filterClauses.isEmpty()) {
                    MenuItem menuItem = new MenuItem(menu, 2);
                }
            }
            for (final Map.Entry entry : filterClauses.entrySet()) {
                MenuItem ci = new MenuItem(menu, 8);
                ci.setText((String)entry.getValue());
                ci.setImage(ImageService.getResourceImage(this.display_, "delete.png"));
                ci.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evnt) {
                        filterClauses.remove(entry.getKey());
                        LogDialog.this.repopulateEntries(table, table.getSortColumn(), table.getSortDirection(), filterClauses);
                    }
                });
            }
        });
        table.setMenu(menu);
        table.addListener(3, event -> {
            this.clickedEntry = null;
            this.clickedColumn = null;
            Point pt = new Point(event.x, event.y);
            TableItem item = table.getItem(pt);
            if (item == null) {
                return;
            }
            for (int i = 0; i < titles.length; ++i) {
                if (!item.getBounds(i).contains(pt)) continue;
                this.clickedEntry = this.logEntries.get(table.indexOf(item));
                this.clickedColumn = i;
                break;
            }
        });
        this.repopulateEntries(table, table.getColumn(0), 128, filterClauses);
        for (int i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        this.createOkButton((SelectionListener)this.closeShellAdapter);
        Button enableButton = Button_.on(this.otherButtons_).toggle().key(this.settings_.getBooleanValue("log", "enabled") ? "dialog.log.enabled" : "dialog.log.disabled").select(this.settings_.getBooleanValue("log", "enabled")).listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                LogDialog.this.settings_.setBooleanValue("log", "enabled", button.getSelection());
                button.setText(LogDialog.this.text_.get(button.getSelection() ? "dialog.log.enabled" : "dialog.log.disabled"));
            }
        }).ctrl();
        Button clearButton = Button_.on(this.otherButtons_).text().key("button.clear").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Mess_.on(LogDialog.this.shell_).key("dialog.log.confirm.clear").confirm()) {
                    try {
                        new LoggingRepository().clear();
                        table.removeAll();
                    }
                    catch (SQLException e) {
                        Mess_.on(LogDialog.this.shell_).exception(e).warning();
                    }
                }
            }
        }).ctrl();
        LogDialog.setLayoutDataButtons(this.okButton_, enableButton, clearButton);
    }

    private void repopulateEntries(Table table, TableColumn sortColumn, int sortDirection, Map<String, String> filterClauses) {
        int selLogEntryId = table.getSelectionIndex() == -1 ? -1 : this.logEntries.get(table.getSelectionIndex()).getId();
        try {
            String whereClause = filterClauses.isEmpty() ? "" : " WHERE " + StringUtils.join(filterClauses.keySet(), (String)" AND ");
            this.logEntries = new LoggingRepository().list(whereClause, this.orderByClause_);
        }
        catch (SQLException e) {
            Mess_.on(this.shell_).exception(e).warning();
            this.logEntries = new ArrayList<LogEntry>();
        }
        table.removeAll();
        table.setSortColumn(sortColumn);
        table.setSortDirection(sortDirection);
        table.setItemCount(this.logEntries.size());
        int idx = this.logEntries.size() - 1;
        for (int i = 0; i < this.logEntries.size(); ++i) {
            LogEntry entry = this.logEntries.get(i);
            TableItem item = table.getItem(i);
            item.setText(0, this.text_.toString(entry.getTime(), 2));
            item.setText(1, this.getEventName(entry.getEvent()));
            item.setText(2, this.getEntityTypeName(entry.getEntityType()));
            item.setText(3, entry.getEntityTitle());
            item.setText(4, String.valueOf(entry.getEntityId()));
            if (selLogEntryId != this.logEntries.get(i).getId()) continue;
            idx = i;
        }
        table.setSelection(idx);
        table.showSelection();
    }

    private String getEventName(LogEntry.Event event) {
        switch (event) {
            case ADD: {
                return this.text_.get("dialog.log.columns.event.add");
            }
            case EDIT: {
                return this.text_.get("dialog.log.columns.event.edit");
            }
            case REMOVE: {
                return this.text_.get("dialog.log.columns.event.remove");
            }
            case DUPLICATE: {
                return this.text_.get("dialog.log.columns.event.duplicate");
            }
            case RUN: {
                return this.text_.get("dialog.log.columns.event.run");
            }
            case SETUP: {
                return this.text_.get("dialog.log.columns.event.setup");
            }
        }
        return "";
    }

    private String getEntityTypeName(LogEntry.EntityType type) {
        switch (type) {
            case PROFILE: {
                return this.text_.get("dialog.log.columns.entitytype.profile");
            }
            case DOSBOXVERSION: {
                return this.text_.get("dialog.template.dosboxversion");
            }
            case TEMPLATE: {
                return this.text_.get("dialog.profile.template");
            }
            case FILTER: {
                return this.text_.get("dialog.log.columns.entitytype.filter");
            }
        }
        return "";
    }
}

