/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.conf.dfend.DFendReloadedConfiguration;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.util.FilesUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class DFendReloadedImportThread
extends UIThread<File> {
    private final boolean performCleanup_;
    private final DosboxVersion defaultDBVersion_;
    private final File dfendPath_;
    private final DFendReloadedConfiguration profiles_;

    public DFendReloadedImportThread(Text log, ProgressBar progressBar, Label status, File dfendPath, File confsPath, boolean performCleanup, DosboxVersion defaultDBVersion) throws IOException {
        super(log, progressBar, status, false);
        this.performCleanup_ = performCleanup;
        this.defaultDBVersion_ = defaultDBVersion;
        File settingsFile = new File(new File(dfendPath, "Settings"), "DFend.ini");
        this.profiles_ = new DFendReloadedConfiguration(settingsFile);
        this.messageLog_.append(this.profiles_.loadDat(new File(dfendPath, "Confs"), confsPath));
        this.setObjects(this.profiles_.getConfFiles());
        String defLoc = this.profiles_.getValue("ProgramSets", "defloc");
        this.dfendPath_ = StringUtils.isNotBlank((CharSequence)defLoc) ? new File(defLoc) : dfendPath;
    }

    @Override
    public String work(File profFile) throws IOException, SQLException {
        File srcCaptures;
        StringBuilder warnings = new StringBuilder();
        warnings.append(this.profiles_.loadProfile(profFile));
        String title = this.profiles_.getValue(profFile, "ExtraInfo", "name");
        this.displayTitle(text_.get("dialog.dfendimport.importing", new Object[]{title}));
        String developer = this.profiles_.getValue(profFile, "ExtraInfo", "developer");
        String publisher = this.profiles_.getValue(profFile, "ExtraInfo", "publisher");
        String genre = this.profiles_.getValue(profFile, "ExtraInfo", "genre");
        String year = this.profiles_.getValue(profFile, "ExtraInfo", "year");
        String status = text_.get("dialog.dfendimport.defaultprofilestatus");
        String notes = DFendReloadedImportThread.fixCrLf(this.profiles_.getValue(profFile, "ExtraInfo", "notes"));
        boolean favorite = this.profiles_.getValue(profFile, "ExtraInfo", "favorite").equals("1");
        String[] links = new String[]{DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www2")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www3")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www4")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www5")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www6")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www7")), DFendReloadedImportThread.fixUrl(this.profiles_.getValue(profFile, "ExtraInfo", "www8"))};
        String[] linkTitles = new String[]{this.profiles_.getValue(profFile, "ExtraInfo", "wwwname"), this.profiles_.getValue(profFile, "ExtraInfo", "www2name"), this.profiles_.getValue(profFile, "ExtraInfo", "www3name"), this.profiles_.getValue(profFile, "ExtraInfo", "www4name"), this.profiles_.getValue(profFile, "ExtraInfo", "www5name"), this.profiles_.getValue(profFile, "ExtraInfo", "www6name"), this.profiles_.getValue(profFile, "ExtraInfo", "www7name"), this.profiles_.getValue(profFile, "ExtraInfo", "www8name")};
        String language = this.profiles_.getValue(profFile, "ExtraInfo", "language");
        String userInfo = this.profiles_.getValue(profFile, "ExtraInfo", "userinfo");
        if (StringUtils.isNotEmpty((CharSequence)userInfo)) {
            userInfo = StringUtils.join((Object[])StringUtils.split((String)DFendReloadedImportThread.fixCrLf(userInfo), (String)"\n"), (String)", ");
        }
        String[] customStrings = new String[]{language, "", "", "", userInfo, "", "", "", "", "", "", ""};
        String setup = this.profiles_.getValue(profFile, "Extra", "setup");
        if (StringUtils.isNotEmpty((CharSequence)setup)) {
            setup = FilesUtils.concat(this.dfendPath_, setup);
        }
        String setupParams = this.profiles_.getValue(profFile, "Extra", "setupparameters");
        Profile newProfile = ProfileFactory.create(title, developer, publisher, genre, year, status, notes, favorite, links, linkTitles, customStrings, setup, setupParams);
        warnings.append(newProfile.loadConfigurationData(text_, this.profiles_.getConf(profFile), this.profiles_.getConfFile(profFile)));
        GenerationAwareConfiguration.Generation srcGeneration = newProfile.getConfiguration().getGeneration();
        if (srcGeneration == null) {
            srcGeneration = GenerationAwareConfiguration.Generation.GEN_073;
        }
        if (this.performCleanup_) {
            newProfile.getConfiguration().removeSection("joystick");
            newProfile.getConfiguration().removeSection("sdl");
        }
        newProfile.alterToDosboxVersionGeneration(srcGeneration, this.defaultDBVersion_);
        newProfile = new ProfileRepository().add(newProfile);
        String captures = this.profiles_.getValue(profFile, "dosbox", "captures");
        File file = srcCaptures = StringUtils.isBlank((CharSequence)captures) ? null : new File(this.dfendPath_, captures);
        if (FilesUtils.isExistingDirectory(srcCaptures)) {
            FileUtils.copyDirectory(srcCaptures, newProfile.getCanonicalCaptures(), FileFileFilter.FILE);
        }
        if (newProfile.isIncomplete()) {
            warnings.append(text_.get("general.error.profileincomplete", new String[]{newProfile.getConfigurationCanonicalFile().getPath()}));
        }
        return warnings.toString();
    }

    private static String fixCrLf(String s) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)"[13][10]", (String)"\n"), (String)"[13]", (String)"").trim();
    }

    private static String fixUrl(String s) {
        return StringUtils.isNotEmpty((CharSequence)s) && !s.toLowerCase().startsWith("http://") && !s.toLowerCase().startsWith("https://") ? "http://" + s : s;
    }

    @Override
    public String getTitle(File file) {
        return file.getName();
    }
}

