/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.SectionsCollection;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.service.ITextService;
import org.dbgl.util.SystemUtils;

public class Configuration
extends Settings {
    private static final String AUTOEXEC_SECTION_NAME = "autoexec";
    private static final String[] CUSTOM_SECTION = new String[]{"#REM DBGL-CUSTOM", "#REM /DBGL-CUSTOM"};
    private String customSection_ = "";
    private Autoexec autoexec_ = new Autoexec();

    public Configuration() {
    }

    public Configuration(Configuration configuration) {
        this();
        this.sections_ = new SectionsCollection(configuration.getSections());
        this.customSection_ = configuration.getCustomSection();
        this.autoexec_ = new Autoexec(configuration.getAutoexec());
    }

    public String getCustomSection() {
        return this.customSection_;
    }

    public void setCustomSection(String customSection) {
        this.customSection_ = customSection;
    }

    public Autoexec getAutoexec() {
        return this.autoexec_;
    }

    public void setAutoexec(Autoexec autoexec) {
        this.autoexec_ = autoexec;
    }

    public String reloadWithAutoexec(ITextService text, List<Mount> dbMounts) throws IOException {
        return this.reloadWithAutoexec(text, dbMounts, null);
    }

    public String reloadWithAutoexec(ITextService text, List<Mount> dbMounts, File cwd) throws IOException {
        this.sections_ = new SectionsCollection();
        this.customSection_ = "";
        this.autoexec_ = new Autoexec();
        return this.loadWithAutoexec(text, dbMounts, cwd);
    }

    public String loadWithAutoexec(ITextService text, List<Mount> dbMounts, File cwd) throws IOException {
        File file = this.fileLocation_.getCanonicalFile();
        if (file == null || !file.isFile() || !file.canRead()) {
            throw new IOException(text.get("general.error.openfile", new Object[]{String.valueOf(file)}));
        }
        try (FileReader reader = new FileReader(file);){
            String string = this.loadDataWithAutoexec(text, reader, file, dbMounts, cwd);
            return string;
        }
    }

    public String loadDataWithAutoexec(ITextService text, String data, File file, List<Mount> dbMounts) throws IOException {
        return this.loadDataWithAutoexec(text, data, file, dbMounts, null);
    }

    public String loadDataWithAutoexec(ITextService text, String data, File file, List<Mount> dbMounts, File cwd) throws IOException {
        try (StringReader reader = new StringReader(data);){
            String string = this.loadDataWithAutoexec(text, reader, file, dbMounts, cwd);
            return string;
        }
    }

    private String loadDataWithAutoexec(ITextService text, Reader reader, File file, List<Mount> dbMounts, File cwd) throws IOException {
        StringBuilder warningsLog = new StringBuilder();
        ArrayList<String> autoexecLines = new ArrayList<String>();
        ArrayList<String> customLines = new ArrayList<String>();
        warningsLog.append(this.loadData(text, reader, file, AUTOEXEC_SECTION_NAME, autoexecLines, CUSTOM_SECTION, customLines));
        if (!autoexecLines.isEmpty()) {
            warningsLog.append(this.autoexec_.load(autoexecLines, dbMounts, cwd));
        }
        if (!customLines.isEmpty()) {
            this.customSection_ = StringUtils.join(customLines, (String)SystemUtils.EOLN);
        }
        return warningsLog.toString();
    }

    public void load(Configuration conf) {
        this.sections_.load(conf.getSections());
    }

    public void save(boolean prepareOnly, List<Mount> combinedMountingPoints) throws IOException {
        File file = this.fileLocation_.getCanonicalFile();
        FileUtils.forceMkdirParent(file);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.writeData(writer, prepareOnly, combinedMountingPoints);
        }
    }

    private void writeData(BufferedWriter writer, boolean prepareOnly, List<Mount> combinedMountingPoints) throws IOException {
        writer.write(this.sections_.toString());
        if (StringUtils.isNotBlank((CharSequence)this.customSection_)) {
            StringBuilder result = new StringBuilder();
            result.append(CUSTOM_SECTION[0]).append(SystemUtils.EOLN);
            result.append(this.customSection_).append(SystemUtils.EOLN);
            result.append(CUSTOM_SECTION[1]).append(SystemUtils.EOLN).append(SystemUtils.EOLN);
            writer.write(result.toString());
        }
        writer.write(this.autoexec_.toString(prepareOnly, combinedMountingPoints));
    }

    public void removeUnequalValuesIn(Configuration configuration) {
        super.removeUnequalValuesIn(configuration);
        if (!StringUtils.equals((CharSequence)this.customSection_, (CharSequence)configuration.getCustomSection())) {
            this.customSection_ = null;
        }
        this.autoexec_.removeUnequalValuesIn(configuration.autoexec_);
    }

    public void removeUnnecessaryMounts(Configuration configuration) {
        this.autoexec_.removeUnnecessaryMounts(configuration.autoexec_);
    }

    public String toString(List<Mount> combinedMountingPoints) {
        StringWriter result = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(result);){
            this.writeData(writer, false, combinedMountingPoints);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }
}

