/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.factory;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.GenericStats;
import org.dbgl.model.Link;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.ProfileStats;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.entity.Configurable;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.TextService;

public class ProfileFactory {
    private ProfileFactory() {
    }

    public static Profile create(DosboxVersion dosboxVersion, Template template) {
        Object[] customStrings = new String[12];
        Arrays.fill(customStrings, "");
        Object[] links = new Link[8];
        Arrays.fill(links, new Link("", ""));
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        Profile profile = ProfileFactory.create("", false, "", "", "", "", "", "", (String[])customStrings, new int[]{0, 0}, (Link[])links, null, null, "", new String[]{"", ""}, new String[]{"", ""}, nativeCommands, dosboxVersion);
        GenerationAwareConfiguration config = profile.getConfiguration();
        if (template != null) {
            config.setSections(template.getConfiguration().getSections());
            config.getAutoexec().setExit(template.getConfiguration().getAutoexec().isExit());
            config.getAutoexec().setCustomSections(template.getConfiguration().getAutoexec().getCustomSections());
            config.getAutoexec().setBooterByDefault(template.getConfiguration().getAutoexec().isBooter());
            config.getAutoexec().setMountingpoints(template.getConfiguration().getAutoexec().getMountingpoints());
            profile.setNativeCommands(template.getNativeCommands());
        } else {
            config.getAutoexec().setExit(true);
        }
        return profile;
    }

    public static Profile create(int id, String title, boolean favorite, String developer, String publisher, String genre, String year, String status, String notes, String[] customStrings, int[] customInts, String[] links, String captures, String setup, String setupParams, String altExe1, String altExe1Params, String altExe2, String altExe2Params, List<NativeCommand> nativeCommands, int dosboxVersionId, String configuration, Timestamp created, Timestamp modified, Timestamp lastRun, Timestamp lastSetup, int runs, int setups, List<DosboxVersion> dosboxVersions) {
        Link[] link = new Link[8];
        for (int i = 0; i < 8; ++i) {
            link[i] = new Link(links[i * 2], links[i * 2 + 1]);
        }
        Profile profile = ProfileFactory.create(title, favorite, developer, publisher, genre, year, status, notes, customStrings, customInts, link, captures, setup, setupParams, new String[]{altExe1, altExe2}, new String[]{altExe1Params, altExe2Params}, nativeCommands, BaseRepository.findById(dosboxVersions, dosboxVersionId));
        profile.setId(id);
        profile.setConfigurationFileLocation(configuration);
        profile.setStats(new GenericStats(created, modified, lastRun, runs));
        profile.setProfileStats(new ProfileStats(lastSetup, setups));
        return profile;
    }

    public static Profile createCopy(Profile prof) {
        return ProfileFactory.create(prof.getTitle(), prof.isFavorite(), prof.getDeveloper(), prof.getPublisher(), prof.getGenre(), prof.getYear(), prof.getStatus(), prof.getNotes(), (String[])prof.getCustomStrings().clone(), (int[])prof.getCustomInts().clone(), (Link[])prof.getLinks().clone(), prof.getCapturesString(), prof.getSetupString(), prof.getSetupParams(), (String[])prof.getAltExeStrings().clone(), (String[])prof.getAltExeParams().clone(), new ArrayList<NativeCommand>(prof.getNativeCommands()), prof.getDosboxVersion());
    }

    public static Profile create(String title, String developer, String publisher, String genre, String year, String status, String notes, boolean favorite, String setup, String setupParams) {
        Object[] customStrings = new String[12];
        Arrays.fill(customStrings, "");
        Object[] links = new Link[8];
        Arrays.fill(links, new Link("", ""));
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        return ProfileFactory.create(title, favorite, developer, publisher, genre, year, status, notes, (String[])customStrings, new int[]{0, 0}, (Link[])links, null, setup, setupParams, new String[]{"", ""}, new String[]{"", ""}, nativeCommands, null);
    }

    public static Profile create(String title, String developer, String publisher, String genre, String year, String status, String notes, boolean favorite, String[] links, String[] linkTitles, String[] customStrings, String setup, String setupParams) {
        Link[] link = new Link[8];
        for (int i = 0; i < 8; ++i) {
            link[i] = new Link(linkTitles[i], links[i]);
        }
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        return ProfileFactory.create(title, favorite, developer, publisher, genre, year, status, notes, customStrings, new int[]{0, 0}, link, null, setup, setupParams, new String[]{"", ""}, new String[]{"", ""}, nativeCommands, null);
    }

    public static Profile create(String title, String developer, String publisher, String genre, String year, String status, String notes, boolean favorite, String[] links, String[] linkTitles, String rating, DosboxVersion dbVersion, String configuration) {
        Object[] customStrings = new String[12];
        Arrays.fill(customStrings, "");
        Link[] link = new Link[8];
        for (int i = 0; i < 8; ++i) {
            link[i] = new Link(linkTitles[i], links[i]);
        }
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        int[] customInts = new int[]{0, 0};
        if (StringUtils.isNotBlank((CharSequence)rating)) {
            customInts[0] = (int)(Double.parseDouble(rating) * 20.0);
        }
        Profile profile = ProfileFactory.create(title, favorite, developer, publisher, genre, year, status, notes, (String[])customStrings, customInts, link, null, "", "", new String[]{"", ""}, new String[]{"", ""}, nativeCommands, dbVersion);
        profile.getConfiguration().setFileLocation(new FileLocation(configuration));
        return profile;
    }

    public static Profile create(String title, boolean favorite, String developer, String publisher, String genre, String year, String status, String notes, String[] customStrings, int[] customInts, String[] links, String[] linkTitles, String setup, String setupParams, String[] altExe, String[] altExeParams, List<NativeCommand> nativeCommands, DosboxVersion dbVersion, String configuration) {
        Link[] link = new Link[8];
        for (int i = 0; i < 8; ++i) {
            link[i] = new Link(linkTitles[i], links[i]);
        }
        Profile profile = ProfileFactory.create(title, favorite, developer, publisher, genre, year, status, notes, customStrings, customInts, link, "", setup, setupParams, altExe, altExeParams, nativeCommands, dbVersion);
        profile.setConfigurationFileLocation(configuration);
        return profile;
    }

    public static Profile create(File configuration, DosboxVersion dosboxVersion) {
        Object[] customStrings = new String[12];
        Arrays.fill(customStrings, "");
        Object[] links = new Link[8];
        Arrays.fill(links, new Link("", ""));
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        Profile profile = ProfileFactory.create("", false, "", "", "", "", "", "", (String[])customStrings, new int[]{0, 0}, (Link[])links, null, "", "", new String[]{"", ""}, new String[]{"", ""}, nativeCommands, dosboxVersion);
        profile.setConfigurationFileLocation(configuration.getPath());
        return profile;
    }

    public static Profile combine(List<DosboxVersion> allVersions, List<Profile> profiles, StringBuilder warningsLog) throws IOException {
        List<DosboxVersion> dbversions = profiles.stream().map(TemplateProfileBase::getDosboxVersion).collect(Collectors.toList());
        DosboxVersion dbv = DosboxVersionRepository.findBestMatch(dbversions, BaseRepository.findDefault(allVersions));
        Configurable profile = null;
        Settings configuration = null;
        for (Profile prof : profiles) {
            Profile currentProfile = ProfileFactory.createCopy(prof);
            warningsLog.append(currentProfile.loadConfigurationData(TextService.getInstance(), prof.getConfigurationString(), prof.getConfigurationCanonicalFile()));
            if (currentProfile.getDosboxVersion().getId() != dbv.getId()) {
                currentProfile.setToDosboxVersion(dbv);
            }
            if (profile == null) {
                profile = currentProfile;
                configuration = currentProfile.getCombinedConfiguration();
                continue;
            }
            ((Profile)profile).removeUnequalValuesIn(currentProfile);
            if (configuration == null) continue;
            ((Configuration)configuration).removeUnequalValuesIn(currentProfile.getCombinedConfiguration());
        }
        if (profile != null && configuration != null) {
            profile.getConfiguration().setSections(configuration.getSections());
            profile.getConfiguration().setCustomSection(((Configuration)configuration).getCustomSection());
            profile.getConfiguration().setAutoexec(((Configuration)configuration).getAutoexec());
        }
        return profile;
    }

    private static Profile create(String title, boolean favorite, String developer, String publisher, String genre, String year, String status, String notes, String[] customStrings, int[] customInts, Link[] links, String captures, String setup, String setupParams, String[] altExe, String[] altExeParams, List<NativeCommand> nativeCommands, DosboxVersion dosboxVersion) {
        Profile profile = new Profile();
        profile.setTitle(title);
        profile.setFavorite(favorite);
        profile.setDeveloper(developer);
        profile.setPublisher(publisher);
        profile.setGenre(genre);
        profile.setYear(year);
        profile.setStatus(status);
        profile.setNotes(notes);
        profile.setCustomStrings(customStrings);
        profile.setCustomInts(customInts);
        profile.setLinks(links);
        profile.setCapturesFileLocation(captures);
        profile.setSetupFileLocation(setup);
        profile.setSetupParams(setupParams);
        profile.setAltExeFileLocations(altExe);
        profile.setAltExeParams(altExeParams);
        profile.setNativeCommands(nativeCommands);
        profile.setDosboxVersion(dosboxVersion);
        profile.setConfiguration(new GenerationAwareConfiguration());
        profile.setStats(new GenericStats());
        profile.setProfileStats(new ProfileStats());
        return profile;
    }
}

