/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return 0;
        }
        long hwnd = this.parent.handle;
        return (int)OS.SendMessage(hwnd, 4125, (long)index, 0L);
    }

    public void pack() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        long hwnd = this.parent.handle;
        int oldWidth = (int)OS.SendMessage(hwnd, 4125, (long)index, 0L);
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.text, true);
        int headerWidth = (int)OS.SendMessage(hwnd, 4183, 0L, buffer) + 12;
        if (OS.IsAppThemed()) {
            headerWidth += 3;
        }
        boolean hasHeaderImage = false;
        if (this.image != null || this.parent.sortColumn == this) {
            hasHeaderImage = true;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                headerWidth += 10;
            } else if (this.image != null) {
                Rectangle bounds = this.image.getBoundsInPixels();
                headerWidth += bounds.width;
            }
            long hwndHeader = OS.SendMessage(hwnd, 4127, 0L, 0L);
            int margin = (int)OS.SendMessage(hwndHeader, 4629, 0L, 0L);
            headerWidth += margin * 4;
        }
        this.parent.ignoreColumnResize = true;
        int columnWidth = 0;
        if (this.parent.hooks(41)) {
            RECT headerRect = new RECT();
            long hwndHeader = OS.SendMessage(hwnd, 4127, 0L, 0L);
            OS.SendMessage(hwndHeader, 4615, (long)index, headerRect);
            OS.MapWindowPoints(hwndHeader, hwnd, headerRect, 2);
            long hDC = OS.GetDC(hwnd);
            long oldFont = 0L;
            long newFont = OS.SendMessage(hwnd, 49, 0L, 0L);
            if (newFont != 0L) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            int count = (int)OS.SendMessage(hwnd, 4100, 0L, 0L);
            for (int i = 0; i < count; ++i) {
                TableItem item = this.parent._getItem(i, false);
                if (item == null) continue;
                long hFont = item.fontHandle(index);
                if (hFont != -1L) {
                    hFont = OS.SelectObject(hDC, hFont);
                }
                Event event = this.parent.sendMeasureItemEvent(item, i, index, hDC);
                if (hFont != -1L) {
                    hFont = OS.SelectObject(hDC, hFont);
                }
                if (this.isDisposed() || this.parent.isDisposed()) break;
                Rectangle bounds = event.getBoundsInPixels();
                columnWidth = Math.max(columnWidth, bounds.x + bounds.width - headerRect.left);
            }
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(hwnd, hDC);
            OS.SendMessage(hwnd, 4126, (long)index, columnWidth);
        } else {
            OS.SendMessage(hwnd, 4126, (long)index, -1L);
            columnWidth = (int)OS.SendMessage(hwnd, 4125, (long)index, 0L);
            if (index == 0) {
                long hStateList;
                if (this.parent.imageList == null) {
                    columnWidth += 2;
                }
                if ((this.parent.style & 0x20) != 0 && (hStateList = OS.SendMessage(hwnd, 4098, 2L, 0L)) != 0L) {
                    int[] cx = new int[1];
                    int[] cy = new int[1];
                    OS.ImageList_GetIconSize(hStateList, cx, cy);
                    columnWidth += cx[0];
                }
            }
        }
        if (headerWidth > columnWidth) {
            if (!hasHeaderImage) {
                boolean fixWidth;
                RECT rect = null;
                boolean bl = fixWidth = index == this.parent.getColumnCount() - 1;
                if (fixWidth) {
                    rect = new RECT();
                    OS.GetWindowRect(hwnd, rect);
                    OS.UpdateWindow(hwnd);
                    int flags = 30;
                    OS.SetWindowPos(hwnd, 0L, 0, 0, 0, rect.bottom - rect.top, flags);
                }
                OS.SendMessage(hwnd, 4126, (long)index, -2L);
                if (fixWidth) {
                    int flags = 22;
                    OS.SetWindowPos(hwnd, 0L, 0, 0, rect.right - rect.left, rect.bottom - rect.top, flags);
                }
            } else {
                OS.SendMessage(hwnd, 4126, (long)index, headerWidth);
            }
        } else if (index == 0) {
            OS.SendMessage(hwnd, 4126, (long)index, columnWidth);
        }
        this.parent.ignoreColumnResize = false;
        int newWidth = (int)OS.SendMessage(hwnd, 4125, (long)index, 0L);
        if (oldWidth != newWidth) {
            this.updateToolTip(index);
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            boolean moved = false;
            TableColumn[] columns = this.parent.getColumns();
            for (int columnindex : this.parent.getColumnOrder()) {
                TableColumn column = columns[columnindex];
                if (moved && !column.isDisposed()) {
                    column.updateToolTip(columnindex);
                    column.sendEvent(10);
                }
                if (column != this) continue;
                moved = true;
            }
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        long hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 1;
        OS.SendMessage(hwnd, 4191, (long)index, lvColumn);
        lvColumn.fmt &= 0xFFFFFFFC;
        int fmt = 0;
        if ((this.style & 0x4000) == 16384) {
            fmt = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            fmt = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            fmt = 1;
        }
        lvColumn.fmt |= fmt;
        OS.SendMessage(hwnd, 4192, (long)index, lvColumn);
        if (index != 0) {
            this.parent.forceResize();
            RECT rect = new RECT();
            RECT headerRect = new RECT();
            OS.GetClientRect(hwnd, rect);
            long hwndHeader = OS.SendMessage(hwnd, 4127, 0L, 0L);
            OS.SendMessage(hwndHeader, 4615, (long)index, headerRect);
            OS.MapWindowPoints(hwndHeader, hwnd, headerRect, 2);
            rect.left = headerRect.left;
            rect.right = headerRect.right;
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean sort, boolean right) {
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        long hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 17;
        OS.SendMessage(hwnd, 4191, (long)index, lvColumn);
        if (image != null) {
            lvColumn.fmt |= 0x800;
            lvColumn.iImage = this.parent.imageIndexHeader(image);
            if (right) {
                lvColumn.fmt |= 0x1000;
            }
        } else {
            lvColumn.mask &= 0xFFFFFFEF;
            lvColumn.fmt &= 0xFFFFE7FF;
        }
        OS.SendMessage(hwnd, 4192, (long)index, lvColumn);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    void setSortDirection(int direction) {
        RECT headerRect;
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        long hwnd = this.parent.handle;
        long hwndHeader = OS.SendMessage(hwnd, 4127, 0L, 0L);
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 36;
        OS.SendMessage(hwndHeader, 4619, (long)index, hdItem);
        switch (direction) {
            case 128: {
                hdItem.fmt &= 0xFFFFF5FF;
                hdItem.fmt |= 0x400;
                if (this.image != null) break;
                hdItem.mask &= 0xFFFFFFDF;
                break;
            }
            case 1024: {
                hdItem.fmt &= 0xFFFFF3FF;
                hdItem.fmt |= 0x200;
                if (this.image != null) break;
                hdItem.mask &= 0xFFFFFFDF;
                break;
            }
            case 0: {
                hdItem.fmt &= 0xFFFFF9FF;
                if (this.image != null) {
                    hdItem.fmt |= 0x800;
                    hdItem.iImage = this.parent.imageIndexHeader(this.image);
                    break;
                }
                hdItem.fmt &= 0xFFFFF7FF;
                hdItem.mask &= 0xFFFFFFDF;
            }
        }
        OS.SendMessage(hwndHeader, 4620, (long)index, hdItem);
        this.parent.forceResize();
        RECT rect = new RECT();
        OS.GetClientRect(hwnd, rect);
        if ((int)OS.SendMessage(hwnd, 4096, 0L, 0L) != -1) {
            int oldColumn = (int)OS.SendMessage(hwnd, 4270, 0L, 0L);
            int newColumn = direction == 0 ? -1 : index;
            OS.SendMessage(hwnd, 4236, (long)newColumn, 0L);
            RECT headerRect2 = new RECT();
            if (oldColumn != -1 && OS.SendMessage(hwndHeader, 4615, (long)oldColumn, headerRect2) != 0L) {
                OS.MapWindowPoints(hwndHeader, hwnd, headerRect2, 2);
                rect.left = headerRect2.left;
                rect.right = headerRect2.right;
                OS.InvalidateRect(hwnd, rect, true);
            }
        }
        if (OS.SendMessage(hwndHeader, 4615, (long)index, headerRect = new RECT()) != 0L) {
            OS.MapWindowPoints(hwndHeader, hwnd, headerRect, 2);
            rect.left = headerRect.left;
            rect.right = headerRect.right;
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setText(string);
        long hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 1;
        OS.SendMessage(hwnd, 4191, (long)index, lvColumn);
        long hHeap = OS.GetProcessHeap();
        char[] buffer = this.fixMnemonic(string);
        int byteCount = buffer.length * 2;
        long pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        lvColumn.mask |= 4;
        lvColumn.pszText = pszText;
        long result = OS.SendMessage(hwnd, 4192, (long)index, lvColumn);
        if (pszText != 0L) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (result == 0L) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        long hwndHeaderToolTip = this.parent.headerToolTipHandle;
        if (hwndHeaderToolTip == 0L) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(width));
    }

    void setWidthInPixels(int width) {
        if (width < 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        long hwnd = this.parent.handle;
        if (width != (int)OS.SendMessage(hwnd, 4125, (long)index, 0L)) {
            OS.SendMessage(hwnd, 4126, (long)index, width);
        }
    }

    void updateToolTip(int index) {
        RECT rect;
        long hwnd;
        long hwndHeader;
        long hwndHeaderToolTip = this.parent.headerToolTipHandle;
        if (hwndHeaderToolTip != 0L && OS.SendMessage(hwndHeader = OS.SendMessage(hwnd = this.parent.handle, 4127, 0L, 0L), 4615, (long)index, rect = new RECT()) != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.hwnd = hwndHeader;
            lpti.uId = this.id;
            lpti.left = rect.left;
            lpti.top = rect.top;
            lpti.right = rect.right;
            lpti.bottom = rect.bottom;
            OS.SendMessage(hwndHeaderToolTip, 1076, 0L, lpti);
        }
    }
}

