/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import org.dbgl.gui.abstractdialog.WizardDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.ProgressBar_;
import org.dbgl.gui.thread.UIThread;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class JobWizardDialog<T>
extends WizardDialog<T> {
    protected ProgressBar progressBar_;
    protected Label status_;
    protected Text log_;
    protected UIThread<?> job_;

    protected JobWizardDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    @Override
    protected void shellDispatchCallback() {
        if (this.hasJobFinished() && !this.nextButton_.getEnabled()) {
            this.goForward();
        }
    }

    @Override
    protected void activateCurrentStep() {
        super.activateCurrentStep();
        if (this.job_ != null) {
            this.backButton_.setEnabled(false);
            this.nextButton_.setEnabled(this.hasJobFinished());
            this.cancelButton_.setEnabled(false);
            if (this.job_.getState() == Thread.State.NEW) {
                this.job_.start();
            }
        }
    }

    @Override
    protected int totalSteps() {
        return super.totalSteps() + 2;
    }

    private boolean hasJobFinished() {
        return this.job_ != null && this.job_.getState() == Thread.State.TERMINATED;
    }

    protected void addFinalStep(String groupTitle, String statusText) {
        Group progressGroup = Group_.on(this.shell_).layout(new GridLayout()).key(groupTitle).build();
        this.progressBar_ = ProgressBar_.on(progressGroup).build();
        Chain chain = Chain.on(progressGroup).lbl(l -> l.key(statusText)).txt(t -> t.multi().readOnly()).build();
        this.status_ = chain.getLabel();
        this.log_ = chain.getText();
        this.addStep(progressGroup);
    }
}

