/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GalleryItemRenderer
extends AbstractGalleryItemRenderer {
    private static final int LINE_WIDTH = 2;
    private static final int SELECTION_RADIUS = 8;
    private static final String ELLIPSIS = "...";
    private static final Color foregroundColor_ = Display.getDefault().getSystemColor(24);
    private static final Color backgroundColor_ = Display.getDefault().getSystemColor(25);
    private static final Color selectionForegroundColor_ = Display.getDefault().getSystemColor(27);
    private static final Color selectionBackgroundColor_ = Display.getDefault().getSystemColor(26);
    private final String truncPosition_;

    public GalleryItemRenderer(String truncPosition) {
        this.truncPosition_ = truncPosition;
    }

    @Override
    public void draw(GC gc, GalleryItem item, int index, int x, int y, int width, int height) {
        Image drawImage;
        gc.setFont(this.getFont(item));
        int fontHeight = gc.getFontMetrics().getHeight();
        boolean drawBackground = this.selected;
        Color drawBackgroundColor = null;
        if (!drawBackground && item.getBackground(true) != null && !RendererHelper.isColorsEquals(drawBackgroundColor = this.getBackground(item), backgroundColor_)) {
            drawBackground = true;
        }
        if (drawBackground) {
            if (this.selected) {
                gc.setBackground(selectionBackgroundColor_);
                gc.setForeground(selectionBackgroundColor_);
            } else if (drawBackgroundColor != null) {
                gc.setBackground(drawBackgroundColor);
            }
            gc.setLineStyle(3);
            gc.setLineWidth(2);
            gc.drawRoundRectangle(x + 1, y + 1, width - 2, height - 2, 8, 8);
            gc.fillRoundRectangle(x + 1, y + height - fontHeight - 1 - 1, width - 2, fontHeight + 1, 8, 8);
        }
        if ((drawImage = item.getImage()) != null) {
            Rectangle itemImageBounds = drawImage.getBounds();
            int xShift = RendererHelper.getShift(width - 4, itemImageBounds.width);
            gc.drawImage(drawImage, x + 2 + xShift, y + 2);
            this.drawAllOverlays(gc, item, x, y, new Point(itemImageBounds.width, itemImageBounds.height), xShift, 2);
        }
        if (this.selected) {
            gc.setForeground(selectionForegroundColor_);
            gc.setBackground(selectionBackgroundColor_);
        } else {
            gc.setBackground(drawBackgroundColor != null ? drawBackgroundColor : backgroundColor_);
            Color drawForegroundColor = this.getForeground(item);
            gc.setForeground(drawForegroundColor != null ? drawForegroundColor : foregroundColor_);
        }
        String text = this.truncPosition_.equalsIgnoreCase("end") ? GalleryItemRenderer.createLabelTruncAtEnd(item.getText(), gc, width - 8) : RendererHelper.createLabel(item.getText(), gc, width - 8);
        gc.drawText(text, x + RendererHelper.getShift(width, gc.textExtent((String)text).x), y + height - fontHeight, true);
    }

    @Override
    public void dispose() {
    }

    private static String createLabelTruncAtEnd(String text, GC gc, int width) {
        int w;
        int extent;
        if (text != null && (extent = gc.textExtent((String)text).x) > width && width > (w = gc.textExtent((String)ELLIPSIS).x)) {
            int l = text.length();
            while (extent > width) {
                extent = gc.textExtent((String)text.substring((int)0, (int)(--l))).x + w;
            }
            return text.substring(0, l) + ELLIPSIS;
        }
        return text;
    }
}

