/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.constants.Constants;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.CTabFolder_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.GridData_;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Spinner_;
import org.dbgl.gui.controls.Table_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.searchengine.MetropolisSearchEngine;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.TheGamesDBSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SettingsDialog
extends SizeControlledTabbedDialog<Boolean> {
    private static final int EDITABLE_COLUMN = 0;
    private int lastOptionSelection = -1;
    private final String[] columnNames_;

    public SettingsDialog(Shell parent, String[] columnNames) {
        super(parent, "settingsdialog");
        this.columnNames_ = columnNames;
        this.result_ = false;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.settings.title");
    }

    @Override
    protected void onShellCreated() {
        Composite generalComposite = this.createTabWithComposite("dialog.settings.tab.general", new GridLayout());
        final SortedMap<String, Locale> locales = SettingsDialog.getLocales();
        Locale locale = new Locale(this.settings_.getValue("locale", "language"), this.settings_.getValue("locale", "country"), this.settings_.getValue("locale", "variant"));
        String locString = locales.keySet().stream().filter(key -> ((Locale)locales.get(key)).equals(locale)).findFirst().orElse("");
        Group dosboxGroup = Group_.on(generalComposite).layout(new GridLayout(2, false)).key("dialog.settings.dosbox").build();
        final Button console = Chain.on(dosboxGroup).lbl(l -> l.key("dialog.settings.hidestatuswindow")).but(b -> b.select(this.settings_.getBooleanValue("dosbox", "hideconsole"))).button();
        Group sendToGroup = Group_.on(generalComposite).layout(new GridLayout(2, false)).key("dialog.settings.sendto").build();
        final Button portEnabled = Chain.on(sendToGroup).lbl(l -> l.key("dialog.settings.enableport")).but(b -> b.select(this.settings_.getBooleanValue("communication", "port_enabled"))).button();
        final Text port = Chain.on(sendToGroup).lbl(l -> l.key("dialog.settings.port")).txt(t -> t.val(this.settings_.getValue("communication", "port"))).text();
        port.setEnabled(portEnabled.getSelection());
        portEnabled.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                port.setEnabled(portEnabled.getSelection());
            }
        });
        Group profileDefGroup = Group_.on(generalComposite).layout(new GridLayout(3, false)).key("dialog.settings.profiledefaults").build();
        final Combo confLocation = Chain.on(profileDefGroup).lbl(l -> l.key("dialog.settings.configfile")).cmb(c -> c.items(SettingsDialog.getConfLocations()).select(this.settings_.getIntValue("profiledefaults", "confpath"))).combo();
        final Combo confFilename = Combo_.on(profileDefGroup).items(SettingsDialog.getConfFilenames()).select(this.settings_.getIntValue("profiledefaults", "conffile")).build();
        final Combo capturesLocation = Chain.on(profileDefGroup).lbl(l -> l.key("dialog.settings.captures")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(SettingsDialog.getCapsLocations()).select(this.settings_.getIntValue("profiledefaults", "capturespath"))).combo();
        Group i18nGroup = Group_.on(generalComposite).layout(new GridLayout(2, false)).key("dialog.settings.i18n").build();
        final Combo localeCombo = Chain.on(i18nGroup).lbl(l -> l.key("dialog.settings.languagecountry")).cmb(c -> c.items(locales.keySet().toArray(new String[0])).visibleItemCount(20)).combo();
        localeCombo.setText(locString);
        final Composite profileTableComposite = this.createTabWithComposite("dialog.settings.tab.profiletable", new GridLayout());
        final List<Integer> allColumnIds = this.getColumnIds();
        Group visColumnsGroup = ((Group_.Builder)Group_.on(profileTableComposite).layoutData(new GridData(4, 4, true, true))).layout(new FillLayout()).key("dialog.settings.visiblecolunms").build();
        final Table visibleColumnsTable = Table_.on(visColumnsGroup).check().build();
        TableColumn column1 = new TableColumn(visibleColumnsTable, 0);
        column1.setWidth(350);
        final TableItem[] visibleColumns = new TableItem[this.columnNames_.length];
        for (int i = 0; i < this.columnNames_.length; ++i) {
            visibleColumns[i] = new TableItem(visibleColumnsTable, 2048);
            visibleColumns[i].setText(this.columnNames_[allColumnIds.get(i)]);
            visibleColumns[i].setChecked(this.settings_.getBooleanValue("gui", "column" + (allColumnIds.get(i) + 1) + "visible"));
        }
        final TableEditor editor = new TableEditor(visibleColumnsTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        visibleColumnsTable.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)event.item) == null) {
                    return;
                }
                int selIdx = item.getParent().getSelectionIndex();
                if (selIdx == -1) {
                    return;
                }
                int idx = (Integer)allColumnIds.get(selIdx);
                if (idx >= 10 && idx < 20 || idx >= 28 && idx < 32) {
                    Text newEditor = Text_.on(visibleColumnsTable).val(item.getText(0)).build();
                    newEditor.addModifyListener(mEvent -> {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(0, text.getText());
                    });
                    newEditor.selectAll();
                    newEditor.setFocus();
                    editor.setEditor(newEditor, item, 0);
                }
            }
        });
        Group addProfGroup = ((Group_.Builder)Group_.on(profileTableComposite).layout(new GridLayout(2, false)).layoutData(new GridData(4, 4, true, false))).key("dialog.settings.addeditduplicateprofile").build();
        final Button autosort = Chain.on(addProfGroup).lbl(l -> l.key("dialog.settings.autosort")).but(b -> b.select(this.settings_.getBooleanValue("gui", "autosortonupdate"))).button();
        Composite dynamicOptionsComposite = this.createTabWithComposite("dialog.settings.tab.dynamicoptions", 1);
        SashForm sashForm = SettingsDialog.createSashForm(dynamicOptionsComposite, 1);
        Composite left = Composite_.on(sashForm).innerLayout(1).build();
        final org.eclipse.swt.widgets.List optionsList = Chain.on(left).lbl(l -> l.key("dialog.settings.options")).lst(l -> l).list();
        Composite right = Composite_.on(sashForm).innerLayout(1).build();
        final Text values = Chain.on(right).lbl(l -> l.key("dialog.settings.values")).txt(Text_.Builder::multi).text();
        final LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        for (String s2 : this.settings_.getProfileSectionItemNames()) {
            optionsMap.put(s2, this.settings_.getMultilineValue("profile", s2, values.getLineDelimiter()));
            optionsList.add(s2);
        }
        optionsList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.updateOptionsMap(optionsMap, optionsList, SettingsDialog.this.lastOptionSelection, values);
                SettingsDialog.this.lastOptionSelection = optionsList.getSelectionIndex();
                if (SettingsDialog.this.lastOptionSelection != -1) {
                    values.setText((String)optionsMap.get(optionsList.getItem(SettingsDialog.this.lastOptionSelection)));
                }
            }
        });
        final Composite guiComposite = this.createTabWithComposite("dialog.settings.tab.gui", 4);
        Font notesFont = SettingsDialog.stringToFont(this.shell_.getDisplay(), this.settings_.getValues("gui", "notesfont"), port.getFont());
        Group screenshots = ((Group_.Builder)Group_.on(guiComposite).layout(new GridLayout(3, false)).layoutData(new GridData(4, 4, true, false, 4, 1))).key("dialog.settings.screenshots").build();
        final Scale screenshotsHeight = Chain.on(screenshots).lbl(l -> l.key("dialog.settings.height")).scl(s -> s.min(50).max(750).incr(25).pageIncr(100).select(this.settings_.getIntValue("gui", "screenshotsheight"))).scale();
        final Label heightValue = Label_.on(screenshots).key("dialog.settings.px", new Object[]{screenshotsHeight.getSelection()}).build();
        screenshotsHeight.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                heightValue.setText(SettingsDialog.this.text_.get("dialog.settings.px", new Object[]{screenshotsHeight.getSelection()}));
                heightValue.pack();
                heightValue.getParent().layout(true);
            }
        });
        final Button displayFilename = Chain.on(screenshots).lbl(l -> l.key("dialog.settings.screenshotsfilename")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue("gui", "screenshotsfilename"))).button();
        Group screenshotsColumn = ((Group_.Builder)Group_.on(guiComposite).layout(new GridLayout(3, false)).layoutData(new GridData(4, 4, true, false, 4, 1))).key("dialog.settings.screenshotscolumn").build();
        final Scale screenshotsColumnHeight = Chain.on(screenshotsColumn).lbl(l -> l.key("dialog.settings.height")).scl(s -> s.min(16).max(200).incr(4).pageIncr(16).select(this.settings_.getIntValue("gui", "screenshotscolumnheight"))).scale();
        final Label columnHeightValue = Label_.on(screenshotsColumn).key("dialog.settings.px", new Object[]{screenshotsColumnHeight.getSelection()}).build();
        screenshotsColumnHeight.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                columnHeightValue.setText(SettingsDialog.this.text_.get("dialog.settings.px", new Object[]{screenshotsColumnHeight.getSelection()}));
                columnHeightValue.pack();
                columnHeightValue.getParent().layout(true);
            }
        });
        final Button stretch = Chain.on(screenshotsColumn).lbl(l -> l.key("dialog.settings.screenshotscolumnstretch")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue("gui", "screenshotscolumnstretch"))).button();
        final Button keepAspectRatio = Chain.on(screenshotsColumn).lbl(l -> l.key("dialog.settings.screenshotscolumnkeepaspectratio")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"))).button();
        keepAspectRatio.setEnabled(stretch.getSelection());
        stretch.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                keepAspectRatio.setEnabled(stretch.getSelection());
            }
        });
        Group buttonsGroup = ((Group_.Builder)Group_.on(guiComposite).layout(new GridLayout(2, false)).layoutData(new GridData(4, 0x1000000, true, false))).key("dialog.settings.buttons").build();
        final Combo buttonDisplay = Chain.on(buttonsGroup).lbl(l -> l.key("dialog.settings.display")).cmb(c -> c.items(new String[]{this.text_.get("dialog.settings.displaybuttonimageandtext"), this.text_.get("dialog.settings.displaybuttontextonly"), this.text_.get("dialog.settings.displaybuttonimageonly")}).select(this.settings_.getIntValue("gui", "buttondisplay"))).combo();
        Group linkingGroup = Group_.on(guiComposite).layout(new GridLayout(2, false)).key("dialog.settings.linking").build();
        final Combo linkingSelector = Chain.on(linkingGroup).lbl(l -> l.key("dialog.settings.linking.tofile")).cmb(c -> c.items(Arrays.asList(TextService.getInstance().get("dialog.settings.linking.byurl"), TextService.getInstance().get("dialog.settings.linking.bypath"))).select(this.settings_.getIntValue("gui", "linking"))).combo();
        final Group notesGroup = ((Group_.Builder)Group_.on(guiComposite).layout(new GridLayout(2, false)).layoutData(new GridData(4, 0x1000000, true, false))).key("dialog.profile.notes").build();
        final Button fontButton = Chain.on(notesGroup).lbl(l -> l.key("dialog.settings.font")).but(b -> b.text().txt(notesFont.getFontData()[0].getName()).listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Button fntButton = (Button)e.getSource();
                FontDialog fd = new FontDialog(SettingsDialog.this.shell_, 0);
                fd.setFontList(fntButton.getFont().getFontData());
                FontData newFont = fd.open();
                if (newFont != null) {
                    Font f = fntButton.getFont();
                    fntButton.setText(newFont.getName());
                    fntButton.setFont(new Font((Device)SettingsDialog.this.shell_.getDisplay(), newFont));
                    f.dispose();
                    notesGroup.setSize(notesGroup.computeSize(-1, -1));
                    guiComposite.layout();
                }
            }
        })).button();
        fontButton.addDisposeListener(e -> fontButton.getFont().dispose());
        fontButton.setFont(notesFont);
        Group themeGroup = Group_.on(guiComposite).layout(new GridLayout(2, false)).key("dialog.settings.colors").build();
        final Combo themeSelector = Chain.on(themeGroup).lbl(l -> l.key("dialog.settings.theme")).cmb(c -> c.items(Arrays.asList(TextService.getInstance().get("dialog.settings.theme.default"), TextService.getInstance().get("dialog.settings.theme.forcedarkmode"))).select(this.settings_.getIntValue("gui", "theme"))).combo();
        Composite enginesComposite = this.createTabWithComposite("dialog.settings.tab.engines", new FillLayout());
        final int nrOfEngines = SettingsService.availableWebSearchEngines().size();
        final Button[] setTitle = new Button[nrOfEngines];
        final Button[] setDev = new Button[nrOfEngines];
        final Button[] setPub = new Button[nrOfEngines];
        final Button[] setYear = new Button[nrOfEngines];
        final Button[] setGenre = new Button[nrOfEngines];
        final Button[] setLink = new Button[nrOfEngines];
        final Button[] setRank = new Button[nrOfEngines];
        final Button[] setDescr = new Button[nrOfEngines];
        final Button[] allRegionsCoverArt = new Button[nrOfEngines];
        final Button[] chooseCoverArt = new Button[nrOfEngines];
        final Button[] chooseScreenshot = new Button[nrOfEngines];
        final Spinner[] maxCoverArt = new Spinner[nrOfEngines];
        final Spinner[] maxScreenshots = new Spinner[nrOfEngines];
        final Text[] platformFilterValues = new Text[nrOfEngines];
        CTabFolder enginesTabFolder = CTabFolder_.on(enginesComposite).ctrl();
        for (int i = 0; i < nrOfEngines; ++i) {
            WebSearchEngine engine = SettingsService.availableWebSearchEngines().get(i);
            Composite engineComposite = Composite_.on(enginesTabFolder).layout(new GridLayout()).tab("dialog.settings.tab." + engine.getSimpleName()).build();
            Group consultGroup = ((Group_.Builder)Group_.on(engineComposite).layoutData(new GridData(4, 4, true, true))).layout(new GridLayout(3, false)).txt(this.text_.get("dialog.settings.consult", new String[]{engine.getName()})).build();
            setTitle[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.settitle")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_title"))).button();
            setDev[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setdeveloper")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_developer"))).button();
            if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                setPub[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setpublisher")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_publisher"))).button();
            }
            setYear[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setyear")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_year"))).button();
            setGenre[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setgenre")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_genre"))).button();
            String name = engine instanceof MetropolisSearchEngine ? MobyGamesSearchEngine.getInstance().getName() : engine.getName();
            setLink[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setlink", name)).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_link"))).button();
            setRank[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setrank", this.columnNames_[18])).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_rank"))).button();
            if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                setDescr[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.setdescription")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "set_description"))).button();
            }
            if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                chooseCoverArt[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.choosecoverart")).but(b -> b.select(this.settings_.getBooleanValue(engine.getSimpleName(), "choose_coverart"))).button();
                Composite comp = ((Composite_.Builder)Composite_.on(consultGroup).layoutData(new GridData_().horizontalIndent(40).build())).innerLayout(2).build();
                if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine) {
                    allRegionsCoverArt[i] = Chain.on(comp).lbl(l -> l.key("dialog.settings.allregionscoverart")).but(b -> b.select(this.settings_.getBooleanValue(engine.getSimpleName(), "force_all_regions_coverart"))).button();
                }
            }
            chooseScreenshot[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.choosescreenshot")).but(b -> ((Button_.Builder)b.horSpan(2)).select(this.settings_.getBooleanValue(engine.getSimpleName(), "choose_screenshot"))).button();
            if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                maxCoverArt[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.multieditmaxcoverart")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).select(this.settings_.getIntValue(engine.getSimpleName(), "multi_max_coverart"))).spinner();
            }
            maxScreenshots[i] = Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.multieditmaxscreenshot")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).select(this.settings_.getIntValue(engine.getSimpleName(), "multi_max_screenshot"))).spinner();
            platformFilterValues[i] = engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof PouetSearchEngine ? Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.platformfilter")).txt(t -> ((Text_.Builder)t.multi().horSpan(2)).val(this.settings_.getMultilineValue(engine.getSimpleName(), "platform_filter", values.getLineDelimiter()))).text() : Chain.on(consultGroup).lbl(l -> l.key("dialog.settings.platformfilter")).txt(t -> ((Text_.Builder)t.horSpan(2)).val(this.settings_.getValue(engine.getSimpleName(), "platform_filter"))).text();
        }
        enginesTabFolder.setSelection(0);
        Composite envComposite = this.createTabWithComposite("dialog.settings.tab.environment", new GridLayout());
        Group envGroup = ((Group_.Builder)Group_.on(envComposite).layoutData(new GridData(4, 4, true, true))).layout(new GridLayout(2, false)).key("dialog.settings.environment").build();
        final Button enableEnv = Chain.on(envGroup).lbl(l -> l.key("dialog.settings.enableenvironment")).but(b -> b.select(this.settings_.getBooleanValue("environment", "use"))).button();
        final Text envValues = Chain.on(envGroup).lbl(l -> l.key("dialog.settings.environmentvariables")).txt(t -> t.multi().val(this.settings_.getMultilineValue("environment", "value", values.getLineDelimiter()))).text();
        envValues.setEnabled(enableEnv.getSelection());
        enableEnv.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                envValues.setEnabled(enableEnv.getSelection());
            }
        });
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                int i;
                boolean requireRestart;
                if (!SettingsDialog.this.isValid(visibleColumnsTable, visibleColumns, SettingsDialog.this.getTabItemByComposite(profileTableComposite))) {
                    return;
                }
                boolean changedVisColumns = this.haveColumnsBeenChanged();
                if (changedVisColumns) {
                    SettingsDialog.this.updateColumnSettings(allColumnIds, visibleColumns);
                }
                boolean bl = requireRestart = changedVisColumns || portEnabled.getSelection() != SettingsDialog.this.settings_.getBooleanValue("communication", "port_enabled") || !port.getText().equalsIgnoreCase(SettingsDialog.this.settings_.getValue("communication", "port")) || screenshotsHeight.getSelection() != SettingsDialog.this.settings_.getIntValue("gui", "screenshotsheight") || screenshotsColumnHeight.getSelection() != SettingsDialog.this.settings_.getIntValue("gui", "screenshotscolumnheight") || buttonDisplay.getSelectionIndex() != SettingsDialog.this.settings_.getIntValue("gui", "buttondisplay") || themeSelector.getSelectionIndex() != SettingsDialog.this.settings_.getIntValue("gui", "theme");
                if (!(((Locale)locales.get(localeCombo.getText())).getLanguage().equalsIgnoreCase(SettingsDialog.this.settings_.getValue("locale", "language")) && ((Locale)locales.get(localeCombo.getText())).getCountry().equalsIgnoreCase(SettingsDialog.this.settings_.getValue("locale", "country")) && ((Locale)locales.get(localeCombo.getText())).getVariant().equalsIgnoreCase(SettingsDialog.this.settings_.getValue("locale", "variant")))) {
                    SettingsDialog.this.settings_.setValue("locale", "language", ((Locale)locales.get(localeCombo.getText())).getLanguage());
                    SettingsDialog.this.settings_.setValue("locale", "country", ((Locale)locales.get(localeCombo.getText())).getCountry());
                    SettingsDialog.this.settings_.setValue("locale", "variant", ((Locale)locales.get(localeCombo.getText())).getVariant());
                    SettingsDialog.this.text_.refresh();
                    requireRestart = true;
                }
                SettingsDialog.this.settings_.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                SettingsDialog.this.settings_.setValue("communication", "port", port.getText());
                SettingsDialog.this.settings_.setIntValue("profiledefaults", "confpath", confLocation.getSelectionIndex());
                SettingsDialog.this.settings_.setIntValue("profiledefaults", "conffile", confFilename.getSelectionIndex());
                SettingsDialog.this.settings_.setIntValue("profiledefaults", "capturespath", capturesLocation.getSelectionIndex());
                for (i = 0; i < SettingsDialog.this.columnNames_.length; ++i) {
                    SettingsDialog.this.settings_.setBooleanValue("gui", "column" + (i + 1) + "visible", visibleColumns[allColumnIds.indexOf(i)].getChecked());
                }
                SettingsDialog.this.settings_.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
                for (i = 0; i < 10; ++i) {
                    SettingsDialog.this.settings_.setValue("gui", "custom" + (i + 1), visibleColumns[allColumnIds.indexOf(i + 10)].getText());
                }
                for (i = 0; i < 4; ++i) {
                    SettingsDialog.this.settings_.setValue("gui", "custom" + (i + 10 + 1), visibleColumns[allColumnIds.indexOf(i + 10 + 10 + 8)].getText());
                }
                SettingsDialog.this.settings_.setIntValue("gui", "screenshotsheight", screenshotsHeight.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("gui", "screenshotsfilename", displayFilename.getSelection());
                SettingsDialog.this.settings_.setIntValue("gui", "screenshotscolumnheight", screenshotsColumnHeight.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("gui", "screenshotscolumnstretch", stretch.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("gui", "screenshotscolumnkeepaspectratio", keepAspectRatio.getSelection());
                Rectangle rec = SettingsDialog.this.shell_.getBounds();
                SettingsDialog.this.settings_.setIntValue("gui", "settingsdialog_width", rec.width);
                SettingsDialog.this.settings_.setIntValue("gui", "settingsdialog_height", rec.height);
                SettingsDialog.this.settings_.setIntValue("gui", "buttondisplay", buttonDisplay.getSelectionIndex());
                SettingsDialog.this.settings_.setMultilineValue("gui", "notesfont", SettingsDialog.fontToString(fontButton.getFont()), "|");
                SettingsDialog.this.settings_.setIntValue("gui", "theme", themeSelector.getSelectionIndex());
                SettingsDialog.this.settings_.setIntValue("gui", "linking", linkingSelector.getSelectionIndex());
                for (int i2 = 0; i2 < nrOfEngines; ++i2) {
                    WebSearchEngine engine = SettingsService.availableWebSearchEngines().get(i2);
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_title", setTitle[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_developer", setDev[i2].getSelection());
                    if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_publisher", setPub[i2].getSelection());
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_description", setDescr[i2].getSelection());
                    }
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_year", setYear[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_genre", setGenre[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_link", setLink[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_rank", setRank[i2].getSelection());
                    if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "force_all_regions_coverart", allRegionsCoverArt[i2].getSelection());
                    }
                    if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "choose_coverart", chooseCoverArt[i2].getSelection());
                        SettingsDialog.this.settings_.setIntValue(engine.getSimpleName(), "multi_max_coverart", maxCoverArt[i2].getSelection());
                    }
                    if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof PouetSearchEngine || engine instanceof TheGamesDBSearchEngine) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "choose_screenshot", chooseScreenshot[i2].getSelection());
                        SettingsDialog.this.settings_.setIntValue(engine.getSimpleName(), "multi_max_screenshot", maxScreenshots[i2].getSelection());
                    }
                    if (engine instanceof MobyGamesSearchEngine || engine instanceof MetropolisSearchEngine || engine instanceof PouetSearchEngine) {
                        SettingsDialog.this.settings_.setMultilineValue(engine.getSimpleName(), "platform_filter", platformFilterValues[i2].getText(), platformFilterValues[i2].getLineDelimiter());
                        continue;
                    }
                    SettingsDialog.this.settings_.setValue(engine.getSimpleName(), "platform_filter", platformFilterValues[i2].getText());
                }
                SettingsDialog.this.settings_.setBooleanValue("environment", "use", enableEnv.getSelection());
                SettingsDialog.this.settings_.setMultilineValue("environment", "value", envValues.getText(), envValues.getLineDelimiter());
                SettingsDialog.updateOptionsMap(optionsMap, optionsList, SettingsDialog.this.lastOptionSelection, values);
                for (Map.Entry entry : optionsMap.entrySet()) {
                    SettingsDialog.this.settings_.setMultilineValue("profile", (String)entry.getKey(), (String)entry.getValue(), values.getLineDelimiter());
                }
                SettingsDialog.this.result_ = requireRestart;
                SettingsDialog.this.shell_.close();
            }

            private boolean haveColumnsBeenChanged() {
                for (int i = 0; i < SettingsDialog.this.columnNames_.length; ++i) {
                    if (SettingsDialog.this.settings_.getBooleanValue("gui", "column" + ((Integer)allColumnIds.get(i) + 1) + "visible") == visibleColumns[i].getChecked() && SettingsDialog.this.columnNames_[(Integer)allColumnIds.get(i)].equals(visibleColumns[i].getText())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static void updateOptionsMap(Map<String, String> optionsMap, org.eclipse.swt.widgets.List options, int lastOptionSelection, Text values) {
        if (lastOptionSelection != -1) {
            optionsMap.put(options.getItem(lastOptionSelection), values.getText());
        }
    }

    private void updateColumnSettings(List<Integer> allColumnIds, TableItem[] visibleColumns) {
        OptionalInt firstVisibleColumn;
        int[] sort = this.settings_.getIntValues("gui", "sortcolumn");
        boolean[] ascs = this.settings_.getBooleanValues("gui", "sortascending");
        ArrayList<Integer> sortColumnIDs = new ArrayList<Integer>(sort.length);
        ArrayList<Boolean> sortColumnAscs = new ArrayList<Boolean>(sort.length);
        for (int i2 = 0; i2 < sort.length; ++i2) {
            if (!visibleColumns[allColumnIds.indexOf(sort[i2])].getChecked()) continue;
            sortColumnIDs.add(sort[i2]);
            sortColumnAscs.add(ascs[i2]);
        }
        if (sortColumnIDs.isEmpty() && (firstVisibleColumn = IntStream.range(0, visibleColumns.length).filter(i -> visibleColumns[i].getChecked()).findFirst()).isPresent()) {
            sortColumnIDs.add(allColumnIds.get(firstVisibleColumn.getAsInt()));
            sortColumnAscs.add(true);
        }
        this.settings_.setIntValues("gui", "sortcolumn", ArrayUtils.toPrimitive(sortColumnIDs.toArray(new Integer[0])));
        this.settings_.setBooleanValues("gui", "sortascending", ArrayUtils.toPrimitive(sortColumnAscs.toArray(new Boolean[0])));
        ArrayList<Integer> visColumns = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.columnNames_.length; ++i3) {
            if (!visibleColumns[i3].getChecked()) continue;
            visColumns.add(allColumnIds.get(i3));
        }
        ArrayList orderedVisColumns = new ArrayList(visColumns);
        Collections.sort(orderedVisColumns);
        ArrayList<Integer> colOrder = new ArrayList<Integer>();
        Iterator iterator = visColumns.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            colOrder.add(orderedVisColumns.indexOf(id));
        }
        this.settings_.setValue("gui", "columnorder", StringUtils.join(colOrder, ' '));
    }

    private static SortedMap<String, Locale> getLocales() {
        ArrayList<String> supportedLanguages = new ArrayList<String>(Constants.SUPPORTED_LANGUAGES);
        File[] files = new File("./plugins/i18n").listFiles();
        if (files != null) {
            for (File file : files) {
                String code;
                String name = file.getName();
                if (!name.startsWith("MessagesBundle_") || !name.endsWith(".properties") || (code = name.substring("MessagesBundle_".length(), name.indexOf(".properties"))).length() <= 0) continue;
                supportedLanguages.add(code);
            }
        }
        TreeMap<String, Locale> allLocales = new TreeMap<String, Locale>();
        for (Locale loc : Locale.getAvailableLocales()) {
            allLocales.put(loc.toString(), loc);
        }
        TreeMap<String, Locale> locales = new TreeMap<String, Locale>();
        for (String lang : supportedLanguages) {
            Locale loc;
            loc = (Locale)allLocales.get(lang);
            String variant = null;
            if (loc == null && StringUtils.countMatches((CharSequence)lang, "_") == 2) {
                String langWithoutVariant = StringUtils.removeEnd(StringUtils.substringBeforeLast(lang, "_"), "_");
                variant = StringUtils.substringAfterLast(lang, "_");
                loc = (Locale)allLocales.get(langWithoutVariant);
            }
            if (loc == null) continue;
            StringBuilder s = new StringBuilder(loc.getDisplayLanguage());
            s.append(" [").append(loc.getDisplayLanguage(loc)).append("]");
            if (loc.getCountry().length() > 0) {
                s.append(" - ").append(loc.getDisplayCountry()).append(" [").append(loc.getDisplayCountry(loc)).append("]");
            }
            if (variant != null) {
                s.append(" (").append(variant).append(')');
                loc = new Locale(loc.getLanguage(), loc.getCountry(), variant);
            }
            locales.put(s.toString(), loc);
        }
        return locales;
    }

    private List<Integer> getColumnIds() {
        int[] columnOrder;
        ArrayList<Integer> visibleColumnIds = new ArrayList<Integer>();
        for (int i = 0; i < this.columnNames_.length; ++i) {
            if (!this.settings_.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            visibleColumnIds.add(i);
        }
        ArrayList<Integer> orderedVisibleColumnIds = new ArrayList<Integer>();
        for (int element : columnOrder = this.settings_.getIntValues("gui", "columnorder")) {
            orderedVisibleColumnIds.add((Integer)visibleColumnIds.get(element));
        }
        ArrayList<Integer> remainingColumnIDs = new ArrayList<Integer>();
        for (int i = 0; i < this.columnNames_.length; ++i) {
            if (orderedVisibleColumnIds.contains(i)) continue;
            remainingColumnIDs.add(i);
        }
        ArrayList<Integer> allColumnIds = new ArrayList<Integer>(orderedVisibleColumnIds);
        allColumnIds.addAll(remainingColumnIDs);
        return allColumnIds;
    }

    private boolean isValid(Table visibleColumnsTable, TableItem[] visibleColumns, CTabItem columnsTabItem) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (Stream.of(visibleColumns).noneMatch(TableItem::getChecked)) {
            mess.key("dialog.settings.required.onevisiblecolumn").bind(visibleColumnsTable, columnsTabItem);
        }
        return mess.valid();
    }

    public static List<String> getConfLocations() {
        return Arrays.asList(TextService.getInstance().get("dialog.settings.confindbgldir"), TextService.getInstance().get("dialog.settings.confingamedir"));
    }

    public static List<String> getConfFilenames() {
        return Arrays.asList(TextService.getInstance().get("dialog.settings.conffilebyid"), TextService.getInstance().get("dialog.settings.conffilebytitle"));
    }

    public static List<String> getCapsLocations() {
        return Arrays.asList(TextService.getInstance().get("dialog.settings.capturestogether"), TextService.getInstance().get("dialog.settings.capturesseparate"));
    }
}

