/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.util.stream.Stream;
import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class Thumb
extends BaseDialog<Object> {
    private static final int BUTTON_BORDER_WIDTH = 0;
    private static final int BUTTON_BORDER_HEIGHT = 24;
    private File[] files_;
    private int index_;
    private Rectangle monitorClientArea_;
    private Button imgButton_;
    private Rectangle imgBounds_;
    private Image thumbImage_;

    public Thumb(Shell parent, File[] files, int index) {
        super(parent, 67680);
        this.files_ = files;
        this.index_ = index;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.screenshot.title", this.files_[this.index_].getPath());
    }

    @Override
    protected boolean prepare() {
        this.monitorClientArea_ = Stream.of(this.display_.getMonitors()).filter(x -> x.getBounds().intersects(this.getParent().getBounds())).findFirst().orElse(this.display_.getPrimaryMonitor()).getClientArea();
        return true;
    }

    @Override
    protected void onShellCreated() {
        this.shell_.setBounds(this.monitorClientArea_);
        this.shell_.setLayout(new GridLayout(3, true));
        this.imgButton_ = ((Button_.Builder)Button_.on(this.shell_).layoutData(new GridData(4, 4, true, true, 3, 1))).text().listen(this.closeShellAdapter).ctrl();
        this.imgButton_.addTraverseListener(e -> {
            if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                this.nextPrev(e.keyCode == 0x1000004);
                e.doit = false;
            }
        });
        Button_.on(this.shell_).text().key("button.previousimage").listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thumb.this.nextPrev(false);
            }
        }).build();
        Button_.on(this.shell_).text().key("button.close").listen(this.closeShellAdapter).build();
        Button_.on(this.shell_).text().key("button.nextimage").listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thumb.this.nextPrev(true);
            }
        }).build();
    }

    @Override
    protected void onShellOpened() {
        this.imgBounds_ = this.imgButton_.getBounds();
        this.getThumbImage();
        this.imgButton_.setImage(this.thumbImage_);
        this.adjustShellBounds();
    }

    private void adjustShellBounds() {
        this.shell_.pack();
        Rectangle shellBounds = this.shell_.getBounds();
        this.shell_.setLocation(this.monitorClientArea_.x + (this.monitorClientArea_.width - shellBounds.width) / 2, this.monitorClientArea_.y + (this.monitorClientArea_.height - shellBounds.height) / 2);
    }

    private void nextPrev(boolean next) {
        if (next) {
            ++this.index_;
            if (this.index_ >= this.files_.length) {
                this.index_ = 0;
            }
        } else {
            --this.index_;
            if (this.index_ < 0) {
                this.index_ = this.files_.length - 1;
            }
        }
        this.getThumbImage();
        this.imgButton_.setImage(this.thumbImage_);
        this.shell_.setText(this.getDialogTitle());
        this.adjustShellBounds();
    }

    private void getThumbImage() {
        if (this.thumbImage_ != null && !this.thumbImage_.isDisposed()) {
            this.thumbImage_.dispose();
        }
        Image orgThumb = ImageService.getImage(this.display_, this.files_[this.index_].getPath());
        ImageData orgThumbData = orgThumb.getImageData();
        int width = orgThumbData.width;
        int height = orgThumbData.height;
        double factor = Math.min(Math.min((double)(this.imgBounds_.width - 0) / (double)width, (double)(this.imgBounds_.height - 24) / (double)height), (double)SettingsService.getInstance().getIntValue("gui", "screenshotsmaxzoompercentage") / 100.0);
        if ((double)width * factor > (double)SettingsService.getInstance().getIntValue("gui", "screenshotsmaxwidth")) {
            factor = (double)SettingsService.getInstance().getIntValue("gui", "screenshotsmaxwidth") / (double)width;
        }
        if ((double)height * factor > (double)SettingsService.getInstance().getIntValue("gui", "screenshotsmaxheight")) {
            factor = (double)SettingsService.getInstance().getIntValue("gui", "screenshotsmaxheight") / (double)height;
        }
        this.thumbImage_ = ImageService.createScaledImage(orgThumb, width, height, (int)((double)width * factor), (int)((double)height * factor), false, null);
        orgThumb.dispose();
    }
}

