/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.service;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.util.gif.GifDecoder;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class ImageService {
    private static final Map<String, Image> imageCacheMap = new HashMap<String, Image>();
    public static final String IMG_TB_NEW = "tb_new.png";
    public static final String IMG_TB_EDIT = "tb_edit.png";
    public static final String IMG_TB_DELETE = "tb_delete.png";
    public static final String IMG_TB_RUN = "tb_run.png";
    public static final String IMG_TB_SETUP = "tb_setup.png";
    public static final String IMG_TB_ADDGAMEWIZARD = "tb_wizard.png";
    public static final String IMG_RUN = "run.png";
    public static final String IMG_SETUP = "setup.png";
    public static final String IMG_FOLDER = "folder.png";
    public static final String IMG_ZOOM = "zoom.png";
    public static final String IMG_NEW = "new.png";
    public static final String IMG_EDIT = "edit.png";
    public static final String IMG_DUPLICATE = "duplicate.png";
    public static final String IMG_DELETE = "delete.png";
    public static final String IMG_FAVORITE = "favorite.png";
    public static final String IMG_SHORTCUT = "shortcut.png";
    public static final String IMG_REFRESH = "refresh.png";
    public static final String IMG_HOME = "home.png";
    public static final String IMG_DFEND = "dfend.png";
    public static final String IMG_MIGRATE = "case.png";
    public static final String IMG_TABLEEXPORT = "checkout.png";
    public static final String IMG_IMPORT = "import.png";
    public static final String IMG_CLEAN = "clean.png";
    public static final String IMG_SETTINGS = "settings.png";
    public static final String IMG_LOG = "log.png";
    public static final String IMG_EXIT = "stop.png";
    public static final String IMG_FILTER = "filter.png";
    public static final String IMG_EDITFILTER = "editfilter.png";
    public static final String IMG_ABOUT = "about.png";
    public static final String IMG_GRAB = "grab.png";
    public static final String IMG_MOBYGAMES = "moby.png";
    public static final String IMG_METROPOLIS = "metropolis.png";
    public static final String IMG_POUET = "pouet.png";
    public static final String IMG_HOTUD = "hotud.png";
    public static final String IMG_THEGAMESDB = "thegamesdb.png";
    public static final String IMG_SHARE = "share.png";
    public static final String IMG_UNDO = "undo.png";
    public static final String IMG_TOPDOG = "topdog.png";
    public static final String IMG_TILES_LARGE = "tiles_large.png";
    public static final String IMG_TILES_MEDIUM = "tiles_medium.png";
    public static final String IMG_TILES_SMALL = "tiles_small.png";
    public static final String IMG_BOXES_LARGE = "boxes_large.png";
    public static final String IMG_BOXES_MEDIUM = "boxes_medium.png";
    public static final String IMG_BOXES_SMALL = "boxes_small.png";
    public static final String IMG_TABLE = "table.png";
    public static final String IMG_SCREENSHOTS = "screenshots.png";
    public static final String IMG_NOTES = "notes.png";
    private static final Color widgetBackgroundColor = Display.getDefault().getSystemColor(22);
    private static final Color whiteColor = Display.getDefault().getSystemColor(1);
    private static final Color blackColor = Display.getDefault().getSystemColor(2);
    private static final Color widgetSelectedColor = Display.getDefault().getSystemColor(26);
    private static final int SELECTED_BUTTON_BORDER_WIDTH = 2;

    private ImageService() {
    }

    public static Image getResourceImage(Display display, String path) {
        Image image;
        block8: {
            InputStream is = ImageService.class.getResourceAsStream("/img/" + path);
            try {
                image = new Image((Device)display, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
        }
        return image;
    }

    public static Image[] getResourceImages(Display display, String[] path) {
        return (Image[])Stream.of(path).map(x -> ImageService.getResourceImage(display, x)).toArray(Image[]::new);
    }

    public static Image getImage(Display display, String path) {
        try {
            Image result;
            if (path.toLowerCase().endsWith(".ico")) {
                ImageLoader iLoader = new ImageLoader();
                iLoader.load(path);
                int bestWidth = 0;
                int bestDepth = 0;
                int bestIndex = 0;
                for (int i = 0; i < iLoader.data.length; ++i) {
                    if (iLoader.data[i].width < bestWidth || iLoader.data[i].depth < bestDepth) continue;
                    bestWidth = iLoader.data[i].width;
                    bestDepth = iLoader.data[i].depth;
                    bestIndex = i;
                }
                return new Image((Device)display, iLoader.data[bestIndex]);
            }
            Image image = result = path.toLowerCase().endsWith(".gif") ? ImageService.getImageUsingGifDecoder(display, path) : new Image((Device)display, path);
            if (result == null) {
                System.err.println("Could not load image " + path + ", retrying with generic SWT ImageLoader...");
                result = new Image((Device)display, path);
            }
            return result;
        }
        catch (Exception e) {
            Mess_.on(null).exception(e).warning();
            return ImageService.getEmptyImage(display, 10, 10);
        }
    }

    public static ImageData getImageData(InputStream imageInputStream, String mimetype) throws IOException {
        return mimetype.equalsIgnoreCase("image/gif") ? ImageService.getImageDataUsingGifDecoder(imageInputStream) : new ImageData(imageInputStream);
    }

    public static ImageData[] getAnimatedImageData(InputStream imageInputStream) throws IOException {
        ArrayList<ImageData> result = new ArrayList<ImageData>();
        GifDecoder d = new GifDecoder();
        int status = d.read(imageInputStream);
        if (status == 0 || status == 1) {
            int amount = d.getDelay(0) < 500 ? 1 : d.getFrameCount();
            for (int i = 0; i < amount; ++i) {
                ImageData imageData = ImageService.getImageDataFrame(d, i);
                if (imageData == null) continue;
                result.add(imageData);
            }
        }
        return result.toArray(new ImageData[result.size()]);
    }

    public static Image getWidthLimitedImage(Display display, int width, ImageData data) {
        Image orgImage = new Image((Device)display, data);
        int orgW = orgImage.getBounds().width;
        int orgH = orgImage.getBounds().height;
        int height = (int)((double)orgH * ((double)width / (double)orgW));
        Image image = ImageService.createScaledImage(orgImage, orgW, orgH, width, height, false, null);
        orgImage.dispose();
        return image;
    }

    public static Image getHeightLimitedImage(Display display, int height, ImageData data) {
        Image orgImage = new Image((Device)display, data);
        int orgW = orgImage.getBounds().width;
        int orgH = orgImage.getBounds().height;
        int width = (int)((double)orgW * ((double)height / (double)orgH));
        Image image = ImageService.createScaledImage(orgImage, orgW, orgH, width, height, false, null);
        orgImage.dispose();
        return image;
    }

    public static Image getCachedHeightLimitedImage(Display display, int height, String path, String name) {
        return imageCacheMap.computeIfAbsent(path + height + name, h -> {
            Image orgImage = ImageService.getImage(display, path);
            int orgW = orgImage.getBounds().width;
            int orgH = orgImage.getBounds().height;
            int width = (int)((double)orgW * ((double)height / (double)orgH));
            Image newImage = ImageService.createScaledImage(orgImage, orgW, orgH, width, height, false, name);
            orgImage.dispose();
            return newImage;
        });
    }

    public static Image getCachedResizedImage(Display display, int width, int height, boolean keepAspectRatio, String path) {
        return imageCacheMap.computeIfAbsent(path + width + height + keepAspectRatio, h -> {
            Image orgImage = ImageService.getImage(display, path);
            int orgW = orgImage.getBounds().width;
            int orgH = orgImage.getBounds().height;
            Image newImage = ImageService.createScaledImage(orgImage, orgW, orgH, width, height, keepAspectRatio, null);
            orgImage.dispose();
            return newImage;
        });
    }

    public static Image getEmptyImage(Display display, int width, int height) {
        Image image = new Image((Device)display, width, height);
        GC graphc = new GC(image);
        graphc.setBackground(widgetBackgroundColor);
        graphc.fillRectangle(0, 0, width, height);
        graphc.dispose();
        return image;
    }

    public static Image createDisabledImage(Image img) {
        return new Image(img.getDevice(), img, 1);
    }

    public static Image createSelectedImage(Image img) {
        Image image = new Image(img.getDevice(), img.getBounds().width, img.getBounds().height);
        GC graphc = new GC(image);
        graphc.drawImage(img, 0, 0);
        graphc.setLineWidth(2);
        for (int i = 0; i < 3; ++i) {
            graphc.setForeground(i % 2 == 0 ? widgetSelectedColor : whiteColor);
            int d = i * 2 + 1;
            graphc.drawRectangle(d, d, image.getBounds().width - d * 2 - 1, image.getBounds().height - d * 2 - 1);
        }
        graphc.dispose();
        return image;
    }

    public static void save(Display display, ImageData imageData, String filename) throws SWTException {
        Image tmpImage = new Image((Device)display, imageData);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{tmpImage.getImageData()};
        loader.save(filename, filename.toLowerCase().endsWith(".jpg") ? 4 : 5);
        tmpImage.dispose();
    }

    public static void clearCache() {
        imageCacheMap.values().forEach(Resource::dispose);
        imageCacheMap.clear();
    }

    public static void clearCache(String path) {
        imageCacheMap.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(path)).forEach(x -> ((Image)x.getValue()).dispose());
        imageCacheMap.entrySet().removeIf(x -> ((String)x.getKey()).startsWith(path));
    }

    public static Image createScaledImage(Image orgImage, int orgW, int orgH, int width, int height, boolean keepAspectRatio, String name) {
        int cropX = 0;
        int cropY = 0;
        if (keepAspectRatio) {
            double factor = Math.max((double)width / (double)orgW, (double)height / (double)orgH);
            cropX = (int)(((double)orgW * factor - (double)width) / factor);
            cropY = (int)(((double)orgH * factor - (double)height) / factor);
        }
        Device device = orgImage.getDevice();
        Image image = new Image(device, width, height);
        GC graphc = new GC(image);
        graphc.setAntialias(1);
        graphc.setInterpolation(2);
        graphc.drawImage(orgImage, cropX / 2, cropY / 2, orgW - cropX, orgH - cropY, 0, 0, width, height);
        if (name != null) {
            Point size = graphc.textExtent(name);
            graphc.setBackground(blackColor);
            graphc.setForeground(whiteColor);
            graphc.setAlpha(180);
            graphc.drawString(name, width - size.x - 2, height - size.y - 2, false);
        }
        graphc.dispose();
        return image;
    }

    private static Image getImageUsingGifDecoder(Display display, String path) {
        GifDecoder d = new GifDecoder();
        int status = d.read(path);
        ImageData imageData = ImageService.getImageDataUsingGifDecoder(d, status);
        return imageData != null ? new Image((Device)display, imageData) : null;
    }

    private static ImageData getImageDataUsingGifDecoder(InputStream imageInputStream) throws IOException {
        GifDecoder d = new GifDecoder();
        int status = d.read(imageInputStream);
        return ImageService.getImageDataUsingGifDecoder(d, status);
    }

    private static ImageData getImageDataUsingGifDecoder(GifDecoder d, int status) {
        return status == 0 || status == 1 ? ImageService.getImageDataFrame(d, 0) : null;
    }

    protected static ImageData getImageDataFrame(GifDecoder d, int frameNr) {
        BufferedImage bufferedImage = d.getFrame(frameNr);
        if (bufferedImage != null) {
            int[] data = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
            imageData.setPixels(0, 0, data.length, data, 0);
            return imageData;
        }
        return null;
    }
}

