/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.XmlUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TheGamesDBSearchEngine
extends WebSearchEngine {
    private static final String THE_GAMES_DB_HOST_NAME = "legacy.thegamesdb.net";

    private TheGamesDBSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance_;
    }

    @Override
    public String getIcon() {
        return "thegamesdb.png";
    }

    @Override
    public String getName() {
        return "TheGamesDB.net";
    }

    @Override
    public String getSimpleName() {
        return "thegamesdb";
    }

    @Override
    public boolean available() {
        return false;
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        ArrayList<WebProfile> arrayList;
        block11: {
            String url = "https://legacy.thegamesdb.net/api/GetGamesList.php?name=" + URLEncoder.encode(title.replace("/", " "), "UTF-8") + (String)(platforms.length == 1 ? "&platform=" + platforms[0] : "");
            InputStream is = TheGamesDBSearchEngine.getInputStream(url);
            try {
                Document doc = XmlUtils.getDocumentBuilder().parse(is);
                NodeList gameNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/Data/Game", doc, XPathConstants.NODESET);
                ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
                for (int i = 0; i < gameNodes.getLength(); ++i) {
                    Element gameNode = (Element)gameNodes.item(i);
                    WebProfile gameEntry = new WebProfile();
                    gameEntry.setTitle(XmlUtils.getTextValue(gameNode, "GameTitle"));
                    gameEntry.setUrl(TheGamesDBSearchEngine.absoluteUrl(THE_GAMES_DB_HOST_NAME, "/api/GetGame.php?id=" + XmlUtils.getTextValue(gameNode, "id")));
                    gameEntry.setPlatform(XmlUtils.getTextValue(gameNode, "Platform"));
                    gameEntry.setPublisherName("");
                    String date = XmlUtils.getTextValue(gameNode, "ReleaseDate");
                    if (date != null && date.length() == 10) {
                        gameEntry.setYear(date.substring(date.length() - 4));
                    } else {
                        gameEntry.setYear("");
                    }
                    allEntries.add(gameEntry);
                }
                arrayList = allEntries;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                    throw new IOException(e);
                }
            }
            is.close();
        }
        return arrayList;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws IOException {
        WebProfile result = new WebProfile();
        result.setTitle(entry.getTitle());
        result.setYear(entry.getYear());
        result.setUrl(entry.getUrl());
        result.setPlatform(entry.getPlatform());
        try (InputStream is = TheGamesDBSearchEngine.getInputStream(entry.getUrl());){
            Document doc = XmlUtils.getDocumentBuilder().parse(is);
            Element gameNode = (Element)doc.getFirstChild();
            result.setDeveloperName(StringUtils.defaultString(XmlUtils.getTextValue(gameNode, "Developer")));
            result.setPublisherName(StringUtils.defaultString(XmlUtils.getTextValue(gameNode, "Publisher")));
            result.setNotes(StringUtils.defaultString(XmlUtils.getTextValue(gameNode, "Overview")));
            String rating = XmlUtils.getTextValue(gameNode, "Rating");
            if (rating != null) {
                result.setRank((int)(Double.parseDouble(rating) * 10.0 + 0.5));
            } else {
                result.setRank(0);
            }
            result.setCoreGameCoverUrl(XmlUtils.getTextValue(gameNode, "baseImgUrl"));
            result.setXmlElementWithAllImages(XmlUtils.getNode(gameNode, "Images"));
            StringBuilder genre = new StringBuilder();
            Element el = XmlUtils.getNode(gameNode, "Genres");
            if (el != null) {
                NodeList genreNodes = el.getChildNodes();
                for (int i = 0; i < genreNodes.getLength(); ++i) {
                    if (i > 0) {
                        genre.append(", ");
                    }
                    genre.append(genreNodes.item(i).getFirstChild().getNodeValue());
                }
            }
            result.setGenre(genre.toString());
            result.setUrl(TheGamesDBSearchEngine.absoluteUrl(THE_GAMES_DB_HOST_NAME, "/game/" + XmlUtils.getTextValue(gameNode, "id")));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        return result;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (coverArtMax > 0) {
            try {
                result.addAll(TheGamesDBSearchEngine.getEntryCoverArtInformation(entry, coverArtMax));
            }
            catch (XPathExpressionException e) {
                throw new IOException(e);
            }
        }
        if (screenshotsMax > 0) {
            try {
                result.addAll(TheGamesDBSearchEngine.getEntryScreenshotInformation(entry, screenshotsMax));
            }
            catch (XPathExpressionException e) {
                throw new IOException(e);
            }
        }
        entry.setWebImages(result.toArray(new SearchEngineImageInformation[0]));
        return entry.getWebImages();
    }

    private static List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile entry, int max) throws XPathExpressionException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        NodeList screenshotNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("screenshot", entry.getXmlElementWithAllImages(), XPathConstants.NODESET);
        for (int i = 0; i < Math.min(screenshotNodes.getLength(), max); ++i) {
            Element screenshotNode = (Element)screenshotNodes.item(i);
            String url = entry.getCoreGameCoverUrl() + XmlUtils.getTextValue(screenshotNode, "original");
            result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.SCREENSHOT, url, ""));
        }
        return result;
    }

    private static List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile entry, int max) throws XPathExpressionException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        NodeList screenshotNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("boxart", entry.getXmlElementWithAllImages(), XPathConstants.NODESET);
        for (int i = 0; i < Math.min(screenshotNodes.getLength(), max); ++i) {
            Element screenshotNode = (Element)screenshotNodes.item(i);
            String url = entry.getCoreGameCoverUrl() + screenshotNode.getFirstChild().getNodeValue();
            String descr = screenshotNode.getAttribute("side");
            result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.COVER_ART, url, descr));
        }
        return result;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance_ = new TheGamesDBSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

