/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.gui.controls.GalleryItemRenderer;
import org.dbgl.gui.controls.Table_;
import org.dbgl.gui.interfaces.ReOrderable;
import org.dbgl.gui.listeners.MeasureListener;
import org.dbgl.gui.listeners.PaintListener;
import org.dbgl.gui.listeners.ToolTipListener;
import org.dbgl.model.ThumbInfo;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ProfilesList {
    private final ProfilesListType type_;
    private final Gallery gallery_;
    private final GalleryItem group_;
    private final Color bgColor_;
    private final Table table_;
    private final Image topdog_;
    private int lastSearchEventTime_;
    private static final Listener paintListener = new PaintListener();
    private static final Listener measureListener = new MeasureListener();
    private static final Listener toolTipOpenListener = new ToolTipListener();
    private static final SettingsService settings = SettingsService.getInstance();

    public ProfilesList(Composite composite, ProfilesListType type) {
        this(composite, type, null, null, null);
    }

    public ProfilesList(Composite composite, ProfilesListType type, ReOrderable reOrderable, int[] columnIds, String[] columnNames) {
        this.type_ = type;
        this.topdog_ = ImageService.getResourceImage(composite.getShell().getDisplay(), "topdog.png");
        if (type == ProfilesListType.TABLE) {
            int i;
            this.table_ = Table_.on(composite).header().multi().build();
            for (i = 0; i < columnIds.length; ++i) {
                this.addProfileColumn(reOrderable, columnIds, columnNames[columnIds[i]], i);
            }
            this.table_.setSortColumn(this.table_.getColumn(ProfilesList.findColumnById(columnIds, settings.getIntValues("gui", "sortcolumn")[0])));
            this.table_.setSortDirection(settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
            this.table_.setColumnOrder(settings.getIntValues("gui", "columnorder"));
            for (i = 0; i < columnIds.length; ++i) {
                if (columnIds[i] != 20) continue;
                this.table_.setData(i);
                this.table_.addListener(42, paintListener);
                this.table_.addListener(41, measureListener);
            }
            this.gallery_ = null;
            this.group_ = null;
            this.bgColor_ = null;
        } else {
            this.table_ = null;
            this.gallery_ = new Gallery(composite, 2562);
            if (DarkTheme.forced()) {
                this.gallery_.setBackground(DarkTheme.inputBackground);
            }
            this.gallery_.setAntialias(0);
            this.gallery_.setLowQualityOnUserAction(true);
            this.gallery_.setHigherQualityDelay(100);
            int[] rgb = settings.getIntValues("gui", "gallerybackgroundcolor");
            if (rgb.length == 3) {
                this.bgColor_ = new Color(rgb[0], rgb[1], rgb[2]);
                this.gallery_.setBackground(this.bgColor_);
            } else {
                this.bgColor_ = null;
            }
            NoGroupRenderer gr = new NoGroupRenderer();
            switch (type) {
                case LARGE_TILES: {
                    gr.setItemSize(settings.getIntValue("gui", "large_tile_width"), settings.getIntValue("gui", "large_tile_height"));
                    break;
                }
                case MEDIUM_TILES: {
                    gr.setItemSize(settings.getIntValue("gui", "medium_tile_width"), settings.getIntValue("gui", "medium_tile_height"));
                    break;
                }
                case SMALL_TILES: {
                    gr.setItemSize(settings.getIntValue("gui", "small_tile_width"), settings.getIntValue("gui", "small_tile_height"));
                    break;
                }
                case LARGE_BOXES: {
                    gr.setItemSize(settings.getIntValue("gui", "large_box_width"), settings.getIntValue("gui", "large_box_height"));
                    break;
                }
                case MEDIUM_BOXES: {
                    gr.setItemSize(settings.getIntValue("gui", "medium_box_width"), settings.getIntValue("gui", "medium_box_height"));
                    break;
                }
                case SMALL_BOXES: {
                    gr.setItemSize(settings.getIntValue("gui", "small_box_width"), settings.getIntValue("gui", "small_box_height"));
                    break;
                }
            }
            gr.setAutoMargin(true);
            gr.setMinMargin(1);
            this.gallery_.setGroupRenderer(gr);
            this.gallery_.setItemRenderer(new GalleryItemRenderer(settings.getValue("gui", "tile_title_trunc_pos")));
            this.group_ = new GalleryItem(this.gallery_, 0);
            this.gallery_.getShell().addListener(27, toolTipOpenListener);
            this.gallery_.addListener(12, toolTipOpenListener);
            this.gallery_.addListener(1, toolTipOpenListener);
            this.gallery_.addListener(5, toolTipOpenListener);
            this.gallery_.addListener(37, toolTipOpenListener);
            this.gallery_.addListener(4, toolTipOpenListener);
            this.gallery_.addListener(32, toolTipOpenListener);
            this.gallery_.addListener(42, paintListener);
            final StringBuilder searchTerm = new StringBuilder(8);
            this.gallery_.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.keyCode >= 97 && e.keyCode <= 122 || e.keyCode >= 48 && e.keyCode <= 57) {
                        if (e.time - ProfilesList.this.lastSearchEventTime_ > 750) {
                            searchTerm.setLength(0);
                        }
                        ProfilesList.this.lastSearchEventTime_ = e.time;
                        searchTerm.append(e.character);
                        GalleryItem item = Stream.of(ProfilesList.this.group_.getItems()).filter(x -> StringUtils.startsWithIgnoreCase(x.getText(), searchTerm)).findFirst().orElse(null);
                        if (item == null) {
                            searchTerm.deleteCharAt(searchTerm.length() - 1);
                        } else {
                            ProfilesList.this.gallery_.setSelection(new GalleryItem[]{item});
                        }
                    }
                }
            });
        }
    }

    private static int findColumnById(int[] columnIds, int id) {
        return IntStream.range(0, columnIds.length).filter(x -> columnIds[x] == id).findFirst().orElse(-1);
    }

    private void addProfileColumn(final ReOrderable reOrderable, int[] columnIds, String title, final int colIndex) {
        final String width = "column" + (columnIds[colIndex] + 1) + "width";
        final TableColumn column = new TableColumn(this.table_, 0);
        column.setWidth(settings.getIntValue("gui", width));
        column.setMoveable(true);
        column.setText(title);
        if (columnIds[colIndex] == 8 || columnIds[colIndex] == 9 || columnIds[colIndex] == 18 || columnIds[colIndex] == 19) {
            column.setAlignment(131072);
        }
        if (columnIds[colIndex] == 20) {
            column.setAlignment(0x1000000);
        }
        column.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ProfilesList.this.table_.setSortDirection(ProfilesList.this.table_.getSortColumn().equals(event.widget) && ProfilesList.this.table_.getSortDirection() == 128 ? 1024 : 128);
                ProfilesList.this.table_.setSortColumn((TableColumn)event.widget);
                reOrderable.doReorder(colIndex, ProfilesList.this.table_.getSortDirection());
            }
        });
        column.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent event) {
                settings.setIntValue("gui", width, column.getWidth());
            }

            @Override
            public void controlMoved(ControlEvent event) {
                if (event.time != 0) {
                    settings.setIntValues("gui", "columnorder", ProfilesList.this.table_.getColumnOrder());
                }
            }
        });
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.addMouseListener(mouseAdapter);
        } else {
            this.gallery_.addMouseListener(mouseAdapter);
        }
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.addKeyListener(keyAdapter);
        } else {
            this.gallery_.addKeyListener(keyAdapter);
        }
    }

    public void addTraverseListener(TraverseListener travListener) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.addTraverseListener(travListener);
        } else {
            this.gallery_.addTraverseListener(travListener);
        }
    }

    public void addSelectionListener(SelectionAdapter selectProfAdapter) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.addSelectionListener(selectProfAdapter);
        } else {
            this.gallery_.addSelectionListener(selectProfAdapter);
        }
    }

    public void setFocus() {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.setFocus();
        } else {
            this.gallery_.setFocus();
        }
    }

    public void setRedraw(boolean b) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.setRedraw(b);
        } else {
            this.gallery_.setRedraw(b);
        }
    }

    public void redraw() {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.redraw();
        } else {
            this.gallery_.redraw();
        }
    }

    public void setMenu(Menu menu) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.setMenu(menu);
        } else {
            this.gallery_.setMenu(menu);
        }
    }

    public int getSelectionCount() {
        return this.type_ == ProfilesListType.TABLE ? this.table_.getSelectionCount() : this.gallery_.getSelectionCount();
    }

    public int getSelectionIndex() {
        if (this.type_ == ProfilesListType.TABLE) {
            return this.table_.getSelectionIndex();
        }
        GalleryItem[] items = this.gallery_.getSelection();
        return items.length == 0 ? -1 : this.group_.indexOf(items[0]);
    }

    public int[] getSelectionIndices() {
        return this.type_ == ProfilesListType.TABLE ? this.table_.getSelectionIndices() : Stream.of(this.gallery_.getSelection()).mapToInt(this.group_::indexOf).filter(x -> x != -1).toArray();
    }

    public void setSelection(int index) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.setSelection(index);
        } else {
            GalleryItem item = this.group_.getItem(index);
            if (item != null) {
                this.gallery_.setSelection(new GalleryItem[]{item});
            }
        }
    }

    public void setSelection(int[] indices) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.setSelection(indices);
        } else {
            this.gallery_.setSelection((GalleryItem[])IntStream.of(indices).mapToObj(this.group_::getItem).filter(Objects::nonNull).toArray(GalleryItem[]::new));
        }
    }

    public int getItemCount() {
        return this.type_ == ProfilesListType.TABLE ? this.table_.getItemCount() : this.group_.getItemCount();
    }

    public ProfilesListItem getItem(int index) {
        return this.type_ == ProfilesListType.TABLE ? new ProfilesListItem(this.table_.getItem(index)) : new ProfilesListItem(this.group_.getItem(index));
    }

    public void removeAll() {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.removeAll();
        } else {
            Stream.of(this.group_.getItems()).forEach(this.group_::remove);
        }
    }

    public void remove(int index) {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.remove(index);
        } else {
            this.group_.remove(index);
        }
    }

    public void selectAll() {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.selectAll();
        } else {
            this.group_.selectAll();
        }
    }

    public ProfilesListItem[] getItems() {
        return this.type_ == ProfilesListType.TABLE ? (ProfilesListItem[])Stream.of(this.table_.getItems()).map(x$0 -> new ProfilesListItem((TableItem)x$0)).toArray(ProfilesListItem[]::new) : (ProfilesListItem[])Stream.of(this.group_.getItems()).map(x$0 -> new ProfilesListItem((GalleryItem)x$0)).toArray(ProfilesListItem[]::new);
    }

    public Control getControl() {
        return this.type_ == ProfilesListType.TABLE ? this.table_ : this.gallery_;
    }

    public void dispose() {
        if (this.type_ == ProfilesListType.TABLE) {
            this.table_.removeListener(42, paintListener);
            this.table_.removeListener(41, measureListener);
            this.table_.dispose();
        } else {
            this.gallery_.getShell().removeListener(27, toolTipOpenListener);
            this.gallery_.removeListener(1, toolTipOpenListener);
            this.gallery_.removeListener(5, toolTipOpenListener);
            this.gallery_.removeListener(37, toolTipOpenListener);
            this.gallery_.removeListener(4, toolTipOpenListener);
            this.gallery_.removeListener(32, toolTipOpenListener);
            this.gallery_.removeListener(42, paintListener);
            this.gallery_.dispose();
        }
    }

    public static enum ProfilesListType {
        TABLE,
        SMALL_TILES,
        MEDIUM_TILES,
        LARGE_TILES,
        SMALL_BOXES,
        MEDIUM_BOXES,
        LARGE_BOXES;

    }

    public class ProfilesListItem {
        private final GalleryItem gItem_;
        private final TableItem tItem_;

        public ProfilesListItem(ProfilesList list) {
            if (list.type_ == ProfilesListType.TABLE) {
                this.gItem_ = null;
                this.tItem_ = new TableItem(list.table_, 2048);
            } else {
                this.gItem_ = new GalleryItem(list.group_, 0);
                this.tItem_ = null;
            }
        }

        public ProfilesListItem(TableItem item) {
            this.gItem_ = null;
            this.tItem_ = item;
        }

        public ProfilesListItem(GalleryItem item) {
            this.gItem_ = item;
            this.tItem_ = null;
        }

        public Object getData() {
            return this.tItem_ != null ? this.tItem_.getData() : this.gItem_.getData();
        }

        public void setData(Object obj) {
            if (this.tItem_ != null) {
                this.tItem_.setData(obj);
            } else {
                this.gItem_.setData(obj);
            }
        }

        public void resetCachedInfo() {
            ThumbInfo thumbInfo = (ThumbInfo)this.getData();
            thumbInfo.resetCachedInfo();
            this.setData(thumbInfo);
            if (this.gItem_ != null) {
                this.gItem_.setImage(null);
            }
        }

        public void setText(int i, int columnId, String columnName, String value) {
            if (this.tItem_ != null) {
                this.tItem_.setText(i, value);
            } else {
                if (i == 0) {
                    this.gItem_.setText(1, "");
                }
                if (columnId == 0) {
                    this.gItem_.setText(value);
                }
                if (columnId == 7) {
                    this.gItem_.setData("org.eclipse.nebula.widget.gallery.bottomLeftOverlay", value.equals(TextService.getInstance().get("general.yes")) ? ProfilesList.this.topdog_ : null);
                }
                if (StringUtils.isEmpty(value)) {
                    return;
                }
                StringBuilder s = new StringBuilder(this.gItem_.getText(1));
                if (!StringUtils.isEmpty(s)) {
                    s.append("\n");
                }
                s.append(columnName).append(": ").append(value);
                this.gItem_.setText(1, s.toString());
            }
        }
    }
}

