/*
 * Decompiled with CFR 0.152.
 */
package exodos;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.interfaces.PreProgressNotifyable;

class AsciiProgressBar
implements PreProgressNotifyable {
    private static final int TITLE_MAX_WIDTH = 68;
    private static final int TITLE_AREA_WIDTH = 70;
    private static final int PROGR_AREA_WIDTH = 34;
    final String title_;
    final long total_;
    long preProgress_;
    long progress_;

    public AsciiProgressBar(String title, long total) {
        this.title_ = title;
        this.total_ = total;
        this.out(this.calc());
    }

    @Override
    public void setTotal(long total) {
    }

    @Override
    public void setProgress(long progress) {
    }

    @Override
    public void incrProgress(long progress) {
        int[] before = this.calc();
        this.progress_ += progress;
        this.preProgress_ = 0L;
        int[] after = this.calc();
        if (!Arrays.equals(before, after)) {
            this.out(after);
        }
    }

    @Override
    public void setPreProgress(long preProgress) {
        int[] before = this.calc();
        this.preProgress_ = preProgress;
        int[] after = this.calc();
        if (!Arrays.equals(before, after)) {
            this.out(after);
        }
    }

    private int[] calc() {
        int progBlocks = (int)((float)this.progress_ / (float)this.total_ * 34.0f);
        int preBlocks = (int)((float)this.preProgress_ / (float)this.total_ * 34.0f);
        return new int[]{progBlocks, preBlocks};
    }

    private void out(int[] values) {
        System.out.print("\r");
        System.out.print(StringUtils.rightPad(StringUtils.abbreviate(this.title_, 68), 70, '.'));
        System.out.print(" ");
        System.out.print(StringUtils.repeat('\u2593', values[0]));
        System.out.print(StringUtils.repeat('\u2592', values[1]));
        System.out.print(StringUtils.repeat('\u2591', 34 - values[0] - values[1]));
    }
}

