/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.DaControlConvertorAdapter;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.List_;
import org.dbgl.gui.controls.Scale_;
import org.dbgl.gui.controls.Spinner_;
import org.dbgl.gui.controls.TextControl_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class Chain {
    private final Builder builder_;
    private boolean isMultiEdit_;
    private boolean initialValueSet_;
    private boolean conflictingValues_;
    private Object initialValue_;
    private Object currentValue_;

    public Chain(Builder builder) {
        this.builder_ = builder;
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public void multiEdit() {
        this.isMultiEdit_ = true;
    }

    public void bindListenersAndSetLabelColor() {
        ModifyListener modifyListener = event -> this.updateLabelColor();
        SelectionAdapter selectionListener = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                Button button;
                if (event.widget instanceof Button && Chain.this.conflictingValues_ && ((button = (Button)event.widget).getStyle() & 0x20) == 32) {
                    if (button.getSelection()) {
                        if (button.getGrayed()) {
                            button.setSelection(false);
                        }
                    } else if (button.getGrayed()) {
                        button.setGrayed(false);
                    } else {
                        button.setGrayed(true);
                        button.setSelection(true);
                    }
                }
                Chain.this.updateLabelColor();
            }
        };
        for (Control cntrl : this.builder_.controls_) {
            if (cntrl instanceof Combo) {
                ((Combo)cntrl).addModifyListener(modifyListener);
                continue;
            }
            if (cntrl instanceof Text) {
                ((Text)cntrl).addModifyListener(modifyListener);
                continue;
            }
            if (cntrl instanceof Button) {
                ((Button)cntrl).addSelectionListener(selectionListener);
                continue;
            }
            if (cntrl instanceof Spinner) {
                ((Spinner)cntrl).addModifyListener(modifyListener);
                continue;
            }
            if (cntrl instanceof Scale) {
                ((Scale)cntrl).addSelectionListener(selectionListener);
                continue;
            }
            if (!(cntrl instanceof org.eclipse.swt.widgets.List)) continue;
            ((org.eclipse.swt.widgets.List)cntrl).addSelectionListener(selectionListener);
        }
        this.updateLabelColor();
    }

    private void updateLabelColor() {
        if (this.hasChangedValue()) {
            Color color = DarkTheme.forced() ? DarkTheme.changedForeground : Display.getDefault().getSystemColor(3);
            this.getLabel().setForeground(color);
            this.getLabel().setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.alteredvalue"));
        } else if (this.conflictingValues_) {
            Color color = DarkTheme.forced() ? DarkTheme.conflictingForeground : Display.getDefault().getSystemColor(4);
            this.getLabel().setForeground(color);
            this.getLabel().setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.conflictingvalues"));
        } else {
            Color color = DarkTheme.forced() ? DarkTheme.defaultForeground : Display.getDefault().getSystemColor(21);
            this.getLabel().setForeground(color);
            this.getLabel().setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.unalteredvalue"));
        }
    }

    public List<Label> getLabels() {
        return this.builder_.labels_;
    }

    public Label getLabel() {
        return this.builder_.labels_.get(0);
    }

    public Text getText() {
        return this.builder_.text_;
    }

    public List<Combo> getCombos() {
        return this.builder_.combos_;
    }

    public Combo getCombo() {
        return this.builder_.combos_.get(0);
    }

    public List<Button> getButtons() {
        return this.builder_.buttons_;
    }

    public Button getButton() {
        return this.builder_.buttons_.get(0);
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.builder_.list_;
    }

    public Spinner getSpinner() {
        return this.builder_.spinner_;
    }

    public List<Scale> getScales() {
        return this.builder_.scales_;
    }

    public Scale getScale() {
        return this.builder_.scales_.get(0);
    }

    public void enableOrDisableControl(TemplateProfileBase configurable) {
        if (StringUtils.isNotBlank(this.builder_.section_)) {
            GenerationAwareConfiguration conf = configurable.getDosboxVersion().getConfiguration();
            boolean dosboxHasConfSetting = conf.hasValue(this.confSection(conf), this.confItem(conf));
            this.builder_.controls_.forEach(x -> x.setEnabled(dosboxHasConfSetting));
            this.builder_.labels_.get(0).setEnabled(dosboxHasConfSetting);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setControlByConfigurable(TemplateProfileBase configurable, Configuration combinedConf) {
        String[] values;
        if (this.builder_.customSectionGetter_ != null) {
            this.setControlByStringValue(this.builder_.customSectionGetter_.apply(configurable));
            return;
        }
        if (this.builder_.nativeCommandsGetter_ != null) {
            this.setControlByNativeCommands(this.builder_.nativeCommandsGetter_.apply(configurable));
            return;
        }
        if (this.builder_.templateStringGetter_ != null) {
            this.setControlByStringValue(this.builder_.templateStringGetter_.apply((Template)configurable));
            return;
        }
        if (this.builder_.profileStringGetter_ != null) {
            this.setControlByStringValue(this.builder_.profileStringGetter_.apply((Profile)configurable));
            return;
        }
        if (this.builder_.profileIndexedStringGetter_ != null) {
            this.setControlByStringValue(this.builder_.profileIndexedStringGetter_.apply((Profile)configurable, this.builder_.index_));
            return;
        }
        if (this.builder_.autoexecStringGetter_ != null) {
            this.setControlByStringValue(this.builder_.autoexecStringGetter_.apply(this.isMultiEdit_ ? configurable.getConfiguration().getAutoexec() : combinedConf.getAutoexec()));
            return;
        }
        if (this.builder_.autoexecIndexedStringGetter_ != null) {
            this.setControlByStringValue(this.builder_.autoexecIndexedStringGetter_.apply(this.isMultiEdit_ ? configurable.getConfiguration().getAutoexec() : combinedConf.getAutoexec(), this.builder_.index_));
            return;
        }
        if (!StringUtils.isNotBlank(this.builder_.section_)) return;
        if (this.allControlsDisabled()) {
            return;
        }
        GenerationAwareConfiguration dosboxConf = configurable.getDosboxVersion().getConfiguration();
        Configuration conf = this.isMultiEdit_ ? configurable.getConfiguration() : combinedConf;
        String[] stringArray = values = conf.hasValue(this.builder_.section_, this.builder_.item_) && conf.hasValue(this.builder_.sectionNew_, this.builder_.itemNew_) ? this.builder_.convertor_.toControlValues(new String[]{conf.getValue(this.builder_.section_, this.builder_.item_), conf.getValue(this.builder_.sectionNew_, this.builder_.itemNew_)}) : this.builder_.convertor_.toControlValues(conf.getValue(this.confSection(dosboxConf), this.confItem(dosboxConf)));
        if (values == null || values.length != this.builder_.controls_.size()) {
            if (!this.isMultiEdit_) {
                this.builder_.controls_.forEach(x -> x.setEnabled(false));
                System.err.println(this.toString() + ": control disabled because of configuration mismatch");
                return;
            }
            for (int i = 0; i < this.builder_.controls_.size(); ++i) {
                this.setFieldValue(this.builder_.controls_.get(i), null);
            }
        } else {
            for (int i = 0; i < this.builder_.controls_.size(); ++i) {
                this.setFieldValue(this.builder_.controls_.get(i), values[i]);
            }
        }
        if (this.initialValueSet_) return;
        this.initialValue_ = this.getCurrentStringValue();
        this.initialValueSet_ = true;
        this.conflictingValues_ = values == null || values.length == 0;
    }

    public void updateConfigurableByControl(TemplateProfileBase configurable, Configuration combinedConf) {
        if (this.builder_.customSectionUpdater_ != null) {
            this.builder_.customSectionUpdater_.accept(configurable, this.getCurrentStringValue());
        } else if (this.builder_.nativeCommandsUpdater_ != null) {
            this.builder_.nativeCommandsUpdater_.accept(configurable, this.getCurrentNativeCommands());
        } else if (this.builder_.templateStringUpdater_ != null) {
            this.builder_.templateStringUpdater_.accept((Template)configurable, this.getCurrentStringValue());
        } else if (this.builder_.profileStringUpdater_ != null) {
            this.builder_.profileStringUpdater_.accept((Profile)configurable, this.getCurrentStringValue());
        } else if (this.builder_.profileIndexedStringUpdater_ != null) {
            this.builder_.profileIndexedStringUpdater_.accept((Profile)configurable, this.builder_.index_, this.getCurrentStringValue());
        } else if (this.builder_.autoexecStringUpdater_ != null) {
            this.builder_.autoexecStringUpdater_.accept(configurable.getConfiguration().getAutoexec(), this.getCurrentStringValue());
        } else if (this.builder_.autoexecIndexedStringUpdater_ != null) {
            this.builder_.autoexecIndexedStringUpdater_.accept(configurable.getConfiguration().getAutoexec(), this.builder_.index_, this.getCurrentStringValue());
        } else if (StringUtils.isNotBlank(this.builder_.section_)) {
            String[] fieldValues = (String[])this.builder_.controls_.stream().map(this::getFieldValue).filter(Objects::nonNull).toArray(String[]::new);
            if (fieldValues.length == 0) {
                return;
            }
            if (combinedConf.hasValue(this.builder_.section_, this.builder_.item_) && combinedConf.hasValue(this.builder_.sectionNew_, this.builder_.itemNew_)) {
                String[] confValues = this.builder_.convertor_.toConfValues(fieldValues);
                configurable.setValue(this.builder_.section_, this.builder_.item_, confValues[0]);
                configurable.setValue(this.builder_.sectionNew_, this.builder_.itemNew_, confValues[1]);
            } else {
                GenerationAwareConfiguration dosboxConf = configurable.getDosboxVersion().getConfiguration();
                String section = this.confSection(dosboxConf);
                String item = this.confItem(dosboxConf);
                String value = this.builder_.convertor_.toConfValue(combinedConf.getValue(section, item), fieldValues);
                configurable.setValue(section, item, value);
            }
        }
    }

    public void setControlByNativeCommands(List<NativeCommand> cmds) {
        if (cmds == null) {
            this.conflictingValues_ = true;
            return;
        }
        this.currentValue_ = cmds;
        org.eclipse.swt.widgets.List nativeCommandsList = (org.eclipse.swt.widgets.List)this.builder_.controls_.get(0);
        nativeCommandsList.setItems((String[])cmds.stream().map(NativeCommand::toString).toArray(String[]::new));
        nativeCommandsList.notifyListeners(13, new Event());
        if (!this.initialValueSet_) {
            this.initialValue_ = cmds;
            this.initialValueSet_ = true;
        }
    }

    private void setControlByStringValue(String value) {
        this.setFieldValue(this.builder_.controls_.get(0), value);
        if (!this.initialValueSet_) {
            this.initialValue_ = this.getCurrentStringValue();
            this.initialValueSet_ = true;
            this.conflictingValues_ = value == null;
        }
    }

    public String getInitialNativeCommandsAsString() {
        return Chain.nativeCommandsToString((List)this.initialValue_);
    }

    public String getInitialStringValue() {
        return (String)this.initialValue_;
    }

    public List<NativeCommand> getCurrentNativeCommands() {
        return (List)this.currentValue_;
    }

    public String getCurrentNativeCommandsAsString() {
        return Chain.nativeCommandsToString(this.getCurrentNativeCommands());
    }

    private static String nativeCommandsToString(List<NativeCommand> obj) {
        if (obj != null) {
            return obj.stream().map(NativeCommand::toString).collect(Collectors.joining("; "));
        }
        return "";
    }

    public String getCurrentStringValue() {
        String[] values = (String[])this.builder_.controls_.stream().map(this::getFieldValue).filter(Objects::nonNull).toArray(String[]::new);
        return values.length == this.builder_.controls_.size() ? this.builder_.convertor_.toConfValue(null, values) : null;
    }

    public String getCurrentStringValueForDisplay() {
        String[] values = (String[])this.builder_.controls_.stream().map(this::getFieldValue).filter(Objects::nonNull).toArray(String[]::new);
        return values.length == this.builder_.controls_.size() ? this.builder_.convertor_.toConfValueForDisplay(values) : "<invalid>";
    }

    public boolean conflictingValues() {
        return this.conflictingValues_;
    }

    public boolean hasChangedValue() {
        if (this.allControlsDisabled()) {
            return false;
        }
        if (this.builder_.nativeCommandsGetter_ != null) {
            return (List)this.initialValue_ != this.getCurrentNativeCommands();
        }
        return !StringUtils.equals(this.getInitialStringValue(), this.getCurrentStringValue());
    }

    private String getFieldValue(Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                String contents = ((Text)control).getText();
                String del = ((Text)control).getLineDelimiter();
                return StringUtils.replace(StringUtils.strip(contents, del), del, SystemUtils.EOLN);
            }
            if (control instanceof Combo) {
                return ((Combo)control).getText();
            }
            if (control instanceof Button && !((Button)control).getGrayed()) {
                boolean v = ((Button)control).getSelection();
                return this.builder_.isOnOff_ ? (v ? "on" : "off") : String.valueOf(v);
            }
            if (control instanceof Scale) {
                return String.valueOf(((Scale)control).getSelection());
            }
            if (control instanceof Spinner) {
                return String.valueOf(((Spinner)control).getSelection());
            }
        }
        return null;
    }

    private void setFieldValue(Control control, String value) {
        if (control.isEnabled()) {
            if (value == null) {
                if (control instanceof Button && (((Button)control).getStyle() & 0x20) == 32) {
                    ((Button)control).setSelection(true);
                    ((Button)control).setGrayed(true);
                }
            } else if (control instanceof Text) {
                String newValue = StringUtils.replace(value, SystemUtils.EOLN, ((Text)control).getLineDelimiter());
                if (!((Text)control).getText().equals(newValue)) {
                    ((Text)control).setText(newValue);
                }
            } else if (control instanceof Combo) {
                if (!((Combo)control).getText().equals(value)) {
                    ((Combo)control).setText(value);
                }
            } else if (control instanceof Button) {
                boolean newValue;
                boolean bl = newValue = this.builder_.isOnOff_ ? "on".equalsIgnoreCase(value) : Boolean.valueOf(value).booleanValue();
                if (((Button)control).getSelection() != newValue || ((Button)control).getGrayed()) {
                    ((Button)control).setSelection(newValue);
                    ((Button)control).notifyListeners(13, new Event());
                }
            } else if (control instanceof Scale) {
                Integer newValue = Integer.valueOf(value);
                if (((Scale)control).getSelection() != newValue.intValue()) {
                    ((Scale)control).setSelection(newValue);
                }
            } else if (control instanceof Spinner) {
                Integer newValue = Integer.valueOf(value);
                if (((Spinner)control).getSelection() != newValue.intValue()) {
                    ((Spinner)control).setSelection(newValue);
                }
            }
        }
    }

    public void setComboValues(Map<String, String> map) {
        this.getCombos().forEach(x -> {
            String item;
            String section = (String)x.getData("dynOptSection");
            if (StringUtils.isNoneBlank(section, item = (String)x.getData("dynOptItem"))) {
                String[] items = SettingsService.getInstance().getValues(section, item);
                if (map != null) {
                    if (map.containsKey(item)) {
                        String[] dbItems = Settings.splitValues((String)map.get(item));
                        if (dbItems != null && dbItems.length > 0) {
                            items = dbItems;
                        } else {
                            System.err.println(this.toString() + ": control not be populated by DOSBox Version dynamic values because it has [" + item + "] set to [" + (String)map.get(item) + "]");
                        }
                    } else {
                        System.err.println(this.toString() + ": control could not be populated by DOSBox Version dynamic values because it's missing [" + item + "]");
                    }
                }
                x.setItems(items);
            }
        });
    }

    private String confSection(Configuration conf) {
        return StringUtils.isNotBlank(this.builder_.sectionNew_) && StringUtils.isNotBlank(this.builder_.itemNew_) && conf.hasValue(this.builder_.sectionNew_, this.builder_.itemNew_) ? this.builder_.sectionNew_ : this.builder_.section_;
    }

    private String confItem(Configuration conf) {
        return StringUtils.isNotBlank(this.builder_.itemNew_) && (conf.hasValue(this.builder_.section_, this.builder_.itemNew_) || StringUtils.isNotBlank(this.builder_.sectionNew_) && conf.hasValue(this.builder_.sectionNew_, this.builder_.itemNew_)) ? this.builder_.itemNew_ : this.builder_.item_;
    }

    private boolean allControlsDisabled() {
        return this.builder_.controls_.stream().noneMatch(Control::isEnabled);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getLabel().getText());
        if (StringUtils.isNotBlank(this.builder_.section_)) {
            result.append(" ([");
            result.append(StringUtils.isNotBlank(this.builder_.sectionNew_) ? this.builder_.sectionNew_ : this.builder_.section_);
            result.append("] ").append(StringUtils.isNotBlank(this.builder_.itemNew_) ? this.builder_.itemNew_ : this.builder_.item_);
            result.append(")");
        }
        return result.toString();
    }

    public static final class Builder {
        private static final DaControlConvertor defaultConvertor = new DaControlConvertorAdapter(){};
        private final Composite composite_;
        private final List<Label> labels_;
        private final List<Control> controls_;
        private Text text_;
        private final List<Combo> combos_;
        private final List<Button> buttons_;
        private org.eclipse.swt.widgets.List list_;
        private Spinner spinner_;
        private final List<Scale> scales_;
        private Function<TemplateProfileBase, String> customSectionGetter_;
        private BiConsumer<TemplateProfileBase, String> customSectionUpdater_;
        private Function<TemplateProfileBase, List<NativeCommand>> nativeCommandsGetter_;
        private BiConsumer<TemplateProfileBase, List<NativeCommand>> nativeCommandsUpdater_;
        private Function<Template, String> templateStringGetter_;
        private BiConsumer<Template, String> templateStringUpdater_;
        private Function<Profile, String> profileStringGetter_;
        private BiFunction<Profile, Integer, String> profileIndexedStringGetter_;
        private BiConsumer<Profile, String> profileStringUpdater_;
        private TriConsumer<Profile, Integer, String> profileIndexedStringUpdater_;
        private Function<Autoexec, String> autoexecStringGetter_;
        private BiConsumer<Autoexec, String> autoexecStringUpdater_;
        private BiFunction<Autoexec, Integer, String> autoexecIndexedStringGetter_;
        private TriConsumer<Autoexec, Integer, String> autoexecIndexedStringUpdater_;
        private int index_;
        private String section_;
        private String sectionNew_;
        private String item_;
        private String itemNew_;
        private boolean isOnOff_;
        private DaControlConvertor convertor_ = defaultConvertor;

        public Builder(Composite composite) {
            this.composite_ = composite;
            this.controls_ = new ArrayList<Control>();
            this.labels_ = new ArrayList<Label>();
            this.combos_ = new ArrayList<Combo>();
            this.buttons_ = new ArrayList<Button>();
            this.scales_ = new ArrayList<Scale>();
        }

        public Builder lbl(UnaryOperator<Label_.Builder> lb) {
            this.labels_.add(((Label_.Builder)lb.apply(Label_.on(this.composite_))).build());
            return this;
        }

        public Builder txt(UnaryOperator<Text_.Builder> tb) {
            this.text_ = ((Text_.Builder)tb.apply(Text_.on(this.composite_))).build();
            this.controls_.add(this.text_);
            return this;
        }

        public Builder cmb(UnaryOperator<Combo_.Builder> cb) {
            Combo combo = ((Combo_.Builder)cb.apply(Combo_.on(this.composite_))).build();
            this.combos_.add(combo);
            this.controls_.add(combo);
            return this;
        }

        public Builder but(UnaryOperator<Button_.Builder> bb) {
            TextControl_ textControl = this.text_ != null ? new TextControl_(this.text_) : (!this.combos_.isEmpty() ? new TextControl_(this.combos_.get(this.combos_.size() - 1)) : null);
            Button button = ((Button_.Builder)bb.apply(Button_.on(this.composite_))).ctrl(textControl);
            this.buttons_.add(button);
            if (IntStream.of(16, 2, 32).anyMatch(x -> (button.getStyle() & x) == x)) {
                this.controls_.add(button);
            }
            return this;
        }

        public Builder lst(UnaryOperator<List_.Builder> lb) {
            this.list_ = ((List_.Builder)lb.apply(List_.on(this.composite_))).build();
            this.controls_.add(this.list_);
            return this;
        }

        public Builder spn(UnaryOperator<Spinner_.Builder> sb) {
            this.spinner_ = ((Spinner_.Builder)sb.apply(Spinner_.on(this.composite_))).build();
            this.controls_.add(this.spinner_);
            return this;
        }

        public Builder scl(UnaryOperator<Scale_.Builder> sb) {
            Scale scale = ((Scale_.Builder)sb.apply(Scale_.on(this.composite_))).build();
            this.scales_.add(scale);
            this.controls_.add(scale);
            return this;
        }

        public Builder section(String section) {
            return this.section(section, null);
        }

        public Builder section(String sectionOld, String sectionNew) {
            this.section_ = sectionOld;
            this.sectionNew_ = sectionNew;
            return this;
        }

        public Builder item(String item) {
            return this.item(item, null);
        }

        public Builder item(String itemOld, String itemNew) {
            this.item_ = itemOld;
            this.itemNew_ = itemNew;
            return this;
        }

        public Builder onOff() {
            this.isOnOff_ = true;
            return this;
        }

        public Builder convert(DaControlConvertor convertor) {
            this.convertor_ = convertor;
            return this;
        }

        public Builder customSection(Function<TemplateProfileBase, String> getMethod, BiConsumer<TemplateProfileBase, String> updateMethod) {
            this.customSectionGetter_ = getMethod;
            this.customSectionUpdater_ = updateMethod;
            return this;
        }

        public Builder nativeCommands(Function<TemplateProfileBase, List<NativeCommand>> getMethod, BiConsumer<TemplateProfileBase, List<NativeCommand>> updateMethod) {
            this.nativeCommandsGetter_ = getMethod;
            this.nativeCommandsUpdater_ = updateMethod;
            return this;
        }

        public Builder template(Function<Template, String> getMethod, BiConsumer<Template, String> updateMethod) {
            this.templateStringGetter_ = getMethod;
            this.templateStringUpdater_ = updateMethod;
            return this;
        }

        public Builder profile(Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
            this.profileStringGetter_ = getMethod;
            this.profileStringUpdater_ = updateMethod;
            return this;
        }

        public Builder profile(int i, BiFunction<Profile, Integer, String> getMethod, TriConsumer<Profile, Integer, String> updateMethod) {
            this.index_ = i;
            this.profileIndexedStringGetter_ = getMethod;
            this.profileIndexedStringUpdater_ = updateMethod;
            return this;
        }

        public Builder autoexec(Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
            this.autoexecStringGetter_ = getMethod;
            this.autoexecStringUpdater_ = updateMethod;
            return this;
        }

        public Builder autoexec(int i, BiFunction<Autoexec, Integer, String> getMethod, TriConsumer<Autoexec, Integer, String> updateMethod) {
            this.index_ = i;
            this.autoexecIndexedStringGetter_ = getMethod;
            this.autoexecIndexedStringUpdater_ = updateMethod;
            return this;
        }

        public Chain build(List<Chain> chains) {
            Chain chain = this.build();
            chains.add(chain);
            return chain;
        }

        public Chain build() {
            return new Chain(this);
        }

        public Label label() {
            return this.build().getLabel();
        }

        public Text text() {
            return this.build().getText();
        }

        public Combo combo() {
            return this.build().getCombo();
        }

        public Button button() {
            return this.build().getButton();
        }

        public org.eclipse.swt.widgets.List list() {
            return this.build().getList();
        }

        public Spinner spinner() {
            return this.build().getSpinner();
        }

        public Scale scale() {
            return this.build().getScale();
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);

        default public TriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after) {
            Objects.requireNonNull(after);
            return (a, b, c) -> {
                this.accept(a, b, c);
                after.accept(a, b, c);
            };
        }
    }
}

