/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import org.dbgl.util.iso.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FatType {
    FAT12(4095L, 1.5f){

        @Override
        public long readEntry(byte[] data, int index) {
            int v = Util.getUInt16(data, (int)((double)index * 1.5));
            return index % 2 == 0 ? (long)(v & 0xFFF) : (long)(v >> 4);
        }
    }
    ,
    FAT16(65535L, 2.0f){

        @Override
        public long readEntry(byte[] data, int index) {
            return Util.getUInt16(data, index * 2);
        }
    }
    ,
    FAT32(0xFFFFFFFFL, 4.0f){

        @Override
        public long readEntry(byte[] data, int index) {
            return Util.getUInt32(data, index * 4);
        }
    };

    private final long eofCluster_;
    private final float entrySize_;

    private FatType(long bitMask, float entrySize) {
        this.eofCluster_ = 0xFFFFFF8L & bitMask;
        this.entrySize_ = entrySize;
    }

    public boolean isEofCluster(long entry) {
        return entry >= this.eofCluster_;
    }

    public float getEntrySize() {
        return this.entrySize_;
    }

    public abstract long readEntry(byte[] var1, int var2);
}

