/*
 * Decompiled with CFR 0.152.
 */
package exodos;

import exodos.AsciiProgressBar;
import exodos.ExoContext;
import exodos.ExoDosVersion;
import exodos.ExoUtils;
import exodos.ZipReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.Filter;
import org.dbgl.model.repository.FilterRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Import {
    private static final String IMPORTER_VERSION = "0.99";
    private static boolean listOnly_ = false;
    private static boolean analyzeOnly_ = false;
    private static boolean skipZips_ = false;
    private static boolean defaultDosboxOnly_ = false;
    private static boolean verboseOutput_ = false;
    private static boolean mediapack_ = false;

    private static void displaySyntax() {
        System.out.println("Use: Import <inputexodosdir> [-l] [-a] [-d] [-v] [game-1] [game-2] [game-N]");
        System.out.println("-l\t\tList game titles and abbreviations, don't import");
        System.out.println("-a\t\tAnalyze only, don't import");
        System.out.println("-d\t\tUse only the default DOSBox version, do not import the ones used in eXoDOS");
        System.out.println("-v\t\tVerbose output");
        System.out.println("-z\t\tDon't import zips (debugging)");
        System.out.println("Optional: game(s) to import based on title or abbreviation");
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("Imports eXoDOS games into DBGL (v0.99)");
        System.out.println();
        if (args.length < 1) {
            Import.displaySyntax();
        }
        File srcDir = new File(args[0]);
        List<String> impTitles = new ArrayList<String>();
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-l")) {
                    listOnly_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-a")) {
                    analyzeOnly_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    defaultDosboxOnly_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-v")) {
                    verboseOutput_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-z")) {
                    skipZips_ = true;
                    continue;
                }
                impTitles.add(args[i].toLowerCase());
            }
        }
        if (listOnly_) {
            System.out.println("* List only");
        }
        if (analyzeOnly_) {
            System.out.println("* Analyze only");
        }
        if (defaultDosboxOnly_) {
            System.out.println("* Default DOSBox version only");
        }
        if (verboseOutput_) {
            System.out.println("* Verbose output");
        }
        if (skipZips_) {
            System.out.println("* Don't import zips");
        }
        if (!impTitles.isEmpty()) {
            System.out.println("* Processing: " + StringUtils.join(impTitles, ", "));
        } else {
            System.out.println("* Processing all games");
        }
        ExoContext ctx = new ExoContext(srcDir);
        if (ctx.version() == ExoDosVersion.UNKNOWN) {
            System.out.println("The eXoDOS version could not be determined.");
            System.exit(1);
        }
        System.out.println("* eXoDOS " + String.valueOf((Object)ctx.version()) + " found");
        mediapack_ = ctx.isMediapackAvailable();
        if (mediapack_) {
            System.out.println("* eXoDOS Media Add On Pack found");
        }
        try {
            List<ZipEntry> xodosZipEntries = ExoUtils.listEntries(ctx.xoMetadataZipFile(), true);
            NodeList gameNodes = ExoUtils.getGameNodes(xodosZipEntries, ctx);
            impTitles = ExoUtils.determineTitles(impTitles, gameNodes);
            if (!impTitles.isEmpty()) {
                System.out.println("* Games: " + StringUtils.join(impTitles, ", "));
            }
            new Import().importData(xodosZipEntries, gameNodes, impTitles, ctx);
            DatabaseService.getInstance().shutdown();
        }
        catch (SQLException xodosZipEntries) {
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importData(List<ZipEntry> xodosZipEntries, NodeList gameNodes, List<String> impTitles, ExoContext ctx) {
        List<ZipEntry> dosZipEntries = ExoUtils.listEntries(ctx.metadataZipFile(), true);
        List<ZipEntry> dosboxConfEntries = dosZipEntries.parallelStream().filter(x -> x.getName().toLowerCase().endsWith("dosbox.conf")).toList();
        List<ZipEntry> imageEntries = xodosZipEntries.parallelStream().filter(x -> x.getName().startsWith(ctx.xoMetadataImages())).toList();
        List<Integer> gameIndices = ExoUtils.determineGameIndices(gameNodes);
        try (ZipFile xodosZipfile = new ZipFile(ctx.xoMetadataZipFile(), ExoUtils.CP437);
             ZipFile dosZipfile = new ZipFile(ctx.metadataZipFile(), ExoUtils.CP437);){
            DosboxVersion defaultDosboxVersion;
            Map<String, DosboxVersion> gameDosboxversionMap = !ctx.hasDosboxVersions() || listOnly_ || analyzeOnly_ || defaultDosboxOnly_ ? null : ExoUtils.ensureGameDosboxversions(null, impTitles, ctx);
            DosboxVersion dosboxVersion = defaultDosboxVersion = gameDosboxversionMap == null ? ExoUtils.findDefaultDosboxVersion(verboseOutput_) : null;
            if (ctx.hasRoms() && !listOnly_ && !analyzeOnly_ && !skipZips_) {
                this.ensureRoms(ctx);
            }
            if (ctx.hasDemoVideos() && !listOnly_ && !analyzeOnly_ && !skipZips_) {
                System.out.println("Importing videos ...");
                ExoUtils.extractMedia(ctx.demoVideosZipFile(), ctx.demoVideoEntries(), "eXo/Videos", ExoContext.IMPORT_VIDEOS_DIR, "Videos");
            }
            if (mediapack_ && !listOnly_ && !analyzeOnly_ && impTitles.isEmpty() && !skipZips_) {
                System.out.println("Importing Media Add On Pack ...");
                ExoUtils.extractInnerMedia(ctx.soundtracksZipFile(), ctx.soundtrackEntries(), "eXo/Soundtracks", ExoContext.IMPORT_SOUNDTRACKS_DIR, "Soundtracks");
                ExoUtils.extractMedia(ctx.booksZipFile(), ctx.bookEntries(), "eXo/Books", ExoContext.IMPORT_BOOKS_DIR, "Books");
                ExoUtils.extractMedia(ctx.catalogsZipFile(), ctx.catalogEntries(), "eXo/Catalogs", ExoContext.IMPORT_CATALOGS_DIR, "Catalogs");
                ExoUtils.extractMedia(ctx.magazinesZipFile(), ctx.magazineEntries(), "eXo/Magazines", ExoContext.IMPORT_MAGAZINES_DIR, "Magazines");
                if (FilesUtils.isExistingFile(ctx.videosZipFile())) {
                    ExoUtils.extractMedia(ctx.videosZipFile(), ctx.videoEntries(), "eXo/Videos", ExoContext.IMPORT_VIDEOS_DIR, "Videos");
                }
            }
            TreeMap<String, Set> filters = new TreeMap<String, Set>();
            int processed = 0;
            for (int i = 0; i < gameNodes.getLength(); ++i) {
                Collection<ZipEntry> gameImageEntries;
                String gameDirName;
                Element gameNode = (Element)gameNodes.item(gameIndices.get(i));
                String gameApplicationPath = XmlUtils.getTextValue(gameNode, "ApplicationPath");
                String fullGameTitle = FilenameUtils.getBaseName(gameApplicationPath);
                if (StringUtils.isBlank(fullGameTitle) || !impTitles.isEmpty() && !impTitles.contains(fullGameTitle)) continue;
                String gameTitle = StringUtils.defaultString(XmlUtils.getTextValue(gameNode, "Title"));
                String cleanedUpGameTitle = ExoUtils.cleanupGameTitle(gameTitle);
                File gamePath = ExoUtils.fixupGamePath(gameTitle, new File(FilenameUtils.separatorsToSystem(gameApplicationPath)).getParentFile(), ctx, verboseOutput_);
                String string = gameDirName = gamePath != null ? gamePath.getName() : "";
                if (listOnly_) {
                    System.out.println(String.format("%4d %-50s %-50s %-10s", i + 1, gameTitle, fullGameTitle, gameDirName));
                    continue;
                }
                String gameZipFilename = fullGameTitle + ".zip";
                File gameSrcZipfile = ctx.gameZipFile(gameZipFilename);
                if (!FilesUtils.isExistingFile(gameSrcZipfile)) {
                    System.err.println(fullGameTitle + ": Zip file " + String.valueOf(gameSrcZipfile) + " is missing, skipping");
                    continue;
                }
                String confPathAndFile = FilenameUtils.separatorsToUnix(new File(gamePath, "dosbox.conf").getPath());
                ZipEntry confEntry = dosboxConfEntries.parallelStream().filter(x -> x.getName().equalsIgnoreCase(confPathAndFile)).findAny().orElse(null);
                if (confEntry == null) {
                    System.err.println(fullGameTitle + ": Zip file " + dosZipfile.getName() + " does not contain " + confPathAndFile + ", skipping");
                    continue;
                }
                HashSet<String> playlists = new HashSet<String>();
                if (ctx.hasPlaylists()) {
                    String[] seriesValues;
                    String series = XmlUtils.getTextValue(gameNode, "Series");
                    for (String serieValue : seriesValues = StringUtils.split(series, ';')) {
                        String[] kv = StringUtils.split(serieValue, ':');
                        if (!"Playlist".equals(StringUtils.trim(kv[0]))) continue;
                        playlists.add(StringUtils.trim(kv[1]));
                    }
                }
                if ((gameImageEntries = ExoUtils.getUniqueImages(imageEntries, cleanedUpGameTitle)).isEmpty() && verboseOutput_) {
                    System.out.println(fullGameTitle + ": No images found");
                }
                List<ZipReference> gameCombinedExtraEntries = ctx.extrasInXoDosMetadata() ? ExoUtils.getGameCombinedExtrasV5(xodosZipfile, xodosZipEntries, dosZipfile, dosZipEntries, cleanedUpGameTitle, fullGameTitle, gameDirName, ctx) : ExoUtils.getGameCombinedExtrasV6(gameZipFilename, gameDirName, ctx);
                try (ZipFile gameZipfile = new ZipFile(gameSrcZipfile, ExoUtils.CP437);){
                    List<ZipEntry> gameZipEntries = ExoUtils.listEntries(gameZipfile, false);
                    DosboxVersion db = gameDosboxversionMap == null ? defaultDosboxVersion : (gameDosboxversionMap.containsKey(fullGameTitle) ? gameDosboxversionMap.get(fullGameTitle) : (DosboxVersion)gameDosboxversionMap.entrySet().stream().filter(x -> ((String)x.getKey()).equalsIgnoreCase(fullGameTitle)).map(x -> (DosboxVersion)x.getValue()).findAny().orElse(null));
                    Profile profile = ExoUtils.createProfile(gameNode, fullGameTitle, gameTitle, gamePath, gameDirName, db, confEntry, dosZipfile, gameSrcZipfile.getPath(), gameZipEntries, gameCombinedExtraEntries, ctx, verboseOutput_);
                    if (profile.getConfiguration().getAutoexec().isExit().booleanValue() && profile.isIncomplete()) {
                        System.out.println(fullGameTitle + ": WARNING - autoexec is incomplete");
                    }
                    if (analyzeOnly_) continue;
                    profile = new ProfileRepository().add(profile);
                    for (String playlist : playlists) {
                        Set profileIds = filters.getOrDefault(playlist, new HashSet());
                        profileIds.add(profile.getId());
                        filters.put(playlist, profileIds);
                    }
                    AsciiProgressBar prog = new AsciiProgressBar(fullGameTitle, Stream.of(gameImageEntries, gameZipEntries).flatMap(Collection::stream).mapToLong(ZipEntry::getSize).sum() + gameCombinedExtraEntries.stream().mapToLong(x1 -> x1.zipEntry_.getSize()).sum());
                    File canonicalGamePath = new File(FileLocationService.getInstance().getDosroot(), gameDirName);
                    if (!gameImageEntries.isEmpty() && !skipZips_) {
                        ExoUtils.unzip(xodosZipfile, gameImageEntries, profile.getCanonicalCaptures(), false, true, prog, verboseOutput_);
                    }
                    if (!gameCombinedExtraEntries.isEmpty() && !skipZips_) {
                        if (ctx.extrasInXoDosMetadata()) {
                            ExoUtils.unzip(gameCombinedExtraEntries, new File(canonicalGamePath, "Extras"), prog, verboseOutput_);
                        } else {
                            try (ZipFile extraGameDataZipfile = new ZipFile(gameCombinedExtraEntries.get((int)0).zipFile_.getName(), ExoUtils.CP437);){
                                List<ZipReference> map = gameCombinedExtraEntries.stream().map(x -> new ZipReference(extraGameDataZipfile, x.zipEntry_, x.name_)).toList();
                                ExoUtils.unzip(map, new File(canonicalGamePath, "Extras"), prog, verboseOutput_);
                            }
                        }
                    }
                    if (!skipZips_) {
                        ExoUtils.unzip(gameZipfile, gameZipEntries, canonicalGamePath, true, false, prog, verboseOutput_);
                    }
                    double p = impTitles != null && !impTitles.isEmpty() ? (double)(++processed) / (double)impTitles.size() * 100.0 : (double)(i + 1) / (double)gameNodes.getLength() * 100.0;
                    System.out.println(String.format("\r%s Imported. Overall progress: %5.1f%%", StringUtils.rightPad(StringUtils.abbreviate(fullGameTitle, 68), 70, '.'), p));
                    continue;
                }
            }
            if (impTitles.isEmpty()) {
                FilterRepository repo = new FilterRepository();
                for (Map.Entry entry : filters.entrySet()) {
                    System.out.print("Creating filter " + (String)entry.getKey() + " ... ");
                    repo.add(new Filter((String)entry.getKey(), "GAM.ID IN (" + StringUtils.join((Iterable)entry.getValue(), ',') + ")"));
                    System.out.println("done");
                }
            }
            System.out.println("\n\nFinished.");
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void ensureRoms(ExoContext ctx) {
        System.out.print("Importing Roland MT-32 roms and SC-55 soundfont ...");
        try (ZipFile utilZipFile = new ZipFile(ctx.utilZipFile());
             ZipInputStream zin = new ZipInputStream(utilZipFile.getInputStream(utilZipFile.getEntry(ctx.utilExtZip())), ExoUtils.CP437);){
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                if (ze.isDirectory() || !ze.getName().startsWith("mt32")) continue;
                File dstFile = FileLocationService.getInstance().dosrootRelative().canonicalize(new File(ze.getName()));
                dstFile.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(dstFile);){
                    zin.transferTo(out);
                    System.out.print(".");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("There was a problem extracting " + String.valueOf(ctx.utilZipFile()));
        }
        System.out.println(" done");
    }
}

