/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.SearchEngineSelector;
import org.dbgl.gui.controls.TextControl_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.model.repository.TitledEntityRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public abstract class EditProfileDialog<T>
extends EditConfigurableDialog<T> {
    protected String[] developersList_;
    protected String[] publishersList_;
    protected String[] genresList_;
    protected String[] yearsList_;
    protected String[] statusList_;
    protected List<String[]> customList_;
    protected List<Template> templatesList_;
    protected Text title_;
    protected Text notes_;
    protected SearchEngineSelector engineSelector_;
    protected Text[] link_;
    protected Text[] linkTitle_;
    protected Button[] linkBrowseButton_;
    protected Combo developer_;
    protected Combo publisher_;
    protected Combo genre_;
    protected Combo year_;
    protected Scale custom9_;
    protected Combo templateCombo_;
    protected Button loadfix_;
    protected Combo loadfixValue_;
    protected Text img1_;
    protected Text img2_;
    protected Text img3_;
    protected Text main_;
    protected Text setup_;
    protected Composite webImagesSpaceHolder_;
    protected SearchEngineImageInformation[] imageInformation_;
    protected Button[] imgButtons_;
    protected int templateIndex_;

    protected EditProfileDialog(Shell parent) {
        super(parent, "profiledialog");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            TemplateRepository templRepo = new TemplateRepository();
            TitledEntityRepository titledRepo = new TitledEntityRepository();
            this.templatesList_ = templRepo.listAll(this.dbversionsList_);
            this.developersList_ = titledRepo.developers();
            this.publishersList_ = titledRepo.publishers();
            this.genresList_ = titledRepo.genres();
            this.yearsList_ = titledRepo.years();
            this.statusList_ = titledRepo.statuses();
            this.customList_ = new ArrayList<String[]>();
            for (int i = 0; i < 4; ++i) {
                this.customList_.add(titledRepo.customValues(i));
            }
            this.templateIndex_ = BaseRepository.indexOfDefault(this.templatesList_);
            return true;
        }
        catch (Exception e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    protected Composite createInfoPage(TemplateProfileBase configurable, Composite parent, boolean focusOnTitle) {
        Composite composite = this.createPage("dialog.template.tab.info", parent, 6);
        this.title_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.title")).txt(t -> (Text_.Builder)t.horSpan(4)).profile(TitledEntity::getTitle, TitledEntity::setTitle).build(this.metaControls_).init(configurable).getText();
        ToolBar toolBar = EditProfileDialog.createToolBar(composite);
        this.engineSelector_ = new SearchEngineSelector(toolBar, false);
        this.developer_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.developer")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.developersList_)).profile(Profile::getDeveloper, Profile::setDeveloper).build(this.metaControls_).init(configurable).getCombo();
        this.publisher_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.publisher")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.publishersList_)).profile(Profile::getPublisher, Profile::setPublisher).build(this.metaControls_).init(configurable).getCombo();
        this.genre_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.genre")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.genresList_)).profile(Profile::getGenre, Profile::setGenre).build(this.metaControls_).init(configurable).getCombo();
        this.year_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.year")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.yearsList_)).profile(Profile::getYear, Profile::setYear).build(this.metaControls_).init(configurable).getCombo();
        this.link_ = new Text[8];
        this.linkBrowseButton_ = new Button[8];
        this.linkTitle_ = new Text[8];
        for (int i = 0; i < 8; ++i) {
            int j = i + 1;
            Chain chnLink = Chain.on(composite).lbl(l -> l.key("dialog.profile.link", new Object[]{j})).txt(t -> t).profile(i, Profile::getLinkDestination, Profile::setLinkDestination).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOC, false)).build(this.metaControls_).init(configurable);
            this.link_[i] = chnLink.getText();
            this.linkBrowseButton_[i] = chnLink.getButton();
            this.linkTitle_[i] = Chain.on(composite).lbl(l -> l.key("dialog.profile.linktitle")).txt(t -> (Text_.Builder)t.horSpan(2)).profile(i, Profile::getLinkTitle, Profile::setLinkTitle).build(this.metaControls_).init(configurable).getText();
        }
        Chain.on(composite).lbl(l -> l.key("dialog.profile.status")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.statusList_)).profile(Profile::getStatus, Profile::setStatus).build(this.metaControls_).init(configurable);
        Chain.on(composite).lbl(l -> l.key("dialog.profile.favorite")).but(b -> (Button_.Builder)b.layoutData(new GridData(4, 0x1000000, true, false))).lbl(l -> l).profile(Profile::getFavorite, Profile::setFavorite).build(this.metaControls_).init(configurable);
        this.notes_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.notes")).txt(t -> ((Text_.Builder)t.horSpan(5)).multi().wrap()).profile(Profile::getNotes, Profile::setNotes).build(this.metaControls_).init(configurable).getText();
        this.notes_.setFont(EditProfileDialog.stringToFont(this.display_, this.settings_.getValues("gui", "notesfont"), this.notes_.getFont()));
        this.notes_.addDisposeListener(e -> this.notes_.getFont().dispose());
        if (focusOnTitle) {
            this.title_.selectAll();
            this.title_.setFocus();
        }
        return composite;
    }

    protected Composite createCustomInfoPage(TemplateProfileBase configurable, Composite parent) {
        int j;
        int i;
        Composite composite = this.createPage("dialog.template.tab.info", "dialog.profile.tab.custominfo", parent, 2);
        for (i = 0; i < 4; ++i) {
            j = i + 1;
            Chain.on(composite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom" + j))).cmb(c -> c.autoSelect(this.customList_.get(j - 1))).profile(i, Profile::getCustomString, Profile::setCustomString).build(this.metaControls_).init(configurable);
        }
        for (i = 0; i < 4; ++i) {
            j = i + 1;
            Chain.on(composite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom" + (j + 4)))).txt(t -> t).profile(i + 4, Profile::getCustomString, Profile::setCustomString).build(this.metaControls_).init(configurable);
        }
        for (i = 0; i < 4; ++i) {
            j = i + 1;
            Chain.on(composite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom" + (j + 4 + 2 + 4)))).txt(t -> t).profile(i + 4 + 4, Profile::getCustomString, Profile::setCustomString).build(this.metaControls_).init(configurable);
        }
        this.custom9_ = Chain.on(composite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom9"))).scl(s -> s).profile(0, Profile::getCustomInt, Profile::setCustomInt).build(this.metaControls_).init(configurable).getScale();
        Chain.on(composite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom10"))).spn(s -> s).profile(1, Profile::getCustomInt, Profile::setCustomInt).build(this.metaControls_).init(configurable);
        return composite;
    }

    @Override
    protected Composite createDosboxPage(TemplateProfileBase configurable, Composite parent, String capturesText, String configFileText) {
        Composite composite = super.createDosboxPage(configurable, parent, capturesText, configFileText);
        Group associationGroup = (Group)composite.getChildren()[2];
        this.templateCombo_ = Chain.on(associationGroup).lbl(l -> l.key("dialog.profile.template")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).wide().items((String[])this.templatesList_.stream().map(TitledEntity::getTitle).toArray(String[]::new)).select(this.templateIndex_).visibleItemCount(20)).combo();
        Button_.on(associationGroup).text().key("dialog.profile.loadsettings").tooltip("dialog.profile.loadsettings.tooltip").listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.templateCombo_.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton_.isEnabled()) {
                        Mess_.on(EditProfileDialog.this.shell_).key("dialog.template.required.dosboxassociation").bind((Control)EditProfileDialog.this.setButton_, EditProfileDialog.this.getTreeItemByControl(EditProfileDialog.this.setButton_)).valid();
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction.LOAD_TEMPLATE, (DosboxVersion)EditProfileDialog.this.dbversionsList_.get(EditProfileDialog.this.dbversionCombo_.getSelectionIndex()));
                }
            }
        }).ctrl();
        Button_.on(associationGroup).text().key("dialog.profile.reloadsettings").tooltip("dialog.profile.reloadsettings.tooltip").listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.templateCombo_.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton_.isEnabled()) {
                        Mess_.on(EditProfileDialog.this.shell_).key("dialog.template.required.dosboxassociation").bind((Control)EditProfileDialog.this.setButton_, EditProfileDialog.this.getTreeItemByControl(EditProfileDialog.this.setButton_)).valid();
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction.RELOAD_TEMPLATE, (DosboxVersion)EditProfileDialog.this.dbversionsList_.get(EditProfileDialog.this.dbversionCombo_.getSelectionIndex()));
                }
            }
        }).ctrl().setEnabled(this.dbversionIndex_ != -1);
        return composite;
    }

    @Override
    protected void createMemoryPageAdditions(TemplateProfileBase configurable, Composite composite) {
        this.loadfix_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.loadfix")).but(b -> b.tooltip("dialog.profile.loadfix.tooltip")).autoexec(Autoexec::getLoadfix, Autoexec::setLoadfix).build(this.metaControls_).init(configurable).getButton();
        this.loadfixValue_ = Chain.on(composite).cmb(c -> c.tooltip("dialog.profile.loadfixvalue.tooltip").editable().items("profile", "loadfix_value")).lbl(l -> l.key("dialog.profile.kb")).autoexec(Autoexec::getLoadfixValueAsString, Autoexec::setLoadfixValue).build(this.metaControls_).init(configurable).getCombo();
        this.loadfix_.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                EditProfileDialog.this.loadfixValue_.setEnabled(EditProfileDialog.this.loadfix_.getSelection());
            }
        });
        this.loadfixValue_.setEnabled(this.loadfix_.getSelection());
        Chain.on(composite).lbl(l -> l.key("dialog.profile.loadhigh")).but(b -> (Button_.Builder)b.tooltip("dialog.profile.loadhigh.tooltip").horSpan(3)).autoexec(Autoexec::getLoadhigh, Autoexec::setLoadhigh).build(this.metaControls_).init(configurable);
    }

    @Override
    protected Composite createMountingPage(TemplateProfileBase configurable, Composite parent, boolean multiEdit) {
        Composite composite = super.createMountingPage(configurable, parent, multiEdit);
        final Group executeGroup = (Group)composite.getChildren()[composite.getChildren().length - 1];
        final Composite dosComposite = ((Composite_.Builder)Composite_.on(executeGroup).horSpan(2)).grabHorSpace().innerLayout(7).build();
        this.main_ = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.mainexe")).txt(t -> (Text_.Builder)t.horSpan(4)).autoexec(Autoexec::getMain, Autoexec::setMain).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).but(b -> b.grab(this.mountingpointsList_, false)).build(this.metaControls_).init(configurable).getText();
        Chain.on(dosComposite).lbl(l -> l).lbl(l -> l.key("dialog.profile.mainparameters")).txt(t -> (Text_.Builder)t.horSpan(5)).autoexec(Autoexec::getParameters, Autoexec::setParameters).build(this.metaControls_).init(configurable);
        Chain setupChain = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.setupexe")).txt(t -> (Text_.Builder)t.horSpan(4)).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).profile(Profile::getSetupString, Profile::setSetupFileLocation).but(b -> b.grab(this.mountingpointsList_, false)).build(this.metaControls_).init(configurable);
        this.setup_ = setupChain.getText();
        Chain.on(dosComposite).lbl(l -> l).lbl(l -> l.key("dialog.profile.setupparameters")).txt(t -> (Text_.Builder)t.horSpan(5)).profile(Profile::getSetupParams, Profile::setSetupParams).build(this.metaControls_).init(configurable);
        Text alt1 = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.altexe", new Object[]{1})).txt(t -> (Text_.Builder)t.horSpan(2)).profile(0, Profile::getAltExeString, Profile::setAltExeFileLocation).build(this.metaControls_).init(configurable).getText();
        Chain alt1Chain = Chain.on(dosComposite).lbl(l -> l).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).profile(0, Profile::getAltExeParam, Profile::setAltExeParam).but(b -> b.grab(this.mountingpointsList_, false)).build(this.metaControls_).init(configurable);
        Text alt2 = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.altexe", new Object[]{2})).txt(t -> (Text_.Builder)t.horSpan(2)).profile(1, Profile::getAltExeString, Profile::setAltExeFileLocation).build(this.metaControls_).init(configurable).getText();
        Chain alt2Chain = Chain.on(dosComposite).lbl(l -> l).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).profile(1, Profile::getAltExeParam, Profile::setAltExeParam).but(b -> b.grab(this.mountingpointsList_, false)).build(this.metaControls_).init(configurable);
        final Composite booterComposite = ((Composite_.Builder)Composite_.on(executeGroup).horSpan(2)).grabHorSpace().innerLayout(4).build();
        Chain img1Chain = Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterimage1")).txt(t -> t).autoexec(Autoexec::getImg1, Autoexec::setImg1).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.BOOTER, false)).but(b -> b.grab(this.mountingpointsList_, true)).build(this.metaControls_).init(configurable);
        this.img1_ = img1Chain.getText();
        Chain img2Chain = Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterimage2")).txt(t -> t).autoexec(Autoexec::getImg2, Autoexec::setImg2).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.BOOTER, false)).but(b -> b.grab(this.mountingpointsList_, true)).build(this.metaControls_).init(configurable);
        this.img2_ = img2Chain.getText();
        Chain img3Chain = Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterimage3")).txt(t -> t).autoexec(Autoexec::getImg3, Autoexec::setImg3).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.BOOTER, false)).but(b -> b.grab(this.mountingpointsList_, true)).build(this.metaControls_).init(configurable);
        this.img3_ = img3Chain.getText();
        Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterdriveletter")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).items(new String[]{"", "A", "C", "D"}).visibleItemCount(4)).autoexec(Autoexec::getImgDriveletter, Autoexec::setImgDriveletter).build(this.metaControls_).init(configurable);
        for (int i = 0; i < 8; ++i) {
            this.linkBrowseButton_[i].setData("altControl", this.main_);
        }
        img1Chain.getButton().setData("altControl", this.main_);
        img2Chain.getButton().setData("altControl", this.img1_);
        img3Chain.getButton().setData("altControl", this.img1_);
        setupChain.getButton().setData("altControl", this.main_);
        alt1Chain.getButtons().get(0).setData("control", new TextControl_(alt1));
        alt1Chain.getButtons().get(1).setData("control", new TextControl_(alt1));
        alt1Chain.getButton().setData("altControl", this.main_);
        alt2Chain.getButtons().get(0).setData("control", new TextControl_(alt2));
        alt2Chain.getButtons().get(1).setData("control", new TextControl_(alt2));
        alt2Chain.getButton().setData("altControl", this.main_);
        this.dosRadio_.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.showAndHide(executeGroup, dosComposite, booterComposite, true);
            }
        });
        this.booterRadio_.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                EditProfileDialog.this.showAndHide(executeGroup, dosComposite, booterComposite, false);
            }
        });
        this.showAndHide(executeGroup, dosComposite, booterComposite, configurable.getCombinedConfiguration().getAutoexec().isDos());
        if (multiEdit) {
            this.dosRadio_.setEnabled(false);
            this.booterRadio_.setEnabled(false);
            Stream.of(booterComposite.getChildren()).forEach(x -> x.setEnabled(false));
            Stream.of(dosComposite.getChildren()).forEach(x -> x.setEnabled(false));
        }
        this.createMountingPageAdditions(configurable, composite);
        return composite;
    }

    private void showAndHide(Group executeGroup, Composite dosComposite, Composite booterComposite, boolean dos) {
        dosComposite.setVisible(dos);
        ((GridData)dosComposite.getLayoutData()).exclude = !dos;
        booterComposite.setVisible(!dos);
        ((GridData)booterComposite.getLayoutData()).exclude = dos;
        executeGroup.layout(true, true);
    }
}

