/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.factory.TemplateFactory;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class EditTemplateDialog
extends EditConfigurableDialog<Template> {
    private static final boolean MULTI_EDIT = false;
    private Text title_;
    private Template template_;
    private final boolean editing_;

    public EditTemplateDialog(Shell parent, Template template) {
        super(parent, "templatedialog");
        this.template_ = template;
        this.editing_ = this.template_ != null;
    }

    @Override
    protected String getDialogTitle() {
        return this.editing_ ? this.text_.get("dialog.template.title.edit", new Object[]{this.template_.getTitle(), this.template_.getId()}) : this.text_.get("dialog.template.title.add");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            if (this.editing_) {
                this.dbversionIndex_ = BaseRepository.indexOf(this.dbversionsList_, this.template_.getDosboxVersion());
            } else {
                this.template_ = TemplateFactory.create((DosboxVersion)BaseRepository.findDefault(this.dbversionsList_));
            }
            String warningsLog = this.template_.resetAndLoadConfiguration();
            if (StringUtils.isNotBlank(warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog).warning();
            }
            return true;
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    @Override
    protected void doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction action, DosboxVersion newDosboxVersion) {
        try {
            this.computeAllPages(this.template_);
            this.updateConfigurableByControls(this.template_);
            StringBuilder warningsLog = new StringBuilder(newDosboxVersion.resetAndLoadConfiguration());
            if (action == EditConfigurableDialog.DosboxConfAction.SET) {
                warningsLog.append(this.template_.setToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.SWITCH) {
                warningsLog.append(this.template_.switchToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD) {
                warningsLog.append(this.template_.reloadDosboxVersion(newDosboxVersion));
            }
            this.updateControlsByConfigurable(this.template_);
            if (StringUtils.isNotEmpty(warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
        }
    }

    @Override
    protected void onShellCreated() {
        TreeItem infoItem = this.addPageGenerator("dialog.template.tab.info", this::createInfoPage);
        this.addPageGenerator("dialog.template.tab.mounting", this::createMountingPage);
        TreeItem dosboxItem = this.addPageGenerator("dialog.template.tab.dosbox", this::createDosboxPage);
        this.addCommonPageGenerators(dosboxItem);
        Stream.of(this.tree_.getItems()).forEach(x -> x.setExpanded(true));
        this.tree_.addListener(13, event -> this.renderPage(this.template_, event.item));
        if (SystemUtils.IS_OSX) {
            this.tree_.setSelection(infoItem);
            this.renderPage(this.template_, infoItem);
        }
        this.createOkCancelButtons();
    }

    protected Composite createInfoPage(TemplateProfileBase configurable, Composite parent) {
        Composite composite = this.createPage("dialog.template.tab.info", parent, 2);
        this.title_ = Chain.on(composite).lbl(l -> l.key("dialog.template.title")).txt(t -> t).template(TitledEntity::getTitle, TitledEntity::setTitle).build(this.metaControls_).init(configurable).getText();
        Chain.on(composite).lbl(l -> l.key("dialog.template.default")).but(b -> (Button_.Builder)b.horSpan(1)).template(Template::getDefault, Template::setDefault).build(this.metaControls_).init(configurable);
        if (!this.editing_) {
            this.title_.setFocus();
        }
        return composite;
    }

    protected Composite createMountingPage(TemplateProfileBase configurable, Composite parent) {
        Composite composite = super.createMountingPage(configurable, parent, false);
        this.createMountingPageAdditions(configurable, composite);
        return composite;
    }

    protected Composite createDosboxPage(TemplateProfileBase configurable, Composite parent) {
        return super.createDosboxPage(configurable, parent, this.text_.get("dialog.profile.automatic"), this.editing_ ? this.template_.getConfigurationCanonicalFile().getPath() : SettingsDialog.getConfFilenames().get(0));
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.computePage(EditTemplateDialog.this.template_, "dialog.template.tab.mounting");
                EditTemplateDialog.this.computePage(EditTemplateDialog.this.template_, "dialog.template.tab.dosbox");
                EditTemplateDialog.this.computePage(EditTemplateDialog.this.template_, "dialog.template.tab.startup");
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    EditTemplateDialog.this.updateConfigurableByControls(EditTemplateDialog.this.template_);
                    if (EditTemplateDialog.this.editing_) {
                        new TemplateRepository().update(EditTemplateDialog.this.template_);
                        EditTemplateDialog.this.result_ = EditTemplateDialog.this.template_;
                    } else {
                        EditTemplateDialog.this.result_ = new TemplateRepository().add(EditTemplateDialog.this.template_);
                    }
                }
                catch (Exception e) {
                    Mess_.on(EditTemplateDialog.this.shell_).exception(e).warning();
                }
                EditTemplateDialog.this.shell_.close();
            }
        });
    }

    private boolean isValid() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank(this.title_.getText())) {
            mess.key("dialog.template.required.title").bind((Control)this.title_, this.getTreeItemByControl(this.title_));
        }
        if (this.setButton_.isEnabled()) {
            mess.key("dialog.template.required.dosboxassociation").bind((Control)this.setButton_, this.getTreeItemByControl(this.setButton_));
        }
        this.validateMounts(this.template_, mess);
        return mess.valid();
    }
}

