/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.conf.dfend.DFendConfiguration;
import org.dbgl.model.entity.GenerationAwareConfigurable;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.util.FilesUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class DFendImportThread
extends UIThread<String> {
    private final boolean performCleanup_;
    private final DosboxVersion defaultDBVersion_;
    private final DFendConfiguration profiles_;

    public DFendImportThread(Text log, ProgressBar progressBar, Label status, File dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion) throws IOException {
        super(log, progressBar, status, false);
        this.performCleanup_ = performCleanup;
        this.defaultDBVersion_ = defaultDBVersion;
        this.profiles_ = new DFendConfiguration(dfendProfilesFile);
        this.messageLog_.append(this.profiles_.loadDat());
        this.setObjects(Arrays.asList(this.profiles_.getSectionNames()));
    }

    @Override
    public String work(String title) throws IOException, SQLException {
        File captureDir;
        File alternative;
        this.displayTitle(text_.get("dialog.dfendimport.importing", new Object[]{title}));
        StringBuilder warnings = new StringBuilder(this.profiles_.loadProfile(title));
        String developer = this.profiles_.getValue(title, "ExtraInfo", "developer");
        String publisher = this.profiles_.getValue(title, "ExtraInfo", "publisher");
        String genre = this.profiles_.getValue(title, "ExtraInfo", "genre");
        String year = this.profiles_.getValue(title, "ExtraInfo", "year");
        String status = text_.get("dialog.dfendimport.defaultprofilestatus");
        String notes = this.profiles_.getValue(title, "ExtraInfo", "notes");
        boolean favorite = this.profiles_.getValue(title, "fav").equals("1");
        String setup = this.profiles_.getValue(title, "Extra", "setup");
        String setupParams = this.profiles_.getValue(title, "Extra", "setupparameters");
        Profile newProfile = ProfileFactory.create(title, developer, publisher, genre, year, status, notes, favorite, setup, setupParams);
        warnings.append(newProfile.loadConfigurationData(text_, this.profiles_.getConf(title), this.profiles_.getConfFile(title)));
        GenerationAwareConfigurable.Generation srcGeneration = newProfile.determineGenByConf();
        if (srcGeneration == null) {
            srcGeneration = GenerationAwareConfigurable.Generation.official_063;
        }
        if (this.performCleanup_) {
            newProfile.getConfiguration().removeSection("directserial");
            newProfile.getConfiguration().removeSection("modem");
            newProfile.getConfiguration().removeSection("ipx");
            newProfile.getConfiguration().removeSection("sdl");
        }
        warnings.append(newProfile.alterToDosboxVersionGeneration(srcGeneration, this.defaultDBVersion_));
        newProfile = new ProfileRepository().add(newProfile);
        String captures = this.profiles_.getValue(title, "dosbox", "captures");
        File srcCaptures = new File(captures);
        if (!FilesUtils.isExistingDirectory(srcCaptures) && FilesUtils.isExistingDirectory(alternative = new File(captureDir = new File(this.profiles_.getConfCanonicalFile(title).getParentFile().getParent(), "Capture"), srcCaptures.getName()))) {
            srcCaptures = alternative;
        }
        if (FilesUtils.isExistingDirectory(srcCaptures)) {
            FileUtils.copyDirectory(srcCaptures, newProfile.getCanonicalCaptures(), FileFileFilter.INSTANCE);
        }
        if (newProfile.isIncomplete()) {
            warnings.append(text_.get("general.error.profileincomplete", new String[]{newProfile.getConfigurationCanonicalFile().getPath()}));
        }
        return warnings.toString();
    }

    @Override
    public String getTitle(String title) {
        return title;
    }
}

