/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.entity.LogEntry;
import org.dbgl.model.repository.LoggingRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.TextService;

public class DosboxVersionRepository
extends LoggingRepository<DosboxVersion> {
    private static final String CREATE_QRY = "INSERT INTO DOSBOXVERSIONS(TITLE, FAMILY, VERSION, ISDEFAULT, MULTICONF, USINGCURSES, PATH, EXEFILE, PARAMETERS, CONFFILE, DYNAMIC_OPTIONS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String READ_QRY = "SELECT ID, TITLE, FAMILY, VERSION, ISDEFAULT, MULTICONF, USINGCURSES, PATH, EXEFILE, PARAMETERS, CONFFILE, STATS_CREATED, STATS_LASTMODIFY, STATS_LASTRUN, STATS_RUNS, DYNAMIC_OPTIONS FROM DOSBOXVERSIONS ORDER BY TITLE";
    private static final String UPD_QRY = "UPDATE DOSBOXVERSIONS SET TITLE = ?, FAMILY = ?, VERSION = ?, ISDEFAULT = ?, MULTICONF = ?, USINGCURSES = ?, PATH = ?, EXEFILE = ?, PARAMETERS = ?, CONFFILE = ?, STATS_LASTMODIFY = CURRENT_TIMESTAMP, DYNAMIC_OPTIONS = ? WHERE ID = ?";
    private static final String UPD_NODEFAULT_QRY = "UPDATE DOSBOXVERSIONS SET ISDEFAULT = FALSE";
    private static final String DEL_QRY = "DELETE FROM DOSBOXVERSIONS WHERE ID = ?";
    private static final String REGISTER_RUN_QRY = "UPDATE DOSBOXVERSIONS SET STATS_LASTRUN = CURRENT_TIMESTAMP, STATS_RUNS = (STATS_RUNS + 1) WHERE ID = ?";
    private static final String USAGE_QRY = "SELECT TITLE FROM GAMES WHERE DBVERSION_ID = ? UNION ALL SELECT TITLE FROM TEMPLATES WHERE DBVERSION_ID = ?";

    /*
     * Exception decompiling
     */
    public DosboxVersion add(DosboxVersion dbv) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<DosboxVersion> listAll() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void update(DosboxVersion dbv) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();
             Statement stmt = transaction.createStatement();
             PreparedStatement pstmt = transaction.prepareStatement(UPD_QRY);){
            if (dbv.isDefault()) {
                stmt.executeUpdate(UPD_NODEFAULT_QRY);
            }
            pstmt.setString(1, dbv.getTitle());
            pstmt.setString(2, dbv.getFamily());
            pstmt.setString(3, dbv.getVersion());
            pstmt.setBoolean(4, dbv.isDefault());
            pstmt.setBoolean(5, dbv.isMultiConfig());
            pstmt.setBoolean(6, dbv.isUsingCurses());
            pstmt.setString(7, dbv.getPath().getPath());
            pstmt.setString(8, dbv.getExe().getPath());
            pstmt.setString(9, dbv.getExecutableParameters());
            pstmt.setString(10, dbv.getConfiguration().getFile().getPath());
            pstmt.setObject(11, dbv.getDynamicOptions());
            pstmt.setInt(12, dbv.getId());
            pstmt.executeUpdate();
            DosboxVersionRepository.log(transaction, LogEntry.Event.EDIT, LogEntry.EntityType.DOSBOXVERSION, dbv);
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"update dosboxversion"}));
        }
    }

    public void remove(DosboxVersion dbv) throws SQLException {
        try {
            int totalUsageAmount = 0;
            ArrayList<String> usages = new ArrayList<String>();
            try (Connection con = this.dbService_.getConnection();
                 PreparedStatement stmt = con.prepareStatement(USAGE_QRY);){
                stmt.setInt(1, dbv.getId());
                stmt.setInt(2, dbv.getId());
                try (ResultSet resultset = stmt.executeQuery();){
                    while (resultset.next()) {
                        if (totalUsageAmount++ >= 10) continue;
                        usages.add(resultset.getString(1));
                    }
                }
            }
            if (totalUsageAmount > 0) {
                throw new SQLException(TextService.getInstance().get("general.error.profilesandtemplatesusingdbversion", new Object[]{"", totalUsageAmount, String.join((CharSequence)", ", usages)}));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();){
            this.actionOnEntity(transaction, DEL_QRY, "remove dosboxversion", dbv);
            DosboxVersionRepository.log(transaction, LogEntry.Event.REMOVE, LogEntry.EntityType.DOSBOXVERSION, dbv);
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
    }

    public void registerRun(DosboxVersion dbv) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();){
            this.actionOnEntity(transaction, REGISTER_RUN_QRY, "register run dosboxversion", dbv);
            DosboxVersionRepository.log(transaction, LogEntry.Event.RUN, LogEntry.EntityType.DOSBOXVERSION, dbv);
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
    }

    public static DosboxVersion findBestMatch(List<DosboxVersion> dbversionsList, DosboxVersion db) {
        Optional<DosboxVersion> result = dbversionsList.stream().filter(x -> x.getTitle().equals(db.getTitle())).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        DosboxVersion theDefault = DosboxVersionRepository.findDefault(dbversionsList);
        if (theDefault != null && theDefault.distance(db) == 0) {
            return theDefault;
        }
        return dbversionsList.stream().min(Comparator.comparing(x -> x.distance(db))).orElse(null);
    }
}

