/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.dbgl.util.fat.BlockDevice;
import org.dbgl.util.fat.Fat;

final class ClusterChain {
    private final Fat fat_;
    private final BlockDevice device_;
    private final int clusterSize_;
    private final long dataOffset_;
    private final long startCluster_;

    public ClusterChain(Fat fat, long startCluster) {
        this.fat_ = fat;
        if (startCluster != 0L) {
            this.fat_.testCluster(startCluster);
            if (this.fat_.isFreeCluster(startCluster)) {
                throw new IllegalArgumentException("cluster " + startCluster + " is free");
            }
        }
        this.device_ = fat.getDevice();
        this.dataOffset_ = fat.getBootSector().getFilesOffset();
        this.startCluster_ = startCluster;
        this.clusterSize_ = fat.getBootSector().getBytesPerCluster();
    }

    public Fat getFat() {
        return this.fat_;
    }

    public BlockDevice getDevice() {
        return this.device_;
    }

    public long getStartCluster() {
        return this.startCluster_;
    }

    private long getDevOffset(long cluster, int clusterOffset) {
        return this.dataOffset_ + (long)clusterOffset + (cluster - 2L) * (long)this.clusterSize_;
    }

    public long getLengthOnDisk() {
        if (this.getStartCluster() == 0L) {
            return 0L;
        }
        return (long)this.getChainLength() * (long)this.clusterSize_;
    }

    public int getChainLength() {
        if (this.getStartCluster() == 0L) {
            return 0;
        }
        return this.getFat().getChain(this.getStartCluster()).length;
    }

    public void readData(long offset, ByteBuffer dest) throws IOException {
        int len = dest.remaining();
        if (this.startCluster_ == 0L && len > 0) {
            throw new EOFException();
        }
        long[] chain = this.getFat().getChain(this.startCluster_);
        BlockDevice dev = this.getDevice();
        int chainIdx = (int)(offset / (long)this.clusterSize_);
        if (offset % (long)this.clusterSize_ != 0L) {
            int clusOfs = (int)(offset % (long)this.clusterSize_);
            int size = Math.min(len, (int)((long)this.clusterSize_ - offset % (long)this.clusterSize_ - 1L));
            ((Buffer)dest).limit(dest.position() + size);
            dev.read(this.getDevOffset(chain[chainIdx], clusOfs), dest);
            len -= size;
            ++chainIdx;
        }
        while (len > 0) {
            int size = Math.min(this.clusterSize_, len);
            ((Buffer)dest).limit(dest.position() + size);
            dev.read(this.getDevOffset(chain[chainIdx], 0), dest);
            len -= size;
            ++chainIdx;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterChain)) {
            return false;
        }
        ClusterChain other = (ClusterChain)obj;
        if (!(this.fat_ == other.fat_ || this.fat_ != null && this.fat_.equals(other.fat_))) {
            return false;
        }
        return this.startCluster_ == other.startCluster_;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.fat_ != null ? this.fat_.hashCode() : 0);
        hash = 79 * hash + (int)(this.startCluster_ ^ this.startCluster_ >>> 32);
        return hash;
    }
}

