/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditDosboxVersionDialog
extends Dialog {
    private Text path;
    private Text title;
    protected Object result;
    protected Shell shell;
    private Database db;

    public EditDosboxVersionDialog(Shell parent, int style) {
        super(parent, style);
    }

    public EditDosboxVersionDialog(Shell parent) {
        this(parent, 0);
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setDosboxVersion(DosboxVersion dbversion) {
        this.result = dbversion;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(500, 375);
        if (this.result != null) {
            this.shell.setText("Edit Dosbox Version");
        } else {
            this.shell.setText("Add Dosbox Version");
        }
        Label titleLabel = new Label((Composite)this.shell, 0);
        titleLabel.setText("Title");
        this.title = new Text((Composite)this.shell, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.shell, 0);
        Label pathLabel = new Label((Composite)this.shell, 0);
        pathLabel.setText("Path");
        this.path = new Text((Composite)this.shell, 2048);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button((Composite)this.shell, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditDosboxVersionDialog.this.shell);
                dialog.setFilterPath(EditDosboxVersionDialog.this.path.getText());
                String result = dialog.open();
                if (result != null) {
                    EditDosboxVersionDialog.this.path.setText(result);
                }
            }
        });
        browseButton.setText("Browse..");
        Label multiconfSupportLabel = new Label((Composite)this.shell, 0);
        multiconfSupportLabel.setText("Multiconf support");
        final Button multiconf = new Button((Composite)this.shell, 32);
        new Label((Composite)this.shell, 0);
        Label defaultLabel = new Label((Composite)this.shell, 0);
        defaultLabel.setText("Default");
        final Button isDefaultButton = new Button((Composite)this.shell, 32);
        new Label((Composite)this.shell, 0);
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                if (!EditDosboxVersionDialog.this.path.getText().endsWith(System.getProperty("file.separator"))) {
                    EditDosboxVersionDialog.this.path.setText(String.valueOf(EditDosboxVersionDialog.this.path.getText()) + System.getProperty("file.separator"));
                }
                int dbversionId = EditDosboxVersionDialog.this.db.addOrEditDosboxVersion(EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), isDefaultButton.getSelection(), EditDosboxVersionDialog.this.result != null ? ((DosboxVersion)EditDosboxVersionDialog.this.result).getId() : -1);
                EditDosboxVersionDialog.this.result = new DosboxVersion(dbversionId, EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), isDefaultButton.getSelection());
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDosboxVersionDialog.this.result = null;
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        if (this.result != null) {
            this.title.setText(((DosboxVersion)this.result).getTitle());
            this.path.setText(((DosboxVersion)this.result).getPath());
            isDefaultButton.setSelection(((DosboxVersion)this.result).isDefaultVersion());
            multiconf.setSelection(((DosboxVersion)this.result).isMultiConfig());
        }
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a dosbox version title", (Control)this.title);
        }
        if (this.path.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a path to the dosbox executable", (Control)this.path);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

