/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.GeneralPurposeDialogs;
import com.model.Mount;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditMountDialog
extends Dialog {
    private Text mount_label_1;
    private Combo mount_type_1;
    private Text write;
    private Text zip;
    private Button mountZipButton;
    private Button mountImageAsButton;
    private Button mountADirectoryButton;
    private Text mount_image;
    private Text mount_label;
    private Combo mount_type;
    private Text mount_dir;
    private Combo driveletter;
    protected Object result;
    protected Shell shell;

    public EditMountDialog(Shell parent, int style) {
        super(parent, style);
    }

    public EditMountDialog(Shell parent) {
        this(parent, 0);
    }

    public void setMount(String mount) {
        this.result = mount;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(500, 375);
        if (this.result != null) {
            this.shell.setText("Edit Mount Point");
        } else {
            this.shell.setText("Add Mount Point");
        }
        Label driveLetterLabel = new Label((Composite)this.shell, 0);
        driveLetterLabel.setText("Drive Letter");
        this.driveletter = new Combo((Composite)this.shell, 8);
        this.driveletter.setItems(new String[]{"a", "b", "c", "d", "e", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y"});
        this.driveletter.select(2);
        this.driveletter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        this.mountADirectoryButton = new Button((Composite)this.shell, 16);
        this.mountADirectoryButton.setText("Mount Directory");
        this.mount_dir = new Text((Composite)this.shell, 2048);
        this.mount_dir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button browseButton = new Button((Composite)this.shell, 0);
        browseButton.setText("Browse..");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditMountDialog.this.shell);
                dialog.setFilterPath(EditMountDialog.this.mount_dir.getText());
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.mount_dir.setText(result);
                }
            }
        });
        new Label((Composite)this.shell, 0);
        Label asLabel = new Label((Composite)this.shell, 0);
        asLabel.setText("As");
        this.mount_type = new Combo((Composite)this.shell, 8);
        this.mount_type.setItems(new String[]{"", "cdrom", "dir", "floppy"});
        this.mount_type.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Label");
        this.mount_label = new Text((Composite)this.shell, 2048);
        this.mount_label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        Label lowlevelCdLabel = new Label((Composite)this.shell, 0);
        lowlevelCdLabel.setText("Force ioctl");
        final Button ioctlButton = new Button((Composite)this.shell, 32);
        ioctlButton.setLayoutData((Object)new GridData());
        new Label((Composite)this.shell, 0);
        Label label_1 = new Label((Composite)this.shell, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.mountImageAsButton = new Button((Composite)this.shell, 16);
        this.mountImageAsButton.setText("Mount CD-Image");
        this.mount_image = new Text((Composite)this.shell, 2048);
        this.mount_image.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button browseButton_1 = new Button((Composite)this.shell, 0);
        browseButton_1.setText("Browse..");
        browseButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditMountDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"CD Images", "*.*"});
                dialog.setFilterExtensions(new String[]{"*.iso;*.cue", "*.*"});
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.mount_image.setText(result);
                }
            }
        });
        Label label_2 = new Label((Composite)this.shell, 258);
        label_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.mountZipButton = new Button((Composite)this.shell, 16);
        this.mountZipButton.setLayoutData((Object)new GridData());
        this.mountZipButton.setText("Mount Zip");
        Label zipLabel = new Label((Composite)this.shell, 0);
        zipLabel.setLayoutData((Object)new GridData());
        zipLabel.setText("Zip");
        this.zip = new Text((Composite)this.shell, 2048);
        this.zip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton_2 = new Button((Composite)this.shell, 0);
        browseButton_2.setText("Browse..");
        browseButton_2.setText("Browse..");
        browseButton_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EditMountDialog.this.shell, 4096);
                dialog.setFilterNames(new String[]{"Zip files", "*.*"});
                dialog.setFilterExtensions(new String[]{"*.zip", "*.*"});
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.zip.setText(result);
                }
            }
        });
        new Label((Composite)this.shell, 0);
        Label writeLabel = new Label((Composite)this.shell, 0);
        writeLabel.setLayoutData((Object)new GridData());
        writeLabel.setText("Write");
        this.write = new Text((Composite)this.shell, 2048);
        this.write.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton_3 = new Button((Composite)this.shell, 0);
        browseButton_3.setText("Browse..");
        browseButton_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditMountDialog.this.shell);
                dialog.setFilterPath(EditMountDialog.this.write.getText());
                String result = dialog.open();
                if (result != null) {
                    EditMountDialog.this.write.setText(result);
                }
            }
        });
        new Label((Composite)this.shell, 0);
        Label asLabel_1 = new Label((Composite)this.shell, 0);
        asLabel_1.setText("As");
        this.mount_type_1 = new Combo((Composite)this.shell, 8);
        this.mount_type_1.setItems(new String[]{"", "cdrom", "dir", "floppy"});
        this.mount_type_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        Label label_3 = new Label((Composite)this.shell, 0);
        label_3.setText("Label");
        this.mount_label_1 = new Text((Composite)this.shell, 2048);
        this.mount_label_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.shell, 0);
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditMountDialog.this.isValid()) {
                    return;
                }
                Mount mount = null;
                if (EditMountDialog.this.mountADirectoryButton.getSelection()) {
                    mount = new Mount(Mount.MountingType.DIR, EditMountDialog.this.mount_type.getText(), EditMountDialog.this.driveletter.getText(), EditMountDialog.this.mount_dir.getText(), EditMountDialog.this.mount_label.getText(), ioctlButton.getSelection(), "");
                } else if (EditMountDialog.this.mountImageAsButton.getSelection()) {
                    mount = new Mount(Mount.MountingType.IMAGE, "iso", EditMountDialog.this.driveletter.getText(), EditMountDialog.this.mount_image.getText(), "", false, "");
                } else if (EditMountDialog.this.mountZipButton.getSelection()) {
                    mount = new Mount(Mount.MountingType.PHYSFS, EditMountDialog.this.mount_type_1.getText(), EditMountDialog.this.driveletter.getText(), EditMountDialog.this.zip.getText(), EditMountDialog.this.mount_label_1.getText(), false, EditMountDialog.this.write.getText());
                }
                EditMountDialog.this.result = mount.toString();
                EditMountDialog.this.shell.close();
            }
        });
        okButton.setText("OK");
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMountDialog.this.result = null;
                EditMountDialog.this.shell.close();
            }
        });
        this.mount_dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountADirectoryButton.setSelection(true);
                EditMountDialog.this.mountImageAsButton.setSelection(false);
                EditMountDialog.this.mountZipButton.setSelection(false);
            }
        });
        this.mount_image.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountADirectoryButton.setSelection(false);
                EditMountDialog.this.mountImageAsButton.setSelection(true);
                EditMountDialog.this.mountZipButton.setSelection(false);
            }
        });
        this.zip.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMountDialog.this.mountADirectoryButton.setSelection(false);
                EditMountDialog.this.mountImageAsButton.setSelection(false);
                EditMountDialog.this.mountZipButton.setSelection(true);
            }
        });
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        if (this.result != null) {
            Mount mount = new Mount((String)this.result);
            this.driveletter.setText(mount.getDriveletterString());
            switch (mount.getMountingType()) {
                case DIR: {
                    this.mountADirectoryButton.setSelection(true);
                    this.mount_dir.setText(mount.getPath());
                    if (!mount.getMountAs().equals("")) {
                        this.mount_type.setText(mount.getMountAs());
                    }
                    this.mount_label.setText(mount.getLabel());
                    ioctlButton.setSelection(mount.isIoctl());
                    break;
                }
                case PHYSFS: {
                    this.mountZipButton.setSelection(true);
                    this.zip.setText(mount.getPath());
                    this.write.setText(mount.getWrite());
                    if (!mount.getMountAs().equals("")) {
                        this.mount_type_1.setText(mount.getMountAs());
                    }
                    this.mount_label_1.setText(mount.getLabel());
                    break;
                }
                case IMAGE: {
                    this.mountImageAsButton.setSelection(true);
                    this.mount_image.setText(mount.getPath());
                }
            }
        } else {
            this.mountADirectoryButton.setSelection(true);
        }
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.mountADirectoryButton.getSelection() && this.mount_dir.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a path to mount", (Control)this.mount_dir);
        } else if (this.mountImageAsButton.getSelection() && this.mount_image.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter an image to mount", (Control)this.mount_image);
        } else if (this.mountZipButton.getSelection() && this.zip.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter an zip to mount", (Control)this.zip);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

