/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public abstract class FileUtils {
    public static String getCwd() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException ex) {
            System.err.println("Couldn't get current working directory!!\n");
            return null;
        }
    }

    public static void createDir(String dir) {
        if (!new File(dir).exists() && !new File(dir).mkdirs()) {
            System.err.println("Couldn't create " + dir + " directory!!\n");
        }
    }

    public static void copyFiles(String srcDir, String dstDir) {
        File[] srcFiles = new File(srcDir).listFiles();
        if (srcFiles != null) {
            File[] fileArray = srcFiles;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File src = fileArray[n];
                if (src.isFile()) {
                    FileUtils.copy(src, new File(String.valueOf(dstDir) + src.getName()));
                }
                ++n;
            }
        }
    }

    public static void copy(File source, File dest) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            catch (IOException e) {
                System.err.println("Couldn't copy file " + source + " to directory " + dest + "!!\n");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void removeFile(String filename) {
        File file = new File(filename);
        if (file.isFile()) {
            file.delete();
        }
    }

    public static void removeDir(String dirname) {
        File dir = new File(dirname);
        if (dir.isDirectory()) {
            dir.delete();
        }
    }
}

