/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditDosboxVersionDialog
extends Dialog {
    private Text path;
    private Text title;
    protected Object result;
    protected Shell shell;
    private Database db;

    public EditDosboxVersionDialog(Shell parent, int style) {
        super(parent, style);
    }

    public EditDosboxVersionDialog(Shell parent) {
        this(parent, 0);
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setDosboxVersion(DosboxVersion dbversion) {
        this.result = dbversion;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(500, 200);
        if (this.result != null) {
            this.shell.setText("Edit Dosbox Version");
        } else {
            this.shell.setText("Add Dosbox Version");
        }
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite.setLayout((Layout)gridLayout_1);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title");
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText("Path");
        this.path = new Text(composite, 2048);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button(composite, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditDosboxVersionDialog.this.shell);
                dialog.setFilterPath(EditDosboxVersionDialog.this.path.getText());
                String result = dialog.open();
                if (result != null) {
                    EditDosboxVersionDialog.this.path.setText(result);
                }
            }
        });
        browseButton.setText("Browse..");
        Label multiconfSupportLabel = new Label(composite, 0);
        multiconfSupportLabel.setText("Multiconf support");
        final Button multiconf = new Button(composite, 32);
        new Label(composite, 0);
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText("Default");
        final Button isDefaultButton = new Button(composite, 32);
        new Label(composite, 0);
        Composite composite_1 = new Composite((Composite)this.shell, 0);
        composite_1.setLayoutData((Object)"South");
        composite_1.setLayout((Layout)new RowLayout());
        Button okButton = new Button(composite_1, 0);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData((Object)rowData);
        this.shell.setDefaultButton(okButton);
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                if (!EditDosboxVersionDialog.this.path.getText().endsWith(System.getProperty("file.separator"))) {
                    EditDosboxVersionDialog.this.path.setText(String.valueOf(EditDosboxVersionDialog.this.path.getText()) + System.getProperty("file.separator"));
                }
                int dbversionId = EditDosboxVersionDialog.this.db.addOrEditDosboxVersion(EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), isDefaultButton.getSelection(), EditDosboxVersionDialog.this.result != null ? ((DosboxVersion)EditDosboxVersionDialog.this.result).getId() : -1);
                EditDosboxVersionDialog.this.result = new DosboxVersion(dbversionId, EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), multiconf.getSelection(), isDefaultButton.getSelection());
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_1, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData((Object)rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDosboxVersionDialog.this.result = null;
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        if (this.result != null) {
            this.title.setText(((DosboxVersion)this.result).getTitle());
            this.path.setText(((DosboxVersion)this.result).getPath());
            isDefaultButton.setSelection(((DosboxVersion)this.result).isDefaultVersion());
            multiconf.setSelection(((DosboxVersion)this.result).isMultiConfig());
        }
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a dosbox version title", (Control)this.title);
        }
        if (this.path.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a path to the dosbox executable", (Control)this.path);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

