/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditMountDialog;
import com.gui.GeneralPurposeDialogs;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.Mount;
import com.model.Template;
import com.util.ListUtils;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    private TabItem infoTabItem;
    private Text title;
    private Button reloadSettingsButton;
    private Combo dbversion;
    private Button waitonerror;
    private Button exit;
    private Combo priority_inactive;
    private Combo priority_active;
    private Text captures;
    private Text language;
    private Combo windowresolution;
    private Combo fullresolution;
    private Combo frameskip;
    private Combo output;
    private Button fullscreen;
    private Button fulldouble;
    private Combo scaler;
    private Button aspect;
    private Combo machine;
    private Combo cycles_down;
    private Combo cycles_up;
    private Combo cycles;
    private Combo core;
    private Button timesynched;
    private Button xms;
    private Button ems;
    private Combo umb;
    private Combo memsize;
    private Button nosound;
    private Button mixer;
    private Button pcspeaker;
    private Button disney;
    private Button gus;
    private Combo tandy;
    private Combo tandyrate;
    private Text midi_config;
    private Combo device;
    private Combo mpu401;
    private Text ultradir;
    private Combo gusrate;
    private Combo irq2;
    private Combo dma2;
    private Combo dma1;
    private Combo irq1;
    private Combo gusbase;
    private Combo pcrate;
    private Combo hdma;
    private Combo dma;
    private Combo irq;
    private Combo sbbase;
    private Combo oplrate;
    private Combo oplmode;
    private Combo sbtype;
    private Combo prebuffer;
    private Combo blocksize;
    private Combo rate;
    private Button usescancodes;
    private Button autolock;
    private Text serial4;
    private Text serial3;
    private Text serial2;
    private Text serial1;
    private Combo joysticktype;
    private Text mapperfile;
    private Combo sensitivity;
    private Button ipx;
    private org.eclipse.swt.widgets.List mountingpoints;
    private Button booterButton;
    private Button dosButton;
    protected Shell shell;
    private List<DosboxVersion> dbversionsList;
    private Database db;
    private Configuration templateConf;
    protected Object result;

    public EditTemplateDialog(Shell parent, int style) {
        super(parent, style);
    }

    public EditTemplateDialog(Shell parent) {
        this(parent, 0);
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.dbversionsList = this.db.readDosboxVersionsList();
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(610, 475);
        if (this.result != null) {
            this.shell.setText("Edit Template " + ((Template)this.result).getTitle() + " (" + ((Template)this.result).getId() + ")");
        } else {
            this.shell.setText("Add Template");
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText("Info");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title");
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        generalTabItem.setControl((Control)composite_1);
        Label dosboxVersionLabel = new Label(composite_1, 0);
        dosboxVersionLabel.setText("Dosbox version");
        this.dbversion = new Combo(composite_1, 8);
        this.dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.reloadSettingsButton = new Button(composite_1, 0);
        this.reloadSettingsButton.setText("Reload Settings");
        this.reloadSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DosboxVersion selectedDBVersion = (DosboxVersion)EditTemplateDialog.this.dbversionsList.get(EditTemplateDialog.this.dbversion.getSelectionIndex());
                EditTemplateDialog.this.templateConf = new Configuration(String.valueOf(selectedDBVersion.getPath()) + "dosbox.conf");
                EditTemplateDialog.this.selectSettingsByConfiguration(EditTemplateDialog.this.templateConf);
            }
        });
        Label label = new Label(composite_1, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        new Label(composite_1, 0);
        Label activeLabel = new Label(composite_1, 0);
        activeLabel.setText("Active");
        Label inactiveLabel = new Label(composite_1, 0);
        inactiveLabel.setText("Inactive");
        Label priorityLabel = new Label(composite_1, 0);
        priorityLabel.setText("Priority");
        this.priority_active = new Combo(composite_1, 8);
        this.priority_active.setItems(new String[]{"lowest", "lower", "normal", "higher", "highest", "pause"});
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.minimumWidth = 150;
        this.priority_active.setLayoutData((Object)gridData);
        this.priority_inactive = new Combo(composite_1, 8);
        this.priority_inactive.setItems(new String[]{"lowest", "lower", "normal", "higher", "highest", "pause"});
        this.priority_inactive.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label waitOnErrorLabel = new Label(composite_1, 0);
        waitOnErrorLabel.setText("Wait On Error");
        this.waitonerror = new Button(composite_1, 32);
        new Label(composite_1, 0);
        Label exitAfterwardsLabel = new Label(composite_1, 0);
        exitAfterwardsLabel.setText("Exit afterwards");
        this.exit = new Button(composite_1, 32);
        new Label(composite_1, 0);
        Label languageFileLabel = new Label(composite_1, 0);
        languageFileLabel.setLayoutData((Object)new GridData());
        languageFileLabel.setText("Language File");
        this.language = new Text(composite_1, 2048);
        this.language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText("Display");
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_5);
        displayTabItem.setControl((Control)composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText("Output");
        this.output = new Combo(composite_2, 8);
        this.output.setItems(new String[]{"ddraw", "direct3d", "overlay", "opengl", "openglhq", "openglnb", "surface"});
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText("Frameskip");
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        this.frameskip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText("Scaler");
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(new String[]{"none", "normal2x", "normal3x", "advmame2x", "advmame3x", "advinterp2x", "advinterp3x", "tv2x", "tv3x", "rgb2x", "rgb3x", "scan2x", "scan3x", "supereagle", "super2xsai", "2xsai", "hq2x", "hq3x", "hardware2x", "hardware3x"});
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText("Fullscreen");
        this.fullscreen = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBufferingLabel = new Label(composite_2, 0);
        doubleBufferingLabel.setText("Double Buffering");
        this.fulldouble = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText("Fullscreen Resolution");
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(new String[]{"original", "320x200", "640x480", "800x600", "1024x768", "1280x768", "1280x960", "1280x1024"});
        this.fullresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label windowResolutionLabel = new Label(composite_2, 0);
        windowResolutionLabel.setText("Window Resolution");
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(new String[]{"original", "320x200", "640x480", "800x600", "1024x768", "1280x768", "1280x960", "1280x1024"});
        this.windowresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label aspectCorrectionLabel = new Label(composite_2, 0);
        aspectCorrectionLabel.setText("Aspect Correction");
        this.aspect = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText("Machine");
        Composite composite_3 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout((Layout)gridLayout_2);
        machineTabItem.setControl((Control)composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText("CPU");
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout((Layout)gridLayout_3);
        Label machineLabel = new Label((Composite)cpuGroup, 0);
        machineLabel.setText("Machine");
        this.machine = new Combo((Composite)cpuGroup, 8);
        this.machine.setItems(new String[]{"cga", "hercules", "pcjr", "tandy", "vga"});
        this.machine.setLayoutData((Object)new GridData());
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label coreLabel = new Label((Composite)cpuGroup, 0);
        coreLabel.setText("Core");
        this.core = new Combo((Composite)cpuGroup, 8);
        this.core.setItems(new String[]{"dynamic", "full", "normal", "simple", "auto"});
        this.core.setLayoutData((Object)new GridData());
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label cyclesLabel = new Label((Composite)cpuGroup, 0);
        cyclesLabel.setText("Cycles");
        this.cycles = new Combo((Composite)cpuGroup, 0);
        this.cycles.setItems(new String[]{"500", "750", "1000", "2000", "3000", "4000", "5000", "7500", "10000", "12500", "15000", "17500", "20000", "25000", "30000", "32500", "35000", "40000", "45000", "50000", "55000", "60000", "auto", "max"});
        this.cycles.setLayoutData((Object)new GridData());
        this.cycles.setVisibleItemCount(15);
        Label upLabel = new Label((Composite)cpuGroup, 0);
        upLabel.setLayoutData((Object)new GridData());
        upLabel.setText("Up");
        this.cycles_up = new Combo((Composite)cpuGroup, 0);
        this.cycles_up.setItems(new String[]{"20", "50", "100", "500", "1000", "2000", "5000", "10000"});
        this.cycles_up.setLayoutData((Object)new GridData());
        Label downLabel = new Label((Composite)cpuGroup, 0);
        downLabel.setLayoutData((Object)new GridData());
        downLabel.setText("Down");
        this.cycles_down = new Combo((Composite)cpuGroup, 0);
        this.cycles_down.setItems(new String[]{"20", "50", "100", "500", "1000", "2000", "5000", "10000"});
        this.cycles_down.setLayoutData((Object)new GridData());
        Label timesynchedLabel = new Label((Composite)cpuGroup, 0);
        timesynchedLabel.setText("Timesynched");
        this.timesynched = new Button((Composite)cpuGroup, 32);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Group memoryGroup = new Group(composite_3, 0);
        memoryGroup.setText("Memory");
        memoryGroup.setLayoutData((Object)new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 2;
        memoryGroup.setLayout((Layout)gridLayout_4);
        Label sizeLabel = new Label((Composite)memoryGroup, 0);
        sizeLabel.setText("Size");
        this.memsize = new Combo((Composite)memoryGroup, 8);
        this.memsize.setItems(new String[]{"0", "1", "2", "4", "8", "16", "32", "63"});
        this.memsize.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label xmsLabel = new Label((Composite)memoryGroup, 0);
        xmsLabel.setText("XMS");
        this.xms = new Button((Composite)memoryGroup, 32);
        Label emsLabel = new Label((Composite)memoryGroup, 0);
        emsLabel.setText("EMS");
        this.ems = new Button((Composite)memoryGroup, 32);
        Label umbLabel = new Label((Composite)memoryGroup, 0);
        umbLabel.setText("UMB");
        this.umb = new Combo((Composite)memoryGroup, 8);
        this.umb.setItems(new String[]{"false", "true", "max"});
        this.umb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText("Audio");
        Composite composite_4 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_9);
        audioTabItem.setControl((Control)composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout((Layout)gridLayout_6);
        generalGroup.setText("General");
        Label silentModeLabel = new Label((Composite)generalGroup, 0);
        silentModeLabel.setText("Silent Mode");
        this.nosound = new Button((Composite)generalGroup, 32);
        Label sampleRateLabel = new Label((Composite)generalGroup, 0);
        sampleRateLabel.setText("Sample Rate");
        this.rate = new Combo((Composite)generalGroup, 8);
        this.rate.setItems(new String[]{"11025", "22050", "44100"});
        this.rate.setLayoutData((Object)new GridData());
        Label blockSizeLabel = new Label((Composite)generalGroup, 0);
        blockSizeLabel.setText("Block Size");
        this.blocksize = new Combo((Composite)generalGroup, 8);
        this.blocksize.setItems(new String[]{"512", "1024", "2048", "3072", "4096", "8192"});
        this.blocksize.setLayoutData((Object)new GridData());
        Label prebufferLabel = new Label((Composite)generalGroup, 0);
        prebufferLabel.setText("Prebuffer");
        this.prebuffer = new Combo((Composite)generalGroup, 0);
        this.prebuffer.setItems(new String[]{"10"});
        this.prebuffer.setLayoutData((Object)new GridData());
        Label mpu401Label = new Label((Composite)generalGroup, 0);
        mpu401Label.setText("MPU-401");
        this.mpu401 = new Combo((Composite)generalGroup, 8);
        this.mpu401.setItems(new String[]{"none", "intelligent", "uart"});
        this.mpu401.setLayoutData((Object)new GridData());
        Label midiDeviceLabel = new Label((Composite)generalGroup, 0);
        midiDeviceLabel.setText("Midi Device");
        this.device = new Combo((Composite)generalGroup, 8);
        this.device.setItems(new String[]{"alsa", "default", "coreaudio", "none", "oss", "win32"});
        this.device.setLayoutData((Object)new GridData());
        Label configLabel = new Label((Composite)generalGroup, 0);
        configLabel.setText("Config");
        this.midi_config = new Text((Composite)generalGroup, 2048);
        this.midi_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        soundblasterGroup.setText("Soundblaster");
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout((Layout)gridLayout_7);
        Label typeLabel = new Label((Composite)soundblasterGroup, 0);
        typeLabel.setText("Type");
        this.sbtype = new Combo((Composite)soundblasterGroup, 8);
        this.sbtype.setItems(new String[]{"none", "sb1", "sb2", "sbpro1", "sbpro2", "sb16"});
        this.sbtype.setLayoutData((Object)new GridData());
        Label oplRateLabel = new Label((Composite)soundblasterGroup, 0);
        oplRateLabel.setText("OPL Rate");
        this.oplrate = new Combo((Composite)soundblasterGroup, 8);
        this.oplrate.setItems(new String[]{"11025", "22050", "44100"});
        this.oplrate.setLayoutData((Object)new GridData());
        Label oplModeLabel = new Label((Composite)soundblasterGroup, 0);
        oplModeLabel.setLayoutData((Object)new GridData());
        oplModeLabel.setText("OPL Mode");
        this.oplmode = new Combo((Composite)soundblasterGroup, 8);
        this.oplmode.setItems(new String[]{"auto", "cms", "opl2", "dualopl2", "opl3"});
        this.oplmode.setLayoutData((Object)new GridData());
        Label addressLabel = new Label((Composite)soundblasterGroup, 0);
        addressLabel.setText("Address");
        this.sbbase = new Combo((Composite)soundblasterGroup, 8);
        this.sbbase.setItems(new String[]{"210", "220", "240", "260", "280"});
        this.sbbase.setLayoutData((Object)new GridData());
        Label irqLabel = new Label((Composite)soundblasterGroup, 0);
        irqLabel.setText("IRQ");
        this.irq = new Combo((Composite)soundblasterGroup, 8);
        this.irq.setItems(new String[]{"3", "5", "7", "10", "11"});
        this.irq.setLayoutData((Object)new GridData());
        Label dmaLabel = new Label((Composite)soundblasterGroup, 0);
        dmaLabel.setText("DMA");
        this.dma = new Combo((Composite)soundblasterGroup, 8);
        this.dma.setItems(new String[]{"0", "1", "3"});
        this.dma.setLayoutData((Object)new GridData());
        Label hdmaLabel = new Label((Composite)soundblasterGroup, 0);
        hdmaLabel.setLayoutData((Object)new GridData());
        hdmaLabel.setText("HDMA");
        this.hdma = new Combo((Composite)soundblasterGroup, 8);
        this.hdma.setItems(new String[]{"5", "6", "7"});
        this.hdma.setLayoutData((Object)new GridData());
        Label mixerLabel = new Label((Composite)soundblasterGroup, 0);
        mixerLabel.setText("Mixer");
        this.mixer = new Button((Composite)soundblasterGroup, 32);
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        gusGroup.setText("Gravis Ultrasound");
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout((Layout)gridLayout_8);
        Label enableLabel_1 = new Label((Composite)gusGroup, 0);
        enableLabel_1.setLayoutData((Object)new GridData());
        enableLabel_1.setText("Enable");
        this.gus = new Button((Composite)gusGroup, 32);
        this.gus.setLayoutData((Object)new GridData());
        Label sampleRateLabel_2 = new Label((Composite)gusGroup, 0);
        sampleRateLabel_2.setText("Sample Rate");
        this.gusrate = new Combo((Composite)gusGroup, 8);
        this.gusrate.setItems(new String[]{"11025", "22050", "44100"});
        this.gusrate.setLayoutData((Object)new GridData());
        Label addressLabel_1 = new Label((Composite)gusGroup, 0);
        addressLabel_1.setText("Address");
        this.gusbase = new Combo((Composite)gusGroup, 8);
        this.gusbase.setItems(new String[]{"210", "220", "240", "260", "280"});
        this.gusbase.setLayoutData((Object)new GridData());
        Label irqLabel_1 = new Label((Composite)gusGroup, 0);
        irqLabel_1.setText("IRQ1");
        this.irq1 = new Combo((Composite)gusGroup, 8);
        this.irq1.setItems(new String[]{"3", "5", "7", "10", "11"});
        this.irq1.setLayoutData((Object)new GridData());
        Label irq2Label = new Label((Composite)gusGroup, 0);
        irq2Label.setText("IRQ2");
        this.irq2 = new Combo((Composite)gusGroup, 8);
        this.irq2.setItems(new String[]{"3", "5", "7", "10", "11"});
        this.irq2.setLayoutData((Object)new GridData());
        Label dmaLabel_1 = new Label((Composite)gusGroup, 0);
        dmaLabel_1.setText("DMA1");
        this.dma1 = new Combo((Composite)gusGroup, 8);
        this.dma1.setItems(new String[]{"0", "1", "3"});
        this.dma1.setLayoutData((Object)new GridData());
        Label hdmaLabel_1 = new Label((Composite)gusGroup, 0);
        hdmaLabel_1.setLayoutData((Object)new GridData());
        hdmaLabel_1.setText("DMA2");
        this.dma2 = new Combo((Composite)gusGroup, 8);
        this.dma2.setItems(new String[]{"0", "1", "3"});
        this.dma2.setLayoutData((Object)new GridData());
        Label ultradirLabel = new Label((Composite)gusGroup, 0);
        ultradirLabel.setText("Ultradir");
        this.ultradir = new Text((Composite)gusGroup, 2048);
        this.ultradir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        speakerGroup.setText("PC Speaker");
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout((Layout)gridLayout_10);
        Label enableLabel = new Label((Composite)speakerGroup, 0);
        enableLabel.setText("Enable");
        this.pcspeaker = new Button((Composite)speakerGroup, 32);
        Label sampleRateLabel_1 = new Label((Composite)speakerGroup, 0);
        sampleRateLabel_1.setText("Sample Rate");
        this.pcrate = new Combo((Composite)speakerGroup, 8);
        this.pcrate.setItems(new String[]{"11025", "22050", "44100"});
        this.pcrate.setLayoutData((Object)new GridData());
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        tandyGroup.setText("Tandy");
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout((Layout)gridLayout_11);
        Label enableLabel_2 = new Label((Composite)tandyGroup, 0);
        enableLabel_2.setText("Enable");
        this.tandy = new Combo((Composite)tandyGroup, 8);
        this.tandy.setItems(new String[]{"auto", "off", "on"});
        this.tandy.setLayoutData((Object)new GridData());
        Label sampleRateLabel_1_1 = new Label((Composite)tandyGroup, 0);
        sampleRateLabel_1_1.setText("Sample Rate");
        this.tandyrate = new Combo((Composite)tandyGroup, 8);
        this.tandyrate.setItems(new String[]{"11025", "22050", "44100"});
        this.tandyrate.setLayoutData((Object)new GridData());
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        disneyGroup.setText("Disney Sound Source");
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout((Layout)gridLayout_12);
        Label enableLabel_3 = new Label((Composite)disneyGroup, 0);
        enableLabel_3.setText("Enable");
        this.disney = new Button((Composite)disneyGroup, 32);
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText("I/O");
        Composite composite_5 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout((Layout)gridLayout_17);
        inputTabItem.setControl((Control)composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mouseGroup.setText("Mouse");
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout((Layout)gridLayout_13);
        Label autolockLabel = new Label((Composite)mouseGroup, 0);
        autolockLabel.setText("Autolock");
        this.autolock = new Button((Composite)mouseGroup, 32);
        Label sensitivityLabel = new Label((Composite)mouseGroup, 0);
        sensitivityLabel.setText("Sensitivity");
        this.sensitivity = new Combo((Composite)mouseGroup, 8);
        this.sensitivity.setItems(new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100", "125", "150", "175", "200", "250", "300", "350", "400", "450", "500", "550", "600", "700", "800", "900", "1000"});
        this.sensitivity.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        keyboardGroup.setText("Keyboard");
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout((Layout)gridLayout_14);
        Label useScancodesLabel = new Label((Composite)keyboardGroup, 0);
        useScancodesLabel.setText("Use Scancodes");
        this.usescancodes = new Button((Composite)keyboardGroup, 32);
        Label mapperFileLabel = new Label((Composite)keyboardGroup, 0);
        mapperFileLabel.setText("Mapper File");
        this.mapperfile = new Text((Composite)keyboardGroup, 2048);
        this.mapperfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        joystickGroup.setText("Joystick");
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout((Layout)gridLayout_15);
        Label typeLabel_1 = new Label((Composite)joystickGroup, 0);
        typeLabel_1.setText("Type");
        this.joysticktype = new Combo((Composite)joystickGroup, 8);
        this.joysticktype.setItems(new String[]{"none", "2axis", "4axis", "ch", "fcs"});
        GridData gridData_1 = new GridData(4, 0x1000000, true, false);
        this.joysticktype.setLayoutData((Object)gridData_1);
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText("Modem");
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout((Layout)gridLayout_16);
        Label serial1Label = new Label((Composite)modemGroup, 0);
        serial1Label.setText("Serial 1");
        this.serial1 = new Text((Composite)modemGroup, 2048);
        this.serial1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial2Label = new Label((Composite)modemGroup, 0);
        serial2Label.setText("Serial 2");
        this.serial2 = new Text((Composite)modemGroup, 2048);
        this.serial2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial3Label = new Label((Composite)modemGroup, 0);
        serial3Label.setText("Serial 3");
        this.serial3 = new Text((Composite)modemGroup, 2048);
        this.serial3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial4Label = new Label((Composite)modemGroup, 0);
        serial4Label.setText("Serial 4");
        this.serial4 = new Text((Composite)modemGroup, 2048);
        this.serial4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        networkGroup.setText("Network");
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout((Layout)gridLayout_20);
        Label ipxLabel = new Label((Composite)networkGroup, 0);
        ipxLabel.setText("Enable IPX");
        this.ipx = new Button((Composite)networkGroup, 32);
        new Label(composite_5, 0);
        TabItem mountingTabItem = new TabItem(tabFolder, 0);
        mountingTabItem.setText("Mounting");
        Composite composite_6 = new Composite((Composite)tabFolder, 0);
        composite_6.setLayout((Layout)new GridLayout());
        mountingTabItem.setControl((Control)composite_6);
        Group mountGroup = new Group(composite_6, 0);
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mountGroup.setText("Mounting Overview");
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout((Layout)gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)mountGroup, 2560);
        GridData gridData_2 = new GridData(4, 4, true, false, 1, 3);
        this.mountingpoints.setLayoutData((Object)gridData_2);
        Button addButton = new Button((Composite)mountGroup, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mount;
                EditMountDialog addMountDialog = new EditMountDialog(EditTemplateDialog.this.shell);
                List<Character> freeDriveletters = Mount.getFreeDriveletters(EditTemplateDialog.this.booterButton.getSelection(), EditTemplateDialog.this.mountingpoints.getItems());
                if (freeDriveletters.size() > 0) {
                    addMountDialog.setDefaultDriveletter(freeDriveletters.get(0).charValue());
                }
                if ((mount = (String)addMountDialog.open()) != null) {
                    EditTemplateDialog.this.mountingpoints.add(mount);
                    EditTemplateDialog.this.mountingpoints.select(EditTemplateDialog.this.mountingpoints.getItemCount() - 1);
                }
            }
        });
        addButton.setText("Add");
        Button editButton = new Button((Composite)mountGroup, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText("Edit");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() != -1) {
                    EditMountDialog editMountDialog = new EditMountDialog(EditTemplateDialog.this.shell);
                    editMountDialog.setMount(EditTemplateDialog.this.mountingpoints.getItem(EditTemplateDialog.this.mountingpoints.getSelectionIndex()));
                    String mount = (String)editMountDialog.open();
                    if (mount != null) {
                        EditTemplateDialog.this.mountingpoints.setItem(EditTemplateDialog.this.mountingpoints.getSelectionIndex(), mount);
                    }
                }
            }
        });
        Button removeButton = new Button((Composite)mountGroup, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() != -1) {
                    EditTemplateDialog.this.mountingpoints.remove(EditTemplateDialog.this.mountingpoints.getSelectionIndex());
                } else if (EditTemplateDialog.this.mountingpoints.getItemCount() == 1) {
                    EditTemplateDialog.this.mountingpoints.removeAll();
                }
            }
        });
        Group executeGroup = new Group(composite_6, 0);
        executeGroup.setLayoutData((Object)new GridData());
        executeGroup.setText("Execute");
        GridLayout gridLayout_18 = new GridLayout();
        executeGroup.setLayout((Layout)gridLayout_18);
        this.dosButton = new Button((Composite)executeGroup, 16);
        this.dosButton.setText("Dos");
        Label label_1 = new Label((Composite)executeGroup, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.booterButton = new Button((Composite)executeGroup, 16);
        this.booterButton.setText("Booter");
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new RowLayout());
        composite_7.setLayoutData((Object)"South");
        Label capturesLabel = new Label(composite_1, 0);
        capturesLabel.setLayoutData((Object)new GridData());
        capturesLabel.setText("Captures");
        this.captures = new Text(composite_1, 2048);
        this.captures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText("Default");
        final Button defaultButton = new Button(composite, 32);
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData((Object)rowData);
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                int dbversionId = ((DosboxVersion)EditTemplateDialog.this.dbversionsList.get(EditTemplateDialog.this.dbversion.getSelectionIndex())).getId();
                int templateId = EditTemplateDialog.this.db.addOrEditTemplate(EditTemplateDialog.this.title.getText(), dbversionId, defaultButton.getSelection(), EditTemplateDialog.this.result != null ? ((Template)EditTemplateDialog.this.result).getId() : -1);
                EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), dbversionId, defaultButton.getSelection());
                DosboxVersion selectedDBVersion = (DosboxVersion)EditTemplateDialog.this.dbversionsList.get(EditTemplateDialog.this.dbversion.getSelectionIndex());
                Configuration dosboxConf = new Configuration(String.valueOf(selectedDBVersion.getPath()) + "dosbox.conf");
                EditTemplateDialog.this.getConfigurationBySettings(EditTemplateDialog.this.templateConf);
                EditTemplateDialog.this.templateConf.substract(dosboxConf);
                EditTemplateDialog.this.templateConf.saveToFile("templates" + System.getProperty("file.separator") + templateId + ".conf");
                EditTemplateDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData((Object)rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.result = null;
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        if (this.result != null) {
            this.title.setText(((Template)this.result).getTitle());
            defaultButton.setSelection(((Template)this.result).isDefault());
            int tableIndexVersionIndex = ListUtils.findTIDosboxVersion(this.dbversionsList, ((Template)this.result).getdbversionId());
            this.dbversion.select(tableIndexVersionIndex);
            DosboxVersion selectedDBVersion = this.dbversionsList.get(tableIndexVersionIndex);
            this.templateConf = new Configuration(String.valueOf(selectedDBVersion.getPath()) + "dosbox.conf");
            this.templateConf.parseConfigurationFile("templates" + System.getProperty("file.separator") + ((Template)this.result).getId() + ".conf");
            this.selectSettingsByConfiguration(this.templateConf);
        } else {
            int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(this.dbversionsList);
            this.dbversion.select(defaultDosboxVersionIndex);
            DosboxVersion defaultDBVersion = this.dbversionsList.get(defaultDosboxVersionIndex);
            Configuration dosboxConf = new Configuration(String.valueOf(defaultDBVersion.getPath()) + "dosbox.conf");
            this.templateConf = new Configuration(dosboxConf);
            this.selectSettingsByConfiguration(this.templateConf);
            this.exit.setSelection(true);
        }
    }

    private String getAutoexecSectionBySettings() {
        return new Autoexec(this.mountingpoints.getItems(), false, "", "", "", "", "", this.booterButton.getSelection() ? "file" : "", "", this.exit.getSelection()).toString(false);
    }

    private void selectSettingsByAutoexec(Configuration templateConf) {
        Autoexec autoexec = new Autoexec(templateConf.getValue("autoexec", "autoexec"));
        this.exit.setSelection(autoexec.isExit());
        if (this.mountingpoints.getItemCount() == 0) {
            this.mountingpoints.setItems(autoexec.getMountingpoints());
            this.mountingpoints.setSelection(0);
        }
        this.dosButton.setSelection(!autoexec.isBooter());
        this.booterButton.setSelection(autoexec.isBooter());
    }

    private void selectSettingsByConfiguration(Configuration templateConf) {
        String priority = templateConf.getValue("sdl", "priority");
        String[] priorities = priority.split(",");
        if (priorities != null && priorities.length >= 2) {
            this.priority_active.setText(priorities[0]);
            this.priority_inactive.setText(priorities[1]);
        }
        this.waitonerror.setSelection(Boolean.valueOf(templateConf.getValue("sdl", "waitonerror")).booleanValue());
        this.language.setText(templateConf.getValue("dosbox", "language"));
        this.captures.setText(templateConf.getValue("dosbox", "captures"));
        this.output.setText(templateConf.getValue("sdl", "output"));
        this.frameskip.setText(templateConf.getValue("render", "frameskip"));
        this.scaler.setText(templateConf.getValue("render", "scaler"));
        this.fullscreen.setSelection(Boolean.valueOf(templateConf.getValue("sdl", "fullscreen")).booleanValue());
        this.fulldouble.setSelection(Boolean.valueOf(templateConf.getValue("sdl", "fulldouble")).booleanValue());
        this.fullresolution.setText(templateConf.getValue("sdl", "fullresolution"));
        this.windowresolution.setText(templateConf.getValue("sdl", "windowresolution"));
        this.aspect.setSelection(Boolean.valueOf(templateConf.getValue("render", "aspect")).booleanValue());
        this.machine.setText(templateConf.getValue("dosbox", "machine"));
        this.core.setText(templateConf.getValue("cpu", "core"));
        this.cycles.setText(templateConf.getValue("cpu", "cycles"));
        this.cycles_up.setText(templateConf.getValue("cpu", "cycleup"));
        this.cycles_down.setText(templateConf.getValue("cpu", "cycledown"));
        this.timesynched.setSelection(Boolean.valueOf(templateConf.getValue("cpu", "timesynched")).booleanValue());
        this.timesynched.setEnabled(templateConf.hasValue("cpu", "timesynched"));
        this.memsize.setText(templateConf.getValue("dosbox", "memsize"));
        this.xms.setSelection(Boolean.valueOf(templateConf.getValue("dos", "xms")).booleanValue());
        this.ems.setSelection(Boolean.valueOf(templateConf.getValue("dos", "ems")).booleanValue());
        this.umb.setText(templateConf.getValue("dos", "umb"));
        this.nosound.setSelection(Boolean.valueOf(templateConf.getValue("mixer", "nosound")).booleanValue());
        this.rate.setText(templateConf.getValue("mixer", "rate"));
        this.blocksize.setText(templateConf.getValue("mixer", "blocksize"));
        this.prebuffer.setText(templateConf.getValue("mixer", "prebuffer"));
        this.mpu401.setText(templateConf.getValue("midi", "mpu401"));
        this.device.setText(templateConf.getValue("midi", "device"));
        this.midi_config.setText(templateConf.getValue("midi", "config"));
        this.sbtype.setText(templateConf.getValue("sblaster", "sbtype"));
        this.oplmode.setText(templateConf.getValue("sblaster", "oplmode"));
        this.oplrate.setText(templateConf.getValue("sblaster", "oplrate"));
        this.sbbase.setText(templateConf.getValue("sblaster", "sbbase"));
        this.irq.setText(templateConf.getValue("sblaster", "irq"));
        this.dma.setText(templateConf.getValue("sblaster", "dma"));
        this.hdma.setText(templateConf.getValue("sblaster", "hdma"));
        this.mixer.setSelection(Boolean.valueOf(templateConf.getValue("sblaster", "mixer")).booleanValue());
        this.gus.setSelection(Boolean.valueOf(templateConf.getValue("gus", "gus")).booleanValue());
        this.gusrate.setText(templateConf.getValue("gus", "gusrate"));
        this.gusbase.setText(templateConf.getValue("gus", "gusbase"));
        this.irq1.setText(templateConf.getValue("gus", "irq1"));
        this.irq2.setText(templateConf.getValue("gus", "irq2"));
        this.dma1.setText(templateConf.getValue("gus", "dma1"));
        this.dma2.setText(templateConf.getValue("gus", "dma2"));
        this.ultradir.setText(templateConf.getValue("gus", "ultradir"));
        this.pcspeaker.setSelection(Boolean.valueOf(templateConf.getValue("speaker", "pcspeaker")).booleanValue());
        this.pcrate.setText(templateConf.getValue("speaker", "pcrate"));
        this.tandy.setText(templateConf.getValue("speaker", "tandy"));
        this.tandyrate.setText(templateConf.getValue("speaker", "tandyrate"));
        this.disney.setSelection(Boolean.valueOf(templateConf.getValue("speaker", "disney")).booleanValue());
        this.autolock.setSelection(Boolean.valueOf(templateConf.getValue("sdl", "autolock")).booleanValue());
        this.sensitivity.setText(templateConf.getValue("sdl", "sensitivity"));
        this.usescancodes.setSelection(Boolean.valueOf(templateConf.getValue("sdl", "usescancodes")).booleanValue());
        this.mapperfile.setText(templateConf.getValue("sdl", "mapperfile"));
        this.joysticktype.setText(templateConf.getValue("bios", "joysticktype"));
        this.serial1.setText(templateConf.getValue("serial", "serial1"));
        this.serial2.setText(templateConf.getValue("serial", "serial2"));
        this.serial3.setText(templateConf.getValue("serial", "serial3"));
        this.serial4.setText(templateConf.getValue("serial", "serial4"));
        this.ipx.setSelection(Boolean.valueOf(templateConf.getValue("ipx", "ipx")).booleanValue());
        this.selectSettingsByAutoexec(templateConf);
    }

    private void getConfigurationBySettings(Configuration templateConf) {
        templateConf.setValue("sdl", "priority", String.valueOf(this.priority_active.getText()) + "," + this.priority_inactive.getText());
        templateConf.setValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()));
        templateConf.setValue("dosbox", "language", this.language.getText());
        templateConf.setValue("dosbox", "captures", this.captures.getText());
        templateConf.setValue("sdl", "output", this.output.getText());
        templateConf.setValue("render", "frameskip", this.frameskip.getText());
        templateConf.setValue("render", "scaler", this.scaler.getText());
        templateConf.setValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()));
        templateConf.setValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()));
        templateConf.setValue("sdl", "fullresolution", this.fullresolution.getText());
        templateConf.setValue("sdl", "windowresolution", this.windowresolution.getText());
        templateConf.setValue("render", "aspect", String.valueOf(this.aspect.getSelection()));
        templateConf.setValue("dosbox", "machine", this.machine.getText());
        templateConf.setValue("cpu", "core", this.core.getText());
        templateConf.setValue("cpu", "cycles", this.cycles.getText());
        templateConf.setValue("cpu", "cycleup", this.cycles_up.getText());
        templateConf.setValue("cpu", "cycledown", this.cycles_down.getText());
        templateConf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()));
        templateConf.setValue("dosbox", "memsize", this.memsize.getText());
        templateConf.setValue("dos", "xms", String.valueOf(this.xms.getSelection()));
        templateConf.setValue("dos", "ems", String.valueOf(this.ems.getSelection()));
        templateConf.setValue("dos", "umb", this.umb.getText());
        templateConf.setValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()));
        templateConf.setValue("mixer", "rate", this.rate.getText());
        templateConf.setValue("mixer", "blocksize", this.blocksize.getText());
        templateConf.setValue("mixer", "prebuffer", this.prebuffer.getText());
        templateConf.setValue("midi", "mpu401", this.mpu401.getText());
        templateConf.setValue("midi", "device", this.device.getText());
        templateConf.setValue("midi", "config", this.midi_config.getText());
        templateConf.setValue("sblaster", "sbtype", this.sbtype.getText());
        templateConf.setValue("sblaster", "oplmode", this.oplmode.getText());
        templateConf.setValue("sblaster", "sbbase", this.sbbase.getText());
        templateConf.setValue("sblaster", "irq", this.irq.getText());
        templateConf.setValue("sblaster", "dma", this.dma.getText());
        templateConf.setValue("sblaster", "hdma", this.hdma.getText());
        templateConf.setValue("sblaster", "mixer", String.valueOf(this.mixer.getSelection()));
        templateConf.setValue("gus", "gus", String.valueOf(this.gus.getSelection()));
        templateConf.setValue("gus", "gusrate", this.gusrate.getText());
        templateConf.setValue("gus", "gusbase", this.gusbase.getText());
        templateConf.setValue("gus", "irq1", this.irq1.getText());
        templateConf.setValue("gus", "irq2", this.irq2.getText());
        templateConf.setValue("gus", "dma1", this.dma1.getText());
        templateConf.setValue("gus", "dma2", this.dma2.getText());
        templateConf.setValue("gus", "ultradir", this.ultradir.getText());
        templateConf.setValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()));
        templateConf.setValue("speaker", "pcrate", this.pcrate.getText());
        templateConf.setValue("speaker", "tandy", this.tandy.getText());
        templateConf.setValue("speaker", "tandyrate", this.tandyrate.getText());
        templateConf.setValue("speaker", "disney", String.valueOf(this.disney.getSelection()));
        templateConf.setValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()));
        templateConf.setValue("sdl", "sensitivity", this.sensitivity.getText());
        templateConf.setValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()));
        templateConf.setValue("sdl", "mapperfile", this.mapperfile.getText());
        templateConf.setValue("bios", "joysticktype", this.joysticktype.getText());
        templateConf.setValue("serial", "serial1", this.serial1.getText());
        templateConf.setValue("serial", "serial2", this.serial2.getText());
        templateConf.setValue("serial", "serial3", this.serial3.getText());
        templateConf.setValue("serial", "serial4", this.serial4.getText());
        templateConf.setValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()));
        templateConf.setValue("autoexec", "autoexec", this.getAutoexecSectionBySettings());
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a template title", (Control)this.title, this.infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

