/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditDosboxVersionDialog;
import com.gui.EditProfileDialog;
import com.gui.EditTemplateDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.StreamGobbler;
import com.gui.Thumb;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Developer;
import com.model.DosboxVersion;
import com.model.Genre;
import com.model.Profile;
import com.model.Publisher;
import com.model.Status;
import com.model.Template;
import com.model.Year;
import com.swtdesigner.SWTResourceManager;
import com.util.FileUtils;
import com.util.ListUtils;
import com.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow {
    public static final String PROGRAM_NAME = "DOSBox Game Launcher v0.41";
    public static final String CAPTURES_DIR = "captures";
    public static final String TEMPLATES_DIR = "templates";
    public static final String PROFILES_DIR = "profiles";
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String SETUP_CONF = "setup.conf";
    public static final String DFEND_PATH = "C:/Program Files/D-Fend";
    private static final int THUMB_HEIGHT = 100;
    private static final String SETTINGS_CONF = "settings.conf";
    private Display display;
    protected Shell shell;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private Database db = null;
    private Configuration settings = null;
    private Table template_table;
    private Table dosboxversion_table;
    private Table profile_table;
    private Text notesField;
    private ToolBar thumbsToolBar;
    private Link link1;
    private Link link2;

    public static void main(String[] args) {
        try {
            MainWindow window = new MainWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.db = Database.getInstance();
        this.loadSettings();
        this.display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        this.saveSettings();
        this.db.shutdown();
    }

    protected void createContents() {
        this.profilesList = this.db.readProfilesList(this.settings.getIntValue("gui", "sortcolumn"), this.settings.getBooleanValue("gui", "sortascending"));
        this.dbversionsList = this.db.readDosboxVersionsList();
        this.templatesList = this.db.readTemplatesList();
        this.shell = new Shell();
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                boolean isMaximized = MainWindow.this.shell.getMaximized();
                if (!isMaximized) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "width", rec.width);
                    MainWindow.this.settings.setIntValue("gui", "height", rec.height);
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
                MainWindow.this.settings.setBooleanValue("gui", "maximized", isMaximized);
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
            }
        });
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setMaximized(this.settings.getBooleanValue("gui", "maximized"));
        this.shell.setLocation(this.settings.getIntValue("gui", "x"), this.settings.getIntValue("gui", "y"));
        this.shell.setSize(this.settings.getIntValue("gui", "width"), this.settings.getIntValue("gui", "height"));
        this.shell.setText(PROGRAM_NAME);
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem profilesTabItem = new TabItem(tabFolder, 0);
        profilesTabItem.setText("Profiles");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        profilesTabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        ToolItem newItemToolItem = new ToolItem(toolBar, 8);
        newItemToolItem.setText("Add profile");
        newItemToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddProfile();
            }
        });
        ToolItem newItemToolItem_2 = new ToolItem(toolBar, 8);
        newItemToolItem_2.setText("Edit Profile");
        newItemToolItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditProfile();
            }
        });
        ToolItem newItemToolItem_1 = new ToolItem(toolBar, 8);
        newItemToolItem_1.setText("Remove profile");
        newItemToolItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveProfile();
            }
        });
        TabItem dosboxTabItem = new TabItem(tabFolder, 0);
        dosboxTabItem.setText("DOSBox versions");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        dosboxTabItem.setControl((Control)composite_1);
        this.dosboxversion_table = new Table(composite_1, 67584);
        this.dosboxversion_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (e.keyCode == 0x1000009) {
                    MainWindow.this.doAddDosboxVersion();
                }
            }
        });
        this.dosboxversion_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        });
        this.dosboxversion_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainWindow.this.doRunDosbox();
            }
        });
        this.dosboxversion_table.setLinesVisible(true);
        this.dosboxversion_table.setHeaderVisible(true);
        TableColumn newColumnTableColumn_6 = new TableColumn(this.dosboxversion_table, 0);
        newColumnTableColumn_6.setWidth(201);
        newColumnTableColumn_6.setText("Title");
        TableColumn newColumnTableColumn_7 = new TableColumn(this.dosboxversion_table, 0);
        newColumnTableColumn_7.setWidth(218);
        newColumnTableColumn_7.setText("Path");
        TableColumn newColumnTableColumn_8 = new TableColumn(this.dosboxversion_table, 0);
        newColumnTableColumn_8.setWidth(100);
        newColumnTableColumn_8.setText("Default");
        ToolBar toolBar_1 = new ToolBar(composite_1, 0);
        toolBar_1.setLayoutData((Object)"North");
        ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, 8);
        newItemToolItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddDosboxVersion();
            }
        });
        newItemToolItem_3.setText("Add version");
        ToolItem newItemToolItem_2_1 = new ToolItem(toolBar_1, 8);
        newItemToolItem_2_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditDosboxVersion();
            }
        });
        newItemToolItem_2_1.setText("Edit version");
        ToolItem newItemToolItem_1_1 = new ToolItem(toolBar_1, 8);
        newItemToolItem_1_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        });
        newItemToolItem_1_1.setText("Remove version");
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem fileMenuItem = new MenuItem(menu, 64);
        fileMenuItem.setText("File");
        Menu menu_1 = new Menu(fileMenuItem);
        fileMenuItem.setMenu(menu_1);
        MenuItem dfendImportMenuItem = new MenuItem(menu_1, 0);
        dfendImportMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doDFendImport();
            }
        });
        dfendImportMenuItem.setText("D-Fend Import");
        new MenuItem(menu_1, 2);
        MenuItem exitMenuItem = new MenuItem(menu_1, 0);
        exitMenuItem.setText("Exit");
        exitMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.shell.close();
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(120);
        scrolledComposite.setLayoutData((Object)"South");
        this.thumbsToolBar = new ToolBar((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.thumbsToolBar);
        final SashForm sashForm = new SashForm(composite, 0);
        this.profile_table = new Table((Composite)sashForm, 67584);
        this.profile_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.doRemoveProfile();
                } else if (e.keyCode == 0x1000009) {
                    MainWindow.this.doAddProfile();
                }
            }
        });
        this.profile_table.setLinesVisible(true);
        this.profile_table.setLayoutData((Object)"West");
        this.profile_table.setHeaderVisible(true);
        this.profile_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.stateMask == 262144 && e.detail == 4) {
                    MainWindow.this.doEditProfile();
                } else if (e.stateMask == 131072 && e.detail == 4) {
                    MainWindow.this.doRunProfileSetup();
                } else if (e.detail == 4) {
                    MainWindow.this.doRunProfile();
                }
            }
        });
        this.profile_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainWindow.this.doRunProfile();
            }
        });
        final TableColumn profileTitleColumn = new TableColumn(this.profile_table, 0);
        profileTitleColumn.setMoveable(true);
        profileTitleColumn.setWidth(this.settings.getIntValue("gui", "column1width"));
        profileTitleColumn.setText("Title");
        profileTitleColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(0, e);
            }
        });
        profileTitleColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column1width", profileTitleColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileSetupColumn = new TableColumn(this.profile_table, 0);
        profileSetupColumn.setMoveable(true);
        profileSetupColumn.setWidth(this.settings.getIntValue("gui", "column2width"));
        profileSetupColumn.setText("Setup");
        profileSetupColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(1, e);
            }
        });
        profileSetupColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column2width", profileSetupColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileDeveloperColumn = new TableColumn(this.profile_table, 0);
        profileDeveloperColumn.setMoveable(true);
        profileDeveloperColumn.setWidth(this.settings.getIntValue("gui", "column3width"));
        profileDeveloperColumn.setText("Developer");
        profileDeveloperColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(2, e);
            }
        });
        profileDeveloperColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column3width", profileDeveloperColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profilePublisherColumn = new TableColumn(this.profile_table, 0);
        profilePublisherColumn.setMoveable(true);
        profilePublisherColumn.setWidth(this.settings.getIntValue("gui", "column4width"));
        profilePublisherColumn.setText("Publisher");
        profilePublisherColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(3, e);
            }
        });
        profilePublisherColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column4width", profilePublisherColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileGenreColumn = new TableColumn(this.profile_table, 0);
        profileGenreColumn.setMoveable(true);
        profileGenreColumn.setWidth(this.settings.getIntValue("gui", "column5width"));
        profileGenreColumn.setText("Genre");
        profileGenreColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(4, e);
            }
        });
        profileGenreColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column5width", profileGenreColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileYearColumn = new TableColumn(this.profile_table, 0);
        profileYearColumn.setMoveable(true);
        profileYearColumn.setWidth(this.settings.getIntValue("gui", "column6width"));
        profileYearColumn.setText("Year");
        profileYearColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(5, e);
            }
        });
        profileYearColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column6width", profileYearColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileStatusColumn = new TableColumn(this.profile_table, 0);
        profileStatusColumn.setMoveable(true);
        profileStatusColumn.setWidth(this.settings.getIntValue("gui", "column7width"));
        profileStatusColumn.setText("Status");
        profileStatusColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(6, e);
            }
        });
        profileStatusColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column7width", profileStatusColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileFavoriteColumn = new TableColumn(this.profile_table, 0);
        profileFavoriteColumn.setMoveable(true);
        profileFavoriteColumn.setWidth(this.settings.getIntValue("gui", "column8width"));
        profileFavoriteColumn.setText("Favorite");
        profileFavoriteColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(7, e);
            }
        });
        profileFavoriteColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column8width", profileFavoriteColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        final TableColumn profileIdColumn = new TableColumn(this.profile_table, 0);
        profileIdColumn.setMoveable(true);
        profileIdColumn.setWidth(this.settings.getIntValue("gui", "column9width"));
        profileIdColumn.setText("ID");
        profileIdColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(8, e);
            }
        });
        profileIdColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", "column9width", profileIdColumn.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "columnorder", StringUtils.intArrayToString(MainWindow.this.profile_table.getColumnOrder()));
            }
        });
        this.profile_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.displayProfileInformation();
            }
        });
        Composite informationGroup = new Composite((Composite)sashForm, 0);
        informationGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setValue("gui", "sashweights", StringUtils.intArrayToString(sashForm.getWeights()));
            }
        });
        informationGroup.setLayout((Layout)new BorderLayout(0, 0));
        this.notesField = new Text(informationGroup, 2634);
        Composite composite_2 = new Composite(informationGroup, 0);
        composite_2.setLayout((Layout)new BorderLayout(0, 0));
        composite_2.setLayoutData((Object)"South");
        this.link1 = new Link(composite_2, 0);
        this.link1.setLayoutData((Object)"North");
        this.link1.setText(" ");
        this.link1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program p = Program.findProgram((String)".html");
                if (p != null) {
                    p.execute(e.text);
                }
            }
        });
        this.link2 = new Link(composite_2, 0);
        this.link2.setText(" ");
        this.link2.setLayoutData((Object)"South");
        this.link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program p = Program.findProgram((String)".html");
                if (p != null) {
                    p.execute(e.text);
                }
            }
        });
        sashForm.setWeights(StringUtils.stringToIntArray(this.settings.getValue("gui", "sashweights")));
        TabItem templatesTabItem = new TabItem(tabFolder, 0);
        templatesTabItem.setText("Templates");
        Composite composite_1_1 = new Composite((Composite)tabFolder, 0);
        composite_1_1.setLayout((Layout)new BorderLayout(0, 0));
        templatesTabItem.setControl((Control)composite_1_1);
        this.template_table = new Table(composite_1_1, 67584);
        this.template_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.doRemoveTemplate();
                } else if (e.keyCode == 0x1000009) {
                    MainWindow.this.doAddTemplate();
                }
            }
        });
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        TableColumn newColumnTableColumn_6_1 = new TableColumn(this.template_table, 0);
        newColumnTableColumn_6_1.setWidth(300);
        newColumnTableColumn_6_1.setText("Title");
        TableColumn newColumnTableColumn_8_1 = new TableColumn(this.template_table, 0);
        newColumnTableColumn_8_1.setWidth(50);
        newColumnTableColumn_8_1.setText("Default");
        ToolBar toolBar_1_1 = new ToolBar(composite_1_1, 0);
        toolBar_1_1.setLayoutData((Object)"North");
        ToolItem newItemToolItem_3_1 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_3_1.setText("Add template");
        newItemToolItem_3_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddTemplate();
            }
        });
        ToolItem newItemToolItem_2_1_1 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_2_1_1.setText("Edit template");
        newItemToolItem_2_1_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditTemplate();
            }
        });
        ToolItem newItemToolItem_1_1_1 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_1_1_1.setText("Remove template");
        newItemToolItem_1_1_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveTemplate();
            }
        });
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        for (DosboxVersion dbversion : this.dbversionsList) {
            this.addDosboxVersionToTable(dbversion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setSortColumn(this.profile_table.getColumn(this.settings.getIntValue("gui", "sortcolumn")));
        this.profile_table.setSortDirection(this.settings.getBooleanValue("gui", "sortascending") ? 128 : 1024);
        this.profile_table.setColumnOrder(StringUtils.stringToIntArray(this.settings.getValue("gui", "columnorder")));
    }

    private void doReorderProfiles(int columnId, SelectionEvent e) {
        TableColumn sortColumn = this.profile_table.getSortColumn();
        TableColumn currentColumn = (TableColumn)e.widget;
        int dir = this.profile_table.getSortDirection();
        if (sortColumn == currentColumn) {
            dir = dir == 128 ? 1024 : 128;
        } else {
            this.profile_table.setSortColumn(currentColumn);
            dir = 128;
        }
        int currentProfileId = -1;
        if (this.profile_table.getSelectionIndex() != -1) {
            currentProfileId = this.profilesList.get(this.profile_table.getSelectionIndex()).getId();
        }
        this.profilesList = this.db.readProfilesList(columnId, dir == 128);
        int i = 0;
        while (i < this.profilesList.size()) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
            ++i;
        }
        this.profile_table.setSortDirection(dir);
        if (currentProfileId != -1) {
            this.profile_table.setSelection(ListUtils.findTIProfile(this.profilesList, currentProfileId));
            this.profile_table.showSelection();
        }
        this.settings.setIntValue("gui", "sortcolumn", columnId);
        this.settings.setBooleanValue("gui", "sortascending", dir == 128);
    }

    private void displayNotes(String notes) {
        this.notesField.setText(notes);
    }

    private void displayLinks(String p_link1, String p_link2) {
        if (p_link1 != null && !p_link1.equals("")) {
            this.link1.setText("<a href=\"" + p_link1 + "\">" + p_link1 + "</a>");
        } else {
            this.link1.setText(" ");
        }
        if (p_link2 != null && !p_link2.equals("")) {
            this.link2.setText("<a href=\"" + p_link2 + "\">" + p_link2 + "</a>");
        } else {
            this.link2.setText(" ");
        }
    }

    private void displayScreenshots(int profileId) {
        ToolItem[] toolItems = this.thumbsToolBar.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
        File path = new File(CAPTURES_DIR + System.getProperty("file.separator") + profileId + System.getProperty("file.separator"));
        String[] files = path.list();
        if (files != null) {
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].toLowerCase().endsWith(".png")) {
                    Image thumb = SWTResourceManager.getImage(CAPTURES_DIR + System.getProperty("file.separator") + profileId + System.getProperty("file.separator") + files[i2]);
                    ImageData smallThumb = thumb.getImageData();
                    int width = smallThumb.width;
                    int height = smallThumb.height;
                    double factor = 100.0 / (double)height;
                    smallThumb = smallThumb.scaledTo((int)((double)width * factor), (int)((double)height * factor));
                    final ToolItem toolItem = new ToolItem(this.thumbsToolBar, 8);
                    toolItem.setImage(new Image((Device)this.display, smallThumb));
                    toolItem.setToolTipText(CAPTURES_DIR + System.getProperty("file.separator") + profileId + System.getProperty("file.separator") + files[i2]);
                    toolItem.setText(files[i2]);
                    toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Thumb thumbDialog = new Thumb(MainWindow.this.shell);
                            thumbDialog.setThumb(toolItem.getToolTipText());
                            thumbDialog.open();
                        }
                    });
                    toolItem.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            toolItem.getImage().dispose();
                        }
                    });
                }
                ++i2;
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getItemCount() != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        if (ListUtils.findTIDefaultDosboxVersion(this.dbversionsList) == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "You must first define a default DOSBox version!");
            return;
        }
        EditProfileDialog addProfileDialog = new EditProfileDialog(this.shell);
        addProfileDialog.setDatabase(this.db);
        Profile profile = (Profile)addProfileDialog.open();
        if (profile != null) {
            this.profilesList.add(profile);
            this.addProfileToTable(profile);
            this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
            this.profile_table.showSelection();
            this.profile_table.setFocus();
        }
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog addDosboxVersionDialog = new EditDosboxVersionDialog(this.shell);
        addDosboxVersionDialog.setDatabase(this.db);
        DosboxVersion dbversion = (DosboxVersion)addDosboxVersionDialog.open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (ListUtils.findTIDefaultDosboxVersion(this.dbversionsList) == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "You must first define a default DOSBox version!");
            return;
        }
        EditTemplateDialog addTemplateDialog = new EditTemplateDialog(this.shell);
        addTemplateDialog.setDatabase(this.db);
        Template template = (Template)addTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doEditProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
            editProfileDialog.setDatabase(this.db);
            editProfileDialog.setProfile(this.profilesList.get(index));
            Profile profile = (Profile)editProfileDialog.open();
            if (profile != null) {
                this.profilesList.set(index, profile);
                this.setTableItem(this.profile_table.getItem(index), profile);
                this.displayProfileInformation();
            }
        }
    }

    private void doEditDosboxVersion() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1) {
            EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(this.shell);
            editDosboxVersionDialog.setDatabase(this.db);
            editDosboxVersionDialog.setDosboxVersion(this.dbversionsList.get(index));
            DosboxVersion dbversion = (DosboxVersion)editDosboxVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        this.dbversionsList = this.db.readDosboxVersionsList();
        this.dosboxversion_table.removeAll();
        for (DosboxVersion version : this.dbversionsList) {
            this.addDosboxVersionToTable(version);
        }
        this.dosboxversion_table.setSelection(ListUtils.findTIDosboxVersion(this.dbversionsList, dbversion.getId()));
        this.dosboxversion_table.showSelection();
        this.dosboxversion_table.setFocus();
    }

    private void updateTemplateList(Template template) {
        this.templatesList = this.db.readTemplatesList();
        this.template_table.removeAll();
        for (Template temp : this.templatesList) {
            this.addTemplateToTable(temp);
        }
        this.template_table.setSelection(ListUtils.findTITemplate(this.templatesList, template.getId()));
        this.template_table.showSelection();
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            EditTemplateDialog editTemplateDialog = new EditTemplateDialog(this.shell);
            editTemplateDialog.setDatabase(this.db);
            editTemplateDialog.setTemplate(this.templatesList.get(index));
            Template template = (Template)editTemplateDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected profile?")) {
            int profileId = this.profilesList.get(index).getId();
            this.db.removeProfile(profileId);
            this.profile_table.remove(index);
            this.profilesList.remove(index);
            String conffile = PROFILES_DIR + System.getProperty("file.separator") + profileId + ".conf";
            if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated conf file " + conffile + " ?")) {
                FileUtils.removeFile(conffile);
            }
            this.displayProfileInformation();
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected DOSBox version?")) {
            this.db.removeDosboxVersion(this.dbversionsList.get(index).getId());
            this.dosboxversion_table.remove(index);
            this.dbversionsList.remove(index);
        }
    }

    private void doRemoveTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected template?")) {
            int templateId = this.templatesList.get(index).getId();
            this.db.removeTemplate(templateId);
            this.template_table.remove(index);
            this.templatesList.remove(index);
            String conffile = TEMPLATES_DIR + System.getProperty("file.separator") + templateId + ".conf";
            if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated conf file " + conffile + " ?")) {
                FileUtils.removeFile(conffile);
            }
        }
    }

    private void addProfileToTable(Profile prof) {
        TableItem newItemTableItem = new TableItem(this.profile_table, 2048);
        this.setTableItem(newItemTableItem, prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        TableItem newItemTableItem = new TableItem(this.dosboxversion_table, 2048);
        this.setTableItem(newItemTableItem, dbversion);
    }

    private void addTemplateToTable(Template template) {
        TableItem newItemTableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(newItemTableItem, template);
    }

    private void setTableItem(TableItem newItemTableItem, Profile prof) {
        newItemTableItem.setText(0, prof.getTitle());
        newItemTableItem.setText(1, prof.hasSetup());
        newItemTableItem.setText(2, prof.getDeveloperName());
        newItemTableItem.setText(3, prof.getPublisherName());
        newItemTableItem.setText(4, prof.getGenre());
        newItemTableItem.setText(5, prof.getYear());
        newItemTableItem.setText(6, prof.getStatus());
        newItemTableItem.setText(7, prof.isFavoriteString());
        newItemTableItem.setText(8, String.valueOf(prof.getId()));
    }

    private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getPath());
        newItemTableItem.setText(2, dbversion.isDefaultVersionString());
    }

    private void setTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefaultString());
    }

    private void doRunProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            this.doRunProfile(prof, String.valueOf(prof.getId()) + ".conf");
        }
    }

    private void executeCommand(List<String> execCommands) throws IOException {
        String[] rtCmds = new String[execCommands.size()];
        int i = 0;
        while (i < execCommands.size()) {
            rtCmds[i] = execCommands.get(i);
            System.out.print(String.valueOf(rtCmds[i]) + " ");
            ++i;
        }
        System.out.println();
        Process proc = Runtime.getRuntime().exec(rtCmds);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
        outputGobbler.start();
        errorGobbler.start();
    }

    private void doRunProfile(Profile prof, String filename) {
        try {
            int dbversionIndex = ListUtils.findTIDosboxVersion(this.dbversionsList, prof.getDbversionId());
            DosboxVersion dbversion = this.dbversionsList.get(dbversionIndex);
            ArrayList<String> confs = new ArrayList<String>();
            if (dbversion.getPath().indexOf(47) != -1) {
                confs.add(String.valueOf(dbversion.getPath()) + "dosbox");
            } else {
                confs.add(String.valueOf(dbversion.getPath()) + "DOSBox.exe");
            }
            if (dbversion.isMultiConfig()) {
                confs.add("-conf");
                confs.add(String.valueOf(dbversion.getPath()) + DOSBOX_CONF);
            }
            confs.add("-conf");
            confs.add(PROFILES_DIR + System.getProperty("file.separator") + filename);
            this.executeCommand(confs);
        }
        catch (IOException e) {
            System.err.println("Profile could not be started!!\n");
        }
    }

    private void doRunProfileSetup() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            Configuration conf = new Configuration(PROFILES_DIR + System.getProperty("file.separator") + prof.getId() + ".conf");
            Autoexec autoexec = new Autoexec(conf.getValue("autoexec", "autoexec"));
            autoexec.setSetup(prof.getSetup());
            autoexec.setSetupParameters(prof.getSetupParameters());
            conf.setValue("autoexec", "autoexec", autoexec.toString(true));
            conf.saveToFile(PROFILES_DIR + System.getProperty("file.separator") + SETUP_CONF);
            this.doRunProfile(prof, SETUP_CONF);
        }
    }

    private void doRunDosbox() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1) {
            try {
                DosboxVersion dbversion = this.dbversionsList.get(index);
                ArrayList<String> confs = new ArrayList<String>();
                if (dbversion.getPath().indexOf(47) != -1) {
                    confs.add(String.valueOf(dbversion.getPath()) + "dosbox");
                } else {
                    confs.add(String.valueOf(dbversion.getPath()) + "DOSBox.exe");
                }
                confs.add("-conf");
                confs.add(String.valueOf(dbversion.getPath()) + DOSBOX_CONF);
                this.executeCommand(confs);
            }
            catch (IOException e) {
                System.err.println("Dosbox could not be started!!\n");
            }
        }
    }

    private void loadSettings() {
        this.settings = new Configuration(SETTINGS_CONF);
        this.settings.createSection("gui");
        if (this.settings.getValue("gui", "width").equals("")) {
            this.settings.setValue("gui", "width", "706");
        }
        if (this.settings.getValue("gui", "height").equals("")) {
            this.settings.setValue("gui", "height", "375");
        }
        if (this.settings.getValue("gui", "x").equals("")) {
            this.settings.setValue("gui", "x", "10");
        }
        if (this.settings.getValue("gui", "y").equals("")) {
            this.settings.setValue("gui", "y", "10");
        }
        if (this.settings.getValue("gui", "maximized").equals("")) {
            this.settings.setBooleanValue("gui", "maximized", false);
        }
        if (this.settings.getValue("gui", "column1width").equals("")) {
            this.settings.setValue("gui", "column1width", "100");
        }
        if (this.settings.getValue("gui", "column2width").equals("")) {
            this.settings.setValue("gui", "column2width", "40");
        }
        if (this.settings.getValue("gui", "column3width").equals("")) {
            this.settings.setValue("gui", "column3width", "100");
        }
        if (this.settings.getValue("gui", "column4width").equals("")) {
            this.settings.setValue("gui", "column4width", "100");
        }
        if (this.settings.getValue("gui", "column5width").equals("")) {
            this.settings.setValue("gui", "column5width", "100");
        }
        if (this.settings.getValue("gui", "column6width").equals("")) {
            this.settings.setValue("gui", "column6width", "40");
        }
        if (this.settings.getValue("gui", "column7width").equals("")) {
            this.settings.setValue("gui", "column7width", "60");
        }
        if (this.settings.getValue("gui", "column8width").equals("")) {
            this.settings.setValue("gui", "column8width", "40");
        }
        if (this.settings.getValue("gui", "column9width").equals("")) {
            this.settings.setValue("gui", "column9width", "40");
        }
        if (this.settings.getValue("gui", "sortcolumn").equals("")) {
            this.settings.setIntValue("gui", "sortcolumn", 0);
        }
        if (this.settings.getValue("gui", "sortascending").equals("")) {
            this.settings.setBooleanValue("gui", "sortascending", true);
        }
        if (this.settings.getValue("gui", "columnorder").equals("")) {
            this.settings.setValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
        }
        if (this.settings.getValue("gui", "sashweights").equals("")) {
            this.settings.setValue("gui", "sashweights", "5 2");
        }
    }

    private void saveSettings() {
        this.settings.saveToFile(SETTINGS_CONF, true);
    }

    private void doDFendImport() {
        int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(this.dbversionsList);
        if (defaultDosboxVersionIndex == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "You must first define a default DOSBox version!");
            return;
        }
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterPath(DFEND_PATH);
        dialog.setFileName("Profiles.dat");
        dialog.setFilterNames(new String[]{"D-Fend Profiles"});
        dialog.setFilterExtensions(new String[]{"Profiles.dat"});
        String dfendProfilesFile = dialog.open();
        if (dfendProfilesFile == null) {
            return;
        }
        boolean performCleanup = GeneralPurposeDialogs.confirmMessageYN(this.shell, "Would you like to perform some extra profile cleanup (remove sections directserial, modem, ipx and sdl) while importing?");
        DosboxVersion defaultDBVersion = this.dbversionsList.get(defaultDosboxVersionIndex);
        Configuration standardProfile = new Configuration(String.valueOf(defaultDBVersion.getPath()) + DOSBOX_CONF);
        Configuration profiles = new Configuration(dfendProfilesFile, false);
        for (String title : profiles.getSections().keySet()) {
            String profFile = profiles.getValue(title, "prof");
            String confFile = profiles.getValue(title, "conf");
            boolean favorite = profiles.getValue(title, "fav").equals("1");
            Configuration dfendExtra = new Configuration(profFile, false);
            String setup = dfendExtra.getValue("Extra", "Setup");
            String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
            String notes = dfendExtra.getValue("ExtraInfo", "Notes");
            String dev = dfendExtra.getValue("ExtraInfo", "Developer");
            String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
            String gen = dfendExtra.getValue("ExtraInfo", "Genre");
            String yr = dfendExtra.getValue("ExtraInfo", "Year");
            String st = "Unknown";
            String cap = dfendExtra.getValue("dosbox", CAPTURES_DIR);
            int devIndex = -1;
            int publIndex = -1;
            int genIndex = -1;
            int yrIndex = -1;
            int statIndex = -1;
            Iterator<Developer> devIt = this.db.readDevelopersList().iterator();
            Iterator<Publisher> pubIt = this.db.readPublishersList().iterator();
            Iterator<Genre> genIt = this.db.readGenresList().iterator();
            Iterator<Year> yrIt = this.db.readYearsList().iterator();
            Iterator<Status> statIt = this.db.readStatusList().iterator();
            while (devIt.hasNext()) {
                Developer developer = devIt.next();
                if (!developer.getName().equals(dev)) continue;
                devIndex = developer.getId();
                break;
            }
            while (pubIt.hasNext()) {
                Publisher publisher = pubIt.next();
                if (!publisher.getName().equals(pub)) continue;
                publIndex = publisher.getId();
                break;
            }
            while (genIt.hasNext()) {
                Genre genre = genIt.next();
                if (!genre.getName().equals(gen)) continue;
                genIndex = genre.getId();
                break;
            }
            while (yrIt.hasNext()) {
                Year year = yrIt.next();
                if (!year.getYear().equals(yr)) continue;
                yrIndex = year.getId();
                break;
            }
            while (statIt.hasNext()) {
                Status stat = statIt.next();
                if (!stat.getStat().equals(st)) continue;
                statIndex = stat.getId();
                break;
            }
            int profileId = this.db.addOrEditProfile(title, dev, pub, gen, yr, st, setup, setupParams, notes, "", "", favorite, devIndex, publIndex, genIndex, yrIndex, statIndex, defaultDBVersion.getId(), -1);
            Configuration dfendProfile = new Configuration(confFile);
            Autoexec autoexec = new Autoexec(dfendProfile.getValue("autoexec", "autoexec"));
            dfendProfile.setValue("autoexec", "autoexec", autoexec.toString(false));
            MainWindow.setCapturesDir(dfendProfile, profileId, cap);
            if (performCleanup) {
                dfendProfile.removeSection("directserial");
                dfendProfile.removeSection("modem");
                dfendProfile.removeSection("ipx");
                dfendProfile.removeSection("sdl");
            }
            dfendProfile.removeValue("gus", "base");
            dfendProfile.removeValue("gus", "rate");
            dfendProfile.removeValue("sblaster", "base");
            dfendProfile.removeValue("sblaster", "type");
            if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
                if (dfendProfile.getValue("midi", "intelligent").equals("true")) {
                    dfendProfile.setValue("midi", "mpu401", "intelligent");
                } else if (dfendProfile.getValue("midi", "intelligent").equals("false")) {
                    dfendProfile.setValue("midi", "mpu401", "uart");
                }
            } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
                dfendProfile.setValue("midi", "mpu401", "none");
            }
            dfendProfile.removeValue("midi", "intelligent");
            if (defaultDBVersion.isMultiConfig()) {
                dfendProfile.substract(standardProfile);
            }
            dfendProfile.saveToFile(PROFILES_DIR + System.getProperty("file.separator") + profileId + ".conf");
        }
        this.profilesList = this.db.readProfilesList(this.settings.getIntValue("gui", "sortcolumn"), this.settings.getBooleanValue("gui", "sortascending"));
        this.profile_table.removeAll();
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
    }

    public static void setCapturesDir(Configuration profileConf, int profileId, String srcCap) {
        String capturesDir = FileUtils.getCwd();
        if (capturesDir != null) {
            capturesDir = String.valueOf(capturesDir) + File.separatorChar + CAPTURES_DIR + File.separatorChar + profileId;
            profileConf.setValue("dosbox", CAPTURES_DIR, capturesDir);
            FileUtils.createDir(capturesDir);
            if (srcCap != null) {
                FileUtils.copyFiles(srcCap, CAPTURES_DIR + File.separatorChar + profileId + File.separatorChar);
            }
        }
    }

    private void displayProfileInformation() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            this.displayScreenshots(prof.getId());
            this.displayNotes(prof.getNotes());
            this.displayLinks(prof.getLink1(), prof.getLink2());
        } else {
            this.displayScreenshots(-1);
            this.displayNotes("");
            this.displayLinks("", "");
        }
    }
}

