/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mount {
    private MountingType mountingType;
    private String mountAs;
    private char driveletter;
    private String label;
    private String path;
    private boolean ioctl;
    private String write;

    public Mount(MountingType mountingType, String mountAs, String driveletter, String path, String label, boolean ioctl, String write) {
        this.mountingType = mountingType;
        this.mountAs = mountAs.toLowerCase();
        this.driveletter = Character.toLowerCase(driveletter.charAt(0));
        this.path = StringUtils.fixDir(path);
        this.label = label;
        this.ioctl = ioctl;
        this.write = StringUtils.fixDir(write);
    }

    private void init() {
        this.mountingType = MountingType.DIR;
        this.mountAs = "";
        this.driveletter = '\u0000';
        this.label = "";
        this.path = "";
        this.ioctl = false;
        this.write = "";
    }

    public Mount(boolean floppy, String hostFileLocation, String[] existingMounts) {
        this.init();
        if (hostFileLocation.equals("")) {
            return;
        }
        List<Character> freeDriveletters = Mount.getFreeDriveletters(floppy, existingMounts);
        if (freeDriveletters.size() < 1) {
            return;
        }
        this.driveletter = freeDriveletters.get(0).charValue();
        int lastSlashIndex = hostFileLocation.lastIndexOf(System.getProperty("file.separator"));
        this.path = StringUtils.fixDir(hostFileLocation.substring(0, lastSlashIndex + 1));
    }

    public Mount(String mount) {
        this.init();
        if (mount.equals("")) {
            return;
        }
        int spaceIndex = mount.indexOf(32);
        this.driveletter = Character.toLowerCase(mount.charAt(spaceIndex + 1));
        int firstQuoteIndex = mount.indexOf(34);
        int secondQuoteIndex = mount.lastIndexOf(34);
        if (firstQuoteIndex == -1 && secondQuoteIndex == -1 && (secondQuoteIndex = mount.indexOf(32, (firstQuoteIndex = mount.indexOf(32, spaceIndex + 1)) + 1)) == -1) {
            secondQuoteIndex = mount.length();
        }
        this.path = mount.substring(firstQuoteIndex + 1, secondQuoteIndex);
        if (mount.toLowerCase().startsWith("mount ")) {
            int labelIndex;
            int typeIndex = mount.indexOf("-t ");
            if (typeIndex != -1) {
                int spaceIndex2 = mount.indexOf(" ", typeIndex + 3);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.mountAs = mount.substring(typeIndex + 3, spaceIndex2);
            }
            if ((labelIndex = mount.indexOf("-label ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", labelIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.label = mount.substring(labelIndex + 7, spaceIndex2);
            }
            if (mount.indexOf("-ioctl") != -1) {
                this.ioctl = true;
            }
            if (this.path.toLowerCase().endsWith(".zip:\\")) {
                int colonIndex2;
                this.mountingType = MountingType.PHYSFS;
                int colonIndex1 = this.path.indexOf(":");
                if (colonIndex1 == 1) {
                    colonIndex1 = this.path.indexOf(":", colonIndex1 + 1);
                }
                if (colonIndex1 != (colonIndex2 = this.path.lastIndexOf(":"))) {
                    this.write = StringUtils.fixDir(this.path.substring(0, colonIndex1));
                    this.path = this.path.substring(colonIndex1 + 1, colonIndex2);
                } else {
                    this.path = this.path.substring(0, colonIndex2);
                }
            }
        } else if (mount.toLowerCase().startsWith("imgmount ")) {
            this.mountingType = MountingType.IMAGE;
            this.mountAs = "iso";
        }
        if (this.mountingType != MountingType.PHYSFS) {
            this.path = StringUtils.fixDir(this.path);
        }
    }

    public static List<Character> getFreeDriveletters(boolean floppy, String[] existingMounts) {
        int start;
        Mount[] mnts = new Mount[existingMounts.length];
        int i = 0;
        while (i < mnts.length) {
            mnts[i] = new Mount(existingMounts[i]);
            ++i;
        }
        ArrayList<Character> freeDriveletters = new ArrayList<Character>();
        int i2 = start = floppy ? 97 : 99;
        while (i2 < 122) {
            freeDriveletters.add(Character.valueOf((char)i2));
            i2 = (char)(i2 + '\u0001');
        }
        if (!floppy) {
            freeDriveletters.add(Character.valueOf('a'));
            freeDriveletters.add(Character.valueOf('b'));
        }
        i2 = 0;
        while (i2 < mnts.length) {
            freeDriveletters.remove(new Character(mnts[i2].getDriveletter()));
            ++i2;
        }
        return freeDriveletters;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        switch (this.mountingType) {
            case DIR: {
                result.append("mount " + this.driveletter + " \"" + this.path + System.getProperty("file.separator") + "\"");
                if (!this.ioctl) break;
                result.append(" -ioctl");
                break;
            }
            case PHYSFS: {
                result.append("mount " + this.driveletter + " \"");
                if (!this.write.equals("")) {
                    result.append(String.valueOf(this.write) + "\\:");
                }
                result.append(String.valueOf(this.path) + ":\\\"");
                break;
            }
            case IMAGE: {
                result.append("imgmount " + this.driveletter + " \"" + this.path + "\"");
            }
        }
        if (!this.label.equals("")) {
            result.append(" -label " + this.label);
        }
        if (!this.mountAs.equals("")) {
            result.append(" -t " + this.mountAs);
        }
        return result.toString();
    }

    public char getDriveletter() {
        return this.driveletter;
    }

    public String getDriveletterString() {
        return String.valueOf(this.driveletter);
    }

    public boolean isIoctl() {
        return this.ioctl;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    public MountingType getMountingType() {
        return this.mountingType;
    }

    public String getMountAs() {
        return this.mountAs;
    }

    public String getWrite() {
        return this.write;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MountingType {
        DIR,
        IMAGE,
        PHYSFS;

    }
}

