/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.Mount;
import com.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Autoexec {
    private List<Mount> mountingpoints;
    private boolean loadfix;
    private int loadfixValue;
    private String main;
    private String setup;
    private String img1;
    private String img2;
    private boolean exit;
    private boolean isBooter;
    private String mainParams;
    private String setupParams;

    public Autoexec(String[] mountingpoints, boolean loadfix, String loadfixValue, String main, String setup, String mainParams, String setupParams, String img1, String img2, boolean exit) {
        this.mountingpoints = new ArrayList<Mount>();
        String[] stringArray = mountingpoints;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String mount = stringArray[n];
            this.mountingpoints.add(new Mount(mount));
            ++n;
        }
        this.loadfix = loadfix;
        try {
            this.loadfixValue = Integer.parseInt(loadfixValue);
        }
        catch (NumberFormatException e) {
            this.loadfixValue = 0;
        }
        this.main = main;
        this.setup = setup;
        this.img1 = img1;
        this.img2 = img2;
        this.exit = exit;
        this.mainParams = mainParams;
        this.setupParams = setupParams;
    }

    public Autoexec(String autoexec) {
        this.init();
        if (autoexec.equals("")) {
            return;
        }
        String[] orgLines = autoexec.split("\n");
        char driveletter = '\u0000';
        char imgdriveletter1 = '\u0000';
        char imgdriveletter2 = '\u0000';
        String remainder = "";
        String executable = "";
        String image1 = "";
        String image2 = "";
        int exeIndex = -1;
        String[] stringArray = orgLines;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String orgLine = stringArray[n];
            String line = orgLine.toLowerCase();
            if (line.startsWith("mount") || line.startsWith("imgmount")) {
                this.mountingpoints.add(new Mount(orgLine));
            } else if (line.endsWith(":") && line.length() == 2) {
                driveletter = Character.toLowerCase(line.charAt(0));
            } else if (line.startsWith("cd\\")) {
                remainder = StringUtils.fixDir(this.convertToNativePath(orgLine).substring(2));
            } else if (line.startsWith("cd \\")) {
                remainder = StringUtils.fixDir(this.convertToNativePath(orgLine).substring(3));
            } else if (line.startsWith("cd ") && line.endsWith("\\")) {
                remainder = StringUtils.fixDir(this.convertToNativePath(orgLine).substring(3));
            } else {
                exeIndex = line.indexOf(".com");
                if (exeIndex != -1 || (exeIndex = line.indexOf(".exe")) != -1 || (exeIndex = line.indexOf(".bat")) != -1) {
                    int spaceAfterIndex;
                    executable = orgLine;
                    int spaceBeforeIndex = executable.lastIndexOf(" ", exeIndex);
                    if (spaceBeforeIndex != -1) {
                        executable = executable.substring(spaceBeforeIndex + 1);
                    }
                    if ((spaceAfterIndex = executable.indexOf(" ")) != -1) {
                        this.mainParams = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
                        executable = executable.substring(0, spaceAfterIndex);
                    }
                } else if (line.startsWith("boot ")) {
                    this.isBooter = true;
                    int spaceIndex = line.indexOf(32, 5);
                    if (spaceIndex != -1) {
                        imgdriveletter2 = line.charAt(spaceIndex + 1);
                        image2 = StringUtils.fixDir(this.convertToNativePath(orgLine).substring(spaceIndex + 3));
                    } else {
                        spaceIndex = line.length();
                    }
                    imgdriveletter1 = line.charAt(5);
                    image1 = StringUtils.fixDir(this.convertToNativePath(orgLine).substring(7, spaceIndex));
                } else if (line.startsWith("exit")) {
                    this.exit = true;
                }
            }
            if (line.startsWith("loadfix -") && !line.startsWith("loadfix -f")) {
                this.loadfix = true;
                int endIndex = line.indexOf(32, 9);
                if (endIndex == -1) {
                    endIndex = line.length();
                }
                try {
                    this.loadfixValue = Integer.parseInt(line.substring(9, endIndex));
                }
                catch (NumberFormatException e) {
                    this.loadfixValue = 0;
                }
            }
            ++n;
        }
        for (Mount mount : this.mountingpoints) {
            char mount_drive = mount.getDriveletter();
            String mountPath = mount.getPath();
            if (driveletter == mount_drive) {
                this.main = String.valueOf(mountPath) + remainder + File.separatorChar + executable;
                continue;
            }
            if (imgdriveletter1 == mount_drive) {
                this.img1 = String.valueOf(mountPath) + image1;
            }
            if (imgdriveletter2 != mount_drive) continue;
            this.img2 = String.valueOf(mountPath) + image2;
        }
    }

    private void init() {
        this.mountingpoints = new ArrayList<Mount>();
        this.loadfix = false;
        this.loadfixValue = 0;
        this.main = "";
        this.setup = "";
        this.img1 = "";
        this.img2 = "";
        this.exit = false;
        this.isBooter = false;
        this.mainParams = "";
        this.setupParams = "";
    }

    public String toString(boolean isSetup) {
        String[] dosboxLocation;
        StringBuffer result = new StringBuffer();
        for (Mount mount : this.mountingpoints) {
            result.append(String.valueOf(mount.toString()) + "\n");
        }
        if (!this.main.equals("")) {
            dosboxLocation = this.convertToDosboxPath(isSetup ? this.setup : this.main);
            result.append(String.valueOf(dosboxLocation[0]) + "\n");
            result.append("cd " + dosboxLocation[1] + "\\\n");
            if (this.loadfix) {
                result.append("loadfix -" + this.loadfixValue + "\n");
            }
            if (dosboxLocation[2].toLowerCase().endsWith(".bat")) {
                result.append("call ");
            }
            result.append(dosboxLocation[2]);
            if (isSetup && !this.setupParams.equals("")) {
                result.append(" " + this.setupParams);
            } else if (!isSetup && !this.mainParams.equals("")) {
                result.append(" " + this.mainParams);
            }
            if (this.loadfix) {
                result.append("\nloadfix -f");
            }
            if (this.exit) {
                result.append("\nexit");
            }
        } else if (!this.img1.equals("")) {
            if (this.loadfix) {
                result.append("loadfix -" + this.loadfixValue + "\n");
            }
            dosboxLocation = this.convertToDosboxPath(this.img1);
            result.append("boot " + dosboxLocation[0] + dosboxLocation[1] + "\\" + dosboxLocation[2]);
            if (!this.img2.equals("")) {
                dosboxLocation = this.convertToDosboxPath(this.img2);
                result.append(" " + dosboxLocation[0] + dosboxLocation[1] + "\\" + dosboxLocation[2]);
            }
            if (this.loadfix) {
                result.append("\nloadfix -f");
            }
            if (this.exit) {
                result.append("\nexit");
            }
        } else if (this.exit) {
            result.append("exit");
        }
        return result.toString();
    }

    private String convertToNativePath(String dosboxFileLocation) {
        return dosboxFileLocation.replace("\\", File.separator);
    }

    private String[] convertToDosboxPath(String hostFileLocation) {
        String[] result = new String[3];
        result[0] = "";
        result[1] = "";
        int firstSlashIndex = hostFileLocation.indexOf(File.separatorChar);
        int lastSlashIndex = hostFileLocation.lastIndexOf(File.separatorChar);
        if (firstSlashIndex == -1 || lastSlashIndex == -1) {
            result[2] = hostFileLocation;
            return result;
        }
        char hostDrive = '\u0000';
        char mountDrive = '\u0000';
        if (hostFileLocation.charAt(1) == ':') {
            hostDrive = Character.toLowerCase(hostFileLocation.charAt(0));
        }
        String hostDir = StringUtils.fixDir(hostFileLocation.substring(firstSlashIndex, lastSlashIndex));
        result[2] = hostFileLocation.substring(lastSlashIndex + 1);
        for (Mount mount : this.mountingpoints) {
            String mountDir = mount.getPath();
            if (mountDir.charAt(1) == ':') {
                mountDrive = Character.toLowerCase(mount.getPath().charAt(0));
                mountDir = mountDir.substring(2);
            }
            String extHostDir = String.valueOf(hostDir) + File.separatorChar;
            String extMountDir = String.valueOf(mountDir) + File.separatorChar;
            if ((hostDrive != '\u0000' || !extHostDir.startsWith(extMountDir)) && (hostDrive != mountDrive || !extHostDir.toLowerCase().startsWith(extMountDir.toLowerCase()))) continue;
            result[0] = String.valueOf(mount.getDriveletter()) + ":";
            result[1] = StringUtils.fixDir(hostDir.substring(mountDir.length()));
            break;
        }
        result[1] = result[1].replace('/', '\\');
        return result;
    }

    public boolean isExit() {
        return this.exit;
    }

    public String getImg1() {
        return this.img1;
    }

    public String getImg2() {
        return this.img2;
    }

    public boolean isLoadfix() {
        return this.loadfix;
    }

    public String getLoadfixValue() {
        return this.loadfixValue > 0 ? String.valueOf(this.loadfixValue) : "";
    }

    public String getMain() {
        return this.main;
    }

    public String[] getMountingpoints() {
        String[] result = new String[this.mountingpoints.size()];
        int i = 0;
        for (Mount mount : this.mountingpoints) {
            result[i++] = mount.toString();
        }
        return result;
    }

    public String getSetup() {
        return this.setup;
    }

    public void setSetup(String setup) {
        this.setup = setup;
    }

    public void setSetupParameters(String setupParams) {
        this.setupParams = setupParams;
    }

    public boolean isBooter() {
        return this.isBooter;
    }

    public String getMainParameters() {
        return this.mainParams;
    }

    public String getSetupParameters() {
        return this.setupParams;
    }
}

