/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import java.io.File;
import java.io.IOException;

public class DosboxVersion {
    private int id;
    private String title;
    private String path;
    private boolean multiConfig;
    private boolean defaultVersion;

    public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean version) {
        this.id = id;
        this.title = title;
        this.path = path;
        this.multiConfig = multiConfig;
        this.defaultVersion = version;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public String isDefaultVersionString() {
        return this.defaultVersion ? "Yes" : "No";
    }

    public boolean isMultiConfig() {
        return this.multiConfig;
    }

    public String isMultiConfigString() {
        return this.multiConfig ? "Yes" : "No";
    }

    public int getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getCanonicalPath() {
        try {
            return new File(this.path).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(this.path).getAbsolutePath();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getExecutable() {
        if (this.path.indexOf(47) != -1) {
            try {
                return new File(String.valueOf(this.path) + "dosbox").getCanonicalPath();
            }
            catch (IOException e) {
                return new File(String.valueOf(this.path) + "dosbox").getAbsolutePath();
            }
        }
        try {
            return new File(String.valueOf(this.path) + "DOSBox.exe").getCanonicalPath();
        }
        catch (IOException e) {
            return new File(String.valueOf(this.path) + "DOSBox.exe").getAbsolutePath();
        }
    }

    public String getConfigFile() {
        try {
            return new File(String.valueOf(this.path) + "dosbox.conf").getCanonicalPath();
        }
        catch (IOException e) {
            return new File(String.valueOf(this.path) + "dosbox.conf").getAbsolutePath();
        }
    }
}

